/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.rules;

import java.util.HashSet;
import org.drools.lang.descr.FunctionImportDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.Handler;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PackageHandler
extends BaseAbstractHandler
implements Handler {
    public PackageHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(null);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String ruleSetName = attrs.getValue("name");
        if (ruleSetName == null || ruleSetName.trim().equals("")) {
            throw new SAXParseException("<package> requires a 'name' attribute", parser.getLocator());
        }
        PackageDescr packageDescr = new PackageDescr(ruleSetName.trim());
        parser.setData((Object)packageDescr);
        return packageDescr;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        PackageDescr packageDescr = (PackageDescr)parser.getData();
        Element element = parser.endElementBuilder();
        NodeList imports = element.getElementsByTagName("import");
        int i = 0;
        int length = imports.getLength();
        while (i < length) {
            String importEntry = ((Element)imports.item(i)).getAttribute("name");
            if (importEntry == null || importEntry.trim().equals("")) {
                throw new SAXParseException("<import> cannot be blank", parser.getLocator());
            }
            packageDescr.addImport(new ImportDescr(importEntry));
            ++i;
        }
        NodeList importfunctions = element.getElementsByTagName("importfunction");
        int i2 = 0;
        int length2 = importfunctions.getLength();
        while (i2 < length2) {
            String importfunctionEntry = ((Element)importfunctions.item(i2)).getAttribute("name");
            if (importfunctionEntry == null || importfunctionEntry.trim().equals("")) {
                throw new SAXParseException("<importfunction> cannot be blank", parser.getLocator());
            }
            FunctionImportDescr funcdescr = new FunctionImportDescr();
            funcdescr.setTarget(importfunctionEntry);
            packageDescr.addFunctionImport(funcdescr);
            ++i2;
        }
        NodeList globals = element.getElementsByTagName("global");
        int i3 = 0;
        int length3 = globals.getLength();
        while (i3 < length3) {
            String identifier = ((Element)globals.item(i3)).getAttribute("identifier");
            if (identifier == null || identifier.trim().equals("")) {
                throw new SAXParseException("<global> must have an identifier", parser.getLocator());
            }
            String type = ((Element)globals.item(i3)).getAttribute("type");
            if (type == null || type.trim().equals("")) {
                throw new SAXParseException("<global> must have specify a type", parser.getLocator());
            }
            GlobalDescr global = new GlobalDescr(identifier, type);
            packageDescr.addGlobal(global);
            ++i3;
        }
        return packageDescr;
    }

    public Class generateNodeFor() {
        return PackageDescr.class;
    }
}

