/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.base.TypeResolver;
import org.drools.commons.jci.compilers.CompilationResult;
import org.drools.commons.jci.compilers.JavaCompiler;
import org.drools.commons.jci.compilers.JavaCompilerFactory;
import org.drools.commons.jci.compilers.JavaCompilerSettings;
import org.drools.commons.jci.problems.CompilationProblem;
import org.drools.commons.jci.readers.MemoryResourceReader;
import org.drools.commons.jci.readers.ResourceReader;
import org.drools.compiler.DescrBuildError;
import org.drools.compiler.Dialect;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageRegistry;
import org.drools.core.util.StringUtils;
import org.drools.definition.process.Process;
import org.drools.io.Resource;
import org.drools.io.internal.InternalResource;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.EntryPointDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.ProcessDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.DialectRuntimeData;
import org.drools.rule.Function;
import org.drools.rule.JavaDialectRuntimeData;
import org.drools.rule.LineMappings;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.rule.builder.AccumulateBuilder;
import org.drools.rule.builder.ActionBuilder;
import org.drools.rule.builder.CollectBuilder;
import org.drools.rule.builder.ConsequenceBuilder;
import org.drools.rule.builder.EnabledBuilder;
import org.drools.rule.builder.EntryPointBuilder;
import org.drools.rule.builder.ForallBuilder;
import org.drools.rule.builder.FromBuilder;
import org.drools.rule.builder.FunctionBuilder;
import org.drools.rule.builder.GroupElementBuilder;
import org.drools.rule.builder.PackageBuildContext;
import org.drools.rule.builder.PatternBuilder;
import org.drools.rule.builder.PredicateBuilder;
import org.drools.rule.builder.ProcessBuildContext;
import org.drools.rule.builder.ProcessClassBuilder;
import org.drools.rule.builder.QueryBuilder;
import org.drools.rule.builder.ReturnValueBuilder;
import org.drools.rule.builder.ReturnValueEvaluatorBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleClassBuilder;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.SalienceBuilder;
import org.drools.rule.builder.dialect.java.DeclarationTypeFixer;
import org.drools.rule.builder.dialect.java.JavaAccumulateBuilder;
import org.drools.rule.builder.dialect.java.JavaActionBuilder;
import org.drools.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.rule.builder.dialect.java.JavaConsequenceBuilder;
import org.drools.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.rule.builder.dialect.java.JavaEvalBuilder;
import org.drools.rule.builder.dialect.java.JavaExprAnalyzer;
import org.drools.rule.builder.dialect.java.JavaFunctionBuilder;
import org.drools.rule.builder.dialect.java.JavaPredicateBuilder;
import org.drools.rule.builder.dialect.java.JavaProcessClassBuilder;
import org.drools.rule.builder.dialect.java.JavaReturnValueBuilder;
import org.drools.rule.builder.dialect.java.JavaReturnValueEvaluatorBuilder;
import org.drools.rule.builder.dialect.java.JavaRuleClassBuilder;
import org.drools.rule.builder.dialect.java.KnowledgeHelperFixer;
import org.drools.rule.builder.dialect.java.PackageStore;
import org.drools.rule.builder.dialect.mvel.MVELEnabledBuilder;
import org.drools.rule.builder.dialect.mvel.MVELFromBuilder;
import org.drools.rule.builder.dialect.mvel.MVELSalienceBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaDialect
implements Dialect {
    public static final String ID = "java";
    private static final String EXPRESSION_DIALECT_NAME = "mvel";
    private static final PatternBuilder PATTERN_BUILDER = new PatternBuilder();
    private static final QueryBuilder QUERY_BUILDER = new QueryBuilder();
    private static final SalienceBuilder SALIENCE_BUILDER = new MVELSalienceBuilder();
    private static final EnabledBuilder ENABLED_BUILDER = new MVELEnabledBuilder();
    private static final JavaAccumulateBuilder ACCUMULATE_BUILDER = new JavaAccumulateBuilder();
    private static final JavaEvalBuilder EVAL_BUILDER = new JavaEvalBuilder();
    private static final JavaPredicateBuilder PREDICATE_BUILDER = new JavaPredicateBuilder();
    private static final JavaReturnValueBuilder RETURN_VALUE_BUILDER = new JavaReturnValueBuilder();
    private static final JavaConsequenceBuilder CONSESUENCE_BUILDER = new JavaConsequenceBuilder();
    private static final JavaActionBuilder ACTION_BUILDER = new JavaActionBuilder();
    private static final ReturnValueEvaluatorBuilder RETURN_VALUE_EVALUATOR_BUIDER = new JavaReturnValueEvaluatorBuilder();
    private static final JavaRuleClassBuilder RULE_CLASS_BUILDER = new JavaRuleClassBuilder();
    private static final JavaProcessClassBuilder PROCESS_CLASS_BUILDER = new JavaProcessClassBuilder();
    private static final MVELFromBuilder FROM_BUILDER = new MVELFromBuilder();
    private static final JavaFunctionBuilder FUNCTION_BUILDER = new JavaFunctionBuilder();
    private static final CollectBuilder COLLECT_BUIDER = new CollectBuilder();
    private static final ForallBuilder FORALL_BUILDER = new ForallBuilder();
    private static final EntryPointBuilder ENTRY_POINT_BUILDER = new EntryPointBuilder();
    private static final GroupElementBuilder GE_BUILDER = new GroupElementBuilder();
    private static Map builders;
    private static final KnowledgeHelperFixer knowledgeHelperFixer;
    private static final DeclarationTypeFixer typeFixer;
    private static final JavaExprAnalyzer analyzer;
    private JavaDialectConfiguration configuration;
    private Package pkg;
    private JavaCompiler compiler;
    private List generatedClassList;
    private MemoryResourceReader src;
    private PackageStore packageStoreWrapper;
    private Map errorHandlers;
    private List results;
    private PackageBuilder packageBuilder;
    private PackageRegistry packageRegistry;

    static {
        JavaDialect.initBuilder();
        knowledgeHelperFixer = new KnowledgeHelperFixer();
        typeFixer = new DeclarationTypeFixer();
        analyzer = new JavaExprAnalyzer();
    }

    public JavaDialect(PackageBuilder builder, PackageRegistry pkgRegistry, Package pkg) {
        this.packageBuilder = builder;
        this.pkg = pkg;
        this.packageRegistry = pkgRegistry;
        this.configuration = (JavaDialectConfiguration)builder.getPackageBuilderConfiguration().getDialectConfiguration(ID);
        this.errorHandlers = new HashMap();
        this.results = new ArrayList();
        this.src = new MemoryResourceReader();
        this.generatedClassList = new ArrayList();
        JavaDialectRuntimeData data = null;
        if (pkg.getDialectRuntimeRegistry().getDialectData(ID) == null) {
            data = new JavaDialectRuntimeData();
            this.pkg.getDialectRuntimeRegistry().setDialectData(ID, (DialectRuntimeData)data);
            data.onAdd(this.pkg.getDialectRuntimeRegistry(), this.packageBuilder.getRootClassLoader());
        }
        this.packageStoreWrapper = new PackageStore(data, this.results);
        this.loadCompiler();
    }

    public static synchronized void initBuilder() {
        if (builders != null) {
            return;
        }
        builders = new HashMap();
        builders.put(CollectDescr.class, COLLECT_BUIDER);
        builders.put(ForallDescr.class, FORALL_BUILDER);
        builders.put(AndDescr.class, GE_BUILDER);
        builders.put(OrDescr.class, GE_BUILDER);
        builders.put(NotDescr.class, GE_BUILDER);
        builders.put(ExistsDescr.class, GE_BUILDER);
        builders.put(PatternDescr.class, PATTERN_BUILDER);
        builders.put(QueryDescr.class, QUERY_BUILDER);
        builders.put(FromDescr.class, FROM_BUILDER);
        builders.put(AccumulateDescr.class, ACCUMULATE_BUILDER);
        builders.put(EvalDescr.class, EVAL_BUILDER);
        builders.put(EntryPointDescr.class, ENTRY_POINT_BUILDER);
    }

    public Map getBuilders() {
        return builders;
    }

    @Override
    public void init(RuleDescr ruleDescr) {
        String ruleClassName = JavaDialect.getUniqueLegalName(this.pkg.getName(), ruleDescr.getName(), ID, "Rule", this.src);
        ruleDescr.setClassName(StringUtils.ucFirst((String)ruleClassName));
    }

    @Override
    public void init(ProcessDescr processDescr) {
        String processDescrClassName = JavaDialect.getUniqueLegalName(this.pkg.getName(), processDescr.getName(), ID, "Process", this.src);
        processDescr.setClassName(StringUtils.ucFirst((String)processDescrClassName));
    }

    @Override
    public String getExpressionDialectName() {
        return EXPRESSION_DIALECT_NAME;
    }

    @Override
    public Dialect.AnalysisResult analyzeExpression(PackageBuildContext context, BaseDescr descr, Object content, Map<String, Class<?>>[] availableIdentifiers) {
        JavaAnalysisResult result = null;
        try {
            result = analyzer.analyzeExpression((String)content, availableIdentifiers);
        }
        catch (Exception e) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, e, "Unable to determine the used declarations.\n" + e));
        }
        return result;
    }

    @Override
    public Dialect.AnalysisResult analyzeBlock(PackageBuildContext context, BaseDescr descr, String text, Map<String, Class<?>>[] availableIdentifiers) {
        JavaAnalysisResult result = null;
        try {
            result = analyzer.analyzeBlock(text, availableIdentifiers);
        }
        catch (Exception e) {
            context.getErrors().add(new DescrBuildError(context.getParentDescr(), descr, e, "Unable to determine the used declarations.\n" + e));
        }
        return result;
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.packageRegistry.getTypeResolver();
    }

    public KnowledgeHelperFixer getKnowledgeHelperFixer() {
        return knowledgeHelperFixer;
    }

    public DeclarationTypeFixer getTypeFixer() {
        return typeFixer;
    }

    public RuleConditionBuilder getBuilder(Class clazz) {
        return (RuleConditionBuilder)builders.get(clazz);
    }

    @Override
    public PatternBuilder getPatternBuilder() {
        return PATTERN_BUILDER;
    }

    @Override
    public QueryBuilder getQueryBuilder() {
        return QUERY_BUILDER;
    }

    @Override
    public SalienceBuilder getSalienceBuilder() {
        return SALIENCE_BUILDER;
    }

    @Override
    public EnabledBuilder getEnabledBuilder() {
        return ENABLED_BUILDER;
    }

    @Override
    public AccumulateBuilder getAccumulateBuilder() {
        return ACCUMULATE_BUILDER;
    }

    @Override
    public RuleConditionBuilder getEvalBuilder() {
        return EVAL_BUILDER;
    }

    @Override
    public PredicateBuilder getPredicateBuilder() {
        return PREDICATE_BUILDER;
    }

    @Override
    public ReturnValueBuilder getReturnValueBuilder() {
        return RETURN_VALUE_BUILDER;
    }

    @Override
    public ConsequenceBuilder getConsequenceBuilder() {
        return CONSESUENCE_BUILDER;
    }

    @Override
    public ActionBuilder getActionBuilder() {
        return ACTION_BUILDER;
    }

    @Override
    public ReturnValueEvaluatorBuilder getReturnValueEvaluatorBuilder() {
        return RETURN_VALUE_EVALUATOR_BUIDER;
    }

    @Override
    public RuleClassBuilder getRuleClassBuilder() {
        return RULE_CLASS_BUILDER;
    }

    @Override
    public ProcessClassBuilder getProcessClassBuilder() {
        return PROCESS_CLASS_BUILDER;
    }

    public FunctionBuilder getFunctionBuilder() {
        return FUNCTION_BUILDER;
    }

    @Override
    public FromBuilder getFromBuilder() {
        return FROM_BUILDER;
    }

    @Override
    public EntryPointBuilder getEntryPointBuilder() {
        return ENTRY_POINT_BUILDER;
    }

    @Override
    public void compileAll() {
        CompilationResult result;
        if (this.generatedClassList.isEmpty()) {
            return;
        }
        String[] classes = new String[this.generatedClassList.size()];
        this.generatedClassList.toArray(classes);
        File dumpDir = this.configuration.getPackageBuilderConfiguration().getDumpDir();
        if (dumpDir != null) {
            this.dumpResources(classes, dumpDir);
        }
        if ((result = this.compiler.compile(classes, this.src, this.packageStoreWrapper, (ClassLoader)this.packageBuilder.getRootClassLoader())).getErrors().length > 0) {
            int i = 0;
            while (i < result.getErrors().length) {
                CompilationProblem err = result.getErrors()[i];
                PackageBuilder.ErrorHandler handler = (PackageBuilder.ErrorHandler)this.errorHandlers.get(err.getFileName());
                if (handler instanceof PackageBuilder.RuleErrorHandler) {
                    PackageBuilder.RuleErrorHandler ruleErrorHandler = (PackageBuilder.RuleErrorHandler)handler;
                }
                handler.addError(err);
                ++i;
            }
            Collection errors = this.errorHandlers.values();
            for (PackageBuilder.ErrorHandler handler : errors) {
                if (!handler.isInError()) continue;
                this.results.add(handler.getError());
            }
        }
        this.generatedClassList.clear();
    }

    private void dumpResources(String[] classes, File dumpDir) {
        int i = 0;
        while (i < classes.length) {
            block19: {
                File target = new File(dumpDir, classes[i]);
                FileOutputStream out = null;
                try {
                    File parent = target.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    target.createNewFile();
                    out = new FileOutputStream(target);
                    out.write(this.src.getBytes(classes[i]));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block19;
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                        break block19;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                if (out == null) break block19;
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    @Override
    public void addRule(RuleBuildContext context) {
        RuleClassBuilder classBuilder = context.getDialect().getRuleClassBuilder();
        String ruleClass = classBuilder.buildRule(context);
        if (ruleClass == null) {
            return;
        }
        Rule rule = context.getRule();
        RuleDescr ruleDescr = context.getRuleDescr();
        this.addClassCompileTask(String.valueOf(this.pkg.getName()) + "." + ruleDescr.getClassName(), ruleDescr, ruleClass, this.src, new PackageBuilder.RuleErrorHandler(ruleDescr, rule, "Rule Compilation error"));
        JavaDialectRuntimeData data = (JavaDialectRuntimeData)this.pkg.getDialectRuntimeRegistry().getDialectData(ID);
        for (String className : context.getInvokers().keySet()) {
            Object invoker = context.getInvokerLookups().get(className);
            if (invoker != null) {
                data.putInvoker(className, invoker);
            }
            String text = (String)context.getInvokers().get(className);
            BaseDescr descr = (BaseDescr)context.getDescrLookups().get(className);
            this.addClassCompileTask(className, descr, text, this.src, new PackageBuilder.RuleInvokerErrorHandler(descr, rule, "Unable to generate rule invoker."));
        }
        String name = String.valueOf(this.pkg.getName()) + "." + StringUtils.ucFirst((String)ruleDescr.getClassName());
        LineMappings mapping = new LineMappings(name);
        mapping.setStartLine(ruleDescr.getConsequenceLine());
        mapping.setOffset(ruleDescr.getConsequenceOffset());
        this.pkg.getDialectRuntimeRegistry().getLineMappings().put(name, mapping);
    }

    @Override
    public void addProcess(ProcessBuildContext context) {
        ProcessClassBuilder classBuilder = context.getDialect().getProcessClassBuilder();
        String processClass = classBuilder.buildRule(context);
        if (processClass == null) {
            return;
        }
        Process process = context.getProcess();
        ProcessDescr processDescr = context.getProcessDescr();
        this.addClassCompileTask(String.valueOf(this.pkg.getName()) + "." + processDescr.getClassName(), processDescr, processClass, this.src, new PackageBuilder.ProcessErrorHandler(processDescr, process, "Process Compilation error"));
        JavaDialectRuntimeData data = (JavaDialectRuntimeData)this.pkg.getDialectRuntimeRegistry().getDialectData(ID);
        for (String className : context.getInvokers().keySet()) {
            Object invoker = context.getInvokerLookups().get(className);
            if (invoker != null) {
                data.putInvoker(className, invoker);
            }
            String text = (String)context.getInvokers().get(className);
            BaseDescr descr = (BaseDescr)context.getDescrLookups().get(className);
            this.addClassCompileTask(className, descr, text, this.src, new PackageBuilder.ProcessInvokerErrorHandler(processDescr, process, "Unable to generate action invoker."));
        }
    }

    @Override
    public void addFunction(FunctionDescr functionDescr, TypeResolver typeResolver, Resource resource) {
        JavaDialectRuntimeData data = (JavaDialectRuntimeData)this.pkg.getDialectRuntimeRegistry().getDialectData(ID);
        String functionClassName = String.valueOf(this.pkg.getName()) + "." + StringUtils.ucFirst((String)functionDescr.getName());
        functionDescr.setClassName(functionClassName);
        this.pkg.addStaticImport(String.valueOf(functionClassName) + "." + functionDescr.getName());
        Function function = new Function(functionDescr.getNamespace(), functionDescr.getName(), ID);
        if (resource != null && ((InternalResource)resource).hasURL()) {
            function.setResource(resource);
        }
        this.pkg.addFunction(function);
        String functionSrc = this.getFunctionBuilder().build(this.pkg, functionDescr, typeResolver, this.pkg.getDialectRuntimeRegistry().getLineMappings(), this.results);
        this.addClassCompileTask(functionClassName, functionDescr, functionSrc, this.src, new PackageBuilder.FunctionErrorHandler(functionDescr, "Function Compilation error"));
        LineMappings mapping = new LineMappings(functionClassName);
        mapping.setStartLine(functionDescr.getLine());
        mapping.setOffset(functionDescr.getOffset());
        this.pkg.getDialectRuntimeRegistry().getLineMappings().put(functionClassName, mapping);
    }

    @Override
    public void preCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
        String functionClassName = String.valueOf(this.pkg.getName()) + "." + StringUtils.ucFirst((String)functionDescr.getName());
        this.pkg.addStaticImport(String.valueOf(functionClassName) + "." + functionDescr.getName());
    }

    @Override
    public void postCompileAddFunction(FunctionDescr functionDescr, TypeResolver typeResolver) {
        String functionClassName = String.valueOf(this.pkg.getName()) + "." + StringUtils.ucFirst((String)functionDescr.getName());
        this.packageRegistry.addStaticImport(String.valueOf(functionClassName) + "." + functionDescr.getName());
    }

    public void addSrc(String resourceName, byte[] content) {
        this.src.add(resourceName, content);
        this.errorHandlers.put(resourceName, new PackageBuilder.SrcErrorHandler("Src compile error"));
        this.addClassName(resourceName);
    }

    private void addClassCompileTask(String className, BaseDescr descr, String text, MemoryResourceReader src, PackageBuilder.ErrorHandler handler) {
        String fileName = String.valueOf(className.replace('.', '/')) + ".java";
        src.add(fileName, text.getBytes());
        this.errorHandlers.put(fileName, handler);
        this.addClassName(fileName);
    }

    public void addClassName(String className) {
        this.generatedClassList.add(className);
    }

    private void loadCompiler() {
        switch (this.configuration.getCompiler()) {
            case 1: {
                this.compiler = JavaCompilerFactory.getInstance().createCompiler("janino");
                break;
            }
            default: {
                this.compiler = JavaCompilerFactory.getInstance().createCompiler("eclipse");
                JavaCompilerSettings settings = this.compiler.createDefaultSettings();
                String lngLevel = this.configuration.getJavaLanguageLevel();
                settings.setTargetVersion(lngLevel);
                settings.setSourceVersion(lngLevel);
            }
        }
    }

    @Override
    public void addImport(String importEntry) {
    }

    @Override
    public void addStaticImport(String staticImportEntry) {
    }

    @Override
    public List getResults() {
        return this.results;
    }

    public static String getUniqueLegalName(String packageName, String name, String ext, String prefix, ResourceReader src) {
        String newName = String.valueOf(prefix) + "_" + name.replaceAll("[ -/:-@\\[-`\\{-\\xff]", "_");
        int counter = -1;
        boolean exists = true;
        while (exists) {
            String fileName = String.valueOf(packageName.replaceAll("\\.", "/")) + "/" + newName + "_" + ++counter + "." + ext;
            boolean bl = exists = src != null && src.isAvailable(fileName);
        }
        if (counter >= 0) {
            newName = String.valueOf(newName) + "_" + counter;
        }
        return newName;
    }

    @Override
    public String getId() {
        return ID;
    }
}

