/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.InternalRuleBase;
import org.drools.common.NodeMemory;
import org.drools.common.SingleBetaConstraints;
import org.drools.common.TripleNonIndexSkipBetaConstraints;
import org.drools.core.util.LeftTupleIndexHashTable;
import org.drools.core.util.RightTupleIndexHashTable;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.io.ResourceFactory;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.rule.VariableConstraint;
import org.junit.Assert;
import org.junit.Test;

public class IndexingTest {
    @Test
    public void testBuildsIndexedMemory() {
        String drl = "";
        drl = drl + "package org.test\n";
        drl = drl + "import org.drools.Person\n";
        drl = drl + "global java.util.List list\n";
        drl = drl + "rule test1\n";
        drl = drl + "when\n";
        drl = drl + "   $p1  : Person($name : name )\n";
        drl = drl + "   $p2 : Person(name == $name)\n";
        drl = drl + "   $p3 : Person(name == $p1.name)\n";
        drl = drl + "then\n";
        drl = drl + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        List nodes = ((InternalRuleBase)((KnowledgeBaseImpl)kbase).ruleBase).getRete().getObjectTypeNodes();
        ObjectTypeNode node = null;
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != Person.class) continue;
            node = n;
            break;
        }
        ReteooWorkingMemory wm = ((StatefulKnowledgeSessionImpl)kbase.newStatefulKnowledgeSession()).session;
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)node.getSinkPropagator().getSinks()[0];
        JoinNode j2 = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
        JoinNode j3 = (JoinNode)j2.getSinkPropagator().getSinks()[0];
        SingleBetaConstraints c = (SingleBetaConstraints)j2.getRawConstraints();
        Assert.assertEquals((Object)"$name", (Object)((VariableConstraint)c.getConstraint()).getRequiredDeclarations()[0].getIdentifier());
        Assert.assertTrue((boolean)c.isIndexed());
        BetaMemory bm = (BetaMemory)wm.getNodeMemory((NodeMemory)j2);
        Assert.assertTrue((boolean)(bm.getLeftTupleMemory() instanceof LeftTupleIndexHashTable));
        Assert.assertTrue((boolean)(bm.getRightTupleMemory() instanceof RightTupleIndexHashTable));
        c = (SingleBetaConstraints)j3.getRawConstraints();
        Assert.assertEquals((Object)"name", (Object)((VariableConstraint)c.getConstraint()).getRequiredDeclarations()[0].getIdentifier());
        Assert.assertTrue((boolean)c.isIndexed());
        bm = (BetaMemory)wm.getNodeMemory((NodeMemory)j3);
        Assert.assertTrue((boolean)(bm.getLeftTupleMemory() instanceof LeftTupleIndexHashTable));
        Assert.assertTrue((boolean)(bm.getRightTupleMemory() instanceof RightTupleIndexHashTable));
    }

    @Test
    public void testIndexingOnQueryUnification() throws Exception {
        String str = "";
        str = str + "package org.drools.test  \n";
        str = str + "import org.drools.Person \n";
        str = str + "query peeps( String $name, String $likes, String $street) \n";
        str = str + "    $p : Person( $name := name, $likes := likes, $street := address.street ) \n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        List nodes = ((InternalRuleBase)((KnowledgeBaseImpl)kbase).ruleBase).getRete().getObjectTypeNodes();
        ObjectTypeNode node = null;
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != DroolsQuery.class) continue;
            node = n;
            break;
        }
        ReteooWorkingMemory wm = ((StatefulKnowledgeSessionImpl)kbase.newStatefulKnowledgeSession()).session;
        AlphaNode alphanode = (AlphaNode)node.getSinkPropagator().getSinks()[0];
        LeftInputAdapterNode liaNode = (LeftInputAdapterNode)alphanode.getSinkPropagator().getSinks()[0];
        JoinNode j = (JoinNode)liaNode.getSinkPropagator().getSinks()[0];
        TripleNonIndexSkipBetaConstraints c = (TripleNonIndexSkipBetaConstraints)j.getRawConstraints();
        Assert.assertTrue((boolean)c.isIndexed());
        BetaMemory bm = (BetaMemory)wm.getNodeMemory((NodeMemory)j);
        Assert.assertTrue((boolean)(bm.getLeftTupleMemory() instanceof LeftTupleIndexHashTable));
        Assert.assertTrue((boolean)(bm.getRightTupleMemory() instanceof RightTupleIndexHashTable));
    }
}

