/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests.waltz;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.PackageIntegrationException;
import org.drools.RuleBase;
import org.drools.RuleIntegrationException;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.integrationtests.waltz.Line;
import org.drools.integrationtests.waltz.Stage;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Package;
import org.junit.Assert;
import org.junit.Test;

public abstract class Waltz {
    protected abstract RuleBase getRuleBase() throws Exception;

    @Test
    public void testWaltz() {
        try {
            RuleBase ruleBase = this.readRule();
            for (int i = 0; i < 1; ++i) {
                StatefulSession session = ruleBase.newStatefulSession();
                this.loadLines((WorkingMemory)session, "waltz50.dat");
                long start = System.currentTimeMillis();
                Stage stage = new Stage(1);
                session.insert((Object)stage);
                session.fireAllRules();
                session.dispose();
                long end = System.currentTimeMillis();
                System.out.println(end - start);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    private RuleBase readRule() throws Exception, DroolsParserException, RuleIntegrationException, PackageIntegrationException, InvalidPatternException {
        InputStreamReader reader = new InputStreamReader(Waltz.class.getResourceAsStream("waltz.drl"));
        DrlParser parser = new DrlParser();
        PackageDescr packageDescr = parser.parse((Reader)reader);
        if (parser.hasErrors()) {
            for (DroolsError error : parser.getErrors()) {
                System.out.println(error);
            }
            Assert.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
        }
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        return ruleBase;
    }

    private void loadLines(WorkingMemory wm, String filename) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(Waltz.class.getResourceAsStream(filename)));
        Pattern pat = Pattern.compile(".*make line \\^p1 ([0-9]*) \\^p2 ([0-9]*).*");
        String line = reader.readLine();
        while (line != null) {
            Matcher m = pat.matcher(line);
            if (m.matches()) {
                Line l = new Line(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)));
                wm.insert((Object)l);
            }
            line = reader.readLine();
        }
        reader.close();
    }
}

