/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import junit.framework.TestCase;
import org.drools.base.evaluators.EvaluatorRegistry;
import org.drools.compiler.DrlExprParser;
import org.drools.lang.descr.AtomicExprDescr;
import org.drools.lang.descr.ConnectiveType;
import org.drools.lang.descr.ConstraintConnectiveDescr;
import org.drools.lang.descr.RelationalExprDescr;

public class DRLExprTreeTest
extends TestCase {
    DrlExprParser parser;

    protected void setUp() throws Exception {
        super.setUp();
        new EvaluatorRegistry();
        this.parser = new DrlExprParser();
    }

    protected void tearDown() throws Exception {
        this.parser = null;
        super.tearDown();
    }

    public void testSimpleExpression() throws Exception {
        String source = "a > b";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        DRLExprTreeTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        DRLExprTreeTest.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        DRLExprTreeTest.assertEquals((int)1, (int)result.getDescrs().size());
        RelationalExprDescr expr = (RelationalExprDescr)result.getDescrs().get(0);
        DRLExprTreeTest.assertEquals((String)">", (String)expr.getOperator());
        AtomicExprDescr left = (AtomicExprDescr)expr.getLeft();
        AtomicExprDescr right = (AtomicExprDescr)expr.getRight();
        DRLExprTreeTest.assertEquals((String)"a", (String)left.getExpression());
        DRLExprTreeTest.assertEquals((String)"b", (String)right.getExpression());
    }

    public void testAndConnective() throws Exception {
        String source = "a > b && 10 != 20";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        DRLExprTreeTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        DRLExprTreeTest.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        DRLExprTreeTest.assertEquals((int)2, (int)result.getDescrs().size());
        RelationalExprDescr expr = (RelationalExprDescr)result.getDescrs().get(0);
        DRLExprTreeTest.assertEquals((String)">", (String)expr.getOperator());
        AtomicExprDescr left = (AtomicExprDescr)expr.getLeft();
        AtomicExprDescr right = (AtomicExprDescr)expr.getRight();
        DRLExprTreeTest.assertEquals((String)"a", (String)left.getExpression());
        DRLExprTreeTest.assertEquals((String)"b", (String)right.getExpression());
        expr = (RelationalExprDescr)result.getDescrs().get(1);
        DRLExprTreeTest.assertEquals((String)"!=", (String)expr.getOperator());
        left = (AtomicExprDescr)expr.getLeft();
        right = (AtomicExprDescr)expr.getRight();
        DRLExprTreeTest.assertEquals((String)"10", (String)left.getExpression());
        DRLExprTreeTest.assertEquals((String)"20", (String)right.getExpression());
    }

    public void testConnective2() throws Exception {
        String source = "(a > b || 10 != 20) && someMethod(10) == 20";
        ConstraintConnectiveDescr result = this.parser.parse(source);
        DRLExprTreeTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        DRLExprTreeTest.assertEquals((Object)ConnectiveType.AND, (Object)result.getConnective());
        DRLExprTreeTest.assertEquals((int)2, (int)result.getDescrs().size());
        ConstraintConnectiveDescr or = (ConstraintConnectiveDescr)result.getDescrs().get(0);
        DRLExprTreeTest.assertEquals((Object)ConnectiveType.OR, (Object)or.getConnective());
        DRLExprTreeTest.assertEquals((int)2, (int)or.getDescrs().size());
        RelationalExprDescr expr = (RelationalExprDescr)or.getDescrs().get(0);
        DRLExprTreeTest.assertEquals((String)">", (String)expr.getOperator());
        AtomicExprDescr left = (AtomicExprDescr)expr.getLeft();
        AtomicExprDescr right = (AtomicExprDescr)expr.getRight();
        DRLExprTreeTest.assertEquals((String)"a", (String)left.getExpression());
        DRLExprTreeTest.assertEquals((String)"b", (String)right.getExpression());
        expr = (RelationalExprDescr)or.getDescrs().get(1);
        DRLExprTreeTest.assertEquals((String)"!=", (String)expr.getOperator());
        left = (AtomicExprDescr)expr.getLeft();
        right = (AtomicExprDescr)expr.getRight();
        DRLExprTreeTest.assertEquals((String)"10", (String)left.getExpression());
        DRLExprTreeTest.assertEquals((String)"20", (String)right.getExpression());
        expr = (RelationalExprDescr)result.getDescrs().get(1);
        DRLExprTreeTest.assertEquals((String)"==", (String)expr.getOperator());
        left = (AtomicExprDescr)expr.getLeft();
        right = (AtomicExprDescr)expr.getRight();
        DRLExprTreeTest.assertEquals((String)"someMethod(10)", (String)left.getExpression());
        DRLExprTreeTest.assertEquals((String)"20", (String)right.getExpression());
    }
}

