/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.agent.BaseKnowledgeAgentTest;
import org.drools.agent.KnowledgeAgent;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.builder.impl.KnowledgeBuilderImpl;
import org.drools.command.Command;
import org.drools.command.runtime.rule.InsertObjectCommand;
import org.drools.definition.KnowledgePackage;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.StatelessKnowledgeSession;
import org.junit.Assert;
import org.junit.Test;

public class KnowledgeAgentTest
extends BaseKnowledgeAgentTest {
    @Test
    public void testModifyFileUrl() throws Exception {
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        this.fileManager.write("rule2.drl", this.createDefaultRule("rule2"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule2.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule3"));
        this.scan(kagent);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule3"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        kagent.dispose();
    }

    @Test
    public void testChangeSetInChangeSet() throws Exception {
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        this.fileManager.write("rule2.drl", this.createDefaultRule("rule2"));
        String xml1 = "";
        xml1 = xml1 + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml1 = xml1 + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml1 = xml1 + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml1 = xml1 + "    <add> ";
        xml1 = xml1 + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml1 = xml1 + "        <resource source='http://localhost:" + this.getPort() + "/rule2.drl' type='DRL' />";
        xml1 = xml1 + "    </add> ";
        xml1 = xml1 + "</change-set>";
        File fxml = this.fileManager.write("changeset2.xml", xml1);
        String xml2 = "";
        xml2 = xml2 + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml2 = xml2 + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml2 = xml2 + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml2 = xml2 + "    <add> ";
        xml2 = xml2 + "        <resource source='http://localhost:" + this.getPort() + "/changeset2.xml' type='CHANGE_SET' />";
        xml2 = xml2 + "    </add> ";
        xml2 = xml2 + "</change-set>";
        File fxm2 = this.fileManager.write("changeset.xml", xml1);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxm2.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule3"));
        this.scan(kagent);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule3"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        kagent.dispose();
    }

    @Test
    public void testModifyFileUrlWithStateless() throws Exception {
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        this.fileManager.write("rule2.drl", this.createDefaultRule("rule2"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule2.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatelessKnowledgeSession ksession = kagent.newStatelessKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.execute((Object)"hello");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule3"));
        this.scan(kagent);
        ksession.execute((Object)"hello");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule3"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        kagent.dispose();
    }

    @Test
    public void testModifyPackageUrl() throws Exception {
        String rule1 = this.createDefaultRule("rule1");
        String rule2 = this.createDefaultRule("rule2");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule2.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgePackage pkg = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        KnowledgeAgentTest.writePackage(pkg, this.fileManager.newFile("pkg1.pkg"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/pkg1.pkg' type='PKG' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        rule1 = this.createDefaultRule("rule3");
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule2.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        pkg = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        KnowledgeAgentTest.writePackage(pkg, this.fileManager.newFile("pkg1.pkg"));
        this.scan(kagent);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule3"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        kagent.dispose();
    }

    @Test
    public void testDeletePackageUrl() throws Exception {
        String rule1 = this.createDefaultRule("rule1", "org.drools.test1");
        String rule2 = this.createDefaultRule("rule2", "org.drools.test2");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule2.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        HashMap<String, KnowledgePackage> map = new HashMap<String, KnowledgePackage>();
        for (KnowledgePackage pkg : kbuilder.getKnowledgePackages()) {
            map.put(pkg.getName(), pkg);
        }
        KnowledgeAgentTest.writePackage((KnowledgePackage)map.get("org.drools.test1"), this.fileManager.newFile("pkg1.pkg"));
        KnowledgeAgentTest.writePackage((KnowledgePackage)map.get("org.drools.test2"), this.fileManager.newFile("pkg2.pkg"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/pkg1.pkg' type='PKG' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/pkg2.pkg' type='PKG' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        this.applyChangeSet(kagent, ResourceFactory.newByteArrayResource((byte[])xml.getBytes()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <remove> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/pkg2.pkg' type='PKG' />";
        xml = xml + "    </remove> ";
        xml = xml + "</change-set>";
        this.applyChangeSet(kagent, xml);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        kagent.dispose();
    }

    @Test
    public void testOldSchoolPackageUrl() throws Exception {
        String rule1 = this.createDefaultRule("rule1");
        String rule2 = this.createDefaultRule("rule2");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule2.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBuilderImpl kbi = (KnowledgeBuilderImpl)kbuilder;
        KnowledgeAgentTest.writePackage(kbi.getPackageBuilder().getPackage(), this.fileManager.newFile("pkgold.pkg"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/pkgold.pkg' type='PKG' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        kagent.dispose();
    }

    @Test
    public void testModifyFile() throws IOException, InterruptedException {
        File f1 = this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        File f2 = this.fileManager.write("rule2.drl", this.createDefaultRule("rule2"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='" + f1.toURI().toURL() + "' type='DRL' />";
        xml = xml + "        <resource source='" + f2.toURI().toURL() + "' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule3"));
        this.scan(kagent);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule3"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        kagent.monitorResourceChangeEvents(false);
    }

    @Test
    public void testModifyDirectory() throws IOException, InterruptedException {
        File f1 = this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        File f2 = this.fileManager.write("rule2.drl", this.createDefaultRule("rule2"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='" + f1.getParentFile().toURI().toURL() + "' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset", "changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.write("rule3.drl", this.createDefaultRule("rule3"));
        this.fileManager.deleteFile(f1);
        this.scan(kagent);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule2"));
        Assert.assertTrue((boolean)list.contains("rule3"));
        kagent.dispose();
    }

    @Test
    public void testModifyFileInDirectory() throws Exception {
        File testDirectory = this.fileManager.newFile("test");
        testDirectory.mkdir();
        File f1 = this.fileManager.write("test", "rule1.drl", this.createDefaultRule("rule1"));
        File f2 = this.fileManager.write("test", "rule2.drl", this.createDefaultRule("rule2"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='file:" + this.fileManager.getRootDirectory().getAbsolutePath() + "/test' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset", "changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.write("test", "rule1.drl", this.createDefaultRule("rule3"));
        this.scan(kagent);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule3"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        kagent.dispose();
    }

    @Test
    public void testStatelessWithCommands() throws Exception {
        File f1 = this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        File f2 = this.fileManager.write("rule2.drl", this.createDefaultRule("rule2"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='" + f1.getParentFile().toURI().toURL() + "' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset", "changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatelessKnowledgeSession ksession = kagent.newStatelessKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.execute((Command)new InsertObjectCommand((Object)"hello"));
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
    }
}

