/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.drools.Address;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.io.impl.ByteArrayResource;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.drools.runtime.rule.QueryResults;
import org.drools.runtime.rule.QueryResultsRow;
import org.drools.runtime.rule.Variable;
import org.junit.Assert;
import org.junit.Test;

public class BackwardChainingTest {
    @Test
    public void testQueryPositional() throws Exception {
        String str = "package org.drools.test  \nimport org.drools.Person \nglobal java.util.List list\nquery peeps( String $name, String $likes, int $age ) \n    Person( $name := name, $likes := likes, $age := age; ) \nend\n";
        str = str + "rule x1\nwhen\n    String( this == \"go1\" )\n    ?peeps($name1, $likes1, $age1; )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        str = str + "rule x2\nwhen\n    String( this == \"go2\" )\n    ?peeps($name1, \"stilton\", $age1; )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        str = str + "rule x3\nwhen\n    String( this == \"go3\" )\n    $name1 : String() from \"darth\";\n     ?peeps($name1, \"stilton\", $age1; )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        str = str + "rule x4\nwhen\n    String( this == \"go4\" )\n    $name1 : String() from \"darth\"\n     $age1 : Integer() from 200;\n     ?peeps($name1, \"stilton\", $age1; )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("darth", "stilton", 200);
        Person p3 = new Person("yoda", "stilton", 300);
        Person p4 = new Person("luke", "brie", 300);
        Person p5 = new Person("bobba", "cheddar", 300);
        ksession.insert((Object)p1);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.insert((Object)p2);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.insert((Object)p3);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.insert((Object)p4);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.insert((Object)p5);
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.insert((Object)"go1");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        Assert.assertTrue((boolean)list.contains("yoda : 300"));
        Assert.assertTrue((boolean)list.contains("luke : 300"));
        Assert.assertTrue((boolean)list.contains("bobba : 300"));
        list.clear();
        ksession.insert((Object)"go2");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        Assert.assertTrue((boolean)list.contains("yoda : 300"));
        list.clear();
        ksession.insert((Object)"go3");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        list.clear();
        ksession.insert((Object)"go4");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 200"));
    }

    @Test
    public void testQueryNamed() throws Exception {
        String str = "package org.drools.test  \nimport org.drools.Person \nglobal java.util.List list\nquery peeps( String $name, String $likes, int $age ) \n    Person( $name := name, $likes := likes, $age := age ) \nend\n";
        str = str + "rule x1\nwhen\n    String( this == \"go1\" )\n    ?peeps($name1 : $name, $likes1 : $likes, $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        str = str + "rule x2\nwhen\n    String( this == \"go2\" )\n    ?peeps($name1 : $name, $likes : \"stilton\", $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        str = str + "rule x3\nwhen\n    String( this == \"go3\" )\n    $name1 : String() from \"darth\";\n     ?peeps($name1 : $name, $likes : \"stilton\", $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        str = str + "rule x4\nwhen\n    String( this == \"go4\" )\n    $name1 : String() from \"darth\";\n     $age1 : Integer() from 200;\n     ?peeps($name1 : $name, $likes : \"stilton\", $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("darth", "stilton", 200);
        Person p3 = new Person("yoda", "stilton", 300);
        Person p4 = new Person("luke", "brie", 300);
        Person p5 = new Person("bobba", "cheddar", 300);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.insert((Object)p4);
        ksession.insert((Object)p5);
        ksession.insert((Object)"go1");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        Assert.assertTrue((boolean)list.contains("yoda : 300"));
        Assert.assertTrue((boolean)list.contains("luke : 300"));
        Assert.assertTrue((boolean)list.contains("bobba : 300"));
        list.clear();
        ksession.insert((Object)"go2");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        Assert.assertTrue((boolean)list.contains("yoda : 300"));
        list.clear();
        ksession.insert((Object)"go3");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        list.clear();
        ksession.insert((Object)"go4");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 200"));
    }

    @Test
    public void testQueryMixed() throws Exception {
        String str = "package org.drools.test  \nimport org.drools.Person \nglobal java.util.List list\nquery peeps( String $name, String $likes, int $age ) \n    Person( $name := name, $likes := likes, $age := age; ) \nend\n";
        str = str + "rule x1\nwhen\n    String( this == \"go1\" )\n    ?peeps($name1; $likes1 : $likes, $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        str = str + "rule x2\nwhen\n    String( this == \"go2\" )\n    ?peeps($name1, \"stilton\"; $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        str = str + "rule x3\nwhen\n    String( this == \"go3\" )\n    $name1 : String() from \"darth\";\n     ?peeps($name1, \"stilton\"; $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        str = str + "rule x4\nwhen\n    String( this == \"go4\" )\n    $name1 : String() from \"darth\"\n     $age1 : Integer() from 200;\n     ?peeps($name1; $likes : \"stilton\", $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("darth", "stilton", 200);
        Person p3 = new Person("yoda", "stilton", 300);
        Person p4 = new Person("luke", "brie", 300);
        Person p5 = new Person("bobba", "cheddar", 300);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.insert((Object)p4);
        ksession.insert((Object)p5);
        ksession.insert((Object)"go1");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        Assert.assertTrue((boolean)list.contains("yoda : 300"));
        Assert.assertTrue((boolean)list.contains("luke : 300"));
        Assert.assertTrue((boolean)list.contains("bobba : 300"));
        list.clear();
        ksession.insert((Object)"go2");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        Assert.assertTrue((boolean)list.contains("yoda : 300"));
        list.clear();
        ksession.insert((Object)"go3");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        list.clear();
        ksession.insert((Object)"go4");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 200"));
    }

    @Test
    public void testQueryPatternBindingAsResult() throws Exception {
        String str = "package org.drools.test  \nimport org.drools.Person \nglobal java.util.List list\nquery peeps( Person $p, String $name, String $likes, int $age ) \n    $p := Person( $name := name, $likes := likes, $age := age; ) \nend\n";
        str = str + "rule x1\nwhen\n    String( this == \"go1\" )\n    ?peeps($p, $name1; $likes1 : $likes, $age1 : $age )\nthen\n   list.add( $p );\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("darth", "stilton", 200);
        Person p3 = new Person("yoda", "stilton", 300);
        Person p4 = new Person("luke", "brie", 300);
        Person p5 = new Person("bobba", "cheddar", 300);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.insert((Object)p4);
        ksession.insert((Object)p5);
        ksession.insert((Object)"go1");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)10L, (long)list.size());
        Assert.assertEquals((Object)p1, list.get(list.indexOf("darth : 100") - 1));
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertEquals((Object)p2, list.get(list.indexOf("darth : 200") - 1));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        Assert.assertEquals((Object)p3, list.get(list.indexOf("yoda : 300") - 1));
        Assert.assertTrue((boolean)list.contains("yoda : 300"));
        Assert.assertEquals((Object)p4, list.get(list.indexOf("luke : 300") - 1));
        Assert.assertTrue((boolean)list.contains("luke : 300"));
        Assert.assertEquals((Object)p5, list.get(list.indexOf("bobba : 300") - 1));
        Assert.assertTrue((boolean)list.contains("bobba : 300"));
    }

    @Test
    public void testQueriesWithNestedAcecssorsAllOutputs() throws Exception {
        String str = "package org.drools.test  \nimport org.drools.Person \nglobal java.util.List list\nquery peeps( String $name, String $likes, String $street ) \n   Person( $name := name, $likes := likes, $street := address.street ) \nend\n";
        str = str + "rule x1\nwhen\n    String( this == \"go1\" )\n    ?peeps($name1; $likes1 : $likes, $street1 : $street )\nthen\n   list.add( $name1 + \" : \" + $likes1 + \" : \" +  $street1 );\nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("darth", "stilton", 100);
        p1.setAddress(new Address("s1"));
        Person p2 = new Person("yoda", "stilton", 300);
        p2.setAddress(new Address("s2"));
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)"go1");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : stilton : s1"));
        Assert.assertTrue((boolean)list.contains("yoda : stilton : s2"));
    }

    @Test
    public void testQueriesWithNestedAcecssorsMixedArgs() throws Exception {
        String str = "package org.drools.test  \nimport org.drools.Person \nglobal java.util.List list\nquery peeps( String $name, String $likes, String $street ) \n   Person( $name := name, $likes := likes, $street := address.street ) \nend\n";
        str = str + "rule x1\nwhen\n    $s : String()\n    ?peeps($name1; $likes1 : $likes, $street : $s )\nthen\n   list.add( $name1 + \" : \" + $likes1 + \" : \" +  $s );\nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("darth", "stilton", 100);
        p1.setAddress(new Address("s1"));
        Person p2 = new Person("yoda", "stilton", 300);
        p2.setAddress(new Address("s2"));
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)"s1");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : stilton : s1"));
        list.clear();
        ksession.insert((Object)"s2");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("yoda : stilton : s2"));
    }

    @Test
    public void testQueryWithDynamicData() throws Exception {
        String str = "package org.drools.test  \nimport org.drools.Person \nglobal java.util.List list\nquery peeps( Person $p, String $name, String $likes, int $age ) \n    $p := Person( ) from new Person( $name, $likes, $age ) \nend\n";
        str = str + "rule x1\nwhen\n    $n1 : String( )\n    ?peeps($p; $name : $n1, $likes : \"stilton\", $age : 100 )\nthen\n   list.add( $p );\nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("yoda", "stilton", 100);
        ksession.insert((Object)"darth");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)p1, list.get(0));
        list.clear();
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.insert((Object)"yoda");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)p2, list.get(0));
    }

    @Test
    public void testQueryWithDyanmicInsert() throws Exception {
        String str = "package org.drools.test  \nimport org.drools.Person \nglobal java.util.List list\nquery peeps( Person $p, String $name, String $likes, int $age ) \n    $p := Person( ) from new Person( $name, $likes, $age ) \nend\n";
        str = str + "rule x1\nwhen\n    $n1 : String( )\n    not Person( name == 'darth' )\n     ?peeps($p; $name : $n1, $likes : \"stilton\", $age : 100 )\nthen\n   insert( $p );\nend \n";
        str = str + "rule x2\nwhen\n    $p : Person( )\nthen\n   list.add( $p );\nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("yoda", "stilton", 100);
        ksession.insert((Object)"darth");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        ksession.insert((Object)"yoda");
        ksession = SerializationHelper.getSerialisedStatefulKnowledgeSession(ksession, true);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)p1, list.get(0));
    }

    @Test
    public void testQueryWithOr() throws Exception {
        String str = "package org.drools.test  \nimport java.util.List\nimport java.util.ArrayList\nglobal List list\ndialect \"mvel\"\n\nimport org.drools.integrationtests.BackwardChainingTest.Q\nimport org.drools.integrationtests.BackwardChainingTest.R\nimport org.drools.integrationtests.BackwardChainingTest.S\n\nquery q(int x)\n    Q( x := value )\nend\n\nquery r(int x)\n    R( x := value )\nend\n\nquery s(int x)\n    S( x := value )    \nend\n\nquery p(int x)\n    (?q(x;) and ?r(x;) ) \n    or\n    ?s(x;)\nend\nrule init when\nthen\n insert( new Q(1) );\n  insert( new Q(5) );\n  insert( new Q(6) );\n  insert( new R(1) );\n  insert( new R(4) );\n  insert( new R(6) );\n  insert( new R(2) );\n  insert( new S(2) );\n  insert( new S(3) );\n  insert( new S(6) );\n end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList<Integer> list = new ArrayList<Integer>();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        QueryResults results = null;
        list.clear();
        results = ksession.getQueryResults("p", (Object[])new Integer[]{0});
        for (QueryResultsRow result : results) {
            list.add((Integer)result.get("x"));
        }
        Assert.assertEquals((long)0L, (long)list.size());
        list.clear();
        results = ksession.getQueryResults("p", (Object[])new Integer[]{1});
        for (QueryResultsRow result : results) {
            list.add((Integer)result.get("x"));
        }
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Integer)list.get(0)).intValue());
        System.out.println();
        list.clear();
        results = ksession.getQueryResults("p", (Object[])new Integer[]{2});
        for (QueryResultsRow result : results) {
            list.add((Integer)result.get("x"));
        }
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Integer)list.get(0)).intValue());
        list.clear();
        results = ksession.getQueryResults("p", (Object[])new Integer[]{3});
        for (QueryResultsRow result : results) {
            list.add((Integer)result.get("x"));
        }
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((Integer)list.get(0)).intValue());
        list.clear();
        results = ksession.getQueryResults("p", (Object[])new Integer[]{4});
        for (QueryResultsRow result : results) {
            list.add((Integer)result.get("x"));
        }
        Assert.assertEquals((long)0L, (long)list.size());
        list.clear();
        results = ksession.getQueryResults("p", (Object[])new Integer[]{5});
        for (QueryResultsRow result : results) {
            list.add((Integer)result.get("x"));
        }
        Assert.assertEquals((long)0L, (long)list.size());
        list.clear();
        results = ksession.getQueryResults("p", (Object[])new Integer[]{6});
        for (QueryResultsRow result : results) {
            list.add((Integer)result.get("x"));
        }
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)6L, (long)((Integer)list.get(0)).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)list.get(1)).intValue());
    }

    @Test
    public void testGeneology() throws Exception {
        String str = "package org.drools.test2  \nglobal java.util.List list\ndialect \"mvel\"\nquery man( String name ) \n   org.drools.integrationtests.BackwardChainingTest.Man( name := name ) \nend\nquery woman( String name ) \n   org.drools.integrationtests.BackwardChainingTest.Woman( name := name ) \nend\nquery parent( String parent, String child ) \n   org.drools.integrationtests.BackwardChainingTest.Parent( parent := parent, child := child ) \nend\nquery father( String father, String child ) \n   ?man( father; ) \n   ?parent( father, child; ) \nend\nquery mother( String mother, String child ) \n   ?woman( mother; ) \n   ?parent( mother, child; ) \nend\nquery son( String son, String parent ) \n   ?man( son; ) \n   ?parent( parent, son; ) \nend\nquery daughter( String daughter, String parent ) \n   ?woman( daughter; ) \n   ?parent( parent, daughter; ) \nend\nquery siblings( String c1, String c2 ) \n   ?parent( $p, c1; ) \n   ?parent( $p, c2; ) \n   eval( !c1.equals( c2 ) )\nend\nquery fullSiblings( String c1, String c2 )\n   ?parent( $p1, c1; ) ?parent( $p1, c2; )\n   ?parent( $p2, c1; ) ?parent( $p2, c2; )\n   eval( !c1.equals( c2 ) && !$p1.equals( $p2 )  )\nend\nquery fullSiblings2( String c1, String c2 )\n   ?father( $p1, c1; ) ?father( $p1, c2; )\n   ?mother( $p2, c1; ) ?mother( $p2, c2; )\n   eval( !c1.equals( c2 ) )\nend\nquery uncle( String uncle, String n )\n   ?man( uncle; ) ?siblings( uncle, parent; )\n   ?parent( parent, n; )\n end\nquery aunt( String aunt, String n )\n   ?woman( aunt; ) ?siblings( aunt, parent; )\n   ?parent( parent, n; )\n end\nquery grantParents( String gp, String gc )\n   ?parent( gp, p; ) ?parent( p, gc; )\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList<String> list = new ArrayList<String>();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Man("john"));
        ksession.insert((Object)new Woman("janet"));
        ksession.insert((Object)new Man("adam"));
        ksession.insert((Object)new Parent("john", "adam"));
        ksession.insert((Object)new Parent("janet", "adam"));
        ksession.insert((Object)new Man("stan"));
        ksession.insert((Object)new Parent("john", "stan"));
        ksession.insert((Object)new Parent("janet", "stan"));
        ksession.insert((Object)new Man("carl"));
        ksession.insert((Object)new Woman("tina"));
        ksession.insert((Object)new Woman("eve"));
        ksession.insert((Object)new Parent("carl", "eve"));
        ksession.insert((Object)new Parent("tina", "eve"));
        ksession.insert((Object)new Woman("mary"));
        ksession.insert((Object)new Parent("carl", "mary"));
        ksession.insert((Object)new Parent("tina", "mary"));
        ksession.insert((Object)new Man("peter"));
        ksession.insert((Object)new Parent("adam", "peter"));
        ksession.insert((Object)new Parent("eve", "peter"));
        ksession.insert((Object)new Man("paul"));
        ksession.insert((Object)new Parent("adam", "paul"));
        ksession.insert((Object)new Parent("mary", "paul"));
        ksession.insert((Object)new Woman("jill"));
        ksession.insert((Object)new Parent("adam", "jill"));
        ksession.insert((Object)new Parent("eve", "jill"));
        QueryResults results = null;
        list.clear();
        results = ksession.getQueryResults("woman", new Object[]{Variable.v});
        for (QueryResultsRow result : results) {
            list.add((String)result.get("name"));
        }
        Assert.assertEquals((long)5L, (long)list.size());
        this.assertContains(new String[]{"janet", "mary", "tina", "eve", "jill"}, list);
        list.clear();
        results = ksession.getQueryResults("man", new Object[]{Variable.v});
        for (QueryResultsRow result : results) {
            list.add((String)result.get("name"));
        }
        Assert.assertEquals((long)6L, (long)list.size());
        this.assertContains(new String[]{"stan", "john", "peter", "carl", "adam", "paul"}, list);
        list.clear();
        results = ksession.getQueryResults("father", new Object[]{Variable.v, Variable.v});
        for (QueryResultsRow result : results) {
            list.add(result.get("father") + ", " + result.get("child"));
        }
        Assert.assertEquals((long)7L, (long)list.size());
        this.assertContains(new String[]{"john, adam", "john, stan", "carl, eve", "carl, mary", "adam, peter", "adam, paul", "adam, jill"}, list);
        list.clear();
        results = ksession.getQueryResults("mother", new Object[]{Variable.v, Variable.v});
        for (QueryResultsRow result : results) {
            list.add(result.get("mother") + ", " + result.get("child"));
        }
        Assert.assertEquals((long)7L, (long)list.size());
        this.assertContains(new String[]{"janet, adam", "janet, stan", "mary, paul", "tina, eve", "tina, mary", "eve, peter", "eve, jill"}, list);
        list.clear();
        results = ksession.getQueryResults("son", new Object[]{Variable.v, Variable.v});
        for (QueryResultsRow result : results) {
            list.add(result.get("son") + ", " + result.get("parent"));
        }
        Assert.assertEquals((long)8L, (long)list.size());
        this.assertContains(new String[]{"stan, john", "stan, janet", "peter, adam", "peter, eve", "adam, john", "adam, janet", "paul, mary", "paul, adam"}, list);
        list.clear();
        results = ksession.getQueryResults("daughter", new Object[]{Variable.v, Variable.v});
        for (QueryResultsRow result : results) {
            list.add(result.get("daughter") + ", " + result.get("parent"));
        }
        Assert.assertEquals((long)6L, (long)list.size());
        this.assertContains(new String[]{"mary, carl", "mary, tina", "eve, carl", "eve, tina", "jill, adam", "jill, eve"}, list);
        list.clear();
        results = ksession.getQueryResults("siblings", new Object[]{Variable.v, Variable.v});
        for (QueryResultsRow result : results) {
            list.add(result.get("c1") + ", " + result.get("c2"));
        }
        Assert.assertEquals((long)16L, (long)list.size());
        this.assertContains(new String[]{"eve, mary", "mary, eve", "adam, stan", "stan, adam", "adam, stan", "stan, adam", "peter, paul", "peter, jill", "paul, peter", "paul, jill", "jill, peter", "jill, paul", "peter, jill", "jill, peter", "eve, mary", "mary, eve"}, list);
        list.clear();
        results = ksession.getQueryResults("fullSiblings", new Object[]{Variable.v, Variable.v});
        for (QueryResultsRow result : results) {
            list.add(result.get("c1") + ", " + result.get("c2"));
        }
        Assert.assertEquals((long)12L, (long)list.size());
        this.assertContains(new String[]{"eve, mary", "mary, eve", "adam, stan", "stan, adam", "adam, stan", "stan, adam", "peter, jill", "jill, peter", "peter, jill", "jill, peter", "eve, mary", "mary, eve"}, list);
        list.clear();
        results = ksession.getQueryResults("fullSiblings", new Object[]{Variable.v, Variable.v});
        for (QueryResultsRow result : results) {
            list.add(result.get("c1") + ", " + result.get("c2"));
        }
        Assert.assertEquals((long)12L, (long)list.size());
        this.assertContains(new String[]{"eve, mary", "mary, eve", "adam, stan", "stan, adam", "adam, stan", "stan, adam", "peter, jill", "jill, peter", "peter, jill", "jill, peter", "eve, mary", "mary, eve"}, list);
        list.clear();
        results = ksession.getQueryResults("uncle", new Object[]{Variable.v, Variable.v});
        for (QueryResultsRow result : results) {
            list.add(result.get("uncle") + ", " + result.get("n"));
        }
        Assert.assertEquals((long)6L, (long)list.size());
        this.assertContains(new String[]{"stan, peter", "stan, paul", "stan, jill", "stan, peter", "stan, paul", "stan, jill"}, list);
        list.clear();
        results = ksession.getQueryResults("aunt", new Object[]{Variable.v, Variable.v});
        for (QueryResultsRow result : results) {
            list.add(result.get("aunt") + ", " + result.get("n"));
        }
        Assert.assertEquals((long)6L, (long)list.size());
        this.assertContains(new String[]{"mary, peter", "mary, jill", "mary, peter", "mary, jill", "eve, paul", "eve, paul"}, list);
        list.clear();
        results = ksession.getQueryResults("grantParents", new Object[]{Variable.v, Variable.v});
        for (QueryResultsRow result : results) {
            list.add(result.get("gp") + ", " + result.get("gc"));
        }
        Assert.assertEquals((long)12L, (long)list.size());
        this.assertContains(new String[]{"carl, peter", "carl, jill", "carl, paul", "john, peter", "john, paul", "john, jill", "janet, peter", "janet, paul", "janet, jill", "tina, peter", "tina, jill", "tina, paul"}, list);
    }

    @Test
    public void testNaniSearchs() throws Exception {
        String str = "package org.drools.test  \nimport java.util.List\nimport java.util.ArrayList\nimport java.util.Map\nimport java.util.HashMap\nglobal List list\ndialect \"mvel\"\ndeclare Room    name : String\nend\n\ndeclare Location\n    thing : String \n    location : String \nend\ndeclare Door\n   fromLocation : String\n   toLocation : String\nend\ndeclare Edible\n   thing : String\nend\ndeclare TastesYucky\n   thing : String\nend\ndeclare TastesYucky\n   thing : String\nend\n\ndeclare Here\n   place : String \nend\n\nquery whereFood( String x, String y ) \n    ( Location(x, y;) and\n      Edible(x;) )      or \n     ( Location(z, y;) and ?whereFood(x, z;) )\nend\nquery connect( String x, String y ) \n    Door(x, y;)\n    or \n    Door(y, x;)\nend\n\nquery isContainedIn( String x, String y ) \n    Location(x, y;)\n    or \n    ( Location(z, y;) and ?isContainedIn(x, z;) )\nend\n\nquery look(String place, List things, List food, List exits ) \n    Here(place;)\n    things := List() from accumulate( Location(thing, place;),\n                                      collectList( thing ) )\n    food := List() from accumulate( ?whereFood(thing, place;) ,                                    collectList( thing ) )\n    exits := List() from accumulate( ?connect(place, exit;),\n                                    collectList( exit ) )\nend\n\nrule reactiveLook when\n    Here( place : place) \n    ?look(place, things, food, exits;)\nthen\n    Map map = new HashMap();    list.add(map);    map.put( 'place', place);     map.put( 'things', things);     map.put( 'food', food);     map.put( 'exits', exits);     System.out.println( \"You are in the \" + place);\n    System.out.println( \"  You can see \" + things );\n    System.out.println( \"  You can eat \" + food );\n    System.out.println( \"  You can go to \" + exits );\nend\n\nrule init when\nthen\n        insert( new Room(\"kitchen\") );\n        insert( new Room(\"office\") );\n        insert( new Room(\"hall\") );\n        insert( new Room(\"dining room\") );\n        insert( new Room(\"cellar\") );\n        \n        insert( new Location(\"apple\", \"kitchen\") );\n        insert( new Location(\"desk\", \"office\") );\n        insert( new Location(\"apple\", \"desk\") );\n        insert( new Location(\"flashlight\", \"desk\") );\n        insert( new Location(\"envelope\", \"desk\") );\n        insert( new Location(\"key\", \"envelope\") );\n        insert( new Location(\"washing machine\", \"cellar\") );\n        insert( new Location(\"nani\", \"washing machine\") );\n        insert( new Location(\"broccoli\", \"kitchen\") );\n        insert( new Location(\"crackers\", \"kitchen\") );\n        insert( new Location(\"computer\", \"office\") );\n        \n        insert( new Door(\"office\", \"hall\") );\n        insert( new Door(\"kitchen\", \"office\") );\n        insert( new Door(\"hall\", \"dining room\") );\n        insert( new Door(\"kitchen\", \"cellar\") );\n        insert( new Door(\"dining room\", \"kitchen\") );\n        \n        insert( new Edible(\"apple\") );\n        insert( new Edible(\"crackers\") );\n        \n        insert( new TastesYucky(\"broccoli\") );  end\nrule go1 when\n   String( this == 'go1' )\nthen\n   insert( new Here(\"kitchen\") );\nend\n\nrule go2 when\n   String( this == 'go2' )\n   $h : Here( place == \"kitchen\")then\n   modify( $h ) { place = \"office\" };\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        QueryResults results = null;
        ksession.fireAllRules();
        ksession.insert((Object)"go1");
        ksession.fireAllRules();
        Map map = (Map)list.get(0);
        Assert.assertEquals((Object)"kitchen", map.get("place"));
        List items = (List)map.get("things");
        Assert.assertEquals((long)3L, (long)items.size());
        this.assertContains(new String[]{"apple", "broccoli", "crackers"}, items);
        items = (List)map.get("food");
        Assert.assertEquals((long)2L, (long)items.size());
        this.assertContains(new String[]{"apple", "crackers"}, items);
        items = (List)map.get("exits");
        Assert.assertEquals((long)3L, (long)items.size());
        this.assertContains(new String[]{"office", "cellar", "dining room"}, items);
        ksession.insert((Object)"go2");
        ksession.fireAllRules();
        map = (Map)list.get(1);
        Assert.assertEquals((Object)"office", map.get("place"));
        items = (List)map.get("things");
        Assert.assertEquals((long)2L, (long)items.size());
        this.assertContains(new String[]{"computer", "desk"}, items);
        items = (List)map.get("food");
        Assert.assertEquals((long)1L, (long)items.size());
        this.assertContains(new String[]{"apple"}, items);
        items = (List)map.get("exits");
        Assert.assertEquals((long)2L, (long)items.size());
        this.assertContains(new String[]{"hall", "kitchen"}, items);
        results = ksession.getQueryResults("isContainedIn", new Object[]{"key", "office"});
        Assert.assertEquals((long)1L, (long)results.size());
        QueryResultsRow result = (QueryResultsRow)results.iterator().next();
        Assert.assertEquals((Object)"key", (Object)result.get("x"));
        Assert.assertEquals((Object)"office", (Object)result.get("y"));
        results = ksession.getQueryResults("isContainedIn", new Object[]{"key", Variable.v});
        ArrayList<List<String>> l = new ArrayList<List<String>>();
        for (QueryResultsRow r : results) {
            l.add(Arrays.asList((String)r.get("x"), (String)r.get("y")));
        }
        Assert.assertEquals((long)3L, (long)results.size());
        this.assertContains(Arrays.asList("key", "desk"), l);
        this.assertContains(Arrays.asList("key", "office"), l);
        this.assertContains(Arrays.asList("key", "envelope"), l);
        results = ksession.getQueryResults("isContainedIn", new Object[]{Variable.v, "office"});
        l = new ArrayList();
        for (QueryResultsRow r : results) {
            l.add(Arrays.asList((String)r.get("x"), (String)r.get("y")));
        }
        Assert.assertEquals((long)6L, (long)results.size());
        this.assertContains(Arrays.asList("desk", "office"), l);
        this.assertContains(Arrays.asList("computer", "office"), l);
        this.assertContains(Arrays.asList("apple", "office"), l);
        this.assertContains(Arrays.asList("envelope", "office"), l);
        this.assertContains(Arrays.asList("flashlight", "office"), l);
        this.assertContains(Arrays.asList("key", "office"), l);
        results = ksession.getQueryResults("isContainedIn", new Object[]{Variable.v, Variable.v});
        l = new ArrayList();
        for (QueryResultsRow r : results) {
            l.add(Arrays.asList((String)r.get("x"), (String)r.get("y")));
        }
        Assert.assertEquals((long)17L, (long)results.size());
        this.assertContains(Arrays.asList("apple", "kitchen"), l);
        this.assertContains(Arrays.asList("apple", "desk"), l);
        this.assertContains(Arrays.asList("envelope", "desk"), l);
        this.assertContains(Arrays.asList("desk", "office"), l);
        this.assertContains(Arrays.asList("computer", "office"), l);
        this.assertContains(Arrays.asList("washing machine", "cellar"), l);
        this.assertContains(Arrays.asList("key", "envelope"), l);
        this.assertContains(Arrays.asList("broccoli", "kitchen"), l);
        this.assertContains(Arrays.asList("nani", "washing machine"), l);
        this.assertContains(Arrays.asList("crackers", "kitchen"), l);
        this.assertContains(Arrays.asList("flashlight", "desk"), l);
        this.assertContains(Arrays.asList("nani", "cellar"), l);
        this.assertContains(Arrays.asList("apple", "office"), l);
        this.assertContains(Arrays.asList("envelope", "office"), l);
        this.assertContains(Arrays.asList("flashlight", "office"), l);
        this.assertContains(Arrays.asList("key", "office"), l);
        this.assertContains(Arrays.asList("key", "desk"), l);
    }

    @Test
    public void testOpenBackwardChain() throws Exception {
        String str = "package org.drools.test  \nimport java.util.List\nimport java.util.ArrayList\nimport org.drools.Person\nglobal List list\ndialect \"mvel\"\ndeclare Location\n    thing : String \n    location : String \nend\nquery isContainedIn( String x, String y ) \n    Location(x, y;)\n    or \n    ( Location(z, y;) and isContainedIn(x, z;) )\nend\n\nrule look when \n    Person( $l : likes ) \n    isContainedIn( $l, 'office'; )\nthen\n   insertLogical( 'blah' );end\nrule existsBlah when \n    exists String( this == 'blah') \nthen\n   list.add( 'exists blah' );end\n\nrule notBlah when \n    not String( this == 'blah') \nthen\n   list.add( 'not blah' );end\n\nrule init when\nthen\n        insert( new Location(\"apple\", \"kitchen\") );\n        insert( new Location(\"desk\", \"office\") );\n        insert( new Location(\"flashlight\", \"desk\") );\n        insert( new Location(\"envelope\", \"desk\") );\n        insert( new Location(\"key\", \"envelope\") );\n        insert( new Location(\"washing machine\", \"cellar\") );\n        insert( new Location(\"nani\", \"washing machine\") );\n        insert( new Location(\"broccoli\", \"kitchen\") );\n        insert( new Location(\"crackers\", \"kitchen\") );\n        insert( new Location(\"computer\", \"office\") );\nend\n\nrule go1 when \n    String( this == 'go1') \nthen\n        list.add( rule.getName() ); \n        insert( new Location('lamp', 'desk') );\nend\n\nrule go2 when \n    String( this == 'go2') \n    $l : Location('lamp', 'desk'; )\nthen\n    list.add( rule.getName() ); \n    retract( $l );\nend\n\nrule go3 when \n    String( this == 'go3') \nthen\n        list.add( rule.getName() ); \n        insert( new Location('lamp', 'desk') );\nend\n\nrule go4 when \n    String( this == 'go4') \n    $l : Location('lamp', 'desk'; )\nthen\n        list.add( rule.getName() ); \n    modify( $l ) { thing = 'book' };\nend\n\nrule go5 when \n    String( this == 'go5') \n    $l : Location('book', 'desk'; )\nthen\n    list.add( rule.getName() ); \n    modify( $l ) { thing = 'lamp' };\nend\n\nrule go6 when \n    String( this == 'go6') \n    $l : Location( 'lamp', 'desk'; )\nthen\n    list.add( rule.getName() ); \n    modify( $l ) { thing = 'book' };\nend\n\nrule go7 when \n    String( this == 'go7') \n    $p : Person( likes == 'lamp' ) \nthen\n    list.add( rule.getName() ); \n    modify( $p ) { likes = 'key' };\nend\n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Object results = null;
        Person p = new Person();
        p.setLikes("lamp");
        FactHandle handle = ksession.insert((Object)p);
        ksession.fireAllRules();
        list.clear();
        FactHandle fh = ksession.insert((Object)"go1");
        ksession.fireAllRules();
        ksession.retract(fh);
        Assert.assertEquals((Object)"go1", list.get(0));
        Assert.assertEquals((Object)"exists blah", list.get(1));
        fh = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        ksession.retract(fh);
        Assert.assertEquals((Object)"go2", list.get(2));
        Assert.assertEquals((Object)"not blah", list.get(3));
        fh = ksession.insert((Object)"go3");
        ksession.fireAllRules();
        ksession.retract(fh);
        Assert.assertEquals((Object)"go3", list.get(4));
        Assert.assertEquals((Object)"exists blah", list.get(5));
        fh = ksession.insert((Object)"go4");
        ksession.fireAllRules();
        ksession.retract(fh);
        Assert.assertEquals((Object)"go4", list.get(6));
        Assert.assertEquals((Object)"not blah", list.get(7));
        fh = ksession.insert((Object)"go5");
        ksession.fireAllRules();
        ksession.retract(fh);
        Assert.assertEquals((Object)"go5", list.get(8));
        Assert.assertEquals((Object)"exists blah", list.get(9));
        fh = ksession.insert((Object)"go6");
        ksession.fireAllRules();
        ksession.retract(fh);
        Assert.assertEquals((Object)"go6", list.get(10));
        Assert.assertEquals((Object)"not blah", list.get(11));
        fh = ksession.insert((Object)"go7");
        ksession.fireAllRules();
        ksession.retract(fh);
        Assert.assertEquals((Object)"go7", list.get(12));
        Assert.assertEquals((Object)"exists blah", list.get(13));
    }

    @Test
    public void testCompile() {
        String drl = "";
        drl = "declare Location\nthing : String\nlocation : String\nend\n\n";
        drl = drl + "query isContainedIn( String x, String y )\n" + "Location( x := thing, y := location)\n" + "or \n" + "( Location(z := thing, y := location) and ?isContainedIn( x := x, z := y ) )\n" + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
    }

    public void assertContains(Object[] objects, List list) {
        for (Object object : objects) {
            if (list.contains(object)) continue;
            Assert.fail((String)("does not contain:" + object));
        }
    }

    public void assertContains(List objects, List list) {
        if (!list.contains(objects)) {
            Assert.fail((String)("does not contain:" + objects));
        }
    }

    public static class S {
        int value;

        public S(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String toString() {
            return "S" + this.value;
        }
    }

    public static class R {
        int value;

        public R(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String toString() {
            return "R" + this.value;
        }
    }

    public static class Q {
        int value;

        public Q(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String toString() {
            return "Q" + this.value;
        }
    }

    public static class Parent {
        private String parent;
        private String child;

        public Parent(String parent, String child) {
            this.parent = parent;
            this.child = child;
        }

        public String getParent() {
            return this.parent;
        }

        public void setParent(String parent) {
            this.parent = parent;
        }

        public String getChild() {
            return this.child;
        }

        public void setChild(String child) {
            this.child = child;
        }
    }

    public static class Woman {
        private String name;

        public Woman(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class Man {
        private String name;

        public Man(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

