/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.PackageBuilder;
import org.junit.Assert;
import org.junit.Test;

public class DroolsTest {
    private static final int NUM_FACTS = 20;
    private static int counter;

    @Test
    public void test1() throws Exception {
        String str = "package org.drools.integrationtests;\n";
        str = str + "import org.drools.integrationtests.DroolsTest;\n";
        str = str + "import org.drools.integrationtests.DroolsTest.Foo;\n";
        str = str + "import org.drools.integrationtests.DroolsTest.Bar;\n";
        str = str + "rule test\n";
        str = str + "when\n";
        str = str + "      Foo($p : id, id < " + Integer.toString(20) + ")\n";
        str = str + "      Bar(id == $p)\n";
        str = str + "then\n";
        str = str + "   DroolsTest.incCounter();\n";
        str = str + "end\n";
        counter = 0;
        RuleBase rb = RuleBaseFactory.newRuleBase();
        StatefulSession wm = rb.newStatefulSession();
        for (int i = 0; i < 20; ++i) {
            wm.insert((Object)new Foo(i));
            wm.insert((Object)new Bar(i));
        }
        PackageBuilder bld = new PackageBuilder();
        bld.addPackageFromDrl((Reader)new StringReader(str));
        if (bld.hasErrors()) {
            Assert.fail((String)bld.getErrors().toString());
        }
        rb.addPackage(bld.getPackage());
        wm.fireAllRules();
        System.out.println(counter + ":" + (counter == 20 ? "passed" : "failed"));
    }

    public static void incCounter() {
        ++counter;
    }

    public static class Bar {
        private final int id;

        Bar(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    public static class Foo {
        private final int id;

        Foo(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

