/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.drools.Alarm;
import org.drools.Cheese;
import org.drools.FactHandle;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.PackageBuilder;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.rule.Package;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.conf.ClockTypeOption;
import org.drools.runtime.conf.KnowledgeSessionOption;
import org.drools.time.Calendar;
import org.drools.time.impl.PseudoClockScheduler;
import org.junit.Assert;
import org.junit.Test;

public class TimerAndCalendarTest {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    @Test
    public void testDuration() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Duration.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        FactHandle brieHandle = workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        Thread.sleep(300L);
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testDurationWithNoLoop() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Duration_with_NoLoop.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        FactHandle brieHandle = workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        Thread.sleep(300L);
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testDurationMemoryLeakonRepeatedUpdate() throws Exception {
        String str = "";
        str = str + "package org.drools.test\n";
        str = str + "import org.drools.Alarm\n";
        str = str + "global java.util.List list;";
        str = str + "rule \"COMPTEUR\"\n";
        str = str + "  timer 50\n";
        str = str + "  when\n";
        str = str + "    $alarm : Alarm( number < 5 )\n";
        str = str + "  then\n";
        str = str + "    $alarm.incrementNumber();\n";
        str = str + "    list.add( $alarm );\n";
        str = str + "    update($alarm);\n";
        str = str + "end\n";
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader(str));
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(builder.getPackage());
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.insert((Object)new Alarm());
        session.fireAllRules();
        Thread.sleep(1000L);
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertEquals((long)0L, (long)session.getAgenda().getScheduledActivations().length);
    }

    @Test
    public void testFireRuleAfterDuration() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_FireRuleAfterDuration.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        FactHandle brieHandle = workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        Thread.sleep(300L);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testNoProtocolIntervalTimer() throws Exception {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx \n";
        str = str + "  duration (30s 10s) ";
        str = str + "when \n";
        str = str + "then \n";
        str = str + "  list.add(\"fired\"); \n";
        str = str + "end  \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
            Assert.assertTrue((boolean)kbuilder.hasErrors());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        ArrayList list = new ArrayList();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(conf, null);
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        timeService.advanceTime(new Date().getTime(), TimeUnit.MILLISECONDS);
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        timeService.advanceTime(20L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        timeService.advanceTime(15L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        timeService.advanceTime(3L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        timeService.advanceTime(2L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        timeService.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testIntervalTimer() throws Exception {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx \n";
        str = str + "  timer (int:30s 10s) ";
        str = str + "when \n";
        str = str + "then \n";
        str = str + "  list.add(\"fired\"); \n";
        str = str + "end  \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
            Assert.assertTrue((boolean)kbuilder.hasErrors());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(conf, null);
        ArrayList list = new ArrayList();
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        timeService.advanceTime(new Date().getTime(), TimeUnit.MILLISECONDS);
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        timeService.advanceTime(20L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        timeService.advanceTime(15L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        timeService.advanceTime(3L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        timeService.advanceTime(2L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        timeService.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testCronTimer() throws Exception {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx \n";
        str = str + "  timer (cron:15 * * * * ?) ";
        str = str + "when \n";
        str = str + "then \n";
        str = str + "  list.add(\"fired\"); \n";
        str = str + "end  \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
            Assert.assertTrue((boolean)kbuilder.hasErrors());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        ArrayList list = new ArrayList();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(conf, null);
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        Date date = df.parse("2009-01-01T00:00:00.000-0000");
        timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        timeService.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        timeService.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        timeService.advanceTime(30L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        timeService.advanceTime(30L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testCalendarNormalRuleSingleCalendar() throws Exception {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx \n";
        str = str + "  calendars \"cal1\"\n";
        str = str + "when \n";
        str = str + "  String()\n";
        str = str + "then \n";
        str = str + "  list.add(\"fired\"); \n";
        str = str + "end  \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
            Assert.assertTrue((boolean)kbuilder.hasErrors());
        }
        Calendar calFalse = new Calendar(){

            public boolean isTimeIncluded(long timestamp) {
                return false;
            }
        };
        Calendar calTrue = new Calendar(){

            public boolean isTimeIncluded(long timestamp) {
                return true;
            }
        };
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        ArrayList list = new ArrayList();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(conf, null);
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        Date date = df.parse("2009-01-01T00:00:00.000-0000");
        ksession.getCalendars().set("cal1", calTrue);
        timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
        ksession.setGlobal("list", list);
        ksession.insert((Object)"o1");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        timeService.advanceTime(10L, TimeUnit.SECONDS);
        ksession.insert((Object)"o2");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        ksession.getCalendars().set("cal1", calFalse);
        timeService.advanceTime(10L, TimeUnit.SECONDS);
        ksession.insert((Object)"o3");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        ksession.getCalendars().set("cal1", calTrue);
        timeService.advanceTime(30L, TimeUnit.SECONDS);
        ksession.insert((Object)"o4");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testCalendarNormalRuleMultipleCalendars() throws Exception {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx \n";
        str = str + "  calendars \"cal1\", \"cal2\"\n";
        str = str + "when \n";
        str = str + "  String()\n";
        str = str + "then \n";
        str = str + "  list.add(\"fired\"); \n";
        str = str + "end  \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
            Assert.assertTrue((boolean)kbuilder.hasErrors());
        }
        Calendar calFalse = new Calendar(){

            public boolean isTimeIncluded(long timestamp) {
                return false;
            }
        };
        Calendar calTrue = new Calendar(){

            public boolean isTimeIncluded(long timestamp) {
                return true;
            }
        };
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        ArrayList list = new ArrayList();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(conf, null);
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        Date date = df.parse("2009-01-01T00:00:00.000-0000");
        ksession.getCalendars().set("cal1", calTrue);
        ksession.getCalendars().set("cal2", calTrue);
        timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
        ksession.setGlobal("list", list);
        ksession.insert((Object)"o1");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.getCalendars().set("cal2", calFalse);
        timeService.advanceTime(10L, TimeUnit.SECONDS);
        ksession.insert((Object)"o2");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.getCalendars().set("cal1", calFalse);
        timeService.advanceTime(10L, TimeUnit.SECONDS);
        ksession.insert((Object)"o3");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        ksession.getCalendars().set("cal1", calTrue);
        ksession.getCalendars().set("cal2", calTrue);
        timeService.advanceTime(30L, TimeUnit.SECONDS);
        ksession.insert((Object)"o4");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testCalendarsWithCron() throws Exception {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx \n";
        str = str + "  calendars \"cal1\", \"cal2\"\n";
        str = str + "  timer (cron:15 * * * * ?) ";
        str = str + "when \n";
        str = str + "then \n";
        str = str + "  list.add(\"fired\"); \n";
        str = str + "end  \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
            Assert.assertTrue((boolean)kbuilder.hasErrors());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        ArrayList list = new ArrayList();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(conf, null);
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        Date date = df.parse("2009-01-01T00:00:00.000-0000");
        timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
        final Date date1 = new Date(date.getTime() + 15000L);
        final Date date2 = new Date(date1.getTime() + 60000L);
        final Date date3 = new Date(date2.getTime() + 60000L);
        final Date date4 = new Date(date3.getTime() + 60000L);
        Calendar cal1 = new Calendar(){

            public boolean isTimeIncluded(long timestamp) {
                if (timestamp == date1.getTime()) {
                    return true;
                }
                return timestamp != date4.getTime();
            }
        };
        Calendar cal2 = new Calendar(){

            public boolean isTimeIncluded(long timestamp) {
                if (timestamp == date2.getTime()) {
                    return false;
                }
                if (timestamp == date3.getTime()) {
                    return true;
                }
                return true;
            }
        };
        ksession.getCalendars().set("cal1", cal1);
        ksession.getCalendars().set("cal2", cal2);
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        timeService.advanceTime(20L, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)list.size());
        timeService.advanceTime(60L, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)list.size());
        timeService.advanceTime(60L, TimeUnit.SECONDS);
        Assert.assertEquals((long)2L, (long)list.size());
        timeService.advanceTime(60L, TimeUnit.SECONDS);
        Assert.assertEquals((long)2L, (long)list.size());
        timeService.advanceTime(60L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        timeService.advanceTime(60L, TimeUnit.SECONDS);
        Assert.assertEquals((long)4L, (long)list.size());
    }

    @Test
    public void testCalendarsWithIntervals() throws Exception {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx \n";
        str = str + "  calendars \"cal1\", \"cal2\"\n";
        str = str + "  timer (15s 60s) ";
        str = str + "when \n";
        str = str + "then \n";
        str = str + "  list.add(\"fired\"); \n";
        str = str + "end  \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
            Assert.assertTrue((boolean)kbuilder.hasErrors());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        ArrayList list = new ArrayList();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(conf, null);
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        Date date = df.parse("2009-01-01T00:00:00.000-0000");
        timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
        final Date date1 = new Date(date.getTime() + 15000L);
        final Date date2 = new Date(date1.getTime() + 60000L);
        final Date date3 = new Date(date2.getTime() + 60000L);
        final Date date4 = new Date(date3.getTime() + 60000L);
        Calendar cal1 = new Calendar(){

            public boolean isTimeIncluded(long timestamp) {
                if (timestamp == date1.getTime()) {
                    return true;
                }
                return timestamp != date4.getTime();
            }
        };
        Calendar cal2 = new Calendar(){

            public boolean isTimeIncluded(long timestamp) {
                if (timestamp == date2.getTime()) {
                    return false;
                }
                if (timestamp == date3.getTime()) {
                    return true;
                }
                return true;
            }
        };
        ksession.getCalendars().set("cal1", cal1);
        ksession.getCalendars().set("cal2", cal2);
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        timeService.advanceTime(20L, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)list.size());
        timeService.advanceTime(60L, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)list.size());
        timeService.advanceTime(60L, TimeUnit.SECONDS);
        Assert.assertEquals((long)2L, (long)list.size());
        timeService.advanceTime(60L, TimeUnit.SECONDS);
        Assert.assertEquals((long)2L, (long)list.size());
        timeService.advanceTime(60L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        timeService.advanceTime(60L, TimeUnit.SECONDS);
        Assert.assertEquals((long)4L, (long)list.size());
    }

    @Test
    public void testCalendarsWithIntervalsAndStartAndEnd() throws Exception {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx \n";
        str = str + "  calendars \"cal1\"\n";
        str = str + "  timer (0d 1d start=3-JAN-2010 end=5-JAN-2010) ";
        str = str + "when \n";
        str = str + "then \n";
        str = str + "  list.add(\"fired\"); \n";
        str = str + "end  \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
            Assert.assertTrue((boolean)kbuilder.hasErrors());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        ArrayList list = new ArrayList();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(conf, null);
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        Date date = df.parse("1-JAN-2010");
        Calendar cal1 = new Calendar(){

            public boolean isTimeIncluded(long timestamp) {
                return true;
            }
        };
        long oneDay = 86400L;
        ksession.getCalendars().set("cal1", cal1);
        ksession.setGlobal("list", list);
        timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)2L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testCalendarsWithIntervalsAndStartAndLimit() throws Exception {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx \n";
        str = str + "  calendars \"cal1\"\n";
        str = str + "  timer (0d 1d start=3-JAN-2010 repeat-limit=4) ";
        str = str + "when \n";
        str = str + "then \n";
        str = str + "  list.add(\"fired\"); \n";
        str = str + "end  \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
            Assert.assertTrue((boolean)kbuilder.hasErrors());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        ArrayList list = new ArrayList();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(conf, null);
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        Date date = df.parse("1-JAN-2010");
        Calendar cal1 = new Calendar(){

            public boolean isTimeIncluded(long timestamp) {
                return true;
            }
        };
        long oneDay = 86400L;
        ksession.getCalendars().set("cal1", cal1);
        ksession.setGlobal("list", list);
        timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)2L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testCalendarsWithCronAndStartAndEnd() throws Exception {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx \n";
        str = str + "  calendars \"cal1\"\n";
        str = str + "  timer (cron: 0 0 0 * * ? start=3-JAN-2010 end=5-JAN-2010) ";
        str = str + "when \n";
        str = str + "then \n";
        str = str + "  list.add(\"fired\"); \n";
        str = str + "end  \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
            Assert.assertTrue((boolean)kbuilder.hasErrors());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        ArrayList list = new ArrayList();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(conf, null);
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        Date date = df.parse("1-JAN-2010");
        Calendar cal1 = new Calendar(){

            public boolean isTimeIncluded(long timestamp) {
                return true;
            }
        };
        long oneDay = 86400L;
        ksession.getCalendars().set("cal1", cal1);
        ksession.setGlobal("list", list);
        timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)2L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testCalendarsWithCronAndStartAndLimit() throws Exception {
        String str = "";
        str = str + "package org.simple \n";
        str = str + "global java.util.List list \n";
        str = str + "rule xxx \n";
        str = str + "  calendars \"cal1\"\n";
        str = str + "  timer (cron: 0 0 0 * * ? start=3-JAN-2010 repeat-limit=4) ";
        str = str + "when \n";
        str = str + "then \n";
        str = str + "  list.add(\"fired\"); \n";
        str = str + "end  \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
            Assert.assertTrue((boolean)kbuilder.hasErrors());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        ArrayList list = new ArrayList();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(conf, null);
        PseudoClockScheduler timeService = (PseudoClockScheduler)ksession.getSessionClock();
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        Date date = df.parse("1-JAN-2010");
        Calendar cal1 = new Calendar(){

            public boolean isTimeIncluded(long timestamp) {
                return true;
            }
        };
        long oneDay = 86400L;
        ksession.getCalendars().set("cal1", cal1);
        ksession.setGlobal("list", list);
        timeService.advanceTime(date.getTime(), TimeUnit.MILLISECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)2L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
        timeService.advanceTime(oneDay, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testTimerWithNot() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Timer_With_Not.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.fireAllRules();
        Thread.sleep(1500L);
        Assert.assertEquals((long)2L, (long)workingMemory.getFactCount());
    }

    @Test
    public void testHaltWithTimer() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Halt_With_Timer.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        final StatefulSession workingMemory = ruleBase.newStatefulSession();
        new Thread(new Runnable(){

            public void run() {
                workingMemory.fireUntilHalt();
            }
        }).start();
        Thread.sleep(1000L);
        workingMemory.insert((Object)"halt");
        Thread.sleep(2000L);
        Assert.assertEquals((long)2L, (long)workingMemory.getFactCount());
    }

    @Test
    public void testTimerRemoval() {
        try {
            String str = "package org.drools.test\nimport " + TimeUnit.class.getName() + "\n" + "global java.util.List list \n" + "global " + CountDownLatch.class.getName() + " latch\n" + "rule TimerRule \n" + "   timer (int:0 50) \n" + "when \n" + "then \n" + "        //forces it to pause until main thread is ready\n" + "        latch.await(10, TimeUnit.MINUTES); \n" + "        list.add(list.size()); \n" + " end";
            KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
            if (kbuilder.hasErrors()) {
                System.out.println(kbuilder.getErrors().toString());
                throw new RuntimeException("Unable to compile \"TimerRule.drl\".");
            }
            Collection pkgs = kbuilder.getKnowledgePackages();
            KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
            kbase.addKnowledgePackages(pkgs);
            CountDownLatch latch = new CountDownLatch(1);
            StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
            List list = Collections.synchronizedList(new ArrayList());
            ksession.setGlobal("list", list);
            ksession.setGlobal("latch", (Object)latch);
            ksession.fireAllRules();
            Thread.sleep(200L);
            kbase.removeRule("org.drools.test", "TimerRule");
            latch.countDown();
            Thread.sleep(100L);
            list.clear();
            Thread.sleep(500L);
            Assert.assertEquals((long)0L, (long)list.size());
            ksession.dispose();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

