/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.agent.BaseKnowledgeAgentTest;
import org.drools.agent.KnowledgeAgent;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.rule.Rule;
import org.drools.definitions.impl.KnowledgePackageImp;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.drools.runtime.rule.QueryResults;
import org.drools.runtime.rule.QueryResultsRow;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class KnowledgeAgentIncrementalChangeSetTest
extends BaseKnowledgeAgentTest {
    @Test
    public void testModifyFileUrlIncremental() throws Exception {
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        this.fileManager.write("rule2.drl", this.createDefaultRule("rule2"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule2.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        kagent.applyChangeSet(ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule3"));
        this.scan(kagent);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule3"));
        ksession.dispose();
        ksession = kbase.newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule3"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        ksession.dispose();
        kagent.dispose();
    }

    @Test
    public void testRemoveFileUrlIncremental() throws Exception {
        File f1 = this.fileManager.write("rule1.drl", this.createLhsRule("rule1", "String()"));
        File f2 = this.fileManager.write("rule2.drl", this.createLhsRule("rule2", "String()"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule2.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        kagent.applyChangeSet(ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"String1");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.deleteFile(f1);
        this.scan(kagent);
        ksession.insert((Object)"String2");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.deleteFile(f2);
        this.scan(kagent);
        ksession.insert((Object)"String3");
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        ksession.dispose();
        kagent.dispose();
    }

    @Test
    public void testModifyFileUrlOverwriteIncremental() throws Exception {
        File f1 = this.fileManager.write("rule1.drl", this.createLhsRule(new String[]{"rule1", "rule2"}, "String()\n"));
        File f2 = this.fileManager.write("rule2.drl", this.createVersionedRule(null, new String[]{"rule1"}, null, "String()\n", "2"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule2.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        kagent.applyChangeSet(ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"String1");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1-V2"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        File f3 = this.fileManager.write("rule2.drl", this.createVersionedRule("rule1", "3"));
        this.scan(kagent);
        ksession.insert((Object)"String2");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1-V3"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.deleteFile(f2);
        this.scan(kagent);
        ksession.insert((Object)"String3");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule2"));
        ksession.dispose();
        kagent.dispose();
    }

    @Test
    public void testMultipleRulesOnFileUrlIncremental() throws Exception {
        File f1 = this.fileManager.write("rules.drl", this.createLhsRule(new String[]{"rule1", "rule2"}, "String()\n"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rules.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        kagent.applyChangeSet(ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"String1");
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.write("rules.drl", this.createLhsRule(new String[]{"rule1", "rule3"}, "String()\n"));
        this.scan(kagent);
        ksession.insert((Object)"String2");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule3"));
        ksession.dispose();
        kagent.dispose();
    }

    @Test
    public void testMultipleRulesOnFilesUrlIncremental() throws Exception {
        File f1 = this.fileManager.write("rules1.drl", this.createLhsRule(new String[]{"rule1", "rule2"}, "String()\n"));
        this.fileManager.write("rules2.drl", this.createLhsRule("rule3", "String()\n"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rules1.drl' type='DRL' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rules2.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle h1 = ksession.insert((Object)"String1");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        Assert.assertTrue((boolean)list.contains("rule3"));
        list.clear();
        this.fileManager.write("rules2.drl", this.createLhsRule("rule4", "String()\n"));
        this.scan(kagent);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule4"));
        list.clear();
        ksession.retract(h1);
        ksession.insert((Object)"String2");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        Assert.assertTrue((boolean)list.contains("rule4"));
        list.clear();
        this.fileManager.write("rules1.drl", this.createLhsRule(new String[]{"rule1", "rule5"}, "String()\n"));
        this.scan(kagent);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule5"));
        ksession.retract(h1);
        list.clear();
        ksession.insert((Object)"String3");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule5"));
        Assert.assertTrue((boolean)list.contains("rule4"));
        ksession.dispose();
        kagent.dispose();
    }

    @Test
    public void testModifyPackageUrlIncremental() throws Exception {
        File pkg1 = this.fileManager.newFile("pkg1.pkg");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])this.createLhsRule("rule1", "String()\n").getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgePackage pkg = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        KnowledgeAgentIncrementalChangeSetTest.writePackage(pkg, pkg1);
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/pkg1.pkg' type='PKG' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"String1");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        list.clear();
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])this.createLhsRule("rule3", "String()\n").getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])this.createLhsRule("rule2", "String()\n").getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        pkg = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        KnowledgeAgentIncrementalChangeSetTest.writePackage(pkg, pkg1);
        this.scan(kagent);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule3"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        ksession.insert((Object)"String2");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule3"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        ksession.dispose();
        kagent.dispose();
    }

    @Test
    @Ignore
    public void testUpdatePackageUrlIncremental() throws Exception {
        File pkg1 = this.fileManager.newFile("pkg1.pkg");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])this.createLhsRule("rule1", "String()\n").getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])this.createLhsRule("rule2", "String()\n").getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgePackage pkg = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        KnowledgeAgentIncrementalChangeSetTest.writePackage(pkg, pkg1);
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/pkg1.pkg' type='PKG' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        kagent.applyChangeSet(ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"String1");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])this.createDefaultRule("rule2").getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])this.createDefaultRule("rule3").getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        pkg = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        KnowledgeAgentIncrementalChangeSetTest.writePackage(pkg, pkg1);
        this.scan(kagent);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule3"));
        list.clear();
        ksession.insert((Object)"String2");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule2"));
        Assert.assertTrue((boolean)list.contains("rule3"));
        ksession.dispose();
        kagent.dispose();
    }

    @Test
    public void testUpdatePackageUrlOverwriteIncremental() throws Exception {
        File pkgF1 = this.fileManager.newFile("pkg1.pkg");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])this.createLhsRule("rule1", "String()\n").getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])this.createLhsRule("rule2", "String()\n").getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgePackage pkg1 = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        KnowledgeAgentIncrementalChangeSetTest.writePackage(pkg1, pkgF1);
        File pkgF2 = this.fileManager.newFile("pkg2.pkg");
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])this.createDefaultRule("rule3").getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgePackage pkg2 = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        KnowledgeAgentIncrementalChangeSetTest.writePackage(pkg2, pkgF2);
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/pkg1.pkg' type='PKG' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/pkg2.pkg' type='PKG' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle h1 = ksession.insert((Object)"String1");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        Assert.assertTrue((boolean)list.contains("rule3"));
        list.clear();
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])this.createVersionedRule(null, new String[]{"rule1"}, null, "String()", "2").getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        pkg2 = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        KnowledgeAgentIncrementalChangeSetTest.writePackage(pkg2, pkgF2);
        this.scan(kagent);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1-V2"));
        list.clear();
        ksession.retract(h1);
        ksession.insert((Object)"String2");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1-V2"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        ksession.dispose();
        kagent.dispose();
    }

    @Test
    @Ignore
    public void testCompleteRuleScenario() throws Exception {
        File f1 = this.fileManager.write("rule1.drl", this.createLhsRule(new String[]{"rule1", "rule2"}, "String()\n"));
        File f2 = this.fileManager.write("rule2.drl", this.createLhsRule("rule3", "String()\n"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule2.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        FactHandle h1 = ksession.insert((Object)"String1");
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        Assert.assertTrue((boolean)list.contains("rule3"));
        list.clear();
        File f3 = this.fileManager.write("rule3.drl", this.createVersionedRule(null, new String[]{"rule1"}, null, "String()\n", "2"));
        xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule3.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        fxml = this.fileManager.write("changeset.xml", xml);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1-V2"));
        list.clear();
        ksession.retract(h1);
        h1 = ksession.insert((Object)"String2");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1-V2"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        Assert.assertTrue((boolean)list.contains("rule3"));
        list.clear();
        f2 = this.fileManager.write("rule2.drl", this.createLhsRule(new String[]{"rule3", "rule4"}, "String()\n"));
        this.scan(kagent);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule4"));
        list.clear();
        ksession.retract(h1);
        h1 = ksession.insert((Object)"String3");
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1-V2"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        Assert.assertTrue((boolean)list.contains("rule3"));
        Assert.assertTrue((boolean)list.contains("rule4"));
        list.clear();
        f3 = this.fileManager.write("rule3.drl", this.createVersionedRule(null, new String[]{"rule3"}, null, "String()", "2"));
        this.scan(kagent);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule3-V2"));
        list.clear();
        ksession.retract(h1);
        h1 = ksession.insert((Object)"String4");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule2"));
        Assert.assertTrue((boolean)list.contains("rule3-V2"));
        Assert.assertTrue((boolean)list.contains("rule4"));
        list.clear();
        this.fileManager.deleteFile(f3);
        this.scan(kagent);
        ksession.retract(h1);
        h1 = ksession.insert((Object)"String5");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule2"));
        Assert.assertTrue((boolean)list.contains("rule4"));
        list.clear();
        String str = this.createHeader("org.drools.test") + this.createVersionedRule(false, null, new String[]{"rule1"}, null, "String()\n", "3") + this.createVersionedRule(false, null, new String[]{"rule3", "rule4"}, null, "String()\n", null);
        System.out.println(str);
        f2 = this.fileManager.write("rule2.drl", str);
        this.scan(kagent);
        ksession.fireAllRules();
        System.out.println(list);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1-V3"));
        Assert.assertTrue((boolean)list.contains("rule3"));
        list.clear();
        ksession.retract(h1);
        h1 = ksession.insert((Object)"String5");
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1-V3"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        Assert.assertTrue((boolean)list.contains("rule3"));
        Assert.assertTrue((boolean)list.contains("rule4"));
        ksession.dispose();
        kagent.dispose();
    }

    @Test
    public void testAddModifyFunctionIncremental() throws Exception {
        File f1 = this.fileManager.write("rule1.drl", this.createCustomRule(true, null, new String[]{"rule1"}, null, "String()\n", "function1 (list,drools.getRule().getName());\n"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        try {
            this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
            Assert.fail((String)"Knowledge should fail to compile");
        }
        catch (Exception e) {
            // empty catch block
        }
        KnowledgePackage knowledgePackage = kbase.getKnowledgePackage("org.drools.test");
        Assert.assertNull((Object)knowledgePackage);
        String function1 = this.createCommonFunction("function1", "function1");
        this.fileManager.write("rule1.drl", function1 + this.createCustomRule(false, null, new String[]{"rule1"}, null, "String()\n", "function1 (list, drools.getRule().getName());\n"));
        this.scan(kagent);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"String1");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("function1 from rule1"));
        list.clear();
        String function2 = this.createCommonFunction("function1", "function1-V2");
        this.fileManager.write("rule1.drl", function2 + this.createCustomRule(false, null, new String[]{"rule1"}, null, "String()\n", "function1 (list, drools.getRule().getName());\n"));
        this.scan(kagent);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        ksession.insert((Object)"String2");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("function1-V2 from rule1"));
        ksession.dispose();
        kagent.dispose();
    }

    @Test
    public void testAddModifyQueryIncremental() throws Exception {
        String query1 = "";
        query1 = query1 + "query \"all the Strings\"\n";
        query1 = query1 + "     $strings : String()\n";
        query1 = query1 + "end\n";
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        try {
            this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        }
        catch (Exception e) {
            Assert.fail((String)"Knowledge shouldn't fail to compile");
        }
        KnowledgePackage knowledgePackage = kbase.getKnowledgePackage("org.drools.test");
        Assert.assertNotNull((Object)knowledgePackage);
        Rule allTheStringsQuery = ((KnowledgePackageImp)knowledgePackage).getRule("all the Strings");
        Assert.assertNull((Object)allTheStringsQuery);
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule1") + " \n " + query1);
        this.scan(kagent);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"Some String");
        ksession.insert((Object)"Some Other String");
        QueryResults queryResults = ksession.getQueryResults("all the Strings", new Object[0]);
        Assert.assertEquals((long)2L, (long)queryResults.size());
        Iterator iterator = queryResults.iterator();
        while (iterator.hasNext()) {
            System.out.println("Row= " + ((QueryResultsRow)iterator.next()).get("$strings"));
        }
        String query1V2 = "";
        query1V2 = query1V2 + "query \"all the Strings\"\n";
        query1V2 = query1V2 + "     $strings : String(this == \"Some String\")\n";
        query1V2 = query1V2 + "end\n";
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule1") + " \n " + query1V2);
        this.scan(kagent);
        queryResults = ksession.getQueryResults("all the Strings", new Object[0]);
        Assert.assertEquals((long)1L, (long)queryResults.size());
        Assert.assertEquals((Object)"Some String", (Object)((QueryResultsRow)queryResults.iterator().next()).get("$strings"));
        ksession.dispose();
        kagent.dispose();
    }

    @Test
    public void testCompilationFailndFixIncremental() throws Exception {
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        kagent.applyChangeSet(ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        Assert.assertEquals((long)1L, (long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        list.clear();
        this.fileManager.write("rule1.drl", this.createLhsRule("rule1", "String())"));
        try {
            this.scan(kagent);
            Assert.fail((String)"The compilation should fail!");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        Assert.assertTrue((boolean)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().isEmpty());
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        this.scan(kagent);
        list.clear();
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        ksession.dispose();
        kagent.dispose();
    }

    @Test
    public void testCompilationFailndFixIncremental2() throws Exception {
        this.fileManager.write("rule1.drl", this.createLhsRule("rule1", "String()"));
        this.fileManager.write("rule2.drl", this.createLhsRule("rule2", "String()"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule2.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        kagent.applyChangeSet(ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        Assert.assertEquals((long)2L, (long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"Some String");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.write("rule1.drl", this.createLhsRule("rule1", "String())"));
        try {
            this.scan(kagent);
            Assert.fail((String)"The compilation should fail!");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)((KnowledgePackage)kbase.getKnowledgePackages().iterator().next()).getRules().size());
        ksession.insert((Object)"Some Other String");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        this.scan(kagent);
        ksession.insert((Object)"Yet Another String");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        ksession.dispose();
        kagent.dispose();
    }

    @Test
    public void testMultiplePackages() throws Exception {
        File f1 = this.fileManager.write("rule1.drl", this.createLhsRule("some.pkg", "rule1", "String()"));
        File f2 = this.fileManager.write("rule2.drl", this.createLhsRule("some.other.pkg", new String[]{"rule2", "rule3"}, "String()"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule2.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        kagent.applyChangeSet(ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        Assert.assertEquals((long)2L, (long)kbase.getKnowledgePackages().size());
        KnowledgePackage somePkg = kbase.getKnowledgePackage("some.pkg");
        Assert.assertNotNull((Object)somePkg);
        Assert.assertEquals((long)1L, (long)somePkg.getRules().size());
        Assert.assertEquals((Object)"rule1", (Object)((Rule)somePkg.getRules().iterator().next()).getName());
        KnowledgePackage someOtherPkg = kbase.getKnowledgePackage("some.other.pkg");
        Assert.assertNotNull((Object)someOtherPkg);
        Assert.assertEquals((long)2L, (long)someOtherPkg.getRules().size());
        Iterator someOtherPkgRules = someOtherPkg.getRules().iterator();
        Assert.assertEquals((Object)"rule2", (Object)((Rule)someOtherPkgRules.next()).getName());
        Assert.assertEquals((Object)"rule3", (Object)((Rule)someOtherPkgRules.next()).getName());
        this.fileManager.deleteFile(f2);
        this.scan(kagent);
        Assert.assertEquals((long)2L, (long)kbase.getKnowledgePackages().size());
        somePkg = kbase.getKnowledgePackage("some.pkg");
        Assert.assertNotNull((Object)somePkg);
        Assert.assertEquals((long)1L, (long)somePkg.getRules().size());
        Assert.assertEquals((Object)"rule1", (Object)((Rule)somePkg.getRules().iterator().next()).getName());
        someOtherPkg = kbase.getKnowledgePackage("some.other.pkg");
        Assert.assertNotNull((Object)someOtherPkg);
        Assert.assertTrue((boolean)someOtherPkg.getRules().isEmpty());
        File f3 = this.fileManager.write("rule3.drl", this.createLhsRule("yet.another.pkg", "rule4", "String()"));
        xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule3.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        this.applyChangeSet(kagent, xml);
        Assert.assertEquals((long)3L, (long)kbase.getKnowledgePackages().size());
        somePkg = kbase.getKnowledgePackage("some.pkg");
        Assert.assertNotNull((Object)somePkg);
        Assert.assertEquals((long)1L, (long)somePkg.getRules().size());
        Assert.assertEquals((Object)"rule1", (Object)((Rule)somePkg.getRules().iterator().next()).getName());
        someOtherPkg = kbase.getKnowledgePackage("some.other.pkg");
        Assert.assertNotNull((Object)someOtherPkg);
        Assert.assertTrue((boolean)someOtherPkg.getRules().isEmpty());
        KnowledgePackage yetAnotherPkg = kbase.getKnowledgePackage("yet.another.pkg");
        Assert.assertNotNull((Object)yetAnotherPkg);
        Assert.assertEquals((long)1L, (long)yetAnotherPkg.getRules().size());
        Assert.assertEquals((Object)"rule4", (Object)((Rule)yetAnotherPkg.getRules().iterator().next()).getName());
        kagent.dispose();
    }
}

