/*
 * Decompiled with CFR 0.152.
 */
package org.drools.api;

import java.util.Collection;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.rule.Rule;
import org.drools.io.ResourceFactory;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeBuilderTest {
    @Test
    public void testKnowledgeProvider() {
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        Assert.assertNotNull((Object)builder);
    }

    @Test
    public void testKnowledgeProviderWithRules() {
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        String str = "";
        str = str + "package org.test1\n";
        str = str + "rule rule1\n";
        str = str + "when\n";
        str = str + "then\n";
        str = str + "end\n\n";
        str = str + "rule rule2\n";
        str = str + "when\n";
        str = str + "then\n";
        str = str + "end\n";
        builder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        str = "package org.test2\n";
        str = str + "rule rule3\n";
        str = str + "when\n";
        str = str + "then\n";
        str = str + "end\n\n";
        str = str + "rule rule4\n";
        str = str + "when\n";
        str = str + "then\n";
        str = str + "end\n";
        builder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Collection pkgs = builder.getKnowledgePackages();
        Assert.assertNotNull((Object)pkgs);
        Assert.assertEquals((long)2L, (long)pkgs.size());
        KnowledgePackage test1 = this.getKnowledgePackage(pkgs, "org.test1");
        Collection rules = test1.getRules();
        Assert.assertEquals((long)2L, (long)rules.size());
        Rule rule = this.getRule(rules, "rule1");
        Assert.assertEquals((Object)"rule1", (Object)rule.getName());
        rule = this.getRule(rules, "rule2");
        Assert.assertEquals((Object)"rule2", (Object)rule.getName());
        KnowledgePackage test2 = this.getKnowledgePackage(pkgs, "org.test2");
        rules = test2.getRules();
        Assert.assertEquals((long)2L, (long)rules.size());
        rule = this.getRule(rules, "rule3");
        Assert.assertEquals((Object)"rule3", (Object)rule.getName());
        rule = this.getRule(rules, "rule4");
        Assert.assertEquals((Object)"rule4", (Object)rule.getName());
    }

    public Rule getRule(Collection<Rule> rules, String name) {
        for (Rule rule : rules) {
            if (!rule.getName().equals(name)) continue;
            return rule;
        }
        return null;
    }

    public KnowledgePackage getKnowledgePackage(Collection<KnowledgePackage> pkgs, String name) {
        for (KnowledgePackage pkg : pkgs) {
            if (!pkg.getName().equals(name)) continue;
            return pkg;
        }
        return null;
    }
}

