/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import org.drools.Cheese;
import org.drools.DroolsTestCase;
import org.drools.Person;
import org.drools.QueryResults;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.PackageBuilder;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.BindingDescr;
import org.drools.lang.descr.ExprConstraintDescr;
import org.drools.lang.descr.LiteralDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.VariableDescr;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class QueryBuilderTest
extends DroolsTestCase {
    @Test
    @Ignore
    public void testRuleWithQuery() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        QueryDescr queryDescr = new QueryDescr("query1");
        queryDescr.addParameter("String", "$name");
        queryDescr.addParameter("int", "$age");
        queryDescr.addParameter("String", "$likes");
        packageDescr.addRule((RuleDescr)queryDescr);
        AndDescr lhs = new AndDescr();
        queryDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Person.class.getName());
        lhs.addDescr((BaseDescr)pattern);
        pattern.addConstraint((BaseDescr)new ExprConstraintDescr("$name : name"));
        pattern.addConstraint((BaseDescr)new ExprConstraintDescr("$age : age"));
        pattern.addConstraint((BaseDescr)new ExprConstraintDescr("$likes : likes"));
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        pattern = new PatternDescr(Cheese.class.getName());
        lhs.addDescr((BaseDescr)pattern);
        pattern.addBinding(new BindingDescr("$type", "type"));
        pattern = new PatternDescr("query1");
        lhs.addDescr((BaseDescr)pattern);
        pattern.addConstraint((BaseDescr)new LiteralDescr("bobba", 3));
        pattern.addConstraint((BaseDescr)new VariableDescr("$age"));
        pattern.addConstraint((BaseDescr)new VariableDescr("$type"));
        ruleDescr.setConsequence((Object)"System.out.println(\"age: \" + $age);");
        builder.addPackage(packageDescr);
        this.assertLength(0, builder.getErrors().getErrors());
        RuleBase rbase = RuleBaseFactory.newRuleBase();
        rbase.addPackage(builder.getPackage());
        StatefulSession session = rbase.newStatefulSession();
        session.insert((Object)new Person("bobba", "stilton", 90));
        session.insert((Object)new Person("bobba", "brie", 80));
        session.insert((Object)new Person("bobba", "brie", 75));
        session.insert((Object)new Person("darth", "brie", 100));
        session.insert((Object)new Person("luke", "brie", 25));
        session.insert((Object)new Cheese("brie", 25));
        session.fireAllRules();
    }

    @Test
    public void testQuery() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        QueryDescr queryDescr = new QueryDescr("query1");
        queryDescr.addParameter("String", "$type");
        packageDescr.addRule((RuleDescr)queryDescr);
        AndDescr lhs = new AndDescr();
        queryDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        pattern.addConstraint((BaseDescr)new ExprConstraintDescr("type == $type"));
        QueryDescr queryDescr2 = new QueryDescr("query2");
        packageDescr.addRule((RuleDescr)queryDescr2);
        AndDescr lhs2 = new AndDescr();
        queryDescr2.setLhs(lhs2);
        PatternDescr pattern2 = new PatternDescr(Cheese.class.getName());
        lhs2.addDescr((BaseDescr)pattern2);
        builder.addPackage(packageDescr);
        this.assertLength(0, builder.getErrors().getErrors());
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(builder.getPackage());
        StatefulSession session = ruleBase.newStatefulSession();
        session.insert((Object)new Cheese("stilton", 15));
        QueryResults results = session.getQueryResults("query1", new Object[]{"stilton"});
        Assert.assertEquals((long)1L, (long)results.size());
        Object object = results.get(0).get(0);
        Assert.assertEquals((Object)new Cheese("stilton", 15), (Object)object);
        results = session.getQueryResults("query1", new Object[]{"cheddar"});
        Assert.assertEquals((long)0L, (long)results.size());
        session.insert((Object)new Cheese("dolcelatte", 20));
        results = session.getQueryResults("query2", new Object[0]);
        Assert.assertEquals((long)2L, (long)results.size());
    }
}

