/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.rules;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.drools.compiler.DrlParser;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.xml.XmlDumper;
import org.drools.compiler.xml.XmlPackageReader;
import org.drools.lang.DrlDumper;
import org.drools.lang.descr.PackageDescr;
import org.junit.Assert;

public class DumperTestHelper {
    public static void XmlFile(String filename) throws Exception {
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        XmlPackageReader xmlPackageReader = new XmlPackageReader(conf.getSemanticModules());
        xmlPackageReader.read((Reader)new InputStreamReader(DumperTestHelper.class.getResourceAsStream(filename)));
        PackageDescr pkgOriginal = xmlPackageReader.getPackageDescr();
        XmlDumper dumper = new XmlDumper();
        String result = dumper.dump(pkgOriginal);
        String buffer = DumperTestHelper.readFile(filename);
        System.out.println(buffer);
        System.out.println(result);
        DumperTestHelper.assertEqualsIgnoreWhitespace(buffer, result);
        Assert.assertNotNull((Object)result);
    }

    public static void DrlFile(String filename) throws Exception {
        DrlParser parser = new DrlParser();
        PackageDescr pkgOriginal = parser.parse((Reader)new InputStreamReader(DumperTestHelper.class.getResourceAsStream(filename)));
        DrlDumper dumper = new DrlDumper();
        String result1 = dumper.dump(pkgOriginal);
        PackageDescr pkgDerivated = parser.parse((Reader)new StringReader(result1));
        String result2 = dumper.dump(pkgDerivated);
        DumperTestHelper.assertEqualsIgnoreWhitespace(result1, result2);
    }

    public static void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        Assert.assertEquals((Object)cleanExpected, (Object)cleanActual);
    }

    private static String readFile(String file) throws IOException {
        InputStreamReader reader = new InputStreamReader(DumperTestHelper.class.getResourceAsStream(file));
        StringBuilder text = new StringBuilder();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text.toString();
    }
}

