/*
 * Decompiled with CFR 0.152.
 */
package org.drools.conf;

import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.conf.AlphaThresholdOption;
import org.drools.conf.AssertBehaviorOption;
import org.drools.conf.CompositeKeyDepthOption;
import org.drools.conf.ConsequenceExceptionHandlerOption;
import org.drools.conf.EventProcessingOption;
import org.drools.conf.IndexLeftBetaMemoryOption;
import org.drools.conf.IndexRightBetaMemoryOption;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.conf.LogicalOverrideOption;
import org.drools.conf.MaintainTMSOption;
import org.drools.conf.MaxThreadsOption;
import org.drools.conf.MultithreadEvaluationOption;
import org.drools.conf.RemoveIdentitiesOption;
import org.drools.conf.SequentialAgendaOption;
import org.drools.conf.SequentialOption;
import org.drools.conf.ShareAlphaNodesOption;
import org.drools.conf.ShareBetaNodesOption;
import org.drools.runtime.rule.impl.DefaultConsequenceExceptionHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KnowledgeBaseConfigurationTest {
    private KnowledgeBaseConfiguration config;

    @Before
    public void setUp() throws Exception {
        this.config = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
    }

    @Test
    public void testMaintainTMSConfiguration() {
        this.config.setOption((KnowledgeBaseOption)MaintainTMSOption.YES);
        Assert.assertEquals((Object)MaintainTMSOption.YES, (Object)this.config.getOption(MaintainTMSOption.class));
        Assert.assertEquals((Object)"true", (Object)this.config.getProperty("drools.maintainTms"));
        this.config.setProperty("drools.maintainTms", "false");
        Assert.assertEquals((Object)MaintainTMSOption.NO, (Object)this.config.getOption(MaintainTMSOption.class));
        Assert.assertEquals((Object)"false", (Object)this.config.getProperty("drools.maintainTms"));
    }

    @Test
    public void testSequentialConfiguration() {
        this.config.setOption((KnowledgeBaseOption)SequentialOption.YES);
        Assert.assertEquals((Object)SequentialOption.YES, (Object)this.config.getOption(SequentialOption.class));
        Assert.assertEquals((Object)"true", (Object)this.config.getProperty("drools.sequential"));
        this.config.setProperty("drools.sequential", "false");
        Assert.assertEquals((Object)SequentialOption.NO, (Object)this.config.getOption(SequentialOption.class));
        Assert.assertEquals((Object)"false", (Object)this.config.getProperty("drools.sequential"));
    }

    @Test
    public void testRemoveIdentitiesConfiguration() {
        this.config.setOption((KnowledgeBaseOption)RemoveIdentitiesOption.YES);
        Assert.assertEquals((Object)RemoveIdentitiesOption.YES, (Object)this.config.getOption(RemoveIdentitiesOption.class));
        Assert.assertEquals((Object)"true", (Object)this.config.getProperty("drools.removeIdentities"));
        this.config.setProperty("drools.removeIdentities", "false");
        Assert.assertEquals((Object)RemoveIdentitiesOption.NO, (Object)this.config.getOption(RemoveIdentitiesOption.class));
        Assert.assertEquals((Object)"false", (Object)this.config.getProperty("drools.removeIdentities"));
    }

    @Test
    public void testShareAlphaNodesConfiguration() {
        this.config.setOption((KnowledgeBaseOption)ShareAlphaNodesOption.YES);
        Assert.assertEquals((Object)ShareAlphaNodesOption.YES, (Object)this.config.getOption(ShareAlphaNodesOption.class));
        Assert.assertEquals((Object)"true", (Object)this.config.getProperty("drools.shareAlphaNodes"));
        this.config.setProperty("drools.shareAlphaNodes", "false");
        Assert.assertEquals((Object)ShareAlphaNodesOption.NO, (Object)this.config.getOption(ShareAlphaNodesOption.class));
        Assert.assertEquals((Object)"false", (Object)this.config.getProperty("drools.shareAlphaNodes"));
    }

    @Test
    public void testShareBetaNodesConfiguration() {
        this.config.setOption((KnowledgeBaseOption)ShareBetaNodesOption.YES);
        Assert.assertEquals((Object)ShareBetaNodesOption.YES, (Object)this.config.getOption(ShareBetaNodesOption.class));
        Assert.assertEquals((Object)"true", (Object)this.config.getProperty("drools.shareBetaNodes"));
        this.config.setProperty("drools.shareBetaNodes", "false");
        Assert.assertEquals((Object)ShareBetaNodesOption.NO, (Object)this.config.getOption(ShareBetaNodesOption.class));
        Assert.assertEquals((Object)"false", (Object)this.config.getProperty("drools.shareBetaNodes"));
    }

    @Test
    public void testIndexLeftBetaMemoryConfiguration() {
        this.config.setOption((KnowledgeBaseOption)IndexLeftBetaMemoryOption.YES);
        Assert.assertEquals((Object)IndexLeftBetaMemoryOption.YES, (Object)this.config.getOption(IndexLeftBetaMemoryOption.class));
        Assert.assertEquals((Object)"true", (Object)this.config.getProperty("drools.indexLeftBetaMemory"));
        this.config.setProperty("drools.indexLeftBetaMemory", "false");
        Assert.assertEquals((Object)IndexLeftBetaMemoryOption.NO, (Object)this.config.getOption(IndexLeftBetaMemoryOption.class));
        Assert.assertEquals((Object)"false", (Object)this.config.getProperty("drools.indexLeftBetaMemory"));
    }

    @Test
    public void testIndexRightBetaMemoryConfiguration() {
        this.config.setOption((KnowledgeBaseOption)IndexRightBetaMemoryOption.YES);
        Assert.assertEquals((Object)IndexRightBetaMemoryOption.YES, (Object)this.config.getOption(IndexRightBetaMemoryOption.class));
        Assert.assertEquals((Object)"true", (Object)this.config.getProperty("drools.indexRightBetaMemory"));
        this.config.setProperty("drools.indexRightBetaMemory", "false");
        Assert.assertEquals((Object)IndexRightBetaMemoryOption.NO, (Object)this.config.getOption(IndexRightBetaMemoryOption.class));
        Assert.assertEquals((Object)"false", (Object)this.config.getProperty("drools.indexRightBetaMemory"));
    }

    @Test
    public void testAssertBehaviorConfiguration() {
        this.config.setOption((KnowledgeBaseOption)AssertBehaviorOption.EQUALITY);
        Assert.assertEquals((Object)AssertBehaviorOption.EQUALITY, (Object)this.config.getOption(AssertBehaviorOption.class));
        Assert.assertEquals((Object)"equality", (Object)this.config.getProperty("drools.assertBehaviour"));
        this.config.setProperty("drools.assertBehaviour", "identity");
        Assert.assertEquals((Object)AssertBehaviorOption.IDENTITY, (Object)this.config.getOption(AssertBehaviorOption.class));
        Assert.assertEquals((Object)"identity", (Object)this.config.getProperty("drools.assertBehaviour"));
    }

    @Test
    public void testLogicalOverrideConfiguration() {
        this.config.setOption((KnowledgeBaseOption)LogicalOverrideOption.PRESERVE);
        Assert.assertEquals((Object)LogicalOverrideOption.PRESERVE, (Object)this.config.getOption(LogicalOverrideOption.class));
        Assert.assertEquals((Object)"preserve", (Object)this.config.getProperty("drools.logicalOverride"));
        this.config.setProperty("drools.logicalOverride", "discard");
        Assert.assertEquals((Object)LogicalOverrideOption.DISCARD, (Object)this.config.getOption(LogicalOverrideOption.class));
        Assert.assertEquals((Object)"discard", (Object)this.config.getProperty("drools.logicalOverride"));
    }

    @Test
    public void testSequentialAgendaConfiguration() {
        this.config.setOption((KnowledgeBaseOption)SequentialAgendaOption.DYNAMIC);
        Assert.assertEquals((Object)SequentialAgendaOption.DYNAMIC, (Object)this.config.getOption(SequentialAgendaOption.class));
        Assert.assertEquals((Object)"dynamic", (Object)this.config.getProperty("drools.sequential.agenda"));
        this.config.setProperty("drools.sequential.agenda", "sequential");
        Assert.assertEquals((Object)SequentialAgendaOption.SEQUENTIAL, (Object)this.config.getOption(SequentialAgendaOption.class));
        Assert.assertEquals((Object)"sequential", (Object)this.config.getProperty("drools.sequential.agenda"));
    }

    @Test
    public void testAlphaThresholdConfiguration() {
        this.config.setOption((KnowledgeBaseOption)AlphaThresholdOption.get((int)5));
        Assert.assertEquals((Object)AlphaThresholdOption.get((int)5), (Object)this.config.getOption(AlphaThresholdOption.class));
        Assert.assertEquals((Object)"5", (Object)this.config.getProperty("drools.alphaNodeHashingThreshold"));
        this.config.setProperty("drools.alphaNodeHashingThreshold", "7");
        Assert.assertEquals((Object)AlphaThresholdOption.get((int)7), (Object)this.config.getOption(AlphaThresholdOption.class));
        Assert.assertEquals((Object)"7", (Object)this.config.getProperty("drools.alphaNodeHashingThreshold"));
    }

    @Test
    public void testCompositeKeyDepthConfiguration() {
        this.config.setOption((KnowledgeBaseOption)CompositeKeyDepthOption.get((int)1));
        Assert.assertEquals((Object)CompositeKeyDepthOption.get((int)1), (Object)this.config.getOption(CompositeKeyDepthOption.class));
        Assert.assertEquals((Object)"1", (Object)this.config.getProperty("drools.compositeKeyDepth"));
        this.config.setProperty("drools.compositeKeyDepth", "2");
        Assert.assertEquals((Object)CompositeKeyDepthOption.get((int)2), (Object)this.config.getOption(CompositeKeyDepthOption.class));
        Assert.assertEquals((Object)"2", (Object)this.config.getProperty("drools.compositeKeyDepth"));
    }

    @Test
    public void testConsequenceExceptionHandlerConfiguration() {
        Class<DefaultConsequenceExceptionHandler> handler = DefaultConsequenceExceptionHandler.class;
        this.config.setOption((KnowledgeBaseOption)ConsequenceExceptionHandlerOption.get(handler));
        Assert.assertEquals((Object)ConsequenceExceptionHandlerOption.get(handler), (Object)this.config.getOption(ConsequenceExceptionHandlerOption.class));
        Assert.assertEquals((Object)handler.getName(), (Object)this.config.getProperty("drools.consequenceExceptionHandler"));
        this.config.setProperty("drools.consequenceExceptionHandler", handler.getName());
        Assert.assertEquals((Object)handler.getName(), (Object)((ConsequenceExceptionHandlerOption)this.config.getOption(ConsequenceExceptionHandlerOption.class)).getHandler().getName());
        Assert.assertEquals((Object)handler.getName(), (Object)this.config.getProperty("drools.consequenceExceptionHandler"));
    }

    @Test
    public void testEventProcessingConfiguration() {
        this.config.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        Assert.assertEquals((Object)EventProcessingOption.STREAM, (Object)this.config.getOption(EventProcessingOption.class));
        Assert.assertEquals((Object)"stream", (Object)this.config.getProperty("drools.eventProcessingMode"));
        this.config.setProperty("drools.eventProcessingMode", "cloud");
        Assert.assertEquals((Object)EventProcessingOption.CLOUD, (Object)this.config.getOption(EventProcessingOption.class));
        Assert.assertEquals((Object)"cloud", (Object)this.config.getProperty("drools.eventProcessingMode"));
    }

    @Test
    public void testMaxThreadsConfiguration() {
        this.config.setOption((KnowledgeBaseOption)MaxThreadsOption.get((int)5));
        Assert.assertEquals((Object)MaxThreadsOption.get((int)5), (Object)this.config.getOption(MaxThreadsOption.class));
        Assert.assertEquals((Object)"5", (Object)this.config.getProperty("drools.maxThreads"));
        this.config.setProperty("drools.maxThreads", "8");
        Assert.assertEquals((Object)MaxThreadsOption.get((int)8), (Object)this.config.getOption(MaxThreadsOption.class));
        Assert.assertEquals((Object)"8", (Object)this.config.getProperty("drools.maxThreads"));
    }

    @Test
    public void testMultithreadEvaluationConfiguration() {
        this.config.setOption((KnowledgeBaseOption)MultithreadEvaluationOption.YES);
        Assert.assertEquals((Object)MultithreadEvaluationOption.YES, (Object)this.config.getOption(MultithreadEvaluationOption.class));
        Assert.assertEquals((Object)"true", (Object)this.config.getProperty("drools.multithreadEvaluation"));
        this.config.setProperty("drools.multithreadEvaluation", "false");
        Assert.assertEquals((Object)MultithreadEvaluationOption.NO, (Object)this.config.getOption(MultithreadEvaluationOption.class));
        Assert.assertEquals((Object)"false", (Object)this.config.getProperty("drools.multithreadEvaluation"));
    }

    @Test
    public void testRulebaseSetUpdateHandler() {
        Assert.assertEquals((Object)"", (Object)this.config.getProperty("drools.ruleBaseUpdateHandler"));
        this.config.setProperty("drools.ruleBaseUpdateHandler", "somethingElse");
        Assert.assertEquals((Object)"somethingElse", (Object)this.config.getProperty("drools.ruleBaseUpdateHandler"));
        this.config.setProperty("drools.ruleBaseUpdateHandler", null);
        Assert.assertEquals((Object)"", (Object)this.config.getProperty("drools.ruleBaseUpdateHandler"));
        this.config.setProperty("drools.ruleBaseUpdateHandler", "");
        Assert.assertEquals((Object)"", (Object)this.config.getProperty("drools.ruleBaseUpdateHandler"));
    }
}

