/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.util.ArrayList;
import org.drools.Address;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.rule.Variable;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.QueryResults;
import org.drools.runtime.rule.QueryResultsRow;
import org.junit.Assert;
import org.junit.Test;

public class BackwardChainingTest {
    @Test
    public void testQueryPositional() throws Exception {
        String str = "package org.drools.test  \nimport org.drools.Person \nglobal java.util.List list\nquery peeps( String $name, String $likes, int $age ) \n    Person( $name : name, $likes : likes, $age : age; ) \nend\n";
        str = str + "rule x1\nwhen\n    String( this == \"go1\" )\n    ?peeps($name1, $likes1, $age1; )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        str = str + "rule x2\nwhen\n    String( this == \"go2\" )\n    ?peeps($name1, \"stilton\", $age1; )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        str = str + "rule x3\nwhen\n    String( this == \"go3\" )\n    $name1 : String() from \"darth\";\n     ?peeps($name1, \"stilton\", $age1; )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        str = str + "rule x4\nwhen\n    String( this == \"go4\" )\n    $name1 : String() from \"darth\"\n     $age1 : Integer() from 200;\n     ?peeps($name1, \"stilton\", $age1; )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("darth", "stilton", 200);
        Person p3 = new Person("yoda", "stilton", 300);
        Person p4 = new Person("luke", "brie", 300);
        Person p5 = new Person("bobba", "cheddar", 300);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.insert((Object)p4);
        ksession.insert((Object)p5);
        ksession.insert((Object)"go1");
        ksession.fireAllRules();
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        Assert.assertTrue((boolean)list.contains("yoda : 300"));
        Assert.assertTrue((boolean)list.contains("luke : 300"));
        Assert.assertTrue((boolean)list.contains("bobba : 300"));
        list.clear();
        ksession.insert((Object)"go2");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        Assert.assertTrue((boolean)list.contains("yoda : 300"));
        list.clear();
        ksession.insert((Object)"go3");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        list.clear();
        ksession.insert((Object)"go4");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 200"));
    }

    @Test
    public void testQueryNamed() throws Exception {
        String str = "package org.drools.test  \nimport org.drools.Person \nglobal java.util.List list\nquery peeps( String $name, String $likes, int $age ) \n    Person( $name : name, $likes : likes, $age : age ) \nend\n";
        str = str + "rule x1\nwhen\n    String( this == \"go1\" )\n    ?peeps($name1 : $name, $likes1 : $likes, $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        str = str + "rule x2\nwhen\n    String( this == \"go2\" )\n    ?peeps($name1 : $name, $likes : \"stilton\", $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        str = str + "rule x3\nwhen\n    String( this == \"go3\" )\n    $name1 : String() from \"darth\";\n     ?peeps($name1 : $name, $likes : \"stilton\", $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        str = str + "rule x4\nwhen\n    String( this == \"go4\" )\n    $name1 : String() from \"darth\";\n     $age1 : Integer() from 200;\n     ?peeps($name1 : $name, $likes : \"stilton\", $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("darth", "stilton", 200);
        Person p3 = new Person("yoda", "stilton", 300);
        Person p4 = new Person("luke", "brie", 300);
        Person p5 = new Person("bobba", "cheddar", 300);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.insert((Object)p4);
        ksession.insert((Object)p5);
        ksession.insert((Object)"go1");
        ksession.fireAllRules();
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        Assert.assertTrue((boolean)list.contains("yoda : 300"));
        Assert.assertTrue((boolean)list.contains("luke : 300"));
        Assert.assertTrue((boolean)list.contains("bobba : 300"));
        list.clear();
        ksession.insert((Object)"go2");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        Assert.assertTrue((boolean)list.contains("yoda : 300"));
        list.clear();
        ksession.insert((Object)"go3");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        list.clear();
        ksession.insert((Object)"go4");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 200"));
    }

    @Test
    public void testQueryMixed() throws Exception {
        String str = "package org.drools.test  \nimport org.drools.Person \nglobal java.util.List list\nquery peeps( String $name, String $likes, int $age ) \n    Person( $name : name, $likes : likes, $age : age; ) \nend\n";
        str = str + "rule x1\nwhen\n    String( this == \"go1\" )\n    ?peeps($name1; $likes1 : $likes, $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        str = str + "rule x2\nwhen\n    String( this == \"go2\" )\n    ?peeps($name1, \"stilton\"; $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        str = str + "rule x3\nwhen\n    String( this == \"go3\" )\n    $name1 : String() from \"darth\";\n     ?peeps($name1, \"stilton\"; $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        str = str + "rule x4\nwhen\n    String( this == \"go4\" )\n    $name1 : String() from \"darth\"\n     $age1 : Integer() from 200;\n     ?peeps($name1; $likes : \"stilton\", $age1 : $age )\nthen\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        System.out.println(str);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("darth", "stilton", 200);
        Person p3 = new Person("yoda", "stilton", 300);
        Person p4 = new Person("luke", "brie", 300);
        Person p5 = new Person("bobba", "cheddar", 300);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.insert((Object)p4);
        ksession.insert((Object)p5);
        ksession.insert((Object)"go1");
        ksession.fireAllRules();
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        Assert.assertTrue((boolean)list.contains("yoda : 300"));
        Assert.assertTrue((boolean)list.contains("luke : 300"));
        Assert.assertTrue((boolean)list.contains("bobba : 300"));
        list.clear();
        ksession.insert((Object)"go2");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        Assert.assertTrue((boolean)list.contains("yoda : 300"));
        list.clear();
        ksession.insert((Object)"go3");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        list.clear();
        ksession.insert((Object)"go4");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : 200"));
    }

    @Test
    public void testQueryPatternBindingAsResult() throws Exception {
        String str = "package org.drools.test  \nimport org.drools.Person \nglobal java.util.List list\nquery peeps( Person $p, String $name, String $likes, int $age ) \n    $p : Person( $name : name, $likes : likes, $age : age; ) \nend\n";
        str = str + "rule x1\nwhen\n    String( this == \"go1\" )\n    ?peeps($p, $name1; $likes1 : $likes, $age1 : $age )\nthen\n   list.add( $p );\n   list.add( $name1 + \" : \" + $age1 );\nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("darth", "stilton", 200);
        Person p3 = new Person("yoda", "stilton", 300);
        Person p4 = new Person("luke", "brie", 300);
        Person p5 = new Person("bobba", "cheddar", 300);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.insert((Object)p4);
        ksession.insert((Object)p5);
        ksession.insert((Object)"go1");
        ksession.fireAllRules();
        Assert.assertEquals((long)10L, (long)list.size());
        Assert.assertSame((Object)p1, list.get(list.indexOf("darth : 100") - 1));
        Assert.assertTrue((boolean)list.contains("darth : 100"));
        Assert.assertSame((Object)p2, list.get(list.indexOf("darth : 200") - 1));
        Assert.assertTrue((boolean)list.contains("darth : 200"));
        Assert.assertSame((Object)p3, list.get(list.indexOf("yoda : 300") - 1));
        Assert.assertTrue((boolean)list.contains("yoda : 300"));
        Assert.assertSame((Object)p4, list.get(list.indexOf("luke : 300") - 1));
        Assert.assertTrue((boolean)list.contains("luke : 300"));
        Assert.assertSame((Object)p5, list.get(list.indexOf("bobba : 300") - 1));
        Assert.assertTrue((boolean)list.contains("bobba : 300"));
    }

    @Test
    public void testQueriesWithNestedAcecssorsAllOutputs() throws Exception {
        String str = "package org.drools.test  \nimport org.drools.Person \nglobal java.util.List list\nquery peeps( String $name, String $likes, String $street ) \n   Person( $name : name, $likes : likes, $street : address.street ) \nend\n";
        str = str + "rule x1\nwhen\n    String( this == \"go1\" )\n    ?peeps($name1; $likes1 : $likes, $street1 : $street )\nthen\n   list.add( $name1 + \" : \" + $likes1 + \" : \" +  $street1 );\nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("darth", "stilton", 100);
        p1.setAddress(new Address("s1"));
        Person p2 = new Person("yoda", "stilton", 300);
        p2.setAddress(new Address("s2"));
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)"go1");
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : stilton : s1"));
        Assert.assertTrue((boolean)list.contains("yoda : stilton : s2"));
    }

    @Test
    public void testQueriesWithNestedAcecssorsMixedArgs() throws Exception {
        String str = "package org.drools.test  \nimport org.drools.Person \nglobal java.util.List list\nquery peeps( String $name, String $likes, String $street ) \n   Person( $name : name, $likes : likes, $street : address.street ) \nend\n";
        str = str + "rule x1\nwhen\n    $s : String()\n    ?peeps($name1; $likes1 : $likes, $street : $s )\nthen\n   list.add( $name1 + \" : \" + $likes1 + \" : \" +  $s );\nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("darth", "stilton", 100);
        p1.setAddress(new Address("s1"));
        Person p2 = new Person("yoda", "stilton", 300);
        p2.setAddress(new Address("s2"));
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)"s1");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("darth : stilton : s1"));
        list.clear();
        ksession.insert((Object)"s2");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("yoda : stilton : s2"));
    }

    @Test
    public void testQueryWithDynamicData() throws Exception {
        String str = "package org.drools.test  \nimport org.drools.Person \nglobal java.util.List list\nquery peeps( Person $p, String $name, String $likes, int $age ) \n    $p : Person( ) from new Person( $name, $likes, $age ) \nend\n";
        str = str + "rule x1\nwhen\n    $n1 : String( )\n    ?peeps($p; $name : $n1, $likes : \"stilton\", $age : 100 )\nthen\n   list.add( $p );\nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("yoda", "stilton", 100);
        ksession.insert((Object)"darth");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)p1, list.get(0));
        list.clear();
        ksession.insert((Object)"yoda");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)p2, list.get(0));
    }

    @Test
    public void testQueryWithDyanmicInsert() throws Exception {
        String str = "package org.drools.test  \nimport org.drools.Person \nglobal java.util.List list\nquery peeps( Person $p, String $name, String $likes, int $age ) \n    $p : Person( ) from new Person( $name, $likes, $age ) \nend\n";
        str = str + "rule x1\nwhen\n    $n1 : String( )\n    not Person( name == 'darth' )\n     ?peeps($p; $name : $n1, $likes : \"stilton\", $age : 100 )\nthen\n   insert( $p );\nend \n";
        str = str + "rule x2\nwhen\n    $p : Person( )\nthen\n   list.add( $p );\nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("yoda", "stilton", 100);
        ksession.insert((Object)"darth");
        ksession.fireAllRules();
        ksession.insert((Object)"yoda");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)p1, list.get(0));
    }

    @Test
    public void testQueryWithOr() throws Exception {
        String str = "package org.drools.test  \nimport java.util.List\nimport java.util.ArrayList\nglobal List list\ndialect \"mvel\"\n\nimport org.drools.integrationtests.BackwardChainingTest.Q\nimport org.drools.integrationtests.BackwardChainingTest.R\nimport org.drools.integrationtests.BackwardChainingTest.S\n\nquery q(int x)\n    Q( x : value; )\nend\n\nquery r(int x)\n    R( x : value; )\nend\n\nquery s(int x)\n    S( x : value; )    \nend\n\nquery p(int x)\n    (?q(x;) and ?r(x;) ) \n    or\n    ?s(x;)\nend\nrule init when\nthen\n insert( new Q(1) );\n  insert( new R(1) );\n  insert( new R(2) );\n  insert( new S(2) );\n  insert( new S(3) );\n end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        QueryResults results = null;
        results = ksession.getQueryResults("p", (Object[])new Integer[]{1});
        for (QueryResultsRow result : results) {
            System.out.println("  result( " + result.get("x") + " )");
        }
        System.out.println();
        results = ksession.getQueryResults("p", (Object[])new Integer[]{2});
        for (QueryResultsRow result : results) {
            System.out.println("  result( " + result.get("x") + " )");
        }
        System.out.println();
        results = ksession.getQueryResults("p", (Object[])new Integer[]{3});
        for (QueryResultsRow result : results) {
            System.out.println("  result( " + result.get("x") + " )");
        }
    }

    @Test
    public void testGeneology() {
        String str = "package org.drools.test  \nglobal java.util.List list\ndialect \"mvel\"\nquery man( String name ) \n   org.drools.integrationtests.BackwardChainingTest.Man( name : name ) \nend\nquery woman( String name ) \n   org.drools.integrationtests.BackwardChainingTest.Woman( name : name ) \nend\nquery parent( String parent, String child ) \n   org.drools.integrationtests.BackwardChainingTest.Parent( parent : parent, child : child ) \nend\nquery father( String father, String child ) \n   ?man( father; ) \n   ?parent( father, child; ) \nend\nquery mother( String mother, String child ) \n   ?woman( mother; ) \n   ?parent( mother, child; ) \nend\nquery son( String son, String parent ) \n   ?man( son; ) \n   ?parent( parent, son; ) \nend\nquery daughter( String daughter, String parent ) \n   ?woman( daughter; ) \n   ?parent( parent, daughter; ) \nend\nquery siblings( String c1, String c2 ) \n   ?parent( $p, c1; ) \n   ?parent( $p, c2; ) \n   eval( !c1.equals( c2 ) )\nend\nquery fullSiblings( String c1, String c2 )\n   ?parent( $p1, c1; ) ?parent( $p1, c2; )\n   ?parent( $p2, c1; ) ?parent( $p2, c2; )\n   eval( !c1.equals( c2 ) && !$p1.equals( $p2 )  )\nend\nquery fullSiblings2( String c1, String c2 )\n   ?father( $p1, c1; ) ?father( $p1, c2; )\n   ?mother( $p2, c1; ) ?mother( $p2, c2; )\n   eval( !c1.equals( c2 ) )\nend\nquery uncle( String uncle, String n )\n   ?man( uncle; ) ?siblings( uncle, parent; )\n   ?parent( parent, n; )\n end\nquery aunt( String aunt, String n )\n   ?woman( aunt; ) ?siblings( aunt, parent; )\n   ?parent( parent, n; )\n end\nquery grantParents( String gp, String gc )\n   ?parent( gp, p; ) ?parent( p, gc; )\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Man("john"));
        ksession.insert((Object)new Woman("janet"));
        ksession.insert((Object)new Man("adam"));
        ksession.insert((Object)new Parent("john", "adam"));
        ksession.insert((Object)new Parent("janet", "adam"));
        ksession.insert((Object)new Man("stan"));
        ksession.insert((Object)new Parent("john", "stan"));
        ksession.insert((Object)new Parent("janet", "stan"));
        ksession.insert((Object)new Man("carl"));
        ksession.insert((Object)new Woman("tina"));
        ksession.insert((Object)new Woman("eve"));
        ksession.insert((Object)new Parent("carl", "eve"));
        ksession.insert((Object)new Parent("tina", "eve"));
        ksession.insert((Object)new Woman("mary"));
        ksession.insert((Object)new Parent("carl", "mary"));
        ksession.insert((Object)new Parent("tina", "mary"));
        ksession.insert((Object)new Man("peter"));
        ksession.insert((Object)new Parent("adam", "peter"));
        ksession.insert((Object)new Parent("eve", "peter"));
        ksession.insert((Object)new Man("paul"));
        ksession.insert((Object)new Parent("adam", "paul"));
        ksession.insert((Object)new Parent("mary", "paul"));
        ksession.insert((Object)new Woman("jill"));
        ksession.insert((Object)new Parent("adam", "jill"));
        ksession.insert((Object)new Parent("eve", "jill"));
        QueryResults results = null;
        System.out.println("woman");
        results = ksession.getQueryResults("woman", new Object[]{Variable.variable});
        for (QueryResultsRow result : results) {
            System.out.println("  " + result.get("name"));
        }
        System.out.println("\nman");
        results = ksession.getQueryResults("man", new Object[]{Variable.variable});
        for (QueryResultsRow result : results) {
            System.out.println("  " + result.get("name"));
        }
        System.out.println("\nfather");
        results = ksession.getQueryResults("father", new Object[]{Variable.variable, Variable.variable});
        for (QueryResultsRow result : results) {
            System.out.println("  father( " + result.get("father") + ", " + result.get("child") + " )");
        }
        System.out.println("\nmother");
        results = ksession.getQueryResults("mother", new Object[]{Variable.variable, Variable.variable});
        for (QueryResultsRow result : results) {
            System.out.println("  mother( " + result.get("mother") + ", " + result.get("child") + " )");
        }
        System.out.println("\nson");
        results = ksession.getQueryResults("son", new Object[]{Variable.variable, Variable.variable});
        for (QueryResultsRow result : results) {
            System.out.println("  son( " + result.get("son") + ", " + result.get("parent") + " )");
        }
        System.out.println("\ndaughter");
        results = ksession.getQueryResults("daughter", new Object[]{Variable.variable, Variable.variable});
        for (QueryResultsRow result : results) {
            System.out.println("  daughter( " + result.get("daughter") + ", " + result.get("parent") + " )");
        }
        System.out.println("\nsiblings");
        results = ksession.getQueryResults("siblings", new Object[]{Variable.variable, Variable.variable});
        for (QueryResultsRow result : results) {
            System.out.println("  sibling( " + result.get("c1") + ", " + result.get("c2") + " )");
        }
        System.out.println("\nfullSiblings");
        results = ksession.getQueryResults("fullSiblings", new Object[]{Variable.variable, Variable.variable});
        for (QueryResultsRow result : results) {
            System.out.println("  fullSiblings( " + result.get("c1") + ", " + result.get("c2") + " )");
        }
        System.out.println("\nfullSiblings2");
        results = ksession.getQueryResults("fullSiblings", new Object[]{Variable.variable, Variable.variable});
        for (QueryResultsRow result : results) {
            System.out.println("  fullSiblings2( " + result.get("c1") + ", " + result.get("c2") + " )");
        }
        System.out.println("\nuncle");
        results = ksession.getQueryResults("uncle", new Object[]{Variable.variable, Variable.variable});
        for (QueryResultsRow result : results) {
            System.out.println("  uncle( " + result.get("uncle") + ", " + result.get("n") + " )");
        }
        System.out.println("\naunt");
        results = ksession.getQueryResults("aunt", new Object[]{Variable.variable, Variable.variable});
        for (QueryResultsRow result : results) {
            System.out.println("  aunt( " + result.get("aunt") + ", " + result.get("n") + " )");
        }
        System.out.println("\ngrantParents");
        results = ksession.getQueryResults("grantParents", new Object[]{Variable.variable, Variable.variable});
        for (QueryResultsRow result : results) {
            System.out.println("  grantParents( " + result.get("gp") + ", " + result.get("gc") + " )");
        }
    }

    @Test
    public void testNaniSearch() {
        String str = "package org.drools.test  \nimport java.util.List\nimport java.util.ArrayList\nglobal List list\ndialect \"mvel\"\ndeclare Room    name : String\nend\n\ndeclare Location\n    thing : String \n    location : String \nend\ndeclare Door\n   fromLocation : String\n   toLocation : String\nend\ndeclare Edible\n   thing : String\nend\ndeclare TastesYucky\n   thing : String\nend\ndeclare TastesYucky\n   thing : String\nend\n\ndeclare Here\n   place : String \nend\n\nquery whereFood( String thing, String location ) \n    ( Location(thing, location;) and\n      Edible(thing;) )\n     or \n    ( Location(thing, location;) and\n      TastesYucky(thing;) ) \nend\n\nquery connect( String x, String y ) \n    Door(x, y;)\n    or \n    Door(y, x;)\nend\n\n\nquery isContainedIn( String x, String y ) \n    Location(x, y;)\n    or \n    ( Location(z, y;) and ?isContainedIn(x, z;) )\nend\n\nquery look(String place, List things, List food, List exits) \n    Here(place;)\n    things : List() from accumulate( Location(thing, place;),\n                                    collectList( thing ) )\n    food : List() from accumulate( ?whereFood(thing, place;) ,                                    collectList( thing ) )\n    exits : List() from accumulate( ?connect(place, exit;),\n                                    collectList( exit ) )\nend\n\nrule reactiveLook when\n    Here( place : place) \n    ?look(place, things, food, exits;)\nthen\n    System.out.println( \"You are in the \" + place);\n    System.out.println( \"  You can see \" + things );\n    System.out.println( \"  You can eat \" + food );\n    System.out.println( \"  You can go to \" + exits );\nend\n\nrule init when\nthen\n        insert( new Room(\"kitchen\") );\n        insert( new Room(\"office\") );\n        insert( new Room(\"hall\") );\n        insert( new Room(\"dining room\") );\n        insert( new Room(\"cellar\") );\n        \n        insert( new Location(\"apple\", \"kitchen\") );\n        insert( new Location(\"desk\", \"office\") );\n        insert( new Location(\"flashlight\", \"desk\") );\n        insert( new Location(\"envelope\", \"desk\") );\n        insert( new Location(\"key\", \"envelope\") );\n        insert( new Location(\"washing machine\", \"cellar\") );\n        insert( new Location(\"nani\", \"washing machine\") );\n        insert( new Location(\"broccoli\", \"kitchen\") );\n        insert( new Location(\"crackers\", \"kitchen\") );\n        insert( new Location(\"compuer\", \"office\") );\n        \n        insert( new Door(\"office\", \"hall\") );\n        insert( new Door(\"kitchen\", \"office\") );\n        insert( new Door(\"hall\", \"dining room\") );\n        insert( new Door(\"kitchen\", \"cellar\") );\n        insert( new Door(\"dining room\", \"kitchen\") );\n        \n        insert( new Edible(\"apple\") );\n        insert( new Edible(\"crackers\") );\n        \n        insert( new TastesYucky(\"broccoli\") );  end\nrule go1 when\n   String( this == 'go1' )\nthen\n   insert( new Here(\"kitchen\") );\nend\n\nrule go2 when\n   String( this == 'go2' )\n   $h : Here( place == \"kitchen\")then\n   modify( $h ) { place = \"office\" };\nend\n";
        System.out.println(str);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        QueryResults results = null;
        ksession.fireAllRules();
        ksession.insert((Object)"go1");
        ksession.fireAllRules();
        ksession.insert((Object)"go2");
        ksession.fireAllRules();
        System.out.println("isContainedIn key in office");
        results = ksession.getQueryResults("isContainedIn", new Object[]{"key", "office"});
        for (QueryResultsRow result : results) {
            System.out.println("  " + result.get("x") + ":" + result.get("y"));
        }
        System.out.println("isContainedIn apple in office");
        results = ksession.getQueryResults("isContainedIn", new Object[]{"apple", "office"});
        for (QueryResultsRow result : results) {
            System.out.println("  " + result.get("x") + ":" + result.get("y"));
        }
    }

    public static class S {
        int value;

        public S(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String toString() {
            return "S" + this.value;
        }
    }

    public static class R {
        int value;

        public R(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String toString() {
            return "R" + this.value;
        }
    }

    public static class Q {
        int value;

        public Q(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String toString() {
            return "Q" + this.value;
        }
    }

    public static class Parent {
        private String parent;
        private String child;

        public Parent(String parent, String child) {
            this.parent = parent;
            this.child = child;
        }

        public String getParent() {
            return this.parent;
        }

        public void setParent(String parent) {
            this.parent = parent;
        }

        public String getChild() {
            return this.child;
        }

        public void setChild(String child) {
            this.child = child;
        }
    }

    public static class Woman {
        private String name;

        public Woman(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class Man {
        private String name;

        public Man(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

