/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.drools.Address;
import org.drools.Cheese;
import org.drools.Cheesery;
import org.drools.ClockType;
import org.drools.FactA;
import org.drools.FactB;
import org.drools.FactC;
import org.drools.FactHandle;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Order;
import org.drools.OrderItem;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.SpecialString;
import org.drools.State;
import org.drools.StatefulSession;
import org.drools.StockTick;
import org.drools.Triangle;
import org.drools.audit.WorkingMemoryConsoleLogger;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.event.rule.AfterActivationFiredEvent;
import org.drools.event.rule.AgendaEventListener;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.conf.ClockTypeOption;
import org.drools.runtime.conf.KnowledgeSessionOption;
import org.drools.time.SessionPseudoClock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;

public class FirstOrderLogicTest {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    private KnowledgeBase loadKnowledgeBase(String fileName) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)fileName, this.getClass()), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                System.err.println(error);
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        Collection knowledgePackages = kbuilder.getKnowledgePackages();
        kbase.addKnowledgePackages(knowledgePackages);
        return kbase;
    }

    @Test
    public void testCollect() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_Collect.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        List results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Cheese("stilton", 7));
        wm.insert((Object)new Cheese("stilton", 8));
        wm.insert((Object)new Cheese("brie", 5));
        wm.insert((Object)new Cheese("provolone", 150));
        wm = SerializationHelper.getSerialisedStatefulSession(wm);
        results = (List)wm.getGlobal("results");
        wm.insert((Object)new Cheese("provolone", 20));
        wm.insert((Object)new Person("Bob", "stilton"));
        wm.insert((Object)new Person("Mark", "provolone"));
        wm = SerializationHelper.getSerialisedStatefulSession(wm);
        results = (List)wm.getGlobal("results");
        wm.fireAllRules();
        wm = SerializationHelper.getSerialisedStatefulSession(wm);
        results = (List)wm.getGlobal("results");
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((Collection)results.get(0)).size());
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)results.get(0).getClass().getName());
    }

    @Test
    public void testCollectNodeSharing() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_collectNodeSharing.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        List results = new ArrayList();
        workingMemory.setGlobal("results", results);
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        results = (List)workingMemory.getGlobal("results");
        workingMemory.insert((Object)new Cheese("stilton", 10));
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        results = (List)workingMemory.getGlobal("results");
        workingMemory.insert((Object)new Cheese("brie", 15));
        workingMemory.fireAllRules();
        workingMemory = SerializationHelper.getSerialisedStatefulSession(workingMemory);
        results = (List)workingMemory.getGlobal("results");
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)2L, (long)((List)results.get(0)).size());
    }

    @Test
    public void testCollectModify() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_Collect.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        int fireCount = 0;
        wm.fireAllRules();
        Assert.assertEquals((long)(++fireCount), (long)results.size());
        Assert.assertEquals((long)3L, (long)((Collection)results.get(fireCount - 1)).size());
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)results.get(fireCount - 1).getClass().getName());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((long)(++fireCount), (long)results.size());
        Assert.assertEquals((long)3L, (long)((Collection)results.get(fireCount - 1)).size());
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)results.get(fireCount - 1).getClass().getName());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)fireCount, (long)results.size());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((long)fireCount, (long)results.size());
    }

    @Test
    public void testCollectResultConstraints() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CollectResultConstraints.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        List results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Cheese("stilton", 10));
        wm = SerializationHelper.getSerialisedStatefulSession(wm);
        results = (List)wm.getGlobal("results");
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)1L, (long)((Collection)results.get(0)).size());
        wm.insert((Object)new Cheese("stilton", 7));
        wm.insert((Object)new Cheese("stilton", 8));
        wm.fireAllRules();
        wm = SerializationHelper.getSerialisedStatefulSession(wm);
        results = (List)wm.getGlobal("results");
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)1L, (long)((Collection)results.get(0)).size());
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)results.get(0).getClass().getName());
    }

    @Test
    public void testExistsWithBinding() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ExistsWithBindings.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Cheese c = new Cheese("stilton", 10);
        Person p = new Person("Mark", "stilton");
        workingMemory.insert((Object)c);
        workingMemory.insert((Object)p);
        workingMemory.fireAllRules();
        Assert.assertTrue((boolean)list.contains(c.getType()));
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testNot() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("not_rule_test.drl")));
        if (builder.hasErrors()) {
            Assert.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        FactHandle stiltonHandle = workingMemory.insert((Object)stilton);
        Cheese cheddar = new Cheese("cheddar", 7);
        FactHandle cheddarHandle = workingMemory.insert((Object)cheddar);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        workingMemory.retract((org.drools.runtime.rule.FactHandle)stiltonHandle);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(new Integer(5)));
        Assert.assertTrue((boolean)list.contains(new Integer(6)));
        Assert.assertTrue((boolean)list.contains(new Integer(7)));
        Assert.assertTrue((boolean)list.contains(new Integer(8)));
    }

    @Test
    public void testNotWithBindings() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("not_with_bindings_rule_test.drl")));
        Package pkg = builder.getPackage();
        Rule rule = pkg.getRules()[0];
        Assert.assertTrue((boolean)rule.isValid());
        Assert.assertEquals((long)0L, (long)builder.getErrors().getErrors().length);
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        FactHandle stiltonHandle = workingMemory.insert((Object)stilton);
        Cheese cheddar = new Cheese("cheddar", 7);
        FactHandle cheddarHandle = workingMemory.insert((Object)cheddar);
        Person paul = new Person("paul", "stilton", 12);
        workingMemory.insert((Object)paul);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        workingMemory.retract((org.drools.runtime.rule.FactHandle)stiltonHandle);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testExists() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("exists_rule_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese cheddar = new Cheese("cheddar", 7);
        FactHandle cheddarHandle = workingMemory.insert((Object)cheddar);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        Cheese stilton = new Cheese("stilton", 5);
        FactHandle stiltonHandle = workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Cheese brie = new Cheese("brie", 5);
        FactHandle brieHandle = workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testExists2() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_exists.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese cheddar = new Cheese("cheddar", 7);
        Cheese provolone = new Cheese("provolone", 5);
        Person edson = new Person("Edson", "cheddar");
        Person bob = new Person("Bob", "muzzarela");
        workingMemory.insert((Object)cheddar);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        workingMemory.insert((Object)provolone);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        workingMemory.insert((Object)edson);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        workingMemory.insert((Object)bob);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testExists3() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_Exists_JBRULES_2810.drl", FirstOrderLogicTest.class), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        WorkingMemoryConsoleLogger logger = new WorkingMemoryConsoleLogger((KnowledgeRuntimeEventManager)ksession);
        ksession.fireAllRules();
        ksession.dispose();
    }

    @Test
    public void testForall() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Forall.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        State state = new State("SP");
        workingMemory.insert((Object)state);
        Person bob = new Person("Bob");
        bob.setStatus(state.getState());
        bob.setLikes("stilton");
        workingMemory.insert((Object)bob);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        workingMemory.insert((Object)new Cheese(bob.getLikes(), 10));
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testForall2() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("test_Forall2.drl")), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        State state = new State("SP");
        ksession.insert((Object)state);
        Person bob = new Person("Bob");
        bob.setStatus(state.getState());
        bob.setAlive(true);
        ksession.insert((Object)bob);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        State qc = new State("QC");
        ksession.insert((Object)qc);
        Person john = new Person("John");
        john.setStatus(qc.getState());
        john.setAlive(false);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testRemoveIdentitiesSubNetwork() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_removeIdentitiesSubNetwork.drl")));
        Package pkg = builder.getPackage();
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        config.setRemoveIdentities(true);
        RuleBase ruleBase = this.getRuleBase(config);
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Person bob = new Person("bob", "stilton");
        workingMemory.insert((Object)bob);
        Person mark = new Person("mark", "stilton");
        workingMemory.insert((Object)mark);
        Cheese stilton1 = new Cheese("stilton", 6);
        FactHandle stilton1Handle = workingMemory.insert((Object)stilton1);
        Cheese stilton2 = new Cheese("stilton", 7);
        FactHandle stilton2Handle = workingMemory.insert((Object)stilton2);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        workingMemory.retract((org.drools.runtime.rule.FactHandle)stilton1Handle);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)mark, list.get(0));
        workingMemory.retract((org.drools.runtime.rule.FactHandle)stilton2Handle);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)bob, list.get(1));
    }

    @Test
    public void testCollectWithNestedFromWithParams() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_CollectWithNestedFrom.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Person bob = new Person("bob", "stilton");
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("brie", 20));
        cheesery.addCheese(new Cheese("muzzarela", 8));
        cheesery.addCheese(new Cheese("stilton", 5));
        cheesery.addCheese(new Cheese("provolone", 1));
        workingMemory.insert((Object)bob);
        workingMemory.insert((Object)cheesery);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        List cheeses = (List)results.get(0);
        Assert.assertEquals((long)2L, (long)cheeses.size());
        Assert.assertEquals((Object)bob.getLikes(), (Object)((Cheese)cheeses.get(0)).getType());
        Assert.assertEquals((Object)bob.getLikes(), (Object)((Cheese)cheeses.get(1)).getType());
    }

    @Test
    public void testCollectModifyAlphaRestriction() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CollectAlphaRestriction.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        int fireCount = 0;
        wm.fireAllRules();
        Assert.assertEquals((long)(++fireCount), (long)results.size());
        Assert.assertEquals((long)3L, (long)((Collection)results.get(fireCount - 1)).size());
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)results.get(fireCount - 1).getClass().getName());
        boolean index = true;
        cheese[1].setType("brie");
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((long)(++fireCount), (long)results.size());
        Assert.assertEquals((long)2L, (long)((Collection)results.get(fireCount - 1)).size());
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)results.get(fireCount - 1).getClass().getName());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[2]);
        wm.fireAllRules();
        Assert.assertEquals((long)(++fireCount), (long)results.size());
        Assert.assertEquals((long)1L, (long)((Collection)results.get(fireCount - 1)).size());
        Assert.assertEquals((Object)ArrayList.class.getName(), (Object)results.get(fireCount - 1).getClass().getName());
    }

    private RuleBase loadRuleBase(Reader reader) throws IOException, DroolsParserException, Exception {
        DrlParser parser = new DrlParser();
        PackageDescr packageDescr = parser.parse(reader);
        if (parser.hasErrors()) {
            System.out.println(parser.getErrors());
            Assert.fail((String)"Error messages in parser, need to sort this our (or else collect error messages)");
        }
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        return ruleBase;
    }

    @Test
    public void testForallSinglePattern() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ForallSinglePattern.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        int fired = 0;
        workingMemory.fireAllRules();
        Assert.assertEquals((long)(++fired), (long)list.size());
        FactHandle stilton1 = workingMemory.insert((Object)new Cheese("stilton", 10));
        workingMemory.fireAllRules();
        Assert.assertEquals((long)fired, (long)list.size());
        FactHandle stilton2 = workingMemory.insert((Object)new Cheese("stilton", 11));
        workingMemory.fireAllRules();
        Assert.assertEquals((long)fired, (long)list.size());
        workingMemory.retract((org.drools.runtime.rule.FactHandle)stilton1);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)(++fired), (long)list.size());
        FactHandle brie = workingMemory.insert((Object)new Cheese("brie", 10));
        workingMemory.fireAllRules();
        Assert.assertEquals((long)fired, (long)list.size());
        workingMemory.retract((org.drools.runtime.rule.FactHandle)brie);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)(++fired), (long)list.size());
        workingMemory.retract((org.drools.runtime.rule.FactHandle)stilton2);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)(++fired), (long)list.size());
    }

    @Test
    public void testForallSinglePattern2() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_ForallSinglePattern2.drl");
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.insert((Object)new Triangle(3, 3, 3));
        ksession.insert((Object)new Triangle(3, 3, 3));
        int fired = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)fired);
        ksession.dispose();
    }

    @Test
    public void testMVELCollect() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_MVELCollect.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Cheese("stilton", 7));
        wm.insert((Object)new Cheese("stilton", 8));
        wm.insert((Object)new Cheese("brie", 5));
        wm.insert((Object)new Cheese("provolone", 150));
        wm.insert((Object)new Cheese("provolone", 20));
        wm.insert((Object)new Person("Bob", "stilton"));
        wm.insert((Object)new Person("Mark", "provolone"));
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)6L, (long)((List)results.get(0)).size());
    }

    @Test
    public void testNestedCorelatedRulesWithForall() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(FirstOrderLogicTest.class.getResourceAsStream("test_NestedCorrelatedRulesWithForall.drl")));
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(builder.getPackage());
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        ArrayList list1 = new ArrayList();
        ArrayList list2 = new ArrayList();
        ArrayList list3 = new ArrayList();
        ArrayList list4 = new ArrayList();
        session.setGlobal("list1", list1);
        session.setGlobal("list2", list2);
        session.setGlobal("list3", list3);
        session.setGlobal("list4", list4);
        SpecialString first42 = new SpecialString("42");
        SpecialString second42 = new SpecialString("42");
        SpecialString world = new SpecialString("World");
        session.insert((Object)world);
        session.insert((Object)first42);
        session.insert((Object)second42);
        Assert.assertTrue((boolean)list1.isEmpty());
        Assert.assertTrue((boolean)list2.isEmpty());
        Assert.assertTrue((boolean)list3.isEmpty());
        Assert.assertTrue((boolean)list4.isEmpty());
        session.fireAllRules();
        Assert.assertEquals((long)0L, (long)list1.size());
        Assert.assertEquals((long)0L, (long)list2.size());
        Assert.assertEquals((long)1L, (long)list3.size());
        Assert.assertEquals((long)0L, (long)list4.size());
    }

    @Test
    public void testFromInsideNotAndExists() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_FromInsideNotAndExists.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Cheese cheddar = new Cheese("cheddar", 7);
        Cheese provolone = new Cheese("provolone", 5);
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(cheddar);
        cheesery.addCheese(provolone);
        FactHandle handle = workingMemory.insert((Object)cheesery);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.removeCheese(cheddar);
        workingMemory.update((org.drools.runtime.rule.FactHandle)handle, (Object)cheesery);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testOr() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_OrNesting.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Cheese cheddar = new Cheese("cheddar", 7);
        Cheese provolone = new Cheese("provolone", 5);
        Cheese brie = new Cheese("brie", 15);
        Person mark = new Person("mark", "stilton");
        FactHandle ch = workingMemory.insert((Object)cheddar);
        FactHandle ph = workingMemory.insert((Object)provolone);
        FactHandle bh = workingMemory.insert((Object)brie);
        FactHandle markh = workingMemory.insert((Object)mark);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testOrWithVariableResolution() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_OrCEFollowedByMultipleEval.drl", FirstOrderLogicTest.class), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        AgendaEventListener al = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(al);
        ksession.insert((Object)new FactA("a"));
        ksession.insert((Object)new FactB("b"));
        ksession.insert((Object)new FactC("c"));
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)al, (VerificationMode)Mockito.times((int)6))).afterActivationFired((AfterActivationFiredEvent)Matchers.any(AfterActivationFiredEvent.class));
    }

    @Test
    public void testOrWithVariableResolution2() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_OrCEFollowedByMultipleEval2.drl", FirstOrderLogicTest.class), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        AgendaEventListener al = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(al);
        ksession.insert((Object)new FactA("a"));
        ksession.insert((Object)new FactB("b"));
        ksession.insert((Object)new FactC("c"));
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)al, (VerificationMode)Mockito.times((int)8))).afterActivationFired((AfterActivationFiredEvent)Matchers.any(AfterActivationFiredEvent.class));
    }

    @Test
    public void testCollectWithMemberOfOperators() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_CollectMemberOfOperator.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Order order1 = new Order(1, "bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        Order order2 = new Order(2, "mark");
        OrderItem item21 = new OrderItem(order2, 1);
        OrderItem item22 = new OrderItem(order2, 2);
        workingMemory.insert((Object)order1);
        workingMemory.insert((Object)item11);
        workingMemory.insert((Object)item12);
        workingMemory.insert((Object)order2);
        workingMemory.insert((Object)item21);
        workingMemory.insert((Object)item22);
        workingMemory.fireAllRules();
        int index = 0;
        Assert.assertEquals((long)8L, (long)list.size());
        Assert.assertSame((Object)order1, list.get(index++));
        Assert.assertSame((Object)item11, list.get(index++));
        Assert.assertSame((Object)order2, list.get(index++));
        Assert.assertSame((Object)item21, list.get(index++));
        Assert.assertSame((Object)order1, list.get(index++));
        Assert.assertSame((Object)item11, list.get(index++));
        Assert.assertSame((Object)order2, list.get(index++));
        Assert.assertSame((Object)item21, list.get(index++));
    }

    @Test
    public void testCollectWithContainsOperators() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_CollectContainsOperator.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Order order1 = new Order(1, "bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        Order order2 = new Order(2, "mark");
        OrderItem item21 = new OrderItem(order2, 1);
        OrderItem item22 = new OrderItem(order2, 2);
        workingMemory.insert((Object)order1);
        workingMemory.insert((Object)item11);
        workingMemory.insert((Object)item12);
        workingMemory.insert((Object)order2);
        workingMemory.insert((Object)item21);
        workingMemory.insert((Object)item22);
        workingMemory.fireAllRules();
        int index = 0;
        Assert.assertEquals((long)8L, (long)list.size());
        Assert.assertSame((Object)order1, list.get(index++));
        Assert.assertSame((Object)item11, list.get(index++));
        Assert.assertSame((Object)order2, list.get(index++));
        Assert.assertSame((Object)item21, list.get(index++));
        Assert.assertSame((Object)order1, list.get(index++));
        Assert.assertSame((Object)item11, list.get(index++));
        Assert.assertSame((Object)order2, list.get(index++));
        Assert.assertSame((Object)item21, list.get(index++));
    }

    @Test
    public void testForallSinglePatternWithExists() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_ForallSinglePatternWithExists.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.insert((Object)new Cheese("stilton", 10));
        workingMemory.insert((Object)new Cheese("brie", 10));
        workingMemory.insert((Object)new Cheese("brie", 10));
        workingMemory.insert((Object)new Order(1, "bob"));
        workingMemory.insert((Object)new Person("bob", "stilton", 10));
        workingMemory.insert((Object)new Person("mark", "stilton"));
        workingMemory.fireAllRules();
    }

    @Test
    public void testCollectResultBetaConstraint() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CollectResultsBetaConstraint.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Double(10.0));
        wm.insert((Object)new Integer(2));
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)results.size());
        wm.insert((Object)new Double(15.0));
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((Object)"collect", results.get(0));
        Assert.assertEquals((Object)"accumulate", results.get(1));
    }

    @Test
    public void testFromWithOr() throws Exception {
        KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        builder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("test_FromWithOr.drl")), ResourceType.DRL);
        if (builder.hasErrors()) {
            System.out.println(builder.getErrors());
        }
        Assert.assertFalse((boolean)builder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(builder.getKnowledgePackages());
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        Address a1 = new Address();
        a1.setZipCode("12345");
        Address a2 = new Address();
        a2.setZipCode("54321");
        Address a3 = new Address();
        a3.setZipCode("99999");
        Person p = new Person();
        p.addAddress(a1);
        p.addAddress(a2);
        p.addAddress(a3);
        session.insert((Object)p);
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(a1));
        Assert.assertTrue((boolean)results.contains(a2));
    }

    @Test
    public void testForallWithSlidingWindow() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream("test_ForallSlidingWindow.drl")), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(conf, null);
        SessionPseudoClock clock = (SessionPseudoClock)ksession.getSessionClock();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        clock.advanceTime(60L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        int seq = 1;
        ksession.insert((Object)new StockTick(seq++, "RHT", 10.0, clock.getCurrentTime()));
        clock.advanceTime(5L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        ksession.insert((Object)new StockTick(seq++, "RHT", 10.0, clock.getCurrentTime()));
        clock.advanceTime(5L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        ksession.insert((Object)new StockTick(seq++, "IBM", 10.0, clock.getCurrentTime()));
        clock.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        ksession.insert((Object)new StockTick(seq++, "RHT", 10.0, clock.getCurrentTime()));
        clock.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        ksession.insert((Object)new StockTick(seq++, "RHT", 10.0, clock.getCurrentTime()));
        clock.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        ksession.insert((Object)new StockTick(seq++, "RHT", 10.0, clock.getCurrentTime()));
        clock.advanceTime(10L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)results.size());
        clock.advanceTime(60L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertEquals((long)4L, (long)results.size());
    }

    @Test
    public void testCollectFromMVELAfterOr() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_CollectFromMVELAfterOr.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        List results = new ArrayList();
        wm.setGlobal("results", results);
        Person jill = new Person("jill");
        Person bob = new Person("bob");
        ArrayList<Address> addresses = new ArrayList<Address>();
        addresses.add(new Address("a"));
        addresses.add(new Address("b"));
        addresses.add(new Address("c"));
        bob.setAddresses(addresses);
        wm.insert((Object)jill);
        wm.insert((Object)bob);
        wm = SerializationHelper.getSerialisedStatefulSession(wm);
        results = (List)wm.getGlobal("results");
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((Collection)results.get(0)).size());
    }
}

