/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.drools.Cheese;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.base.mvel.MVELDebugHandler;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.core.util.DateUtils;
import org.drools.integrationtests.SerializationHelper;
import org.drools.integrationtests.TestObject;
import org.drools.io.ResourceFactory;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.Package;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.type.DateFormats;
import org.drools.type.DateFormatsImpl;
import org.junit.Assert;
import org.junit.Test;
import org.mvel2.MVEL;

public class MVELTest {
    @Test
    public void testHelloWorld() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_mvel.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        ArrayList list2 = new ArrayList();
        workingMemory.setGlobal("list2", list2);
        Cheese c = new Cheese("stilton", 10);
        workingMemory.insert((Object)c);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)BigInteger.valueOf(30L), list.get(0));
        Assert.assertEquals((Object)22, list.get(1));
        Assert.assertEquals((Object)"hello world", list2.get(0));
        Date dt = DateUtils.parseDate((String)"10-Jul-1974", (DateFormats)new DateFormatsImpl());
        Assert.assertEquals((Object)dt, (Object)c.getUsedBy());
    }

    @Test
    public void testIncrementOperator() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    dialect \"mvel\" \n";
        str = str + "when \n";
        str = str + "    $I : Integer() \n";
        str = str + "then \n";
        str = str + "    i = $I.intValue(); \n";
        str = str + "    i += 5; \n";
        str = str + "    list.add( i ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)5);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)10, list.get(0));
    }

    @Test
    public void testEvalWithBigDecimal() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import java.math.BigDecimal; \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    dialect \"mvel\" \n";
        str = str + "when \n";
        str = str + "    $bd : BigDecimal() \n";
        str = str + "    eval( $bd.compareTo( BigDecimal.ZERO ) > 0 ) \n";
        str = str + "then \n";
        str = str + "    list.add( $bd ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.err.println(kbuilder.getErrors());
        }
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new BigDecimal(1.5));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)new BigDecimal(1.5), list.get(0));
    }

    @Test
    public void testLocalVariableMVELConsequence() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_LocalVariableMVELConsequence.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.insert((Object)new Person("bob", "stilton"));
        workingMemory.insert((Object)new Person("mark", "brie"));
        try {
            workingMemory.fireAllRules();
            Assert.assertEquals((String)"should have fired twice", (long)2L, (long)list.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Should not raise any exception");
        }
    }

    @Test
    public void testMVELUsingGlobalsInDebugMode() throws Exception {
        MVELDebugHandler.setDebugMode((boolean)true);
        try {
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_MVELGlobalDebug.drl")));
            Package pkg = builder.getPackage();
            RuleBase ruleBase = this.getRuleBase();
            ruleBase.addPackage(pkg);
            ruleBase = SerializationHelper.serializeObject(ruleBase);
            StatefulSession session = ruleBase.newStatefulSession();
            session.dispose();
            MVELDebugHandler.setDebugMode((boolean)false);
        }
        catch (Exception e) {
            MVELDebugHandler.setDebugMode((boolean)false);
            e.printStackTrace();
            Assert.fail((String)"Should not raise exceptions");
        }
    }

    @Test
    public void testDuplicateLocalVariableMVELConsequence() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DuplicateLocalVariableMVELConsequence.drl")));
        Assert.assertTrue((boolean)builder.hasErrors());
    }

    @Test
    public void testArrays() throws Exception {
        String text = "package test_mvel;\n";
        text = text + "import org.drools.integrationtests.TestObject;\n";
        text = text + "import function org.drools.integrationtests.TestObject.array;\n";
        text = text + "no-loop true\n";
        text = text + "dialect \"mvel\"\n";
        text = text + "rule \"1\"\n";
        text = text + "salience 1\n";
        text = text + "when\n";
        text = text + "    $fact: TestObject()\n";
        text = text + "    eval($fact.checkHighestPriority(\"mvel\", 2))\n";
        text = text + "    eval($fact.stayHasDaysOfWeek(\"mvel\", false, new String[][]{{\"2008-04-01\", \"2008-04-10\"}}))\n";
        text = text + "then\n";
        text = text + "    $fact.applyValueAddPromo(1,2,3,4,\"mvel\");\n";
        text = text + "end";
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(this.compileRule(text.replaceAll("mvel", "java")));
        ruleBase.addPackage(this.compileRule(text));
        ArrayList list = new ArrayList();
        ruleBase.newStatelessSession().execute((Object)new TestObject(list));
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"TestObject.checkHighestPriority: java|2", list.get(0));
        Assert.assertEquals((Object)"TestObject.stayHasDaysOfWeek: java|false|[2008-04-01, 2008-04-10]", list.get(1));
        Assert.assertEquals((Object)"TestObject.checkHighestPriority: mvel|2", list.get(2));
        Assert.assertEquals((Object)"TestObject.stayHasDaysOfWeek: mvel|false|[2008-04-01, 2008-04-10]", list.get(3));
        Assert.assertEquals((Object)"TestObject.applyValueAddPromo: 1|2|3|4|mvel", list.get(4));
        Assert.assertEquals((Object)"TestObject.applyValueAddPromo: 1|2|3|4|java", list.get(5));
    }

    @Test
    public void testPackageImports() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "dialect \"mvel\"\n";
        str = str + "import org.acme.healthcare.* \n";
        str = str + "import org.acme.insurance.* \n";
        str = str + "import org.acme.sensors.SensorReading \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    eval(true)\n";
        str = str + "  then \n";
        str = str + "    insert(new Claim());         // from org.acme.healthcare.* \n";
        str = str + "    insert(new Policy());        // from org.acme.insurance.* \n";
        str = str + "    insert(new SensorReading()); // from org.acme.sensor.SensorReading \n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            throw new RuntimeException(kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        int result = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)result);
        Collection insertedObjects = ksession.getObjects();
        Assert.assertEquals((long)3L, (long)insertedObjects.size());
    }

    private Package compileRule(String drl) throws Exception {
        PackageBuilder builder = new PackageBuilder(new PackageBuilderConfiguration());
        builder.addPackageFromDrl((Reader)new StringReader(drl));
        Package pkg = builder.getPackage();
        if (!pkg.isValid()) {
            throw new DroolsParserException(pkg.getErrorSummary());
        }
        return pkg;
    }

    public Object compiledExecute(String ex) {
        Serializable compiled = MVEL.compileExpression((String)ex);
        return MVEL.executeExpression((Object)compiled, (Object)new Object(), new HashMap());
    }

    private RuleBase loadRuleBase(Reader reader) throws IOException, DroolsParserException, Exception {
        DrlParser parser = new DrlParser();
        PackageDescr packageDescr = parser.parse(reader);
        if (parser.hasErrors()) {
            Assert.fail((String)("Error messages in parser, need to sort this our (or else collect error messages)\n" + parser.getErrors()));
        }
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(packageDescr);
        if (builder.hasErrors()) {
            Assert.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        return ruleBase;
    }

    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }
}

