/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.Address;
import org.drools.Cheese;
import org.drools.FactHandle;
import org.drools.InsertedObject;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.QueryResult;
import org.drools.QueryResults;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.Worker;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.NodeMemory;
import org.drools.compiler.PackageBuilder;
import org.drools.core.util.Entry;
import org.drools.core.util.ObjectHashMap;
import org.drools.core.util.ObjectHashSet;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.rule.Package;
import org.drools.rule.Variable;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.conf.KnowledgeSessionOption;
import org.drools.runtime.conf.QueryListenerOption;
import org.drools.runtime.rule.LiveQuery;
import org.drools.runtime.rule.QueryResultsRow;
import org.drools.runtime.rule.Row;
import org.drools.runtime.rule.ViewChangedEventListener;
import org.drools.runtime.rule.impl.FlatQueryResults;
import org.junit.Assert;
import org.junit.Test;

public class QueryTest {
    protected RuleBase getRuleBase() throws Exception {
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        config.setMultithreadEvaluation(false);
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    @Test
    public void testQuery() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("simple_query_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        Cheese stilton = new Cheese("stinky", 5);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        QueryResults results = session.getQueryResults("simple query", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testQueryRemoval() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("simple_query_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession session = ruleBase.newStatefulSession();
        Cheese stilton = new Cheese("stinky", 5);
        session.insert((Object)stilton);
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        QueryResults results = session.getQueryResults("simple query", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertNotNull((Object)ruleBase.getPackage("org.drools.test").getRule("simple query"));
        ruleBase.removeQuery("org.drools.test", "simple query");
        Assert.assertNull((Object)ruleBase.getPackage("org.drools.test").getRule("simple query"));
        results = session.getQueryResults("simple query", new Object[0]);
        Assert.assertEquals((long)0L, (long)results.size());
    }

    @Test
    public void testQuery2() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Query.drl")));
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(builder.getPackage());
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.fireAllRules();
        QueryResults results = workingMemory.getQueryResults("assertedobjquery", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)new InsertedObject("value1"), (Object)results.get(0).get(0));
    }

    @Test
    public void testQuery2KnowledgeBuilder() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_Query.drl", this.getClass()), ResourceType.DRL);
        KnowledgeBase kbase = kbuilder.newKnowledgeBase();
        kbase.addKnowledgePackages(kbase.getKnowledgePackages());
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.fireAllRules();
        org.drools.runtime.rule.QueryResults results = ksession.getQueryResults("assertedobjquery", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)new InsertedObject("value1"), (Object)((QueryResultsRow)results.iterator().next()).get("assertedobj"));
    }

    @Test
    public void testQueryWithParams() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_QueryWithParams.drl")));
        if (builder.hasErrors()) {
            Assert.fail((String)builder.getErrors().toString());
        }
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(builder.getPackage());
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.fireAllRules();
        QueryResults results = workingMemory.getQueryResults("assertedobjquery", (Object[])new String[]{"value1"});
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)new InsertedObject("value1"), (Object)results.get(0).get(0));
        results = workingMemory.getQueryResults("assertedobjquery", (Object[])new String[]{"value3"});
        Assert.assertEquals((long)0L, (long)results.size());
        results = workingMemory.getQueryResults("assertedobjquery2", (Object[])new String[]{null, "value2"});
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)new InsertedObject("value2"), (Object)results.get(0).get(0));
        results = workingMemory.getQueryResults("assertedobjquery2", (Object[])new String[]{"value3", "value2"});
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)new InsertedObject("value2"), (Object)results.get(0).get(0));
    }

    @Test
    public void testQueryWithParamsOnKnowledgeApi() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_QueryWithParams.drl", this.getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.fireAllRules();
        org.drools.runtime.rule.QueryResults results = ksession.getQueryResults("assertedobjquery", (Object[])new String[]{"value1"});
        Assert.assertEquals((long)1L, (long)results.size());
        results = ksession.getQueryResults("assertedobjquery", (Object[])new String[]{"value3"});
        Assert.assertEquals((long)0L, (long)results.size());
        results = ksession.getQueryResults("assertedobjquery2", (Object[])new String[]{null, "value2"});
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)new InsertedObject("value2"), (Object)((QueryResultsRow)results.iterator().next()).get("assertedobj"));
        results = ksession.getQueryResults("assertedobjquery2", (Object[])new String[]{"value3", "value2"});
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)new InsertedObject("value2"), (Object)((QueryResultsRow)results.iterator().next()).get("assertedobj"));
    }

    @Test
    public void testQueryWithMultipleResultsOnKnowledgeApi() throws Exception {
        String str = "";
        str = str + "package org.drools.test  \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "query cheeses \n";
        str = str + "    stilton : Cheese(type == 'stilton') \n";
        str = str + "    cheddar : Cheese(type == 'cheddar', price == stilton.price) \n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Cheese stilton1 = new Cheese("stilton", 1);
        Cheese cheddar1 = new Cheese("cheddar", 1);
        Cheese stilton2 = new Cheese("stilton", 2);
        Cheese cheddar2 = new Cheese("cheddar", 2);
        Cheese stilton3 = new Cheese("stilton", 3);
        Cheese cheddar3 = new Cheese("cheddar", 3);
        HashSet set = new HashSet();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(stilton1);
        list.add(cheddar1);
        set.add(list);
        list = new ArrayList();
        list.add(stilton2);
        list.add(cheddar2);
        set.add(list);
        list = new ArrayList();
        list.add(stilton3);
        list.add(cheddar3);
        set.add(list);
        ksession.insert((Object)stilton1);
        ksession.insert((Object)stilton2);
        ksession.insert((Object)stilton3);
        ksession.insert((Object)cheddar1);
        ksession.insert((Object)cheddar2);
        ksession.insert((Object)cheddar3);
        org.drools.runtime.rule.QueryResults results = ksession.getQueryResults("cheeses", new Object[0]);
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertEquals((long)2L, (long)results.getIdentifiers().length);
        HashSet<ArrayList<Object>> newSet = new HashSet<ArrayList<Object>>();
        for (QueryResultsRow result : results) {
            list = new ArrayList();
            list.add(result.get("stilton"));
            list.add(result.get("cheddar"));
            newSet.add(list);
        }
        Assert.assertEquals(set, newSet);
        FlatQueryResults flatResults = new FlatQueryResults(((StatefulKnowledgeSessionImpl)ksession).session.getQueryResults("cheeses"));
        Assert.assertEquals((long)3L, (long)flatResults.size());
        Assert.assertEquals((long)2L, (long)flatResults.getIdentifiers().length);
        newSet = new HashSet();
        for (QueryResultsRow result : flatResults) {
            list = new ArrayList();
            list.add(result.get("stilton"));
            list.add(result.get("cheddar"));
            newSet.add(list);
        }
        Assert.assertEquals(set, newSet);
    }

    @Test
    public void testTwoQuerries() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_TwoQuerries.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese stilton = new Cheese("stinky", 5);
        workingMemory.insert((Object)stilton);
        Person per1 = new Person("stinker", "smelly feet", 70);
        Person per2 = new Person("skunky", "smelly armpits", 40);
        workingMemory.insert((Object)per1);
        workingMemory.insert((Object)per2);
        QueryResults results = workingMemory.getQueryResults("find stinky cheeses", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        results = workingMemory.getQueryResults("find pensioners", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
    }

    @Test
    public void testDoubleQueryWithExists() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DoubleQueryWithExists.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Person p1 = new Person("p1", "stilton", 20);
        p1.setStatus("europe");
        FactHandle c1FactHandle = workingMemory.insert((Object)p1);
        Person p2 = new Person("p2", "stilton", 30);
        p2.setStatus("europe");
        FactHandle c2FactHandle = workingMemory.insert((Object)p2);
        Person p3 = new Person("p3", "stilton", 40);
        p3.setStatus("europe");
        FactHandle c3FactHandle = workingMemory.insert((Object)p3);
        workingMemory.fireAllRules();
        QueryResults queryResults = workingMemory.getQueryResults("2 persons with the same status", new Object[0]);
        Assert.assertEquals((long)2L, (long)queryResults.size());
        p3.setStatus("america");
        workingMemory.update((org.drools.runtime.rule.FactHandle)c3FactHandle, (Object)p3);
        workingMemory.fireAllRules();
        queryResults = workingMemory.getQueryResults("2 persons with the same status", new Object[0]);
        Assert.assertEquals((long)1L, (long)queryResults.size());
        p2.setStatus("america");
        workingMemory.update((org.drools.runtime.rule.FactHandle)c2FactHandle, (Object)p2);
        workingMemory.fireAllRules();
        queryResults = workingMemory.getQueryResults("2 persons with the same status", new Object[0]);
        Assert.assertEquals((long)1L, (long)queryResults.size());
        p1.setStatus("america");
        workingMemory.update((org.drools.runtime.rule.FactHandle)c1FactHandle, (Object)p1);
        workingMemory.fireAllRules();
        queryResults = workingMemory.getQueryResults("2 persons with the same status", new Object[0]);
        Assert.assertEquals((long)2L, (long)queryResults.size());
        p2.setStatus("europe");
        workingMemory.update((org.drools.runtime.rule.FactHandle)c2FactHandle, (Object)p2);
        workingMemory.fireAllRules();
        queryResults = workingMemory.getQueryResults("2 persons with the same status", new Object[0]);
        Assert.assertEquals((long)1L, (long)queryResults.size());
        p1.setStatus("europe");
        workingMemory.update((org.drools.runtime.rule.FactHandle)c1FactHandle, (Object)p1);
        workingMemory.fireAllRules();
        queryResults = workingMemory.getQueryResults("2 persons with the same status", new Object[0]);
        Assert.assertEquals((long)1L, (long)queryResults.size());
        p3.setStatus("europe");
        workingMemory.update((org.drools.runtime.rule.FactHandle)c3FactHandle, (Object)p3);
        workingMemory.fireAllRules();
        queryResults = workingMemory.getQueryResults("2 persons with the same status", new Object[0]);
        Assert.assertEquals((long)2L, (long)queryResults.size());
    }

    @Test
    public void testQueryWithCollect() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_Query.drl")));
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(builder.getPackage());
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.fireAllRules();
        QueryResults results = workingMemory.getQueryResults("collect objects", new Object[0]);
        Assert.assertEquals((long)1L, (long)results.size());
        QueryResult result = results.get(0);
        List list = (List)result.get("$list");
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testDroolsQueryCleanup() {
        ReteooWorkingMemory reteWorkingMemory;
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_QueryMemoryLeak.drl", this.getClass()), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (errors.size() > 0) {
            for (KnowledgeBuilderError error : errors) {
                System.err.println(error);
            }
            throw new IllegalArgumentException("Could not parse knowledge.");
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        String workerId = "B1234";
        Worker worker = new Worker();
        worker.setId(workerId);
        org.drools.runtime.rule.FactHandle handle = ksession.insert((Object)worker);
        ksession.fireAllRules();
        Assert.assertNotNull((Object)handle);
        org.drools.runtime.rule.QueryResults retractedWorker = null;
        for (int i = 0; i < 100; ++i) {
            retractedWorker = ksession.getQueryResults("getWorker", new Object[]{workerId});
        }
        Assert.assertNotNull(retractedWorker);
        StatefulKnowledgeSessionImpl sessionImpl = (StatefulKnowledgeSessionImpl)ksession;
        ReteooWorkingMemory abstractWorkingMemory = reteWorkingMemory = sessionImpl.session;
        InternalRuleBase ruleBase = (InternalRuleBase)abstractWorkingMemory.getRuleBase();
        Collection entryPointNodes = ruleBase.getRete().getEntryPointNodes().values();
        EntryPointNode defaultEntryPointNode = null;
        for (EntryPointNode epNode : entryPointNodes) {
            if (epNode.getEntryPoint().getEntryPointId() != "DEFAULT") continue;
            defaultEntryPointNode = epNode;
            break;
        }
        Assert.assertNotNull(defaultEntryPointNode);
        Map obnodes = defaultEntryPointNode.getObjectTypeNodes();
        ClassObjectType key = new ClassObjectType(DroolsQuery.class);
        ObjectTypeNode droolsQueryNode = (ObjectTypeNode)obnodes.get(key);
        ObjectHashSet droolsQueryMemory = (ObjectHashSet)abstractWorkingMemory.getNodeMemory((NodeMemory)droolsQueryNode);
        Assert.assertEquals((long)0L, (long)droolsQueryMemory.size());
        Entry[] entries = droolsQueryMemory.getTable();
        int entryCounter = 0;
        for (Entry entry : entries) {
            if (entry == null) continue;
            ++entryCounter;
            ObjectHashMap.ObjectEntry oEntry = (ObjectHashMap.ObjectEntry)entry;
            DefaultFactHandle factHandle = (DefaultFactHandle)oEntry.getValue();
            Assert.assertNull((Object)factHandle.getObject());
        }
    }

    @Test
    public void testQueriesWithVariableUnification() throws Exception {
        String str = "";
        str = str + "package org.drools.test  \n";
        str = str + "import org.drools.Person \n";
        str = str + "query peeps( String $name, String $likes, int $age ) \n";
        str = str + "    $p : Person( $name : name, $likes : likes, $age : age ) \n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("yoda", "stilton", 300);
        Person p3 = new Person("luke", "brie", 300);
        Person p4 = new Person("bobba", "cheddar", 300);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.insert((Object)p4);
        org.drools.runtime.rule.QueryResults results = ksession.getQueryResults("peeps", new Object[]{Variable.variable, Variable.variable, Variable.variable});
        Assert.assertEquals((long)4L, (long)results.size());
        ArrayList<String> names = new ArrayList<String>();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)4L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("luke"));
        Assert.assertTrue((boolean)names.contains("yoda"));
        Assert.assertTrue((boolean)names.contains("bobba"));
        Assert.assertTrue((boolean)names.contains("darth"));
        results = ksession.getQueryResults("peeps", new Object[]{Variable.variable, Variable.variable, 300});
        Assert.assertEquals((long)3L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)3L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("luke"));
        Assert.assertTrue((boolean)names.contains("yoda"));
        Assert.assertTrue((boolean)names.contains("bobba"));
        results = ksession.getQueryResults("peeps", new Object[]{Variable.variable, "stilton", 300});
        Assert.assertEquals((long)1L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)1L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("yoda"));
        results = ksession.getQueryResults("peeps", new Object[]{Variable.variable, "stilton", Variable.variable});
        Assert.assertEquals((long)2L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)2L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("yoda"));
        Assert.assertTrue((boolean)names.contains("darth"));
        results = ksession.getQueryResults("peeps", new Object[]{"darth", Variable.variable, Variable.variable});
        Assert.assertEquals((long)1L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)1L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("darth"));
    }

    @Test
    public void testQueriesWithVariableUnificationOnPatterns() throws Exception {
        String str = "";
        str = str + "package org.drools.test  \n";
        str = str + "import org.drools.Person \n";
        str = str + "query peeps( Person $p, String $name, String $likes, int $age ) \n";
        str = str + "    $p : Person( $name : name, $likes : likes, $age : age ) \n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Person p1 = new Person("darth", "stilton", 100);
        Person p2 = new Person("yoda", "stilton", 300);
        Person p3 = new Person("luke", "brie", 300);
        Person p4 = new Person("bobba", "cheddar", 300);
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        ksession.insert((Object)p3);
        ksession.insert((Object)p4);
        org.drools.runtime.rule.QueryResults results = ksession.getQueryResults("peeps", new Object[]{Variable.variable, Variable.variable, Variable.variable, Variable.variable});
        Assert.assertEquals((long)4L, (long)results.size());
        ArrayList<String> names = new ArrayList<String>();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)4L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("luke"));
        Assert.assertTrue((boolean)names.contains("yoda"));
        Assert.assertTrue((boolean)names.contains("bobba"));
        Assert.assertTrue((boolean)names.contains("darth"));
        results = ksession.getQueryResults("peeps", new Object[]{p1, Variable.variable, Variable.variable, Variable.variable});
        Assert.assertEquals((long)1L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertEquals((long)1L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("darth"));
    }

    @Test
    public void testQueriesWithVariableUnificationOnNestedFields() throws Exception {
        String str = "";
        str = str + "package org.drools.test  \n";
        str = str + "import org.drools.Person \n";
        str = str + "query peeps( String $name, String $likes, String $street) \n";
        str = str + "    $p : Person( $name : name, $likes : likes, $street : address.street ) \n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Person p1 = new Person("darth", "stilton", 100);
        p1.setAddress(new Address("s1"));
        Person p2 = new Person("yoda", "stilton", 300);
        p2.setAddress(new Address("s2"));
        ksession.insert((Object)p1);
        ksession.insert((Object)p2);
        org.drools.runtime.rule.QueryResults results = ksession.getQueryResults("peeps", new Object[]{Variable.variable, Variable.variable, Variable.variable});
        Assert.assertEquals((long)2L, (long)results.size());
        ArrayList<String> names = new ArrayList<String>();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertTrue((boolean)names.contains("yoda"));
        Assert.assertTrue((boolean)names.contains("darth"));
        results = ksession.getQueryResults("peeps", new Object[]{Variable.variable, Variable.variable, "s1"});
        Assert.assertEquals((long)1L, (long)results.size());
        names = new ArrayList();
        for (QueryResultsRow row : results) {
            names.add(((Person)row.get("$p")).getName());
        }
        Assert.assertTrue((boolean)names.contains("darth"));
    }

    @Test
    public void testOpenQuery() throws Exception {
        String str = "";
        str = str + "package org.drools.test  \n";
        str = str + "import org.drools.Cheese \n";
        str = str + "query cheeses(String $type1, String $type2) \n";
        str = str + "    stilton : Cheese(type == $type1, $sprice : price) \n";
        str = str + "    cheddar : Cheese(type == $type2, $cprice : price == stilton.price) \n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Cheese stilton1 = new Cheese("stilton", 1);
        Cheese cheddar1 = new Cheese("cheddar", 1);
        Cheese stilton2 = new Cheese("stilton", 2);
        Cheese cheddar2 = new Cheese("cheddar", 2);
        Cheese stilton3 = new Cheese("stilton", 3);
        Cheese cheddar3 = new Cheese("cheddar", 3);
        org.drools.runtime.rule.FactHandle s1Fh = ksession.insert((Object)stilton1);
        ksession.insert((Object)stilton2);
        ksession.insert((Object)stilton3);
        ksession.insert((Object)cheddar1);
        ksession.insert((Object)cheddar2);
        org.drools.runtime.rule.FactHandle c3Fh = ksession.insert((Object)cheddar3);
        final ArrayList updated = new ArrayList();
        final ArrayList removed = new ArrayList();
        final ArrayList added = new ArrayList();
        ViewChangedEventListener listener = new ViewChangedEventListener(){

            public void rowUpdated(Row row) {
                Object[] array = new Object[]{row.get("stilton"), row.get("cheddar"), row.get("$sprice"), row.get("$cprice"), row.get("$type1"), row.get("$type2")};
                updated.add(array);
            }

            public void rowRemoved(Row row) {
                Object[] array = new Object[]{row.get("stilton"), row.get("cheddar"), row.get("$sprice"), row.get("$cprice"), row.get("$type1"), row.get("$type2")};
                removed.add(array);
            }

            public void rowAdded(Row row) {
                Object[] array = new Object[]{row.get("stilton"), row.get("cheddar"), row.get("$sprice"), row.get("$cprice"), row.get("$type1"), row.get("$type2")};
                added.add(array);
            }
        };
        LiveQuery query = ksession.openLiveQuery("cheeses", new Object[]{"stilton", "cheddar"}, listener);
        Assert.assertEquals((long)3L, (long)added.size());
        Assert.assertEquals((long)0L, (long)removed.size());
        Assert.assertEquals((long)0L, (long)updated.size());
        Assert.assertSame((Object)stilton1, (Object)((Object[])added.get(0))[0]);
        Assert.assertSame((Object)cheddar1, (Object)((Object[])added.get(0))[1]);
        Assert.assertEquals((Object)1, (Object)((Object[])added.get(0))[2]);
        Assert.assertEquals((Object)1, (Object)((Object[])added.get(0))[3]);
        Assert.assertEquals((Object)"stilton", (Object)((Object[])added.get(0))[4]);
        Assert.assertEquals((Object)"cheddar", (Object)((Object[])added.get(0))[5]);
        Assert.assertEquals((Object)1, (Object)((Object[])added.get(0))[3]);
        Assert.assertEquals((Object)2, (Object)((Object[])added.get(1))[3]);
        Assert.assertEquals((Object)3, (Object)((Object[])added.get(2))[3]);
        cheddar3.setPrice(4);
        ksession.update(c3Fh, (Object)cheddar3);
        Assert.assertEquals((long)3L, (long)added.size());
        Assert.assertEquals((long)1L, (long)removed.size());
        Assert.assertEquals((long)0L, (long)updated.size());
        Assert.assertEquals((Object)4, (Object)((Object[])removed.get(0))[3]);
        cheddar3.setPrice(3);
        ksession.update(c3Fh, (Object)cheddar3);
        Assert.assertEquals((long)4L, (long)added.size());
        Assert.assertEquals((long)1L, (long)removed.size());
        Assert.assertEquals((long)0L, (long)updated.size());
        Assert.assertEquals((Object)3, (Object)((Object[])added.get(3))[3]);
        cheddar3.setOldPrice(0);
        ksession.update(c3Fh, (Object)cheddar3);
        Assert.assertEquals((long)4L, (long)added.size());
        Assert.assertEquals((long)1L, (long)removed.size());
        Assert.assertEquals((long)1L, (long)updated.size());
        Assert.assertEquals((Object)3, (Object)((Object[])updated.get(0))[3]);
        ksession.retract(s1Fh);
        Assert.assertEquals((long)4L, (long)added.size());
        Assert.assertEquals((long)2L, (long)removed.size());
        Assert.assertEquals((long)1L, (long)updated.size());
        Assert.assertEquals((Object)1, (Object)((Object[])removed.get(1))[3]);
        query.close();
        Assert.assertEquals((long)4L, (long)added.size());
        Assert.assertEquals((long)4L, (long)removed.size());
        Assert.assertEquals((long)1L, (long)updated.size());
        Assert.assertEquals((Object)2, (Object)((Object[])removed.get(2))[3]);
        Assert.assertEquals((Object)3, (Object)((Object[])removed.get(3))[3]);
        ksession.update(c3Fh, (Object)cheddar3);
        Assert.assertEquals((long)4L, (long)added.size());
        Assert.assertEquals((long)4L, (long)removed.size());
        Assert.assertEquals((long)1L, (long)updated.size());
    }

    @Test
    public void testStandardQueryListener() {
        this.runQueryListenerTest(QueryListenerOption.STANDARD);
    }

    @Test
    public void testNonCloningQueryListener() {
        this.runQueryListenerTest(QueryListenerOption.LIGHTWEIGHT);
    }

    public void runQueryListenerTest(QueryListenerOption option) {
        String str = "";
        str = str + "package org.drools\n";
        str = str + "query cheeses(String $type) \n";
        str = str + "    $cheese : Cheese(type == $type) \n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        conf.setOption((KnowledgeSessionOption)option);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(conf, null);
        for (int i = 0; i < 10000; ++i) {
            ksession.insert((Object)new Cheese(i % 2 == 0 ? "stilton" : "brie"));
        }
        for (int i = 0; i < 100; ++i) {
            org.drools.runtime.rule.QueryResults queryResults = ksession.getQueryResults("cheeses", new Object[]{"stilton"});
            ArrayList<Cheese> cheeses = new ArrayList<Cheese>();
            for (QueryResultsRow row : queryResults) {
                cheeses.add((Cheese)row.get("$cheese"));
            }
            Assert.assertEquals((long)5000L, (long)cheeses.size());
        }
    }
}

