/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.Cheese;
import org.drools.CheeseEqual;
import org.drools.ClassObjectFilter;
import org.drools.FactHandle;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.Sensor;
import org.drools.StatefulSession;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.TruthMaintenanceSystem;
import org.drools.compiler.PackageBuilder;
import org.drools.core.util.ObjectHashMap;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.rule.Rule;
import org.drools.event.rule.ObjectInsertedEvent;
import org.drools.event.rule.ObjectRetractedEvent;
import org.drools.event.rule.WorkingMemoryEventListener;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.integrationtests.IteratorToList;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.rule.Package;
import org.drools.runtime.ObjectFilter;
import org.drools.runtime.StatefulKnowledgeSession;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;

public class TruthMaintenanceTest {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    protected KnowledgeBase getKnowledgeBase() throws Exception {
        return KnowledgeBaseFactory.newKnowledgeBase();
    }

    protected KnowledgeBase getKnowledgeBase(KnowledgeBaseConfiguration config) throws Exception {
        return KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)config);
    }

    @Test
    public void testLogicalInsertionsDynamicRule() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsDynamicRule.drl", this.getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        Collection kpkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = this.getKnowledgeBase();
        kbase.addKnowledgePackages(kpkgs);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Cheese c1 = new Cheese("a", 1);
        Cheese c2 = new Cheese("b", 2);
        Cheese c3 = new Cheese("c", 3);
        ksession.insert((Object)c1);
        org.drools.runtime.rule.FactHandle h = ksession.insert((Object)c2);
        ksession.insert((Object)c3);
        ksession.fireAllRules();
        ArrayList list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertFalse((boolean)list.contains(new Person(c1.getType())));
        Assert.assertTrue((boolean)list.contains(new Person(c2.getType())));
        Assert.assertTrue((boolean)list.contains(new Person(c3.getType())));
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsDynamicRule2.drl", this.getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        Collection kpkgs2 = kbuilder.getKnowledgePackages();
        kbase.addKnowledgePackages(kpkgs2);
        kbase = SerializationHelper.serializeObject(kbase);
        ksession.fireAllRules();
        kbase = ksession.getKnowledgeBase();
        list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(new Person(c1.getType())));
        Assert.assertTrue((boolean)list.contains(new Person(c2.getType())));
        Assert.assertTrue((boolean)list.contains(new Person(c3.getType())));
        KnowledgePackage[] pkgs = kbase.getKnowledgePackages().toArray(new KnowledgePackage[0]);
        Assert.assertEquals((Object)"org.drools.test", (Object)pkgs[0].getName());
        Assert.assertEquals((Object)"org.drools.test2", (Object)pkgs[1].getName());
        Assert.assertEquals((Object)"rule1", (Object)((Rule)pkgs[0].getRules().iterator().next()).getName());
        Assert.assertEquals((Object)"rule2", (Object)((Rule)pkgs[1].getRules().iterator().next()).getName());
        kbase.removeRule(pkgs[0].getName(), ((Rule)pkgs[0].getRules().iterator().next()).getName());
        pkgs = kbase.getKnowledgePackages().toArray(new KnowledgePackage[0]);
        Assert.assertEquals((long)0L, (long)pkgs[0].getRules().size());
        Assert.assertEquals((long)1L, (long)pkgs[1].getRules().size());
        Assert.assertEquals((Object)"org.drools.test2", (Object)pkgs[1].getName());
        Assert.assertEquals((Object)"rule2", (Object)((Rule)pkgs[1].getRules().iterator().next()).getName());
        list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
        Assert.assertEquals((String)"removal of the rule should result in retraction of c3's logical assertion", (long)2L, (long)list.size());
        Assert.assertTrue((String)"c1's logical assertion should not be retracted", (boolean)list.contains(new Person(c1.getType())));
        Assert.assertTrue((String)"c2's logical assertion should  not be retracted", (boolean)list.contains(new Person(c2.getType())));
        Assert.assertFalse((String)"c3's logical assertion should be  retracted", (boolean)list.contains(new Person(c3.getType())));
        c2.setPrice(3);
        ksession.update(h, (Object)c2);
        list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
        Assert.assertEquals((String)"c2 now has a higher price, its logical assertion should  be cancelled", (long)1L, (long)list.size());
        Assert.assertFalse((String)"The logical assertion cor c2 should have been retracted", (boolean)list.contains(new Person(c2.getType())));
        Assert.assertTrue((String)"The logical assertion  for c1 should exist", (boolean)list.contains(new Person(c1.getType())));
        pkgs = kbase.getKnowledgePackages().toArray(new KnowledgePackage[0]);
        kbase.removeRule(pkgs[1].getName(), ((Rule)pkgs[1].getRules().iterator().next()).getName());
        kbase = SerializationHelper.serializeObject(kbase);
        pkgs = kbase.getKnowledgePackages().toArray(new KnowledgePackage[0]);
        Assert.assertEquals((long)0L, (long)pkgs[0].getRules().size());
        Assert.assertEquals((long)0L, (long)pkgs[1].getRules().size());
        list = new ArrayList(ksession.getObjects((ObjectFilter)new ClassObjectFilter(Person.class)));
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testLogicalInsertions() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertions.drl", this.getClass()), ResourceType.DRL);
        Collection kpkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        org.drools.runtime.rule.FactHandle brieHandle = session.insert((Object)brie);
        Cheese provolone = new Cheese("provolone", 12);
        org.drools.runtime.rule.FactHandle provoloneHandle = session.insert((Object)provolone);
        session.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)3L, (long)session.getObjects().size());
        session.retract(brieHandle);
        Assert.assertEquals((long)2L, (long)session.getObjects().size());
        session.retract(provoloneHandle);
        Assert.assertEquals((long)0L, (long)session.getObjects().size());
    }

    @Test
    public void testLogicalInsertionsBacking() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsBacking.drl", this.getClass()), ResourceType.DRL);
        Collection kpkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        Cheese cheese1 = new Cheese("c", 1);
        Cheese cheese2 = new Cheese(cheese1.getType(), 1);
        org.drools.runtime.rule.FactHandle h1 = session.insert((Object)cheese1);
        session.fireAllRules();
        Collection list = session.getObjects((ObjectFilter)new ClassObjectFilter(cheese1.getType().getClass()));
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)cheese1.getType(), list.iterator().next());
        org.drools.runtime.rule.FactHandle h2 = session.insert((Object)cheese2);
        session.fireAllRules();
        list = session.getObjects((ObjectFilter)new ClassObjectFilter(cheese1.getType().getClass()));
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)cheese1.getType(), list.iterator().next());
        Assert.assertEquals((long)3L, (long)session.getObjects().size());
        session.retract(h1);
        session.fireAllRules();
        list = session.getObjects((ObjectFilter)new ClassObjectFilter(cheese1.getType().getClass()));
        Assert.assertEquals((String)("cheese-type " + cheese1.getType() + " was retracted, but should not. Backed by cheese2 => type."), (long)1L, (long)list.size());
        Assert.assertEquals((String)("cheese-type " + cheese1.getType() + " was retracted, but should not. Backed by cheese2 => type."), (Object)cheese1.getType(), list.iterator().next());
        session.retract(h2);
        session.fireAllRules();
        list = session.getObjects((ObjectFilter)new ClassObjectFilter(cheese1.getType().getClass()));
        Assert.assertEquals((String)("cheese-type " + cheese1.getType() + " was not retracted, but should have. Neither  cheese1 => type nor cheese2 => type is true."), (long)0L, (long)list.size());
    }

    @Test
    public void testLogicalInsertionsSelfreferencing() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsSelfreferencing.drl", this.getClass()), ResourceType.DRL);
        Collection kpkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        Person b = new Person("b");
        Person a = new Person("a");
        session.setGlobal("b", (Object)b);
        org.drools.runtime.rule.FactHandle h1 = session.insert((Object)a);
        session.fireAllRules();
        Collection list = session.getObjects((ObjectFilter)new ClassObjectFilter(a.getClass()));
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(a));
        Assert.assertTrue((boolean)list.contains(b));
        session.retract(h1);
        session.fireAllRules();
        list = session.getObjects((ObjectFilter)new ClassObjectFilter(a.getClass()));
        Assert.assertEquals((String)"b was retracted, but it should not have. Is backed by b => b being true.", (long)1L, (long)list.size());
        Assert.assertEquals((String)"b was retracted, but it should not have. Is backed by b => b being true.", (Object)b, list.iterator().next());
        h1 = session.getFactHandle((Object)b);
        session.retract(h1);
        session.fireAllRules();
        list = session.getObjects((ObjectFilter)new ClassObjectFilter(a.getClass()));
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testLogicalInsertionsLoop() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsLoop.drl", this.getClass()), ResourceType.DRL);
        Collection kpkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kpkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        ArrayList l = new ArrayList();
        Person a = new Person("a");
        session.setGlobal("a", (Object)a);
        session.setGlobal("l", l);
        session.fireAllRules();
        Collection list = session.getObjects((ObjectFilter)new ClassObjectFilter(a.getClass()));
        Assert.assertEquals((String)"a still asserted.", (long)0L, (long)list.size());
        Assert.assertEquals((String)"Rule has not fired (looped) expected number of times", (long)10L, (long)l.size());
    }

    @Test
    public void testLogicalInsertionsNoLoop() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_LogicalInsertionsNoLoop.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList l = new ArrayList();
        Person a = new Person("a");
        workingMemory.setGlobal("a", (Object)a);
        workingMemory.setGlobal("l", l);
        workingMemory.fireAllRules();
        List list = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(a.getClass())));
        Assert.assertEquals((String)"a still in WM", (long)0L, (long)list.size());
        Assert.assertEquals((String)"Rule should not loop", (long)1L, (long)l.size());
    }

    @Test
    public void testLogicalInsertionsWithModify() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_LogicalInsertionsWithUpdate.drl")));
        if (builder.hasErrors()) {
            Assert.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Person p = new Person("person");
        p.setAge(2);
        FactHandle h = workingMemory.insert((Object)p);
        Assert.assertEquals((long)1L, (long)IteratorToList.convert(workingMemory.iterateObjects()).size());
        workingMemory.fireAllRules();
        Assert.assertEquals((long)2L, (long)IteratorToList.convert(workingMemory.iterateObjects()).size());
        List l = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(CheeseEqual.class)));
        Assert.assertEquals((long)1L, (long)l.size());
        Assert.assertEquals((long)2L, (long)((CheeseEqual)l.get(0)).getPrice());
        workingMemory.retract((org.drools.runtime.rule.FactHandle)h);
        Assert.assertEquals((long)0L, (long)IteratorToList.convert(workingMemory.iterateObjects()).size());
        TruthMaintenanceSystem tms = ((InternalWorkingMemory)workingMemory).getTruthMaintenanceSystem();
        Field field = tms.getClass().getDeclaredField("assertMap");
        field.setAccessible(true);
        ObjectHashMap m = (ObjectHashMap)field.get(tms);
        field.setAccessible(false);
        Assert.assertEquals((String)"assertMap should be empty", (long)0L, (long)m.size());
    }

    @Test
    public void testLogicalInsertions2() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_LogicalInsertions2.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList events = new ArrayList();
        workingMemory.setGlobal("events", events);
        Sensor sensor = new Sensor(80, 80);
        FactHandle handle = workingMemory.insert((Object)sensor);
        workingMemory.fireAllRules();
        List list = IteratorToList.convert(workingMemory.iterateObjects());
        Assert.assertEquals((String)"Only sensor is there", (long)1L, (long)list.size());
        Assert.assertEquals((String)"Only one event", (long)1L, (long)events.size());
        sensor.setPressure(200);
        sensor.setTemperature(200);
        workingMemory.update((org.drools.runtime.rule.FactHandle)handle, (Object)sensor);
        workingMemory.fireAllRules();
        Assert.assertEquals((String)"Only sensor is there", (long)1L, (long)list.size());
        Assert.assertEquals((String)"Exactly seven events", (long)7L, (long)events.size());
    }

    @Test
    public void testLogicalInsertionsNot() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_LogicalInsertionsNot.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Person a = new Person("a");
        Cheese cheese = new Cheese("brie", 1);
        workingMemory.setGlobal("cheese", (Object)cheese);
        workingMemory.fireAllRules();
        List list = IteratorToList.convert(workingMemory.iterateObjects());
        Assert.assertEquals((String)"i was not asserted by not a => i.", (long)1L, (long)list.size());
        Assert.assertEquals((String)"i was not asserted by not a => i.", (Object)cheese, list.get(0));
        FactHandle h = workingMemory.insert((Object)a);
        list = IteratorToList.convert(workingMemory.iterateObjects());
        Assert.assertEquals((String)"a was not asserted or i not retracted.", (long)1L, (long)list.size());
        Assert.assertEquals((String)"a was asserted.", (Object)a, list.get(0));
        Assert.assertFalse((String)"i was not rectracted.", (boolean)list.contains(cheese));
        Assert.assertEquals((String)"agenda should be empty.", (long)0L, (long)workingMemory.getAgenda().agendaSize());
        workingMemory.retract((org.drools.runtime.rule.FactHandle)h);
        workingMemory.fireAllRules();
        list = IteratorToList.convert(workingMemory.iterateObjects());
        Assert.assertEquals((String)"i was not asserted by not a => i.", (long)1L, (long)list.size());
        Assert.assertEquals((String)"i was not asserted by not a => i.", (Object)cheese, list.get(0));
    }

    @Test
    public void testLogicalInsertionsNotPingPong() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_LogicalInsertionsNotPingPong.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        Person person = new Person("person");
        Cheese cheese = new Cheese("cheese", 0);
        workingMemory.setGlobal("cheese", (Object)cheese);
        workingMemory.setGlobal("person", (Object)person);
        workingMemory.setGlobal("list", list);
        workingMemory.fireAllRules();
        Assert.assertEquals((String)"Rules have not fired (looped) expected number of times", (long)10L, (long)list.size());
    }

    @Test
    public void testLogicalInsertionsUpdateEqual() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_LogicalInsertionsUpdateEqual.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Person p = new Person("person");
        p.setAge(2);
        FactHandle h = workingMemory.insert((Object)p);
        Assert.assertEquals((long)1L, (long)IteratorToList.convert(workingMemory.iterateObjects()).size());
        workingMemory.fireAllRules();
        Assert.assertEquals((long)2L, (long)IteratorToList.convert(workingMemory.iterateObjects()).size());
        List l = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(CheeseEqual.class)));
        Assert.assertEquals((long)1L, (long)l.size());
        Assert.assertEquals((long)3L, (long)((CheeseEqual)l.get(0)).getPrice());
        workingMemory.retract((org.drools.runtime.rule.FactHandle)h);
        Assert.assertEquals((long)0L, (long)IteratorToList.convert(workingMemory.iterateObjects()).size());
        TruthMaintenanceSystem tms = ((InternalWorkingMemory)workingMemory).getTruthMaintenanceSystem();
        Field field = tms.getClass().getDeclaredField("assertMap");
        field.setAccessible(true);
        ObjectHashMap m = (ObjectHashMap)field.get(tms);
        field.setAccessible(false);
        Assert.assertEquals((String)"assertMap should be empty", (long)0L, (long)m.size());
    }

    @Test
    public void testLogicalInsertionsWithExists() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_LogicalInsertionWithExists.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Person p1 = new Person("p1", "stilton", 20);
        p1.setStatus("europe");
        FactHandle c1FactHandle = workingMemory.insert((Object)p1);
        Person p2 = new Person("p2", "stilton", 30);
        p2.setStatus("europe");
        FactHandle c2FactHandle = workingMemory.insert((Object)p2);
        Person p3 = new Person("p3", "stilton", 40);
        p3.setStatus("europe");
        FactHandle c3FactHandle = workingMemory.insert((Object)p3);
        workingMemory.fireAllRules();
        List cheeseList = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(Cheese.class)));
        Assert.assertEquals((long)2L, (long)cheeseList.size());
        p3.setStatus("america");
        workingMemory.update((org.drools.runtime.rule.FactHandle)c3FactHandle, (Object)p3);
        workingMemory.fireAllRules();
        cheeseList = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(Cheese.class)));
        Assert.assertEquals((long)1L, (long)cheeseList.size());
        p2.setStatus("america");
        workingMemory.update((org.drools.runtime.rule.FactHandle)c2FactHandle, (Object)p2);
        workingMemory.fireAllRules();
        cheeseList = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(Cheese.class)));
        Assert.assertEquals((long)1L, (long)cheeseList.size());
        p1.setStatus("america");
        workingMemory.update((org.drools.runtime.rule.FactHandle)c1FactHandle, (Object)p1);
        workingMemory.fireAllRules();
        cheeseList = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(Cheese.class)));
        Assert.assertEquals((long)2L, (long)cheeseList.size());
        p2.setStatus("europe");
        workingMemory.update((org.drools.runtime.rule.FactHandle)c2FactHandle, (Object)p2);
        workingMemory.fireAllRules();
        cheeseList = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(Cheese.class)));
        Assert.assertEquals((long)1L, (long)cheeseList.size());
        p1.setStatus("europe");
        workingMemory.update((org.drools.runtime.rule.FactHandle)c1FactHandle, (Object)p1);
        workingMemory.fireAllRules();
        cheeseList = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(Cheese.class)));
        Assert.assertEquals((long)1L, (long)cheeseList.size());
        p3.setStatus("europe");
        workingMemory.update((org.drools.runtime.rule.FactHandle)c3FactHandle, (Object)p3);
        workingMemory.fireAllRules();
        cheeseList = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(Cheese.class)));
        Assert.assertEquals((long)2L, (long)cheeseList.size());
    }

    @Test
    public void testLogicalInsertions3() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_logicalInsertions3.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("events", list);
        Sensor sensor = new Sensor(150, 100);
        FactHandle sensorHandle = workingMemory.insert((Object)sensor);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)IteratorToList.convert(workingMemory.iterateObjects()).size());
        sensor.setTemperature(125);
        workingMemory.update((org.drools.runtime.rule.FactHandle)sensorHandle, (Object)sensor);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)2L, (long)IteratorToList.convert(workingMemory.iterateObjects()).size());
        sensor.setTemperature(80);
        workingMemory.update((org.drools.runtime.rule.FactHandle)sensorHandle, (Object)sensor);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)1L, (long)IteratorToList.convert(workingMemory.iterateObjects()).size());
    }

    @Test
    public void testLogicalInsertionsAccumulatorPattern() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_LogicalInsertionsAccumulatorPattern.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.setGlobal("ga", (Object)"a");
        workingMemory.setGlobal("gb", (Object)"b");
        workingMemory.setGlobal("gs", (Object)new Short(3));
        workingMemory.fireAllRules();
        FactHandle h = workingMemory.insert((Object)new Integer(6));
        Assert.assertEquals((long)1L, (long)IteratorToList.convert(workingMemory.iterateObjects()).size());
        workingMemory.fireAllRules();
        List l = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(CheeseEqual.class)));
        Assert.assertEquals((String)"There should be 2 CheeseEqual in Working Memory, 1 justified, 1 stated", (long)2L, (long)l.size());
        Assert.assertEquals((long)6L, (long)IteratorToList.convert(workingMemory.iterateObjects()).size());
        workingMemory.retract((org.drools.runtime.rule.FactHandle)h);
        l = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(CheeseEqual.class)));
        Assert.assertEquals((String)"There should be only 1 CheeseEqual in Working Memory, 1 stated (the justified should have been retracted). Check TruthMaintenanceSystem justifiedMap", (long)1L, (long)l.size());
        l = IteratorToList.convert(workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(Short.class)));
        Assert.assertEquals((long)1L, (long)l.size());
        Assert.assertEquals((long)2L, (long)IteratorToList.convert(workingMemory.iterateObjects()).size());
        workingMemory.fireAllRules();
        Assert.assertEquals((long)0L, (long)IteratorToList.convert(workingMemory.iterateObjects()).size());
    }

    @Test
    public void testLogicalInsertionsModifySameRuleGivesDifferentLogicalInsertion() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertionsModifySameRuleGivesDifferentLogicalInsertion.drl", this.getClass()), ResourceType.DRL);
        Collection pkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = this.getKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        Sensor sensor1 = new Sensor(100, 0);
        org.drools.runtime.rule.FactHandle sensor1Handle = session.insert((Object)sensor1);
        Sensor sensor2 = new Sensor(200, 0);
        org.drools.runtime.rule.FactHandle sensor2Handle = session.insert((Object)sensor2);
        Sensor sensor3 = new Sensor(200, 0);
        org.drools.runtime.rule.FactHandle sensor3Handle = session.insert((Object)sensor3);
        session.fireAllRules();
        ArrayList temperatureList = new ArrayList(session.getObjects((ObjectFilter)new ClassObjectFilter(Integer.class)));
        Assert.assertTrue((boolean)temperatureList.contains(100));
        Assert.assertTrue((boolean)temperatureList.contains(200));
        Assert.assertEquals((long)2L, (long)temperatureList.size());
        sensor1.setTemperature(150);
        ((StatefulKnowledgeSessionImpl)session).session.update((org.drools.runtime.rule.FactHandle)((FactHandle)sensor1Handle), (Object)sensor1);
        session.fireAllRules();
        temperatureList = new ArrayList(session.getObjects((ObjectFilter)new ClassObjectFilter(Integer.class)));
        Assert.assertFalse((boolean)temperatureList.contains(100));
        Assert.assertTrue((boolean)temperatureList.contains(150));
        Assert.assertTrue((boolean)temperatureList.contains(200));
        Assert.assertEquals((long)2L, (long)temperatureList.size());
    }

    @Test
    @Ignore
    public void testLogicalInsertOrder() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_LogicalInsertOrder.drl", this.getClass()), ResourceType.DRL);
        KnowledgeBase kbase = this.getKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        kbase = SerializationHelper.serializeObject(kbase);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        WorkingMemoryEventListener wmel = (WorkingMemoryEventListener)Mockito.mock(WorkingMemoryEventListener.class);
        session.addEventListener(wmel);
        Person bob = new Person("bob");
        bob.setStatus("hungry");
        Person mark = new Person("mark");
        mark.setStatus("thirsty");
        session.insert((Object)bob);
        session.insert((Object)mark);
        int count = session.fireAllRules();
        Assert.assertEquals((long)2L, (long)count);
        ArgumentCaptor insertsCaptor = ArgumentCaptor.forClass(ObjectInsertedEvent.class);
        ((WorkingMemoryEventListener)Mockito.verify((Object)wmel, (VerificationMode)Mockito.times((int)4))).objectInserted((ObjectInsertedEvent)insertsCaptor.capture());
        List inserts = insertsCaptor.getAllValues();
        Assert.assertThat((Object)((ObjectInsertedEvent)inserts.get(2)).getObject(), (Matcher)CoreMatchers.is((Object)"rule 1"));
        Assert.assertThat((Object)((ObjectInsertedEvent)inserts.get(3)).getObject(), (Matcher)CoreMatchers.is((Object)"rule 2"));
        ArgumentCaptor retractsCaptor = ArgumentCaptor.forClass(ObjectRetractedEvent.class);
        ((WorkingMemoryEventListener)Mockito.verify((Object)wmel, (VerificationMode)Mockito.times((int)2))).objectRetracted((ObjectRetractedEvent)retractsCaptor.capture());
        List retracts = retractsCaptor.getAllValues();
        Assert.assertThat((Object)((ObjectRetractedEvent)retracts.get(0)).getOldObject(), (Matcher)CoreMatchers.is((Object)"rule 1"));
        Assert.assertThat((Object)((ObjectRetractedEvent)retracts.get(1)).getOldObject(), (Matcher)CoreMatchers.is((Object)"rule 2"));
    }
}

