/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import org.drools.base.evaluators.MatchesEvaluatorsDefinition;
import org.drools.base.evaluators.SetEvaluatorsDefinition;
import org.drools.compiler.DrlExprParser;
import org.drools.lang.MVELDumper;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.ConstraintConnectiveDescr;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class MVELDumperTest {
    private MVELDumper dumper;

    @Before
    public void setUp() throws Exception {
        new SetEvaluatorsDefinition();
        new MatchesEvaluatorsDefinition();
        this.dumper = new MVELDumper();
    }

    @Test
    public void testDump() throws Exception {
        String input = "price > 10 && < 20 || == $val || == 30";
        String expected = "( price > 10 && price < 20 || price == $val || price == 30 )";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testDumpMatches() throws Exception {
        String input = "type.toString matches \"something\\swith\\tsingle escapes\"";
        String expected = "type.toString ~= \"something\\swith\\tsingle escapes\"";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testDumpMatches2() throws Exception {
        String input = "type.toString matches 'something\\swith\\tsingle escapes'";
        String expected = "type.toString ~= \"something\\swith\\tsingle escapes\"";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testDumpMatches3() throws Exception {
        String input = "this[\"content\"] matches \"hello ;=\"";
        String expected = "this[\"content\"] ~= \"hello ;=\"";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    @Ignore
    public void testDumpWithDateAttr() throws Exception {
        String input = "son.birthDate == \"01-jan-2000\"";
        String expected = "son.birthDate == org.drools.util.DateUtils.parseDate( \"01-jan-2000\" )";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testDumpComplex() throws Exception {
        String input = "a ( > 60 && < 70 ) || ( > 50 && < 55 ) && a3 == \"black\" || a == 40 && a3 == \"pink\" || a == 12 && a3 == \"yellow\" || a3 == \"blue\"";
        String expected = "( ( a > 60 && a < 70 || a > 50 && a < 55 ) && a3 == \"black\" || a == 40 && a3 == \"pink\" || a == 12 && a3 == \"yellow\" || a3 == \"blue\" )";
        ConstraintConnectiveDescr descr = this.parse(input);
        String result = this.dumper.dump((BaseDescr)descr);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    public ConstraintConnectiveDescr parse(String constraint) {
        DrlExprParser parser = new DrlExprParser();
        ConstraintConnectiveDescr result = parser.parse(constraint);
        Assert.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
        return result;
    }
}

