/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.drools.base.evaluators.EvaluatorRegistry;
import org.drools.compiler.DrlParser;
import org.drools.lang.DRLLexer;
import org.drools.lang.DRLParser;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AnnotationDescr;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.BehaviorDescr;
import org.drools.lang.descr.BindingDescr;
import org.drools.lang.descr.CollectDescr;
import org.drools.lang.descr.EntryPointDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.ExprConstraintDescr;
import org.drools.lang.descr.ForallDescr;
import org.drools.lang.descr.FromDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.FunctionImportDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.MVELExprDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.QueryDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.lang.descr.TypeFieldDescr;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RuleParserTest
extends TestCase {
    private DRLParser parser;

    @Before
    protected void setUp() throws Exception {
        super.setUp();
        new EvaluatorRegistry();
    }

    @After
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testPackage_OneSegment() throws Exception {
        String packageName = (String)this.parse("packageStatement", "package foo");
        RuleParserTest.assertEquals((String)"foo", (String)packageName);
    }

    @Test
    public void testPackage_MultipleSegments() throws Exception {
        String packageName = (String)this.parse("packageStatement", "package foo.bar.baz;");
        RuleParserTest.assertEquals((String)"foo.bar.baz", (String)packageName);
    }

    @Test
    public void testPackage() throws Exception {
        String source = "package foo.bar.baz";
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse((Reader)new StringReader("package foo.bar.baz"));
        RuleParserTest.assertFalse((boolean)parser.hasErrors());
        RuleParserTest.assertEquals((String)"foo.bar.baz", (String)pkg.getName());
    }

    @Test
    public void testPackageWithError() throws Exception {
        String source = "package 12 foo.bar.baz";
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(true, (Reader)new StringReader("package 12 foo.bar.baz"));
        RuleParserTest.assertTrue((boolean)parser.hasErrors());
        RuleParserTest.assertEquals((String)"foo.bar.baz", (String)pkg.getName());
    }

    @Test
    public void testPackageWithError2() throws Exception {
        String source = "package 12 12312 231";
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(true, (Reader)new StringReader("package 12 12312 231"));
        RuleParserTest.assertTrue((boolean)parser.hasErrors());
        RuleParserTest.assertEquals((String)"", (String)pkg.getName());
    }

    @Test
    public void testCompilationUnit() throws Exception {
        String source = "package foo; import com.foo.Bar; import com.foo.Baz;";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "package foo; import com.foo.Bar; import com.foo.Baz;");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertEquals((String)"foo", (String)pkg.getName());
        RuleParserTest.assertEquals((int)2, (int)pkg.getImports().size());
        ImportDescr impdescr = (ImportDescr)pkg.getImports().get(0);
        RuleParserTest.assertEquals((String)"com.foo.Bar", (String)impdescr.getTarget());
        RuleParserTest.assertEquals((int)"package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()), (int)impdescr.getStartCharacter());
        RuleParserTest.assertEquals((int)("package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length() + 1), (int)impdescr.getEndCharacter());
        impdescr = (ImportDescr)pkg.getImports().get(1);
        RuleParserTest.assertEquals((String)"com.foo.Baz", (String)impdescr.getTarget());
        RuleParserTest.assertEquals((int)"package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()), (int)impdescr.getStartCharacter());
        RuleParserTest.assertEquals((int)("package foo; import com.foo.Bar; import com.foo.Baz;".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length() + 1), (int)impdescr.getEndCharacter());
    }

    @Test
    public void testFunctionImport() throws Exception {
        String source = "package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertEquals((String)"foo", (String)pkg.getName());
        RuleParserTest.assertEquals((int)2, (int)pkg.getImports().size());
        ImportDescr impdescr = (ImportDescr)pkg.getImports().get(0);
        RuleParserTest.assertEquals((String)"foo.bar.*", (String)impdescr.getTarget());
        RuleParserTest.assertEquals((int)"package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import " + impdescr.getTarget()), (int)impdescr.getStartCharacter());
        RuleParserTest.assertEquals((int)("package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length()), (int)impdescr.getEndCharacter());
        impdescr = (ImportDescr)pkg.getImports().get(1);
        RuleParserTest.assertEquals((String)"baz.Baz", (String)impdescr.getTarget());
        RuleParserTest.assertEquals((int)"package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import " + impdescr.getTarget()), (int)impdescr.getStartCharacter());
        RuleParserTest.assertEquals((int)("package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length()), (int)impdescr.getEndCharacter());
        RuleParserTest.assertEquals((int)2, (int)pkg.getFunctionImports().size());
        impdescr = (ImportDescr)pkg.getFunctionImports().get(0);
        RuleParserTest.assertEquals((String)"java.lang.Math.max", (String)impdescr.getTarget());
        RuleParserTest.assertEquals((int)"package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import function " + impdescr.getTarget()), (int)impdescr.getStartCharacter());
        RuleParserTest.assertEquals((int)("package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import function " + impdescr.getTarget()) + ("import function " + impdescr.getTarget()).length()), (int)impdescr.getEndCharacter());
        impdescr = (ImportDescr)pkg.getFunctionImports().get(1);
        RuleParserTest.assertEquals((String)"java.lang.Math.min", (String)impdescr.getTarget());
        RuleParserTest.assertEquals((int)"package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import function " + impdescr.getTarget()), (int)impdescr.getStartCharacter());
        RuleParserTest.assertEquals((int)("package foo\nimport function java.lang.Math.max\nimport function java.lang.Math.min;\nimport foo.bar.*\nimport baz.Baz".indexOf("import function " + impdescr.getTarget()) + ("import function " + impdescr.getTarget()).length() + 1), (int)impdescr.getEndCharacter());
    }

    @Test
    public void testGlobal1() throws Exception {
        String source = "package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertEquals((String)"foo.bar.baz", (String)pkg.getName());
        RuleParserTest.assertEquals((int)1, (int)pkg.getImports().size());
        ImportDescr impdescr = (ImportDescr)pkg.getImports().get(0);
        RuleParserTest.assertEquals((String)"com.foo.Bar", (String)impdescr.getTarget());
        RuleParserTest.assertEquals((int)"package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber".indexOf("import " + impdescr.getTarget()), (int)impdescr.getStartCharacter());
        RuleParserTest.assertEquals((int)("package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber".indexOf("import " + impdescr.getTarget()) + ("import " + impdescr.getTarget()).length()), (int)impdescr.getEndCharacter());
        RuleParserTest.assertEquals((int)2, (int)pkg.getGlobals().size());
        GlobalDescr global = (GlobalDescr)pkg.getGlobals().get(0);
        RuleParserTest.assertEquals((String)"java.util.List<java.util.Map<String,Integer>>", (String)global.getType());
        RuleParserTest.assertEquals((String)"aList", (String)global.getIdentifier());
        RuleParserTest.assertEquals((int)"package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber".indexOf("global " + global.getType()), (int)global.getStartCharacter());
        RuleParserTest.assertEquals((int)("package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber".indexOf("global " + global.getType() + " " + global.getIdentifier()) + ("global " + global.getType() + " " + global.getIdentifier()).length() + 1), (int)global.getEndCharacter());
        global = (GlobalDescr)pkg.getGlobals().get(1);
        RuleParserTest.assertEquals((String)"Integer", (String)global.getType());
        RuleParserTest.assertEquals((String)"aNumber", (String)global.getIdentifier());
        RuleParserTest.assertEquals((int)"package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber".indexOf("global " + global.getType()), (int)global.getStartCharacter());
        RuleParserTest.assertEquals((int)("package foo.bar.baz\nimport com.foo.Bar\nglobal java.util.List<java.util.Map<String,Integer>> aList;\nglobal Integer aNumber".indexOf("global " + global.getType() + " " + global.getIdentifier()) + ("global " + global.getType() + " " + global.getIdentifier()).length()), (int)global.getEndCharacter());
    }

    @Test
    public void testGlobal() throws Exception {
        PackageDescr pack = (PackageDescr)this.parseResource("compilationUnit", "globals.drl");
        RuleParserTest.assertEquals((int)1, (int)pack.getRules().size());
        RuleDescr rule = (RuleDescr)pack.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        RuleParserTest.assertEquals((int)1, (int)pack.getImports().size());
        RuleParserTest.assertEquals((int)2, (int)pack.getGlobals().size());
        GlobalDescr foo = (GlobalDescr)pack.getGlobals().get(0);
        RuleParserTest.assertEquals((String)"java.lang.String", (String)foo.getType());
        RuleParserTest.assertEquals((String)"foo", (String)foo.getIdentifier());
        GlobalDescr bar = (GlobalDescr)pack.getGlobals().get(1);
        RuleParserTest.assertEquals((String)"java.lang.Integer", (String)bar.getType());
        RuleParserTest.assertEquals((String)"bar", (String)bar.getIdentifier());
    }

    @Test
    public void testFunctionImport2() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "test_FunctionImport.drl");
        RuleParserTest.assertEquals((int)2, (int)pkg.getFunctionImports().size());
        RuleParserTest.assertEquals((String)"abd.def.x", (String)((FunctionImportDescr)pkg.getFunctionImports().get(0)).getTarget());
        RuleParserTest.assertFalse((((FunctionImportDescr)pkg.getFunctionImports().get(0)).getStartCharacter() == -1 ? 1 : 0) != 0);
        RuleParserTest.assertFalse((((FunctionImportDescr)pkg.getFunctionImports().get(0)).getEndCharacter() == -1 ? 1 : 0) != 0);
        RuleParserTest.assertEquals((String)"qed.wah.*", (String)((FunctionImportDescr)pkg.getFunctionImports().get(1)).getTarget());
        RuleParserTest.assertFalse((((FunctionImportDescr)pkg.getFunctionImports().get(1)).getStartCharacter() == -1 ? 1 : 0) != 0);
        RuleParserTest.assertFalse((((FunctionImportDescr)pkg.getFunctionImports().get(1)).getEndCharacter() == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testFromComplexAcessor() throws Exception {
        String source = "rule \"Invalid customer id\" ruleflow-group \"validate\" lock-on-active true \n when \n     o: Order( ) \n     not( Customer( ) from customerService.getCustomer(o.getCustomerId()) ) \n then \n     System.err.println(\"Invalid customer id found!\"); \n     o.addError(\"Invalid customer id\"); \nend \n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        RuleParserTest.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((String)"Invalid customer id", (String)rule.getName());
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        NotDescr not = (NotDescr)rule.getLhs().getDescrs().get(1);
        PatternDescr customer = (PatternDescr)not.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Customer", (String)customer.getObjectType());
        RuleParserTest.assertEquals((String)"customerService.getCustomer(o.getCustomerId())", (String)((FromDescr)customer.getSource()).getDataSource().getText());
    }

    @Test
    public void testFromWithInlineList() throws Exception {
        String source = "rule XYZ \n when \n o: Order( ) \n not( Number( ) from [1, 2, 3] ) \n then \n System.err.println(\"Invalid customer id found!\"); \n o.addError(\"Invalid customer id\"); \nend \n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((String)"XYZ", (String)rule.getName());
        PatternDescr number = (PatternDescr)((NotDescr)rule.getLhs().getDescrs().get(1)).getDescrs().get(0);
        RuleParserTest.assertEquals((String)"[1, 2, 3]", (String)((FromDescr)number.getSource()).getDataSource().toString());
    }

    @Test
    public void testFromWithInlineListMethod() throws Exception {
        String source = "rule XYZ \n when \n o: Order( ) \n Number( ) from [1, 2, 3].sublist(1, 2) \n then \n System.err.println(\"Invalid customer id found!\"); \n o.addError(\"Invalid customer id\"); \nend \n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((String)"XYZ", (String)rule.getName());
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
        PatternDescr number = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"[1, 2, 3].sublist(1, 2)", (String)((FromDescr)number.getSource()).getDataSource().toString());
    }

    @Test
    public void testFromWithInlineListIndex() throws Exception {
        String source = "rule XYZ \n when \n o: Order( ) \n Number( ) from [1, 2, 3][1] \n then \n System.err.println(\"Invalid customer id found!\"); \n o.addError(\"Invalid customer id\"); \nend \n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((String)"XYZ", (String)rule.getName());
        RuleParserTest.assertFalse((boolean)this.parser.hasErrors());
        PatternDescr number = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"[1, 2, 3][1]", (String)((FromDescr)number.getSource()).getDataSource().toString());
    }

    @Test
    public void testRuleWithoutEnd() throws Exception {
        String source = "rule \"Invalid customer id\" \n when \n o: Order( ) \n then \n System.err.println(\"Invalid customer id found!\"); \n";
        this.parse("compilationUnit", source);
        RuleParserTest.assertTrue((boolean)this.parser.hasErrors());
    }

    @Test
    public void testOrWithSpecialBind() throws Exception {
        String source = "rule \"A and (B or C or D)\" \n    when \n        pdo1 : ParametricDataObject( paramID == 101, stringValue == \"1000\" ) and \n        pdo2 :(ParametricDataObject( paramID == 101, stringValue == \"1001\" ) or \n               ParametricDataObject( paramID == 101, stringValue == \"1002\" ) or \n               ParametricDataObject( paramID == 101, stringValue == \"1003\" )) \n    then \n        System.out.println( \"Rule: A and (B or C or D) Fired. pdo1: \" + pdo1 +  \" pdo2: \"+ pdo2); \nend\n";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertEquals((int)2, (int)lhs.getDescrs().size());
        PatternDescr pdo1 = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"pdo1", (String)pdo1.getIdentifier());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((int)3, (int)or.getDescrs().size());
        for (BaseDescr pdo2 : or.getDescrs()) {
            RuleParserTest.assertEquals((String)"pdo2", (String)((PatternDescr)pdo2).getIdentifier());
        }
    }

    @Test
    public void testCompatibleRestriction() throws Exception {
        String source = "package com.sample  rule test  when  Test( ( text == null || text2 matches \"\" ) )  then  end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        RuleParserTest.assertEquals((String)"com.sample", (String)pkg.getName());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((String)"test", (String)rule.getName());
        ExprConstraintDescr expr = (ExprConstraintDescr)((PatternDescr)rule.getLhs().getDescrs().get(0)).getDescrs().get(0);
        RuleParserTest.assertEquals((String)"( text == null || text2 matches \"\" )", (String)expr.getText());
    }

    @Test
    public void testSimpleConstraint() throws Exception {
        String source = "package com.sample  rule test  when  Cheese( type == 'stilton', price > 10 )  then  end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", source);
        RuleParserTest.assertEquals((String)"com.sample", (String)pkg.getName());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((String)"test", (String)rule.getName());
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AndDescr constraint = (AndDescr)pattern.getConstraint();
        RuleParserTest.assertEquals((int)2, (int)constraint.getDescrs().size());
        RuleParserTest.assertEquals((String)"type == \"stilton\"", (String)((BaseDescr)constraint.getDescrs().get(0)).toString());
        RuleParserTest.assertEquals((String)"price > 10", (String)((BaseDescr)constraint.getDescrs().get(1)).toString());
    }

    @Test
    public void testDialect() throws Exception {
        String source = "dialect 'mvel'";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "dialect 'mvel'");
        AttributeDescr attr = (AttributeDescr)pkg.getAttributes().get(0);
        RuleParserTest.assertEquals((String)"dialect", (String)attr.getName());
        RuleParserTest.assertEquals((String)"mvel", (String)attr.getValue());
    }

    @Test
    public void testDialect2() throws Exception {
        String source = "dialect \"mvel\"";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "dialect \"mvel\"");
        AttributeDescr attr = (AttributeDescr)pkg.getAttributes().get(0);
        RuleParserTest.assertEquals((String)"dialect", (String)attr.getName());
        RuleParserTest.assertEquals((String)"mvel", (String)attr.getValue());
    }

    @Test
    public void testEmptyRule() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "empty_rule.drl");
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"empty", (String)rule.getName());
        RuleParserTest.assertNotNull((Object)rule.getLhs());
        RuleParserTest.assertNotNull((Object)rule.getConsequence());
    }

    @Test
    public void testKeywordCollisions() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "eol_funny_business.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
    }

    @Test
    public void testTernaryExpression() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "ternary_expression.drl");
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        this.assertEqualsIgnoreWhitespace("if (speed > speedLimit ? true : false;) pullEmOver();", (String)rule.getConsequence());
    }

    @Test
    public void testFunctionWithArrays() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "function_arrays.drl");
        RuleParserTest.assertEquals((String)"foo", (String)pkg.getName());
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        this.assertEqualsIgnoreWhitespace("yourFunction(new String[3] {\"a\",\"b\",\"c\"});", (String)rule.getConsequence());
        FunctionDescr func = (FunctionDescr)pkg.getFunctions().get(0);
        RuleParserTest.assertEquals((String)"String[]", (String)func.getReturnType());
        RuleParserTest.assertEquals((String)"args[]", (String)((String)func.getParameterNames().get(0)));
        RuleParserTest.assertEquals((String)"String", (String)((String)func.getParameterTypes().get(0)));
    }

    @Test
    public void testAlmostEmptyRule() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "almost_empty_rule.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)pkg);
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((String)"almost_empty", (String)rule.getName());
        RuleParserTest.assertNotNull((Object)rule.getLhs());
        RuleParserTest.assertEquals((String)"", (String)((String)rule.getConsequence()).trim());
    }

    @Test
    public void testQuotedStringNameRule() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "quoted_string_name_rule.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"quoted string name", (String)rule.getName());
        RuleParserTest.assertNotNull((Object)rule.getLhs());
        RuleParserTest.assertEquals((String)"", (String)((String)rule.getConsequence()).trim());
    }

    @Test
    public void testNoLoop() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "no-loop.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"rule1", (String)rule.getName());
        AttributeDescr att = (AttributeDescr)rule.getAttributes().get("no-loop");
        RuleParserTest.assertEquals((String)"false", (String)att.getValue());
        RuleParserTest.assertEquals((String)"no-loop", (String)att.getName());
    }

    @Test
    public void testAutofocus() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "autofocus.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"rule1", (String)rule.getName());
        AttributeDescr att = (AttributeDescr)rule.getAttributes().get("auto-focus");
        RuleParserTest.assertEquals((String)"true", (String)att.getValue());
        RuleParserTest.assertEquals((String)"auto-focus", (String)att.getName());
    }

    @Test
    public void testRuleFlowGroup() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "ruleflowgroup.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"rule1", (String)rule.getName());
        AttributeDescr att = (AttributeDescr)rule.getAttributes().get("ruleflow-group");
        RuleParserTest.assertEquals((String)"a group", (String)att.getValue());
        RuleParserTest.assertEquals((String)"ruleflow-group", (String)att.getName());
    }

    @Test
    public void testConsequenceWithDeclaration() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "declaration-in-consequence.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"myrule", (String)rule.getName());
        String expected = "int i = 0; i = 1; i / 1; i == 1; i(i); i = 'i'; i.i.i; i\\i; i<i; i>i; i=\"i\";  ++i;i++; --i; i--; i += i; i -= i; i *= i; i /= i;int i = 5;for(int j; j<i; ++j) {System.out.println(j);}Object o = new String(\"Hello\");String s = (String) o;";
        this.assertEqualsIgnoreWhitespace("int i = 0; i = 1; i / 1; i == 1; i(i); i = 'i'; i.i.i; i\\i; i<i; i>i; i=\"i\";  ++i;i++; --i; i--; i += i; i -= i; i *= i; i /= i;int i = 5;for(int j; j<i; ++j) {System.out.println(j);}Object o = new String(\"Hello\");String s = (String) o;", (String)rule.getConsequence());
        RuleParserTest.assertTrue((((String)rule.getConsequence()).indexOf("++") > 0 ? 1 : 0) != 0);
        RuleParserTest.assertTrue((((String)rule.getConsequence()).indexOf("--") > 0 ? 1 : 0) != 0);
        RuleParserTest.assertTrue((((String)rule.getConsequence()).indexOf("+=") > 0 ? 1 : 0) != 0);
        RuleParserTest.assertTrue((((String)rule.getConsequence()).indexOf("==") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRuleParseLhs() throws Exception {
        String text = "rule X when Person(age < 42, location==\"atlanta\") \nor\nPerson(name==\"bob\") then end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X when Person(age < 42, location==\"atlanta\") \nor\nPerson(name==\"bob\") then end");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertEquals((int)1, (int)lhs.getDescrs().size());
        RuleParserTest.assertEquals((int)2, (int)((OrDescr)lhs.getDescrs().get(0)).getDescrs().size());
    }

    @Test
    public void testRuleParseLhsWithStringQuotes() throws Exception {
        String text = "rule X when Person( location==\"atlanta\\\"\") then end\n";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X when Person( location==\"atlanta\\\"\") then end\n");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        AndDescr lhs = rule.getLhs();
        ExprConstraintDescr constr = (ExprConstraintDescr)((PatternDescr)lhs.getDescrs().get(0)).getDescrs().get(0);
        RuleParserTest.assertEquals((String)"location==\"atlanta\\\"\"", (String)constr.getText());
    }

    @Test
    public void testRuleParseLhsWithStringQuotes2() throws Exception {
        String text = "rule X when Cheese( $x: type, type == \"s\\tti\\\"lto\\nn\" ) then end\n";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X when Cheese( $x: type, type == \"s\\tti\\\"lto\\nn\" ) then end\n");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        AndDescr lhs = rule.getLhs();
        ExprConstraintDescr constr = (ExprConstraintDescr)((PatternDescr)lhs.getDescrs().get(0)).getDescrs().get(0);
        RuleParserTest.assertEquals((String)"type == \"s\\tti\\\"lto\\nn\"", (String)constr.getText());
    }

    @Test
    public void testLiteralBoolAndNegativeNumbersRule() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "literal_bool_and_negative.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertNotNull((Object)rule.getLhs());
        this.assertEqualsIgnoreWhitespace("cons();", (String)rule.getConsequence());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertEquals((int)3, (int)lhs.getDescrs().size());
        PatternDescr pattern = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        AndDescr fieldAnd = (AndDescr)pattern.getConstraint();
        ExprConstraintDescr fld = (ExprConstraintDescr)fieldAnd.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"bar == false", (String)fld.getExpression());
        pattern = (PatternDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        fieldAnd = (AndDescr)pattern.getConstraint();
        fld = (ExprConstraintDescr)fieldAnd.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"boo > -42", (String)fld.getText());
        pattern = (PatternDescr)lhs.getDescrs().get(2);
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        fieldAnd = (AndDescr)pattern.getConstraint();
        fld = (ExprConstraintDescr)fieldAnd.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"boo > -42.42", (String)fld.getText());
    }

    @Test
    public void testChunkWithoutParens() throws Exception {
        String input = "( foo )";
        this.createParser((CharStream)new ANTLRStringStream(input));
        String returnData = this.parser.chunk(41, 42, -1);
        RuleParserTest.assertEquals((String)"foo", (String)returnData);
    }

    @Test
    public void testChunkWithParens() throws Exception {
        String input = "(fnord())";
        this.createParser((CharStream)new ANTLRStringStream(input));
        String returnData = this.parser.chunk(41, 42, -1);
        RuleParserTest.assertEquals((String)"fnord()", (String)returnData);
    }

    @Test
    public void testChunkWithParensAndQuotedString() throws Exception {
        String input = "( fnord( \"cheese\" ) )";
        this.createParser((CharStream)new ANTLRStringStream(input));
        String returnData = this.parser.chunk(41, 42, -1);
        RuleParserTest.assertEquals((String)"fnord( \"cheese\" )", (String)returnData);
    }

    @Test
    public void testChunkWithRandomCharac5ters() throws Exception {
        String input = "( %*9dkj)";
        this.createParser((CharStream)new ANTLRStringStream(input));
        String returnData = this.parser.chunk(41, 42, -1);
        RuleParserTest.assertEquals((String)"%*9dkj", (String)returnData);
    }

    @Test
    public void testEmptyPattern() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "test_EmptyPattern.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr ruleDescr = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((String)"simple rule", (String)ruleDescr.getName());
        RuleParserTest.assertNotNull((Object)ruleDescr.getLhs());
        RuleParserTest.assertEquals((int)1, (int)ruleDescr.getLhs().getDescrs().size());
        PatternDescr patternDescr = (PatternDescr)ruleDescr.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)0, (int)patternDescr.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((String)"Cheese", (String)patternDescr.getObjectType());
    }

    @Test
    public void testSimpleMethodCallWithFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "test_SimpleMethodCallWithFrom.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        MVELExprDescr method = (MVELExprDescr)from.getDataSource();
        RuleParserTest.assertEquals((String)"something.doIt( foo,bar,42,\"hello\",[ a : \"b\", \"something\" : 42, \"a\" : foo, x : [x:y]],\"end\", [a, \"b\", 42] )", (String)method.getExpression());
    }

    @Test
    public void testSimpleFunctionCallWithFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "test_SimpleFunctionCallWithFrom.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        MVELExprDescr func = (MVELExprDescr)from.getDataSource();
        RuleParserTest.assertEquals((String)"doIt( foo,bar,42,\"hello\",[ a : \"b\", \"something\" : 42, \"a\" : foo, x : [x:y]],\"end\", [a, \"b\", 42] )", (String)func.getExpression());
    }

    @Test
    public void testSimpleAccessorWithFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "test_SimpleAccessorWithFrom.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        MVELExprDescr accessor = (MVELExprDescr)from.getDataSource();
        RuleParserTest.assertEquals((String)"something.doIt", (String)accessor.getExpression());
    }

    @Test
    public void testSimpleAccessorAndArgWithFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "test_SimpleAccessorArgWithFrom.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        MVELExprDescr accessor = (MVELExprDescr)from.getDataSource();
        RuleParserTest.assertEquals((String)"something.doIt[\"key\"]", (String)accessor.getExpression());
    }

    @Test
    public void testComplexChainedAcessor() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "test_ComplexChainedCallWithFrom.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        FromDescr from = (FromDescr)pattern.getSource();
        MVELExprDescr accessor = (MVELExprDescr)from.getDataSource();
        RuleParserTest.assertEquals((String)"doIt1( foo,bar,42,\"hello\",[ a : \"b\"], [a, \"b\", 42] ).doIt2(bar, [a, \"b\", 42]).field[\"key\"]", (String)accessor.getExpression());
    }

    @Test
    public void testFrom() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "from.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrorMessages().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"using_from", (String)rule.getName());
        RuleParserTest.assertEquals((int)9, (int)rule.getLhs().getDescrs().size());
    }

    @Test
    public void testSimpleRule() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "simple_rule.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)7, (int)rule.getConsequenceLine());
        RuleParserTest.assertEquals((int)2, (int)rule.getConsequencePattern());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)3, (int)lhs.getDescrs().size());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"foo3", (String)first.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)first.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)first.getConstraint().getDescrs().size());
        AndDescr fieldAnd = (AndDescr)first.getConstraint();
        ExprConstraintDescr constraint = (ExprConstraintDescr)fieldAnd.getDescrs().get(0);
        RuleParserTest.assertNotNull((Object)constraint);
        RuleParserTest.assertEquals((String)"a==3", (String)constraint.getExpression());
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"foo4", (String)second.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)second.getObjectType());
        fieldAnd = (AndDescr)second.getConstraint();
        RuleParserTest.assertEquals((int)0, (int)fieldAnd.getDescrs().size());
        BindingDescr binding = (BindingDescr)second.getBindings().get(0);
        RuleParserTest.assertEquals((String)"a4", (String)binding.getVariable());
        RuleParserTest.assertEquals((String)"a==4", (String)binding.getExpression());
        PatternDescr third = (PatternDescr)lhs.getDescrs().get(2);
        RuleParserTest.assertNull((Object)third.getIdentifier());
        RuleParserTest.assertEquals((String)"Baz", (String)third.getObjectType());
        this.assertEqualsIgnoreWhitespace("if ( a == b ) {   assert( foo3 );} else {  retract( foo4 );}  System.out.println( a4 );", (String)rule.getConsequence());
    }

    @Test
    public void testRestrictionsMultiple() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "restrictions_test.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        this.assertEqualsIgnoreWhitespace("consequence();", (String)rule.getConsequence());
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        AndDescr and = (AndDescr)pattern.getConstraint();
        ExprConstraintDescr fld = (ExprConstraintDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age > 30 && < 40", (String)fld.getExpression());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Vehicle", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)pattern.getConstraint().getDescrs().size());
        and = (AndDescr)pattern.getConstraint();
        fld = (ExprConstraintDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"type == \"sedan\" || == \"wagon\"", (String)fld.getExpression());
        fld = (ExprConstraintDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"age < 3", (String)fld.getExpression());
    }

    @Test
    public void testLineNumberInAST() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "simple_rule.drl");
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)7, (int)rule.getConsequenceLine());
        RuleParserTest.assertEquals((int)2, (int)rule.getConsequencePattern());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)3, (int)lhs.getDescrs().size());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"foo3", (String)first.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)first.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)first.getConstraint().getDescrs().size());
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"foo4", (String)second.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)second.getObjectType());
        PatternDescr third = (PatternDescr)lhs.getDescrs().get(2);
        RuleParserTest.assertEquals((String)"Baz", (String)third.getObjectType());
        RuleParserTest.assertEquals((int)4, (int)first.getLine());
        RuleParserTest.assertEquals((int)5, (int)second.getLine());
        RuleParserTest.assertEquals((int)6, (int)third.getLine());
    }

    @Test
    public void testLineNumberIncludingCommentsInRHS() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "test_CommentLineNumbersInConsequence.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        String rhs = (String)((RuleDescr)pkg.getRules().get(0)).getConsequence();
        String expected = "\\s*//woot$\\s*first$\\s*$\\s*//$\\s*$\\s*/\\* lala$\\s*$\\s*\\*/$\\s*second$\\s*";
        RuleParserTest.assertTrue((boolean)Pattern.compile(expected, 40).matcher(rhs).matches());
    }

    @Test
    public void testLhsSemicolonDelim() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "lhs_semicolon_delim.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)3, (int)lhs.getDescrs().size());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"foo3", (String)first.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)first.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)first.getConstraint().getDescrs().size());
        AndDescr and = (AndDescr)first.getConstraint();
        ExprConstraintDescr fld = (ExprConstraintDescr)and.getDescrs().get(0);
        RuleParserTest.assertNotNull((Object)fld);
        RuleParserTest.assertEquals((String)"a==3", (String)fld.getExpression());
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"foo4", (String)second.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)second.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)second.getBindings().size());
        BindingDescr fieldBindingDescr = (BindingDescr)second.getBindings().get(0);
        RuleParserTest.assertEquals((String)"a==4", (String)fieldBindingDescr.getExpression());
        RuleParserTest.assertEquals((String)"a4", (String)fieldBindingDescr.getVariable());
        PatternDescr third = (PatternDescr)lhs.getDescrs().get(2);
        RuleParserTest.assertNull((Object)third.getIdentifier());
        RuleParserTest.assertEquals((String)"Baz", (String)third.getObjectType());
        this.assertEqualsIgnoreWhitespace("if ( a == b ) {   assert( foo3 );} else {  retract( foo4 );}  System.out.println( a4 );", (String)rule.getConsequence());
    }

    @Test
    public void testNotNode() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_not.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertEquals((int)1, (int)lhs.getDescrs().size());
        NotDescr not = (NotDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)not.getDescrs().size());
        PatternDescr pattern = (PatternDescr)not.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        AndDescr and = (AndDescr)pattern.getConstraint();
        ExprConstraintDescr fld = (ExprConstraintDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"type == \"stilton\"", (String)fld.getExpression());
    }

    @Test
    public void testNotExistWithBrackets() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "not_exist_with_brackets.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertEquals((int)2, (int)lhs.getDescrs().size());
        NotDescr not = (NotDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)not.getDescrs().size());
        PatternDescr pattern = (PatternDescr)not.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)pattern.getObjectType());
        ExistsDescr ex = (ExistsDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((int)1, (int)ex.getDescrs().size());
        PatternDescr exPattern = (PatternDescr)ex.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Foo", (String)exPattern.getObjectType());
    }

    @Test
    public void testSimpleQuery() throws Exception {
        QueryDescr query = (QueryDescr)this.parseResource("query", "simple_query.drl");
        RuleParserTest.assertNotNull((Object)query);
        RuleParserTest.assertEquals((String)"simple_query", (String)query.getName());
        AndDescr lhs = query.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)3, (int)lhs.getDescrs().size());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"foo3", (String)first.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)first.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)first.getConstraint().getDescrs().size());
        AndDescr and = (AndDescr)first.getConstraint();
        ExprConstraintDescr fld = (ExprConstraintDescr)and.getDescrs().get(0);
        RuleParserTest.assertNotNull((Object)fld);
        RuleParserTest.assertEquals((String)"a==3", (String)fld.getExpression());
        PatternDescr second = (PatternDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"foo4", (String)second.getIdentifier());
        RuleParserTest.assertEquals((String)"Bar", (String)second.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)second.getBindings().size());
        BindingDescr bindingDescr = (BindingDescr)second.getBindings().get(0);
        RuleParserTest.assertEquals((String)"a==4", (String)bindingDescr.getExpression());
        RuleParserTest.assertEquals((String)"a4", (String)bindingDescr.getVariable());
    }

    @Test
    public void testQueryRuleMixed() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "query_and_rule.drl");
        RuleParserTest.assertEquals((int)4, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((String)"bar", (String)rule.getName());
        QueryDescr query = (QueryDescr)pkg.getRules().get(1);
        RuleParserTest.assertEquals((String)"simple_query", (String)query.getName());
        rule = (RuleDescr)pkg.getRules().get(2);
        RuleParserTest.assertEquals((String)"bar2", (String)rule.getName());
        query = (QueryDescr)pkg.getRules().get(3);
        RuleParserTest.assertEquals((String)"simple_query2", (String)query.getName());
    }

    @Test
    public void testMultipleRules() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "multiple_rules.drl");
        List rules = pkg.getRules();
        RuleParserTest.assertEquals((int)2, (int)rules.size());
        RuleDescr rule0 = (RuleDescr)rules.get(0);
        RuleParserTest.assertEquals((String)"Like Stilton", (String)rule0.getName());
        RuleDescr rule1 = (RuleDescr)rules.get(1);
        RuleParserTest.assertEquals((String)"Like Cheddar", (String)rule1.getName());
        AndDescr lhs = rule1.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)1, (int)lhs.getDescrs().size());
        this.assertEqualsIgnoreWhitespace("System.out.println(\"I like \" + t);", (String)rule0.getConsequence());
        PatternDescr first = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)first.getObjectType());
        lhs = rule1.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)1, (int)lhs.getDescrs().size());
        this.assertEqualsIgnoreWhitespace("System.out.println(\"I like \" + t);", (String)rule1.getConsequence());
        first = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)first.getObjectType());
    }

    @Test
    public void testExpanderLineSpread() throws Exception {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(this.getReader("expander_spread_lines.dslr"), this.getReader("complex.dsl"));
        RuleParserTest.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        RuleParserTest.assertNotNull((Object)((String)rule.getConsequence()));
    }

    @Test
    public void testExpanderMultipleConstraints() throws Exception {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(this.getReader("expander_multiple_constraints.dslr"), this.getReader("multiple_constraints.dsl"));
        RuleParserTest.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)pattern.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((String)"age < 42", (String)((ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0)).getExpression());
        RuleParserTest.assertEquals((String)"location==atlanta", (String)((ExprConstraintDescr)pattern.getConstraint().getDescrs().get(1)).getExpression());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Bar", (String)pattern.getObjectType());
        RuleParserTest.assertNotNull((Object)((String)rule.getConsequence()));
    }

    @Test
    public void testExpanderMultipleConstraintsFlush() throws Exception {
        DrlParser parser = new DrlParser();
        PackageDescr pkg = parser.parse(this.getReader("expander_multiple_constraints_flush.dslr"), this.getReader("multiple_constraints.dsl"));
        RuleParserTest.assertFalse((String)parser.getErrors().toString(), (boolean)parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)pattern.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((String)"age < 42", (String)((ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0)).getExpression());
        RuleParserTest.assertEquals((String)"location==atlanta", (String)((ExprConstraintDescr)pattern.getConstraint().getDescrs().get(1)).getExpression());
        RuleParserTest.assertNotNull((Object)((String)rule.getConsequence()));
    }

    @Test
    public void testBasicBinding() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "basic_binding.drl");
        RuleDescr ruleDescr = (RuleDescr)pkg.getRules().get(0);
        AndDescr lhs = ruleDescr.getLhs();
        RuleParserTest.assertEquals((int)1, (int)lhs.getDescrs().size());
        PatternDescr cheese = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese.getObjectType());
        RuleParserTest.assertEquals((int)0, (int)cheese.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((int)1, (int)cheese.getBindings().size());
        BindingDescr fieldBinding = (BindingDescr)cheese.getBindings().get(0);
        RuleParserTest.assertEquals((String)"type", (String)fieldBinding.getExpression());
    }

    @Test
    public void testBoundVariables() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "bindings.drl");
        RuleDescr ruleDescr = (RuleDescr)pkg.getRules().get(0);
        AndDescr lhs = ruleDescr.getLhs();
        RuleParserTest.assertEquals((int)2, (int)lhs.getDescrs().size());
        PatternDescr cheese = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)lhs.getDescrs().size());
        BindingDescr fieldBinding = (BindingDescr)cheese.getBindings().get(0);
        RuleParserTest.assertEquals((String)"type == \"stilton\"", (String)fieldBinding.getExpression());
        PatternDescr person = (PatternDescr)lhs.getDescrs().get(1);
        fieldBinding = (BindingDescr)person.getBindings().get(0);
        RuleParserTest.assertEquals((String)"name == \"bob\"", (String)fieldBinding.getExpression());
        ExprConstraintDescr fld = (ExprConstraintDescr)person.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"likes == $type", (String)fld.getExpression());
    }

    @Test
    public void testOrNesting() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "or_nesting.drl");
        RuleParserTest.assertNotNull((Object)pkg);
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        PatternDescr first = (PatternDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)first.getObjectType());
        AndDescr and = (AndDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((int)2, (int)and.getDescrs().size());
        PatternDescr left = (PatternDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)left.getObjectType());
        PatternDescr right = (PatternDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Cheese", (String)right.getObjectType());
    }

    @Test
    public void testAndOrRules() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "and_or_rule.drl");
        RuleParserTest.assertNotNull((Object)pkg);
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        AndDescr and = rule.getLhs();
        RuleParserTest.assertEquals((int)3, (int)and.getDescrs().size());
        PatternDescr left = (PatternDescr)and.getDescrs().get(0);
        PatternDescr right = (PatternDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Person", (String)left.getObjectType());
        RuleParserTest.assertEquals((String)"Cheese", (String)right.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)left.getConstraint().getDescrs().size());
        ExprConstraintDescr fld = (ExprConstraintDescr)left.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"name == \"mark\"", (String)fld.getExpression());
        RuleParserTest.assertEquals((int)1, (int)right.getConstraint().getDescrs().size());
        fld = (ExprConstraintDescr)right.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"type == \"stilton\"", (String)fld.getExpression());
        OrDescr or = (OrDescr)and.getDescrs().get(2);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        left = (PatternDescr)or.getDescrs().get(0);
        right = (PatternDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Person", (String)left.getObjectType());
        RuleParserTest.assertEquals((String)"Cheese", (String)right.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)left.getConstraint().getDescrs().size());
        fld = (ExprConstraintDescr)left.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"name == \"mark\"", (String)fld.getExpression());
        RuleParserTest.assertEquals((int)1, (int)right.getConstraint().getDescrs().size());
        fld = (ExprConstraintDescr)right.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"type == \"stilton\"", (String)fld.getExpression());
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" );", (String)rule.getConsequence());
    }

    @Test
    public void testOrWithBinding() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "or_binding.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        PatternDescr leftPattern = (PatternDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)leftPattern.getObjectType());
        RuleParserTest.assertEquals((String)"foo", (String)leftPattern.getIdentifier());
        PatternDescr rightPattern = (PatternDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Person", (String)rightPattern.getObjectType());
        RuleParserTest.assertEquals((String)"foo", (String)rightPattern.getIdentifier());
        PatternDescr cheeseDescr = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheeseDescr.getObjectType());
        RuleParserTest.assertEquals(null, (String)cheeseDescr.getIdentifier());
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" + bar );", (String)rule.getConsequence());
    }

    @Test
    public void testOrBindingComplex() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "or_binding_complex.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        PatternDescr firstFact = (PatternDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)firstFact.getObjectType());
        RuleParserTest.assertEquals((String)"foo", (String)firstFact.getIdentifier());
        PatternDescr secondFact = (PatternDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Person", (String)secondFact.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)secondFact.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((String)"foo", (String)secondFact.getIdentifier());
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" + bar );", (String)rule.getConsequence());
    }

    @Test
    public void testOrBindingWithBrackets() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "or_binding_with_brackets.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        PatternDescr firstFact = (PatternDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)firstFact.getObjectType());
        RuleParserTest.assertEquals((String)"foo", (String)firstFact.getIdentifier());
        PatternDescr secondFact = (PatternDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)secondFact.getObjectType());
        RuleParserTest.assertEquals((String)"foo", (String)secondFact.getIdentifier());
        this.assertEqualsIgnoreWhitespace("System.out.println( \"Mark and Michael\" + bar );", (String)rule.getConsequence());
    }

    @Test
    public void testBracketsPrecedence() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "brackets_precedence.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        AndDescr rootAnd = rule.getLhs();
        RuleParserTest.assertEquals((int)2, (int)rootAnd.getDescrs().size());
        OrDescr leftOr = (OrDescr)rootAnd.getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)leftOr.getDescrs().size());
        NotDescr not = (NotDescr)leftOr.getDescrs().get(0);
        PatternDescr foo1 = (PatternDescr)not.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Foo", (String)foo1.getObjectType());
        PatternDescr foo2 = (PatternDescr)leftOr.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Foo", (String)foo2.getObjectType());
        OrDescr rightOr = (OrDescr)rootAnd.getDescrs().get(1);
        RuleParserTest.assertEquals((int)2, (int)rightOr.getDescrs().size());
        PatternDescr shoes = (PatternDescr)rightOr.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Shoes", (String)shoes.getObjectType());
        PatternDescr butt = (PatternDescr)rightOr.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Butt", (String)butt.getObjectType());
    }

    @Test
    public void testEvalMultiple() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "eval_multiple.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)4, (int)rule.getLhs().getDescrs().size());
        EvalDescr eval = (EvalDescr)rule.getLhs().getDescrs().get(0);
        this.assertEqualsIgnoreWhitespace("abc(\"foo\") + 5", (String)eval.getContent());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Foo", (String)pattern.getObjectType());
    }

    @Test
    public void testWithEval() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "with_eval.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)3, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Foo", (String)pattern.getObjectType());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Bar", (String)pattern.getObjectType());
        EvalDescr eval = (EvalDescr)rule.getLhs().getDescrs().get(2);
        this.assertEqualsIgnoreWhitespace("abc(\"foo\")", (String)eval.getContent());
        this.assertEqualsIgnoreWhitespace("Kapow", (String)rule.getConsequence());
    }

    @Test
    public void testWithRetval() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "with_retval.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)col.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((String)"Foo", (String)col.getObjectType());
        ExprConstraintDescr fld = (ExprConstraintDescr)col.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"name== (a + b)", (String)fld.getExpression());
    }

    @Test
    public void testWithPredicate() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "with_predicate.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AndDescr and = (AndDescr)col.getConstraint();
        RuleParserTest.assertEquals((int)1, (int)and.getDescrs().size());
        BindingDescr field = (BindingDescr)col.getBindings().get(0);
        ExprConstraintDescr pred = (ExprConstraintDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age", (String)field.getExpression());
        RuleParserTest.assertEquals((String)"$age2", (String)field.getVariable());
        this.assertEqualsIgnoreWhitespace("$age2 == $age1+2", pred.getExpression());
    }

    @Test
    public void testNotWithConstraint() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "not_with_constraint.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        BindingDescr fieldBinding = (BindingDescr)pattern.getBindings().get(0);
        RuleParserTest.assertEquals((String)"$likes", (String)fieldBinding.getVariable());
        NotDescr not = (NotDescr)rule.getLhs().getDescrs().get(1);
        pattern = (PatternDescr)not.getDescrs().get(0);
        ExprConstraintDescr fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"type == $likes", (String)fld.getExpression());
    }

    @Test
    public void testFunctions() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "functions.drl");
        RuleParserTest.assertEquals((int)2, (int)pkg.getRules().size());
        List functions = pkg.getFunctions();
        RuleParserTest.assertEquals((int)2, (int)functions.size());
        FunctionDescr func = (FunctionDescr)functions.get(0);
        RuleParserTest.assertEquals((String)"functionA", (String)func.getName());
        RuleParserTest.assertEquals((String)"String", (String)func.getReturnType());
        RuleParserTest.assertEquals((int)2, (int)func.getParameterNames().size());
        RuleParserTest.assertEquals((int)2, (int)func.getParameterTypes().size());
        RuleParserTest.assertEquals((int)4, (int)func.getLine());
        RuleParserTest.assertEquals((int)0, (int)func.getColumn());
        RuleParserTest.assertEquals((String)"String", (String)((String)func.getParameterTypes().get(0)));
        RuleParserTest.assertEquals((String)"s", (String)((String)func.getParameterNames().get(0)));
        RuleParserTest.assertEquals((String)"Integer", (String)((String)func.getParameterTypes().get(1)));
        RuleParserTest.assertEquals((String)"i", (String)((String)func.getParameterNames().get(1)));
        this.assertEqualsIgnoreWhitespace("foo();", func.getBody());
        func = (FunctionDescr)functions.get(1);
        RuleParserTest.assertEquals((String)"functionB", (String)func.getName());
        this.assertEqualsIgnoreWhitespace("bar();", func.getText());
    }

    @Test
    public void testComment() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "comment.drl");
        RuleParserTest.assertNotNull((Object)pkg);
        RuleParserTest.assertEquals((String)"foo.bar", (String)pkg.getName());
    }

    @Test
    public void testAttributes() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_attributes.drl");
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        Map attrs = rule.getAttributes();
        RuleParserTest.assertEquals((int)6, (int)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get("salience");
        RuleParserTest.assertEquals((String)"salience", (String)at.getName());
        RuleParserTest.assertEquals((String)"42", (String)at.getValue());
        at = (AttributeDescr)attrs.get("agenda-group");
        RuleParserTest.assertEquals((String)"agenda-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"my_group", (String)at.getValue());
        at = (AttributeDescr)attrs.get("no-loop");
        RuleParserTest.assertEquals((String)"no-loop", (String)at.getName());
        RuleParserTest.assertEquals((String)"true", (String)at.getValue());
        at = (AttributeDescr)attrs.get("duration");
        RuleParserTest.assertEquals((String)"duration", (String)at.getName());
        RuleParserTest.assertEquals((String)"42", (String)at.getValue());
        at = (AttributeDescr)attrs.get("activation-group");
        RuleParserTest.assertEquals((String)"activation-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"my_activation_group", (String)at.getValue());
        at = (AttributeDescr)attrs.get("lock-on-active");
        RuleParserTest.assertEquals((String)"lock-on-active", (String)at.getName());
        RuleParserTest.assertEquals((String)"true", (String)at.getValue());
    }

    @Test
    public void testAttributes2() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "rule_attributes2.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        List rules = pkg.getRules();
        RuleParserTest.assertEquals((int)3, (int)rules.size());
        RuleDescr rule = (RuleDescr)rules.get(0);
        RuleParserTest.assertEquals((String)"rule1", (String)rule.getName());
        Map attrs = rule.getAttributes();
        RuleParserTest.assertEquals((int)2, (int)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get("salience");
        RuleParserTest.assertEquals((String)"salience", (String)at.getName());
        RuleParserTest.assertEquals((String)"(42)", (String)at.getValue());
        at = (AttributeDescr)attrs.get("agenda-group");
        RuleParserTest.assertEquals((String)"agenda-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"my_group", (String)at.getValue());
        rule = (RuleDescr)rules.get(1);
        RuleParserTest.assertEquals((String)"rule2", (String)rule.getName());
        attrs = rule.getAttributes();
        RuleParserTest.assertEquals((int)2, (int)attrs.size());
        at = (AttributeDescr)attrs.get("salience");
        RuleParserTest.assertEquals((String)"salience", (String)at.getName());
        RuleParserTest.assertEquals((String)"(Integer.MIN_VALUE)", (String)at.getValue());
        at = (AttributeDescr)attrs.get("no-loop");
        RuleParserTest.assertEquals((String)"no-loop", (String)at.getName());
        rule = (RuleDescr)rules.get(2);
        RuleParserTest.assertEquals((String)"rule3", (String)rule.getName());
        attrs = rule.getAttributes();
        RuleParserTest.assertEquals((int)2, (int)attrs.size());
        at = (AttributeDescr)attrs.get("enabled");
        RuleParserTest.assertEquals((String)"enabled", (String)at.getName());
        RuleParserTest.assertEquals((String)"(Boolean.TRUE)", (String)at.getValue());
        at = (AttributeDescr)attrs.get("activation-group");
        RuleParserTest.assertEquals((String)"activation-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"my_activation_group", (String)at.getValue());
    }

    @Test
    public void testEnabledExpression() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_enabled_expression.drl");
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        Map attrs = rule.getAttributes();
        RuleParserTest.assertEquals((int)3, (int)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get("enabled");
        RuleParserTest.assertEquals((String)"enabled", (String)at.getName());
        RuleParserTest.assertEquals((String)"( 1 + 1 == 2 )", (String)at.getValue());
        at = (AttributeDescr)attrs.get("salience");
        RuleParserTest.assertEquals((String)"salience", (String)at.getName());
        RuleParserTest.assertEquals((String)"( 1+2 )", (String)at.getValue());
        at = (AttributeDescr)attrs.get("lock-on-active");
        RuleParserTest.assertEquals((String)"lock-on-active", (String)at.getName());
        RuleParserTest.assertEquals((String)"true", (String)at.getValue());
    }

    @Test
    public void testDurationExpression() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_duration_expression.drl");
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        Map attrs = rule.getAttributes();
        RuleParserTest.assertEquals((int)2, (int)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get("duration");
        RuleParserTest.assertEquals((String)"duration", (String)at.getName());
        RuleParserTest.assertEquals((String)"1h30m", (String)at.getValue());
        at = (AttributeDescr)attrs.get("lock-on-active");
        RuleParserTest.assertEquals((String)"lock-on-active", (String)at.getName());
        RuleParserTest.assertEquals((String)"true", (String)at.getValue());
    }

    @Test
    public void testCalendars() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_calendars_attribute.drl");
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        Map attrs = rule.getAttributes();
        RuleParserTest.assertEquals((int)2, (int)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get("calendars");
        RuleParserTest.assertEquals((String)"calendars", (String)at.getName());
        RuleParserTest.assertEquals((String)"[ \"cal1\" ]", (String)at.getValue());
        at = (AttributeDescr)attrs.get("lock-on-active");
        RuleParserTest.assertEquals((String)"lock-on-active", (String)at.getName());
        RuleParserTest.assertEquals((String)"true", (String)at.getValue());
    }

    @Test
    public void testCalendars2() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_calendars_attribute2.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        Map attrs = rule.getAttributes();
        RuleParserTest.assertEquals((int)2, (int)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get("calendars");
        RuleParserTest.assertEquals((String)"calendars", (String)at.getName());
        RuleParserTest.assertEquals((String)"[ \"cal 1\", \"cal 2\", \"cal 3\" ]", (String)at.getValue());
        at = (AttributeDescr)attrs.get("lock-on-active");
        RuleParserTest.assertEquals((String)"lock-on-active", (String)at.getName());
        RuleParserTest.assertEquals((String)"true", (String)at.getValue());
    }

    @Test
    public void testAttributes_alternateSyntax() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "rule_attributes_alt.drl");
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        this.assertEqualsIgnoreWhitespace("bar();", (String)rule.getConsequence());
        Map attrs = rule.getAttributes();
        RuleParserTest.assertEquals((int)6, (int)attrs.size());
        AttributeDescr at = (AttributeDescr)attrs.get("salience");
        RuleParserTest.assertEquals((String)"salience", (String)at.getName());
        RuleParserTest.assertEquals((String)"42", (String)at.getValue());
        at = (AttributeDescr)attrs.get("agenda-group");
        RuleParserTest.assertEquals((String)"agenda-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"my_group", (String)at.getValue());
        at = (AttributeDescr)attrs.get("no-loop");
        RuleParserTest.assertEquals((String)"no-loop", (String)at.getName());
        RuleParserTest.assertEquals((String)"true", (String)at.getValue());
        at = (AttributeDescr)attrs.get("lock-on-active");
        RuleParserTest.assertEquals((String)"lock-on-active", (String)at.getName());
        RuleParserTest.assertEquals((String)"true", (String)at.getValue());
        at = (AttributeDescr)attrs.get("duration");
        RuleParserTest.assertEquals((String)"duration", (String)at.getName());
        RuleParserTest.assertEquals((String)"42", (String)at.getValue());
        at = (AttributeDescr)attrs.get("activation-group");
        RuleParserTest.assertEquals((String)"activation-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"my_activation_group", (String)at.getValue());
    }

    @Test
    public void testEnumeration() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "enumeration.drl");
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Foo", (String)col.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)col.getConstraint().getDescrs().size());
        ExprConstraintDescr fld = (ExprConstraintDescr)col.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"bar == Foo.BAR", (String)fld.getExpression());
    }

    @Test
    public void testExtraLhsNewline() throws Exception {
        this.parseResource("compilationUnit", "extra_lhs_newline.drl");
    }

    @Test
    public void testSoundsLike() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "soundslike_operator.drl");
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr pat = (PatternDescr)rule.getLhs().getDescrs().get(0);
        pat.getConstraint();
    }

    @Test
    public void testPackageAttributes() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "package_attributes.drl");
        AttributeDescr at = (AttributeDescr)pkg.getAttributes().get(0);
        RuleParserTest.assertEquals((String)"agenda-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"x", (String)at.getValue());
        at = (AttributeDescr)pkg.getAttributes().get(1);
        RuleParserTest.assertEquals((String)"dialect", (String)at.getName());
        RuleParserTest.assertEquals((String)"java", (String)at.getValue());
        RuleParserTest.assertEquals((int)2, (int)pkg.getRules().size());
        RuleParserTest.assertEquals((int)2, (int)pkg.getImports().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((String)"bar", (String)rule.getName());
        at = (AttributeDescr)rule.getAttributes().get("agenda-group");
        RuleParserTest.assertEquals((String)"agenda-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"x", (String)at.getValue());
        at = (AttributeDescr)rule.getAttributes().get("dialect");
        RuleParserTest.assertEquals((String)"dialect", (String)at.getName());
        RuleParserTest.assertEquals((String)"java", (String)at.getValue());
        rule = (RuleDescr)pkg.getRules().get(1);
        RuleParserTest.assertEquals((String)"baz", (String)rule.getName());
        at = (AttributeDescr)rule.getAttributes().get("dialect");
        RuleParserTest.assertEquals((String)"dialect", (String)at.getName());
        RuleParserTest.assertEquals((String)"mvel", (String)at.getValue());
        at = (AttributeDescr)rule.getAttributes().get("agenda-group");
        RuleParserTest.assertEquals((String)"agenda-group", (String)at.getName());
        RuleParserTest.assertEquals((String)"x", (String)at.getValue());
    }

    @Test
    public void testStatementOrdering1() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "statement_ordering_1.drl");
        RuleParserTest.assertEquals((int)2, (int)pkg.getRules().size());
        RuleParserTest.assertEquals((String)"foo", (String)((RuleDescr)pkg.getRules().get(0)).getName());
        RuleParserTest.assertEquals((String)"bar", (String)((RuleDescr)pkg.getRules().get(1)).getName());
        RuleParserTest.assertEquals((int)2, (int)pkg.getFunctions().size());
        RuleParserTest.assertEquals((String)"cheeseIt", (String)((FunctionDescr)pkg.getFunctions().get(0)).getName());
        RuleParserTest.assertEquals((String)"uncheeseIt", (String)((FunctionDescr)pkg.getFunctions().get(1)).getName());
        RuleParserTest.assertEquals((int)4, (int)pkg.getImports().size());
        RuleParserTest.assertEquals((String)"im.one", (String)((ImportDescr)pkg.getImports().get(0)).getTarget());
        RuleParserTest.assertEquals((String)"im.two", (String)((ImportDescr)pkg.getImports().get(1)).getTarget());
        RuleParserTest.assertEquals((String)"im.three", (String)((ImportDescr)pkg.getImports().get(2)).getTarget());
        RuleParserTest.assertEquals((String)"im.four", (String)((ImportDescr)pkg.getImports().get(3)).getTarget());
    }

    @Test
    public void testRuleNamesStartingWithNumbers() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "rule_names_number_prefix.drl");
        RuleParserTest.assertEquals((int)2, (int)pkg.getRules().size());
        RuleParserTest.assertEquals((String)"1. Do Stuff!", (String)((RuleDescr)pkg.getRules().get(0)).getName());
        RuleParserTest.assertEquals((String)"2. Do More Stuff!", (String)((RuleDescr)pkg.getRules().get(1)).getName());
    }

    @Test
    public void testEvalWithNewline() throws Exception {
        this.parseResource("compilationUnit", "eval_with_newline.drl");
    }

    @Test
    public void testEndPosition() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "test_EndPosition.drl");
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr col = (PatternDescr)rule.getLhs().getDescrs().get(0);
    }

    @Test
    public void testQualifiedClassname() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "qualified_classname.drl");
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr p = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"com.cheeseco.Cheese", (String)p.getObjectType());
    }

    @Test
    public void testAccumulate() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulate.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)outPattern.getSource();
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        RuleParserTest.assertNull((Object)accum.getReverseCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        RuleParserTest.assertFalse((boolean)accum.isExternalFunction());
        PatternDescr pattern = accum.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
    }

    @Test
    public void testAccumulateWithBindings() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulate_with_bindings.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)outPattern.getSource();
        this.assertEqualsIgnoreWhitespace("$counter", outPattern.getIdentifier());
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        PatternDescr pattern = accum.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
    }

    @Test
    public void testCollect() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "collect.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        CollectDescr collect = (CollectDescr)outPattern.getSource();
        PatternDescr pattern = collect.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
    }

    @Test
    public void testPredicate2() throws Exception {
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X when Foo(eval( $var.equals(\"xyz\") )) then end");
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        List constraints = pattern.getConstraint().getDescrs();
        RuleParserTest.assertEquals((int)1, (int)constraints.size());
        ExprConstraintDescr predicate = (ExprConstraintDescr)constraints.get(0);
        RuleParserTest.assertEquals((String)"eval( $var.equals(\"xyz\") )", (String)predicate.getExpression());
    }

    @Test
    public void testEscapedStrings() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "escaped-string.drl");
        RuleParserTest.assertNotNull((Object)rule);
        RuleParserTest.assertEquals((String)"test_Quotes", (String)rule.getName());
        String expected = "String s = \"\\\"\\n\\t\\\\\";";
        this.assertEqualsIgnoreWhitespace("String s = \"\\\"\\n\\t\\\\\";", (String)rule.getConsequence());
    }

    @Test
    public void testNestedCEs() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "nested_conditional_elements.drl");
        RuleParserTest.assertNotNull((Object)rule);
        AndDescr root = rule.getLhs();
        NotDescr not1 = (NotDescr)root.getDescrs().get(0);
        AndDescr and1 = (AndDescr)not1.getDescrs().get(0);
        PatternDescr state = (PatternDescr)and1.getDescrs().get(0);
        NotDescr not2 = (NotDescr)and1.getDescrs().get(1);
        AndDescr and2 = (AndDescr)not2.getDescrs().get(0);
        PatternDescr person = (PatternDescr)and2.getDescrs().get(0);
        PatternDescr cheese = (PatternDescr)and2.getDescrs().get(1);
        PatternDescr person2 = (PatternDescr)root.getDescrs().get(1);
        OrDescr or = (OrDescr)root.getDescrs().get(2);
        PatternDescr cheese2 = (PatternDescr)or.getDescrs().get(0);
        PatternDescr cheese3 = (PatternDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((String)state.getObjectType(), (String)"State");
        RuleParserTest.assertEquals((String)person.getObjectType(), (String)"Person");
        RuleParserTest.assertEquals((String)cheese.getObjectType(), (String)"Cheese");
        RuleParserTest.assertEquals((String)person2.getObjectType(), (String)"Person");
        RuleParserTest.assertEquals((String)cheese2.getObjectType(), (String)"Cheese");
        RuleParserTest.assertEquals((String)cheese3.getObjectType(), (String)"Cheese");
    }

    @Test
    public void testForall() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "forall.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        ForallDescr forall = (ForallDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)forall.getDescrs().size());
        PatternDescr pattern = forall.getBasePattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        List remaining = forall.getRemainingPatterns();
        RuleParserTest.assertEquals((int)1, (int)remaining.size());
        PatternDescr cheese = (PatternDescr)remaining.get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese.getObjectType());
    }

    @Test
    public void testForCE() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "forCE.drl");
    }

    @Test
    public void testForallWithFrom() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "forallwithfrom.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        ForallDescr forall = (ForallDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)forall.getDescrs().size());
        PatternDescr pattern = forall.getBasePattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((String)"$village", (String)((FromDescr)pattern.getSource()).getDataSource().toString());
        List remaining = forall.getRemainingPatterns();
        RuleParserTest.assertEquals((int)1, (int)remaining.size());
        PatternDescr cheese = (PatternDescr)remaining.get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese.getObjectType());
        RuleParserTest.assertEquals((String)"$cheesery", (String)((FromDescr)cheese.getSource()).getDataSource().toString());
    }

    @Test
    public void testMemberof() throws Exception {
        String text = "rule X when Country( $cities : city )\nPerson( city memberOf $cities )\n then end";
        AndDescr descrs = ((RuleDescr)this.parse("rule", "rule X when Country( $cities : city )\nPerson( city memberOf $cities )\n then end")).getLhs();
        RuleParserTest.assertEquals((int)2, (int)descrs.getDescrs().size());
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(1);
        ExprConstraintDescr fieldConstr = (ExprConstraintDescr)pat.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"city memberOf $cities", (String)fieldConstr.getExpression());
    }

    @Test
    public void testNotMemberof() throws Exception {
        String text = "rule X when Country( $cities : city )\nPerson( city not memberOf $cities ) then end\n";
        AndDescr descrs = ((RuleDescr)this.parse("rule", "rule X when Country( $cities : city )\nPerson( city not memberOf $cities ) then end\n")).getLhs();
        RuleParserTest.assertEquals((int)2, (int)descrs.getDescrs().size());
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(1);
        ExprConstraintDescr fieldConstr = (ExprConstraintDescr)pat.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"city not memberOf $cities", (String)fieldConstr.getExpression());
    }

    @Test
    public void testInOperator() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "in_operator_test.drl");
        RuleParserTest.assertNotNull((Object)rule);
        this.assertEqualsIgnoreWhitespace("consequence();", (String)rule.getConsequence());
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        ExprConstraintDescr fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age > 30 && < 40", (String)fld.getExpression());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Vehicle", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)pattern.getConstraint().getDescrs().size());
        fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"type in ( \"sedan\", \"wagon\" )", (String)fld.getExpression());
        fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"age < 3", (String)fld.getExpression());
    }

    @Test
    public void testNotInOperator() throws Exception {
        RuleDescr rule = (RuleDescr)this.parseResource("rule", "notin_operator_test.drl");
        RuleParserTest.assertNotNull((Object)rule);
        this.assertEqualsIgnoreWhitespace("consequence();", (String)rule.getConsequence());
        RuleParserTest.assertEquals((String)"simple_rule", (String)rule.getName());
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)pattern.getConstraint().getDescrs().size());
        ExprConstraintDescr fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age > 30 && < 40", (String)fld.getExpression());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Vehicle", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((int)2, (int)pattern.getConstraint().getDescrs().size());
        fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"type not in ( \"sedan\", \"wagon\" )", (String)fld.getExpression());
        fld = (ExprConstraintDescr)pattern.getConstraint().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"age < 3", (String)fld.getExpression());
    }

    @Test
    public void testCheckOrDescr() throws Exception {
        String text = "rule X when Person( eval( age == 25 ) || ( eval( name.equals( \"bob\" ) ) && eval( age == 30 ) ) ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( eval( age == 25 ) || ( eval( name.equals( \"bob\" ) ) && eval( age == 30 ) ) ) then end")).getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        RuleParserTest.assertEquals(pattern.getConstraint().getClass(), AndDescr.class);
        RuleParserTest.assertEquals(ExprConstraintDescr.class, ((BaseDescr)pattern.getConstraint().getDescrs().get(0)).getClass());
    }

    @Test
    public void testConstraintAndConnective() throws Exception {
        String text = "rule X when Person( age < 42 && location==\"atlanta\") then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( age < 42 && location==\"atlanta\") then end")).getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age < 42 && location==\"atlanta\"", (String)fcd.getExpression());
    }

    @Test
    public void testConstraintOrConnective() throws Exception {
        String text = "rule X when Person( age < 42 || location==\"atlanta\") then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( age < 42 || location==\"atlanta\") then end")).getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"age < 42 || location==\"atlanta\"", (String)fcd.getExpression());
    }

    @Test
    public void testRestrictions() throws Exception {
        String text = "rule X when Foo( bar > 1 || == 1 ) then end\n";
        AndDescr descrs = ((RuleDescr)this.parse("rule", "rule X when Foo( bar > 1 || == 1 ) then end\n")).getLhs();
        RuleParserTest.assertEquals((int)1, (int)descrs.getDescrs().size());
        PatternDescr pat = (PatternDescr)descrs.getDescrs().get(0);
        ExprConstraintDescr fieldConstr = (ExprConstraintDescr)pat.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"bar > 1 || == 1", (String)fieldConstr.getExpression());
    }

    @Test
    public void testSemicolon() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "semicolon.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertEquals((String)"org.drools", (String)pkg.getName());
        RuleParserTest.assertEquals((int)1, (int)pkg.getGlobals().size());
        RuleParserTest.assertEquals((int)3, (int)pkg.getRules().size());
        RuleDescr rule1 = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)2, (int)rule1.getLhs().getDescrs().size());
        RuleDescr query1 = (RuleDescr)pkg.getRules().get(1);
        RuleParserTest.assertEquals((int)3, (int)query1.getLhs().getDescrs().size());
        RuleDescr rule2 = (RuleDescr)pkg.getRules().get(2);
        RuleParserTest.assertEquals((int)2, (int)rule2.getLhs().getDescrs().size());
    }

    @Test
    public void testEval() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "eval_parsing.drl");
        RuleParserTest.assertEquals((String)"org.drools", (String)pkg.getName());
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule1 = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule1.getLhs().getDescrs().size());
    }

    @Test
    public void testAccumulateReverse() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulateReverse.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        this.assertEqualsIgnoreWhitespace("x--;", accum.getReverseCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        RuleParserTest.assertFalse((boolean)accum.isExternalFunction());
        PatternDescr pattern = accum.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
    }

    @Test
    public void testAccumulateExternalFunction() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulateExternalFunction.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)out.getSource();
        this.assertEqualsIgnoreWhitespace("$age", ((AccumulateDescr.AccumulateFunctionCallDescr)accum.getFunctions().get(0)).getParams()[0]);
        this.assertEqualsIgnoreWhitespace("average", ((AccumulateDescr.AccumulateFunctionCallDescr)accum.getFunctions().get(0)).getFunction());
        RuleParserTest.assertTrue((boolean)accum.isExternalFunction());
        PatternDescr pattern = accum.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)pattern.getObjectType());
    }

    @Test
    public void testCollectWithNestedFrom() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "collect_with_nested_from.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        CollectDescr collect = (CollectDescr)out.getSource();
        PatternDescr person = collect.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)person.getObjectType());
        CollectDescr collect2 = (CollectDescr)person.getSource();
        PatternDescr people = collect2.getInputPattern();
        RuleParserTest.assertEquals((String)"People", (String)people.getObjectType());
    }

    @Test
    public void testAccumulateWithNestedFrom() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulate_with_nested_from.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr out = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accumulate = (AccumulateDescr)out.getSource();
        PatternDescr person = accumulate.getInputPattern();
        RuleParserTest.assertEquals((String)"Person", (String)person.getObjectType());
        CollectDescr collect2 = (CollectDescr)person.getSource();
        PatternDescr people = collect2.getInputPattern();
        RuleParserTest.assertEquals((String)"People", (String)people.getObjectType());
    }

    @Test
    public void testOrCE() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "or_ce.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)2, (int)rule.getLhs().getDescrs().size());
        PatternDescr person = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)person.getObjectType());
        RuleParserTest.assertEquals((String)"$p", (String)person.getIdentifier());
        OrDescr or = (OrDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        PatternDescr cheese1 = (PatternDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese1.getObjectType());
        RuleParserTest.assertEquals((String)"$c", (String)cheese1.getIdentifier());
        PatternDescr cheese2 = (PatternDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese2.getObjectType());
        RuleParserTest.assertNull((Object)cheese2.getIdentifier());
    }

    @Test
    public void testRuleSingleLine() throws Exception {
        String text = "rule \"another test\" salience 10 when eval( true ) then System.out.println(1); end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule \"another test\" salience 10 when eval( true ) then System.out.println(1); end");
        RuleParserTest.assertEquals((String)"another test", (String)rule.getName());
        RuleParserTest.assertEquals((Object)"System.out.println(1); ", (Object)rule.getConsequence());
    }

    @Test
    public void testRuleTwoLines() throws Exception {
        String text = "rule \"another test\" salience 10 when eval( true ) then System.out.println(1);\n end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule \"another test\" salience 10 when eval( true ) then System.out.println(1);\n end");
        RuleParserTest.assertEquals((String)"another test", (String)rule.getName());
        RuleParserTest.assertEquals((Object)"System.out.println(1);\n ", (Object)rule.getConsequence());
    }

    @Test
    public void testRuleParseLhs3() throws Exception {
        String text = "rule X when (or\nnot Person()\n(and Cheese()\nMeat()\nWine())) then end";
        AndDescr pattern = ((RuleDescr)this.parse("rule", "rule X when (or\nnot Person()\n(and Cheese()\nMeat()\nWine())) then end")).getLhs();
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        OrDescr or = (OrDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)or.getDescrs().size());
        NotDescr not = (NotDescr)or.getDescrs().get(0);
        AndDescr and = (AndDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((int)1, (int)not.getDescrs().size());
        PatternDescr person = (PatternDescr)not.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Person", (String)person.getObjectType());
        RuleParserTest.assertEquals((int)3, (int)and.getDescrs().size());
        PatternDescr cheese = (PatternDescr)and.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese.getObjectType());
        PatternDescr meat = (PatternDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Meat", (String)meat.getObjectType());
        PatternDescr wine = (PatternDescr)and.getDescrs().get(2);
        RuleParserTest.assertEquals((String)"Wine", (String)wine.getObjectType());
    }

    @Test
    public void testAccumulateMultiPattern() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "accumulate_multi_pattern.drl");
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr outPattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        AccumulateDescr accum = (AccumulateDescr)outPattern.getSource();
        this.assertEqualsIgnoreWhitespace("$counter", outPattern.getIdentifier());
        this.assertEqualsIgnoreWhitespace("int x = 0 ;", accum.getInitCode());
        this.assertEqualsIgnoreWhitespace("x++;", accum.getActionCode());
        this.assertEqualsIgnoreWhitespace("new Integer(x)", accum.getResultCode());
        AndDescr and = (AndDescr)accum.getInput();
        RuleParserTest.assertEquals((int)2, (int)and.getDescrs().size());
        PatternDescr person = (PatternDescr)and.getDescrs().get(0);
        PatternDescr cheese = (PatternDescr)and.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"Person", (String)person.getObjectType());
        RuleParserTest.assertEquals((String)"Cheese", (String)cheese.getObjectType());
    }

    @Test
    public void testPluggableOperators() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "pluggable_operators.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleParserTest.assertEquals((int)1, (int)pkg.getRules().size());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((int)5, (int)rule.getLhs().getDescrs().size());
        PatternDescr eventA = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"$a", (String)eventA.getIdentifier());
        RuleParserTest.assertEquals((String)"EventA", (String)eventA.getObjectType());
        PatternDescr eventB = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"$b", (String)eventB.getIdentifier());
        RuleParserTest.assertEquals((String)"EventB", (String)eventB.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)eventB.getConstraint().getDescrs().size());
        RuleParserTest.assertEquals((int)1, (int)eventB.getConstraint().getDescrs().size());
        ExprConstraintDescr fcdB = (ExprConstraintDescr)eventB.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"this after[1,10] $a || this not after[15,20] $a", (String)fcdB.getExpression());
        PatternDescr eventC = (PatternDescr)rule.getLhs().getDescrs().get(2);
        RuleParserTest.assertEquals((String)"$c", (String)eventC.getIdentifier());
        RuleParserTest.assertEquals((String)"EventC", (String)eventC.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)eventC.getConstraint().getDescrs().size());
        ExprConstraintDescr fcdC = (ExprConstraintDescr)eventC.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"this finishes $b", (String)fcdC.getExpression());
        PatternDescr eventD = (PatternDescr)rule.getLhs().getDescrs().get(3);
        RuleParserTest.assertEquals((String)"$d", (String)eventD.getIdentifier());
        RuleParserTest.assertEquals((String)"EventD", (String)eventD.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)eventD.getConstraint().getDescrs().size());
        ExprConstraintDescr fcdD = (ExprConstraintDescr)eventD.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"this not starts $a", (String)fcdD.getExpression());
        PatternDescr eventE = (PatternDescr)rule.getLhs().getDescrs().get(4);
        RuleParserTest.assertEquals((String)"$e", (String)eventE.getIdentifier());
        RuleParserTest.assertEquals((String)"EventE", (String)eventE.getObjectType());
        RuleParserTest.assertEquals((int)1, (int)eventE.getConstraint().getDescrs().size());
        ExprConstraintDescr fcdE = (ExprConstraintDescr)eventE.getConstraint().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"this not before[1, 10] $b || after[1, 10] $c && this after[1, 5] $d", (String)fcdE.getExpression());
    }

    @Test
    public void testTypeDeclaration() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "declare_type.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        List declarations = pkg.getTypeDeclarations();
        RuleParserTest.assertEquals((int)2, (int)declarations.size());
        TypeDeclarationDescr descr = (TypeDeclarationDescr)declarations.get(0);
        RuleParserTest.assertEquals((String)"CallEvent", (String)descr.getTypeName());
        RuleParserTest.assertEquals((int)4, (int)descr.getAnnotationNames().size());
        RuleParserTest.assertEquals((Object)"event", (Object)descr.getAnnotation("role").getValue());
        RuleParserTest.assertEquals((Object)"org.drools.events.Call", (Object)descr.getAnnotation("class").getValue());
        RuleParserTest.assertEquals((Object)"duration", (Object)descr.getAnnotation("duration").getValue());
        RuleParserTest.assertEquals((Object)"timestamp", (Object)descr.getAnnotation("timestamp").getValue());
        RuleParserTest.assertNull((Object)descr.getAnnotation("FOO"));
        descr = (TypeDeclarationDescr)declarations.get(1);
        RuleParserTest.assertEquals((String)"some.pkg.Type", (String)descr.getTypeName());
        RuleParserTest.assertEquals((int)5, (int)descr.getAnnotationNames().size());
        RuleParserTest.assertNotNull((Object)descr.getAnnotation("name1"));
        RuleParserTest.assertEquals((Object)"\"value\"", (Object)descr.getAnnotation("name2").getValue());
        RuleParserTest.assertEquals((String)"10", (String)descr.getAnnotation("name3").getValue("k1"));
        RuleParserTest.assertEquals((String)"\"a\"", (String)descr.getAnnotation("name4").getValue("k1"));
        RuleParserTest.assertEquals((String)"Math.max( 10 + 25, 22 ) % 2 + someVariable", (String)descr.getAnnotation("name4").getValue("formula"));
        RuleParserTest.assertEquals((String)"{ a, b, c }", (String)descr.getAnnotation("name4").getValue("array"));
        RuleParserTest.assertEquals((Object)"backward compatible value", (Object)descr.getAnnotation("name5").getValue());
    }

    @Test
    public void testRuleMetadata() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "Rule_with_Metadata.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertTrue((boolean)rule.getAnnotationNames().contains("fooMeta1"));
        RuleParserTest.assertEquals((Object)"barVal1", (Object)rule.getAnnotation("fooMeta1").getValue());
        RuleParserTest.assertTrue((boolean)rule.getAnnotationNames().contains("fooMeta2"));
        RuleParserTest.assertEquals((Object)"barVal2", (Object)rule.getAnnotation("fooMeta2").getValue());
        this.assertEqualsIgnoreWhitespace("System.out.println(\"Consequence\");", (String)rule.getConsequence());
    }

    @Test
    public void testRuleExtends() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "Rule_with_Extends.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertTrue((rule.getParentName() != null ? 1 : 0) != 0);
        RuleParserTest.assertEquals((String)"rule1", (String)rule.getParentName());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)1, (int)lhs.getDescrs().size());
        PatternDescr pattern = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"foo", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((String)"$foo", (String)pattern.getIdentifier());
    }

    @Test
    public void testTypeDeclarationWithFields() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "declare_type_with_fields.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        List td = pkg.getTypeDeclarations();
        RuleParserTest.assertEquals((int)3, (int)td.size());
        TypeDeclarationDescr d = (TypeDeclarationDescr)td.get(0);
        RuleParserTest.assertEquals((String)"SomeFact", (String)d.getTypeName());
        RuleParserTest.assertEquals((int)2, (int)d.getFields().size());
        RuleParserTest.assertTrue((boolean)d.getFields().containsKey("name"));
        RuleParserTest.assertTrue((boolean)d.getFields().containsKey("age"));
        TypeFieldDescr f = (TypeFieldDescr)d.getFields().get("name");
        RuleParserTest.assertEquals((String)"String", (String)f.getPattern().getObjectType());
        f = (TypeFieldDescr)d.getFields().get("age");
        RuleParserTest.assertEquals((String)"Integer", (String)f.getPattern().getObjectType());
        d = (TypeDeclarationDescr)td.get(1);
        RuleParserTest.assertEquals((String)"AnotherFact", (String)d.getTypeName());
        TypeDeclarationDescr type = (TypeDeclarationDescr)td.get(2);
        RuleParserTest.assertEquals((String)"Person", (String)type.getTypeName());
        RuleParserTest.assertEquals((Object)"fact", (Object)type.getAnnotation("role").getValue());
        RuleParserTest.assertEquals((String)"\"Models a person\"", (String)type.getAnnotation("doc").getValue("descr"));
        RuleParserTest.assertEquals((String)"\"Bob\"", (String)type.getAnnotation("doc").getValue("author"));
        RuleParserTest.assertEquals((String)"Calendar.getInstance().getDate()", (String)type.getAnnotation("doc").getValue("date"));
        RuleParserTest.assertEquals((int)2, (int)type.getFields().size());
        TypeFieldDescr field = (TypeFieldDescr)type.getFields().get("name");
        RuleParserTest.assertEquals((String)"name", (String)field.getFieldName());
        RuleParserTest.assertEquals((String)"String", (String)field.getPattern().getObjectType());
        RuleParserTest.assertEquals((String)"\"John Doe\"", (String)field.getInitExpr());
        RuleParserTest.assertEquals((String)"50", (String)field.getAnnotation("length").getValue("max"));
        RuleParserTest.assertNotNull((Object)field.getAnnotation("key"));
        field = (TypeFieldDescr)type.getFields().get("age");
        RuleParserTest.assertEquals((String)"age", (String)field.getFieldName());
        RuleParserTest.assertEquals((String)"int", (String)field.getPattern().getObjectType());
        RuleParserTest.assertEquals((String)"-1", (String)field.getInitExpr());
        RuleParserTest.assertEquals((String)"0", (String)field.getAnnotation("ranged").getValue("min"));
        RuleParserTest.assertEquals((String)"150", (String)field.getAnnotation("ranged").getValue("max"));
        RuleParserTest.assertEquals((String)"-1", (String)field.getAnnotation("ranged").getValue("unknown"));
    }

    @Test
    public void testRuleWithLHSNesting() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "Rule_with_nested_LHS.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((String)"test", (String)rule.getName());
        AndDescr lhs = rule.getLhs();
        RuleParserTest.assertNotNull((Object)lhs);
        RuleParserTest.assertEquals((int)2, (int)lhs.getDescrs().size());
        PatternDescr a = (PatternDescr)lhs.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"A", (String)a.getObjectType());
        OrDescr or = (OrDescr)lhs.getDescrs().get(1);
        RuleParserTest.assertEquals((int)3, (int)or.getDescrs().size());
        AndDescr and1 = (AndDescr)or.getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)and1.getDescrs().size());
        PatternDescr b = (PatternDescr)and1.getDescrs().get(0);
        PatternDescr c = (PatternDescr)and1.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"B", (String)b.getObjectType());
        RuleParserTest.assertEquals((String)"C", (String)c.getObjectType());
        AndDescr and2 = (AndDescr)or.getDescrs().get(1);
        RuleParserTest.assertEquals((int)2, (int)and2.getDescrs().size());
        PatternDescr d = (PatternDescr)and2.getDescrs().get(0);
        PatternDescr e = (PatternDescr)and2.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"D", (String)d.getObjectType());
        RuleParserTest.assertEquals((String)"E", (String)e.getObjectType());
        AndDescr and3 = (AndDescr)or.getDescrs().get(2);
        RuleParserTest.assertEquals((int)2, (int)and3.getDescrs().size());
        PatternDescr f = (PatternDescr)and3.getDescrs().get(0);
        PatternDescr g = (PatternDescr)and3.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"F", (String)f.getObjectType());
        RuleParserTest.assertEquals((String)"G", (String)g.getObjectType());
    }

    @Test
    public void testEntryPoint() throws Exception {
        String text = "rule X when StockTick( symbol==\"ACME\") from entry-point StreamA then end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "rule X when StockTick( symbol==\"ACME\") from entry-point StreamA then end");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"symbol==\"ACME\"", (String)fcd.getExpression());
        RuleParserTest.assertNotNull((Object)pattern.getSource());
        EntryPointDescr entry = (EntryPointDescr)pattern.getSource();
        RuleParserTest.assertEquals((String)"StreamA", (String)entry.getEntryId());
    }

    @Test
    public void testEntryPoint2() throws Exception {
        String text = "rule X when StockTick( symbol==\"ACME\") from entry-point \"StreamA\" then end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "rule X when StockTick( symbol==\"ACME\") from entry-point \"StreamA\" then end");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"symbol==\"ACME\"", (String)fcd.getExpression());
        RuleParserTest.assertNotNull((Object)pattern.getSource());
        EntryPointDescr entry = (EntryPointDescr)pattern.getSource();
        RuleParserTest.assertEquals((String)"StreamA", (String)entry.getEntryId());
    }

    @Test
    public void testSlidingWindow() throws Exception {
        String text = "rule X when StockTick( symbol==\"ACME\") over window:length(10) then end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "rule X when StockTick( symbol==\"ACME\") over window:length(10) then end");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"symbol==\"ACME\"", (String)fcd.getExpression());
        List behaviors = pattern.getBehaviors();
        RuleParserTest.assertNotNull((Object)behaviors);
        RuleParserTest.assertEquals((int)1, (int)behaviors.size());
        BehaviorDescr descr = (BehaviorDescr)behaviors.get(0);
        RuleParserTest.assertEquals((String)"window", (String)descr.getType());
        RuleParserTest.assertEquals((String)"length", (String)descr.getSubType());
        RuleParserTest.assertEquals((String)"10", (String)((String)descr.getParameters().get(0)));
    }

    @Test
    public void testRuleOldSyntax1() throws Exception {
        String source = "rule \"Test\" when ( not $r :LiteralRestriction( operator == Operator.EQUAL ) ) then end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "rule \"Test\" when ( not $r :LiteralRestriction( operator == Operator.EQUAL ) ) then end");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((String)"Test", (String)rule.getName());
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        RuleParserTest.assertEquals((int)1, (int)((NotDescr)rule.getLhs().getDescrs().get(0)).getDescrs().size());
        NotDescr notDescr = (NotDescr)rule.getLhs().getDescrs().get(0);
        PatternDescr patternDescr = (PatternDescr)notDescr.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"$r", (String)patternDescr.getIdentifier());
        RuleParserTest.assertEquals((int)1, (int)patternDescr.getDescrs().size());
        ExprConstraintDescr fieldConstraintDescr = (ExprConstraintDescr)patternDescr.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"operator == Operator.EQUAL", (String)fieldConstraintDescr.getExpression());
    }

    @Test
    public void testRuleOldSyntax2() throws Exception {
        String source = "rule \"Test\" when ( $r :LiteralRestriction( operator == Operator.EQUAL ) ) then end";
        PackageDescr pkg = (PackageDescr)this.parse("compilationUnit", "rule \"Test\" when ( $r :LiteralRestriction( operator == Operator.EQUAL ) ) then end");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        RuleDescr rule = (RuleDescr)pkg.getRules().get(0);
        RuleParserTest.assertEquals((String)"Test", (String)rule.getName());
        RuleParserTest.assertEquals((int)1, (int)rule.getLhs().getDescrs().size());
        PatternDescr patternDescr = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"$r", (String)patternDescr.getIdentifier());
        RuleParserTest.assertEquals((int)1, (int)patternDescr.getDescrs().size());
        ExprConstraintDescr fieldConstraintDescr = (ExprConstraintDescr)patternDescr.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"operator == Operator.EQUAL", (String)fieldConstraintDescr.getExpression());
    }

    @Test
    public void testTypeWithMetaData() throws Exception {
        PackageDescr pkg = (PackageDescr)this.parseResource("compilationUnit", "type_with_meta.drl");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        List declarations = pkg.getTypeDeclarations();
        RuleParserTest.assertEquals((int)3, (int)declarations.size());
    }

    @Test
    public void testNullConstraints() throws Exception {
        String text = "rule X when Person( name == null ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( name == null ) then end")).getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)1, (int)pattern.getDescrs().size());
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"name == null", (String)fcd.getExpression());
        RuleParserTest.assertEquals((int)0, (int)fcd.getPosition());
        RuleParserTest.assertEquals((Object)ExprConstraintDescr.Type.NAMED, (Object)fcd.getType());
    }

    @Test
    public void testPositionalConstraintsOnly() throws Exception {
        String text = "rule X when Person( \"Mark\", 42; ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( \"Mark\", 42; ) then end")).getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)2, (int)pattern.getDescrs().size());
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"\"Mark\"", (String)fcd.getExpression());
        RuleParserTest.assertEquals((int)0, (int)fcd.getPosition());
        RuleParserTest.assertEquals((Object)ExprConstraintDescr.Type.POSITIONAL, (Object)fcd.getType());
        fcd = (ExprConstraintDescr)pattern.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"42", (String)fcd.getExpression());
        RuleParserTest.assertEquals((int)1, (int)fcd.getPosition());
        RuleParserTest.assertEquals((Object)ExprConstraintDescr.Type.POSITIONAL, (Object)fcd.getType());
    }

    @Test
    public void testIsQuery() throws Exception {
        String text = "rule X when ?person( \"Mark\", 42; ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when ?person( \"Mark\", 42; ) then end")).getLhs().getDescrs().get(0);
        RuleParserTest.assertTrue((boolean)pattern.isQuery());
        RuleParserTest.assertEquals((int)2, (int)pattern.getDescrs().size());
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"\"Mark\"", (String)fcd.getExpression());
        RuleParserTest.assertEquals((int)0, (int)fcd.getPosition());
        RuleParserTest.assertEquals((Object)ExprConstraintDescr.Type.POSITIONAL, (Object)fcd.getType());
        fcd = (ExprConstraintDescr)pattern.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"42", (String)fcd.getExpression());
        RuleParserTest.assertEquals((int)1, (int)fcd.getPosition());
        RuleParserTest.assertEquals((Object)ExprConstraintDescr.Type.POSITIONAL, (Object)fcd.getType());
    }

    @Test
    public void testFromFollowedByQuery() throws Exception {
        String text = "rule X when Cheese() from $cheesery ?person( \"Mark\", 42; ) then end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X when Cheese() from $cheesery ?person( \"Mark\", 42; ) then end");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((String)"from $cheesery", (String)pattern.getSource().getText());
        RuleParserTest.assertFalse((boolean)pattern.isQuery());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"person", (String)pattern.getObjectType());
        RuleParserTest.assertTrue((boolean)pattern.isQuery());
    }

    @Test
    public void testFromWithTernaryFollowedByQuery() throws Exception {
        String text = "rule X when Cheese() from (isFull ? $cheesery : $market) ?person( \"Mark\", 42; ) then end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X when Cheese() from (isFull ? $cheesery : $market) ?person( \"Mark\", 42; ) then end");
        RuleParserTest.assertFalse((String)this.parser.getErrors().toString(), (boolean)this.parser.hasErrors());
        PatternDescr pattern = (PatternDescr)rule.getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((String)"Cheese", (String)pattern.getObjectType());
        RuleParserTest.assertEquals((String)"from (isFull ? $cheesery : $market)", (String)pattern.getSource().getText());
        RuleParserTest.assertFalse((boolean)pattern.isQuery());
        pattern = (PatternDescr)rule.getLhs().getDescrs().get(1);
        RuleParserTest.assertEquals((String)"person", (String)pattern.getObjectType());
        RuleParserTest.assertTrue((boolean)pattern.isQuery());
    }

    @Test
    public void testMultiValueAnnotationsBackwardCompatibility() throws Exception {
        String text = "rule X @ann1( val1, val2 ) @ann2( \"val1\", \"val2\" ) when then end";
        RuleDescr rule = (RuleDescr)this.parse("rule", "rule X @ann1( val1, val2 ) @ann2( \"val1\", \"val2\" ) when then end");
        AnnotationDescr ann = rule.getAnnotation("ann1");
        RuleParserTest.assertNotNull((Object)ann);
        RuleParserTest.assertEquals((Object)"val1, val2", (Object)ann.getValue());
        ann = rule.getAnnotation("ann2");
        RuleParserTest.assertNotNull((Object)ann);
        RuleParserTest.assertEquals((Object)"\"val1\", \"val2\"", (Object)ann.getValue());
    }

    @Test
    public void testPositionalsAndNamedConstraints() throws Exception {
        String text = "rule X when Person( \"Mark\", 42; location == \"atlanta\" ) then end";
        PatternDescr pattern = (PatternDescr)((RuleDescr)this.parse("rule", "rule X when Person( \"Mark\", 42; location == \"atlanta\" ) then end")).getLhs().getDescrs().get(0);
        RuleParserTest.assertEquals((int)3, (int)pattern.getDescrs().size());
        ExprConstraintDescr fcd = (ExprConstraintDescr)pattern.getDescrs().get(0);
        RuleParserTest.assertEquals((String)"\"Mark\"", (String)fcd.getExpression());
        RuleParserTest.assertEquals((int)0, (int)fcd.getPosition());
        RuleParserTest.assertEquals((Object)ExprConstraintDescr.Type.POSITIONAL, (Object)fcd.getType());
        fcd = (ExprConstraintDescr)pattern.getDescrs().get(1);
        RuleParserTest.assertEquals((String)"42", (String)fcd.getExpression());
        RuleParserTest.assertEquals((int)1, (int)fcd.getPosition());
        RuleParserTest.assertEquals((Object)ExprConstraintDescr.Type.POSITIONAL, (Object)fcd.getType());
        fcd = (ExprConstraintDescr)pattern.getDescrs().get(2);
        RuleParserTest.assertEquals((String)"location == \"atlanta\"", (String)fcd.getExpression());
        RuleParserTest.assertEquals((int)2, (int)fcd.getPosition());
        RuleParserTest.assertEquals((Object)ExprConstraintDescr.Type.NAMED, (Object)fcd.getType());
    }

    private Object parse(String parserRuleName, String text) throws Exception {
        return this.execParser(parserRuleName, (CharStream)new ANTLRStringStream(text));
    }

    private Object parseResource(String parserRuleName, String name) throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(name));
        StringBuilder text = new StringBuilder();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return this.parse(parserRuleName, text.toString());
    }

    public Object execParser(String testRuleName, CharStream charStream) {
        try {
            this.createParser(charStream);
            Method ruleName = DRLParser.class.getMethod(testRuleName, new Class[0]);
            Object ruleReturn = ruleName.invoke((Object)this.parser, new Object[0]);
            if (this.parser.hasErrors()) {
                System.out.println(this.parser.getErrorMessages());
            }
            return ruleReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            RuleParserTest.fail((String)e.getMessage());
            return null;
        }
    }

    private void createParser(CharStream charStream) {
        DRLLexer lexer = new DRLLexer(charStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        this.parser = new DRLParser((TokenStream)tokens);
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        RuleParserTest.assertEquals((String)cleanExpected, (String)cleanActual);
    }

    private Reader getReader(String name) throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(name);
        return new InputStreamReader(in);
    }
}

