/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.lang.ExpanderException;
import org.drools.lang.dsl.DSLMappingFile;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.lang.dsl.DefaultExpander;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultExpanderTest {
    private DSLMappingFile file = null;
    private DSLTokenizedMappingFile tokenizedFile = null;
    private DefaultExpander expander = null;

    @Before
    public void setUp() throws Exception {
        String filename = "test_metainfo.dsl";
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_metainfo.dsl"));
        this.file = new DSLTokenizedMappingFile();
        this.tokenizedFile = new DSLTokenizedMappingFile();
        this.file.parseAndLoad((Reader)reader);
        ((Reader)reader).close();
        InputStreamReader reader2 = new InputStreamReader(this.getClass().getResourceAsStream("test_metainfo.dsl"));
        this.tokenizedFile.parseAndLoad((Reader)reader2);
        ((Reader)reader2).close();
        this.expander = new DefaultExpander();
    }

    @Test
    public void testAddDSLMapping() {
        this.expander.addDSLMapping(this.file.getMapping());
    }

    @Test
    public void testANTLRAddDSLMapping() {
        this.expander.addDSLMapping(this.tokenizedFile.getMapping());
    }

    @Test
    public void testRegexp() throws Exception {
        this.expander.addDSLMapping(this.file.getMapping());
        InputStreamReader rules = new InputStreamReader(this.getClass().getResourceAsStream("test_expansion.dslr"));
        String result = this.expander.expand((Reader)rules);
    }

    @Test
    public void testANTLRRegexp() throws Exception {
        this.expander.addDSLMapping(this.tokenizedFile.getMapping());
        InputStreamReader rules = new InputStreamReader(this.getClass().getResourceAsStream("test_expansion.dslr"));
        String result = this.expander.expand((Reader)rules);
    }

    @Test
    public void testExpandParts() throws Exception {
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        String dsl = "[when]foo=Foo()\n[then]bar {num}=baz({num});";
        file.parseAndLoad((Reader)new StringReader(dsl));
        Assert.assertEquals((long)0L, (long)file.getErrors().size());
        DefaultExpander ex = new DefaultExpander();
        ex.addDSLMapping(file.getMapping());
    }

    @Test
    public void testExpandKeyword() throws Exception {
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        String dsl = "[keyword]key {param}=Foo( attr=={param} )";
        file.parseAndLoad((Reader)new StringReader(dsl));
        Assert.assertEquals((long)0L, (long)file.getErrors().size());
        DefaultExpander ex = new DefaultExpander();
        ex.addDSLMapping(file.getMapping());
        String source = "rule x\nwhen\n key 1 \n key 2 \nthen\nend";
        String drl = ex.expand(source);
        System.out.println(drl);
        Assert.assertTrue((boolean)drl.contains("attr==1"));
        Assert.assertTrue((boolean)drl.contains("attr==2"));
    }

    @Test
    public void testANTLRExpandParts() throws Exception {
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        String dsl = "[when]foo=Foo()\n[then]bar {num}=baz({num});";
        file.parseAndLoad((Reader)new StringReader(dsl));
        Assert.assertEquals((long)0L, (long)file.getErrors().size());
        DefaultExpander ex = new DefaultExpander();
        ex.addDSLMapping(file.getMapping());
    }

    @Test
    public void testExpandFailure() throws Exception {
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        String dsl = "[when]foo=Foo()\n[then]bar {num}=baz({num});";
        file.parseAndLoad((Reader)new StringReader(dsl));
        Assert.assertEquals((long)0L, (long)file.getErrors().size());
        DefaultExpander ex = new DefaultExpander();
        ex.addDSLMapping(file.getMapping());
        String source = "rule 'q'\nagenda-group 'x'\nwhen\n    foo  \nthen\n    bar 42\nend";
        String drl = ex.expand(source);
        Assert.assertFalse((boolean)ex.hasErrors());
        ex = new DefaultExpander();
        ex.addDSLMapping(file.getMapping());
        source = "rule 'q' agenda-group 'x'\nwhen\n    foos \nthen\n    bar 42\n end";
        drl = ex.expand(source);
        Assert.assertTrue((boolean)ex.hasErrors());
        Assert.assertEquals((long)1L, (long)ex.getErrors().size());
    }

    @Test
    public void testANTLRExpandFailure() throws Exception {
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        String dsl = "[when]foo=Foo()\n[then]bar {num}=baz({num});";
        file.parseAndLoad((Reader)new StringReader(dsl));
        Assert.assertEquals((long)0L, (long)file.getErrors().size());
        DefaultExpander ex = new DefaultExpander();
        ex.addDSLMapping(file.getMapping());
        String source = "rule 'q'\nagenda-group 'x'\nwhen\n    foo  \nthen\n    bar 42\nend";
        String drl = ex.expand(source);
        Assert.assertFalse((boolean)ex.hasErrors());
        ex = new DefaultExpander();
        ex.addDSLMapping(file.getMapping());
        source = "rule 'q' agenda-group 'x'\nwhen\n    foos \nthen\n    bar 42\n end";
        drl = ex.expand(source);
        Assert.assertTrue((boolean)ex.hasErrors());
        Assert.assertEquals((long)1L, (long)ex.getErrors().size());
    }

    @Test
    public void testExpandWithKeywordClashes() throws Exception {
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        String dsl = "[when]Invoke rule executor=ruleExec: RuleExecutor()\n[then]Execute rule \"{id}\"=ruleExec.ExecuteSubRule( new Long({id}));";
        file.parseAndLoad((Reader)new StringReader(dsl));
        Assert.assertEquals((long)0L, (long)file.getErrors().size());
        DefaultExpander ex = new DefaultExpander();
        ex.addDSLMapping(file.getMapping());
        String source = "package something;\n\nrule \"1\"\nwhen\n    Invoke rule executor\nthen\n    Execute rule \"5\"\nend";
        String expected = "package something;\n\nrule \"1\"\nwhen\n   ruleExec: RuleExecutor()\nthen\n   ruleExec.ExecuteSubRule( new Long(5));\nend\n";
        String drl = ex.expand(source);
        Assert.assertFalse((boolean)ex.hasErrors());
        this.equalsIgnoreWhiteSpace(expected, drl);
    }

    @Test
    public void testANTLRExpandWithKeywordClashes() throws Exception {
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        String dsl = "[when]Invoke rule executor=ruleExec: RuleExecutor()\n[then]Execute rule \"{id}\"=ruleExec.ExecuteSubRule( new Long({id}));";
        file.parseAndLoad((Reader)new StringReader(dsl));
        Assert.assertEquals((long)0L, (long)file.getErrors().size());
        DefaultExpander ex = new DefaultExpander();
        ex.addDSLMapping(file.getMapping());
        String source = "package something;\n\nrule \"1\"\nwhen\n    Invoke rule executor\nthen\n    Execute rule \"5\"\nend";
        String expected = "package something;\n\nrule \"1\"\nwhen\n    ruleExec: RuleExecutor()\nthen\n    ruleExec.ExecuteSubRule( new Long(5));\nend";
        String drl = ex.expand(source);
        Assert.assertFalse((boolean)ex.hasErrors());
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    @Test
    public void testLineNumberError() throws Exception {
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        String dsl = "[when]foo=Foo()\n[then]bar {num}=baz({num});";
        file.parseAndLoad((Reader)new StringReader(dsl));
        DefaultExpander ex = new DefaultExpander();
        ex.addDSLMapping(file.getMapping());
        String source = "rule 'q'\nagenda-group 'x'\nwhen\n    __  \nthen\n    bar 42\n\tgoober\nend";
        ex.expand(source);
        Assert.assertTrue((boolean)ex.hasErrors());
        Assert.assertEquals((long)2L, (long)ex.getErrors().size());
        ExpanderException err = (ExpanderException)ex.getErrors().get(0);
        Assert.assertEquals((long)4L, (long)err.getLine());
        err = (ExpanderException)ex.getErrors().get(1);
        Assert.assertEquals((long)7L, (long)err.getLine());
    }

    @Test
    public void testANTLRLineNumberError() throws Exception {
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        String dsl = "[when]foo=Foo()\n[then]bar {num}=baz({num});";
        file.parseAndLoad((Reader)new StringReader(dsl));
        DefaultExpander ex = new DefaultExpander();
        ex.addDSLMapping(file.getMapping());
        String source = "rule 'q'\nagenda-group 'x'\nwhen\n    __  \nthen\n    bar 42\n\tgoober\nend";
        ex.expand(source);
        Assert.assertTrue((boolean)ex.hasErrors());
        Assert.assertEquals((long)2L, (long)ex.getErrors().size());
        ExpanderException err = (ExpanderException)ex.getErrors().get(0);
        Assert.assertEquals((long)4L, (long)err.getLine());
        err = (ExpanderException)ex.getErrors().get(1);
        Assert.assertEquals((long)7L, (long)err.getLine());
    }

    @Test
    public void testANTLREnumExpand() throws Exception {
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        String dsl = "[when]When the credit rating is {rating:ENUM:Applicant.creditRating} = applicant:Applicant(credit=={rating})";
        file.parseAndLoad((Reader)new StringReader(dsl));
        Assert.assertEquals((long)0L, (long)file.getErrors().size());
        DefaultExpander ex = new DefaultExpander();
        ex.addDSLMapping(file.getMapping());
        String source = "rule \"TestNewDslSetup\"\ndialect \"mvel\"\nwhen\nWhen the credit rating is AA\nthen \nend";
        String drl = ex.expand(source);
        String expected = "rule \"TestNewDslSetup\"\ndialect \"mvel\"\nwhen\napplicant:Applicant(credit==AA)\nthen  \nend";
        Assert.assertFalse((String)ex.getErrors().toString(), (boolean)ex.hasErrors());
        Assert.assertEquals((Object)expected, (Object)drl);
    }

    private boolean equalsIgnoreWhiteSpace(String expected, String actual) {
        String patternStr = expected.replaceAll("\\s+", "(\\\\s|\\\\n|\\\\r)*");
        Pattern pattern = Pattern.compile(patternStr, 32);
        Matcher m = pattern.matcher(actual);
        return m.matches();
    }
}

