/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.mvel;

import org.drools.Cheese;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.base.mvel.MVELCompileable;
import org.drools.common.InternalFactHandle;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.reteoo.InitialFactImpl;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.MockLeftTupleSink;
import org.drools.rule.Accumulate;
import org.drools.rule.Package;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.dialect.mvel.MVELAccumulateBuilder;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.spi.Tuple;
import org.junit.Assert;
import org.junit.Test;

public class MVELAccumulateBuilderTest {
    @Test
    public void testSimpleExpression() {
        PackageBuilder pkgBuilder = new PackageBuilder();
        pkgBuilder.addPackage(new PackageDescr("pkg1"));
        Package pkg = pkgBuilder.getPackage();
        RuleDescr ruleDescr = new RuleDescr("rule 1");
        PackageBuilderConfiguration conf = pkgBuilder.getPackageBuilderConfiguration();
        DialectCompiletimeRegistry dialectRegistry = pkgBuilder.getPackageRegistry(pkg.getName()).getDialectCompiletimeRegistry();
        MVELDialect mvelDialect = (MVELDialect)dialectRegistry.getDialect("mvel");
        RuleBuildContext context = new RuleBuildContext(pkgBuilder, ruleDescr, dialectRegistry, pkg, (Dialect)mvelDialect);
        AccumulateDescr accDescr = new AccumulateDescr();
        PatternDescr inputPattern = new PatternDescr("org.drools.Cheese", "$cheese");
        accDescr.setInputPattern(inputPattern);
        accDescr.setInitCode("total = 0;");
        accDescr.setActionCode("total += $cheese.price;");
        accDescr.setReverseCode("total -= $cheese.price;");
        accDescr.setResultCode("new Integer(total)");
        MVELAccumulateBuilder builder = new MVELAccumulateBuilder();
        Accumulate acc = (Accumulate)builder.build(context, (BaseDescr)accDescr);
        ((MVELCompileable)acc.getAccumulators()[0]).compile((ClassLoader)pkgBuilder.getRootClassLoader());
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        StatefulSession wm = ruleBase.newStatefulSession();
        MockLeftTupleSink sink = new MockLeftTupleSink();
        Cheese cheddar1 = new Cheese("cheddar", 10);
        Cheese cheddar2 = new Cheese("cheddar", 8);
        InternalFactHandle f0 = (InternalFactHandle)wm.insert((Object)new InitialFactImpl());
        InternalFactHandle f1 = (InternalFactHandle)wm.insert((Object)cheddar1);
        InternalFactHandle f2 = (InternalFactHandle)wm.insert((Object)cheddar2);
        LeftTuple tuple = new LeftTuple(f0, (LeftTupleSink)sink, true);
        Object[] wmContext = acc.createWorkingMemoryContext();
        Object[] accContext = acc.createContext();
        acc.init(wmContext, accContext, (Tuple)tuple, (WorkingMemory)wm);
        acc.accumulate(wmContext, accContext, (Tuple)tuple, f1, (WorkingMemory)wm);
        acc.accumulate(wmContext, accContext, (Tuple)tuple, f2, (WorkingMemory)wm);
        Assert.assertEquals((Object)new Integer(18), (Object)acc.getResult(wmContext, accContext, (Tuple)tuple, (WorkingMemory)wm)[0]);
        acc.reverse(wmContext, accContext, (Tuple)tuple, f1, (WorkingMemory)wm);
        Assert.assertEquals((Object)new Integer(8), (Object)acc.getResult(wmContext, accContext, (Tuple)tuple, (WorkingMemory)wm)[0]);
    }
}

