/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.drools.base.accumulators.JavaAccumulatorFunctionExecutor;
import org.drools.compiler.AnalysisResult;
import org.drools.compiler.BoundIdentifiers;
import org.drools.compiler.DescrBuildError;
import org.drools.lang.descr.AccumulateDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.rule.Accumulate;
import org.drools.rule.Declaration;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.builder.AccumulateBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.rule.builder.RuleConditionBuilder;
import org.drools.rule.builder.dialect.java.AbstractJavaRuleBuilder;
import org.drools.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.rule.builder.dialect.java.parser.JavaLocalDeclarationDescr;
import org.drools.runtime.rule.AccumulateFunction;
import org.drools.spi.Accumulator;
import org.drools.spi.DeclarationScopeResolver;

public class JavaAccumulateBuilder
extends AbstractJavaRuleBuilder
implements AccumulateBuilder {
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        AccumulateDescr accumDescr = (AccumulateDescr)descr;
        if (!accumDescr.hasValidInput()) {
            return null;
        }
        RuleConditionBuilder builder = (RuleConditionBuilder)context.getDialect().getBuilder(accumDescr.getInput().getClass());
        RuleConditionElement source = builder.build(context, accumDescr.getInput());
        Map decls = context.getDeclarationResolver().getDeclarations(context.getRule());
        context.getDeclarationResolver();
        Map declCls = DeclarationScopeResolver.getDeclarationClasses((Map)decls);
        if (source == null) {
            return null;
        }
        Accumulate accumulate = null;
        if (accumDescr.isExternalFunction()) {
            AccumulateDescr.AccumulateFunctionCallDescr func = accumDescr.getFunctions().get(0);
            AccumulateFunction function = context.getConfiguration().getAccumulateFunction(func.getFunction());
            if (function == null) {
                context.getErrors().add(new DescrBuildError(accumDescr, context.getRuleDescr(), null, "Unknown accumulate function: '" + func.getFunction() + "' on rule '" + context.getRuleDescr().getName() + "'. All accumulate functions must be registered before building a resource."));
                return null;
            }
            JavaAnalysisResult analysis = (JavaAnalysisResult)context.getDialect().analyzeBlock(context, accumDescr, func.getParams().length > 0 ? func.getParams()[0] : "\"\"", new BoundIdentifiers(declCls, context.getPackageBuilder().getGlobals()));
            BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
            Declaration[] previousDeclarations = usedIdentifiers.getDeclarations().values().toArray(new Declaration[usedIdentifiers.getDeclarations().size()]);
            Declaration[] sourceDeclArr = source.getOuterDeclarations().values().toArray(new Declaration[0]);
            String className = "accumulateExpression" + context.getNextId();
            Map<String, Object> map = this.createVariableContext(className, func.getParams().length > 0 ? func.getParams()[0] : "\"\"", context, previousDeclarations, sourceDeclArr, usedIdentifiers.getGlobals(), null);
            map.put("readLocalsFromTuple", accumDescr.isMultiPattern() ? Boolean.TRUE : Boolean.FALSE);
            JavaAccumulatorFunctionExecutor accumulator = new JavaAccumulatorFunctionExecutor(function);
            accumulate = new Accumulate(source, previousDeclarations, sourceDeclArr, new Accumulator[]{accumulator});
            JavaAccumulateBuilder.generatTemplates("returnValueMethod", "returnValueInvoker", context, className, map, accumulator, accumDescr);
        } else {
            String className = "Accumulate" + context.getNextId();
            accumDescr.setClassName(className);
            BoundIdentifiers available = new BoundIdentifiers(declCls, context.getPackageBuilder().getGlobals());
            JavaAnalysisResult initCodeAnalysis = (JavaAnalysisResult)context.getDialect().analyzeBlock(context, accumDescr, accumDescr.getInitCode(), available);
            AnalysisResult actionCodeAnalysis = context.getDialect().analyzeBlock(context, accumDescr, accumDescr.getActionCode(), available);
            AnalysisResult resultCodeAnalysis = context.getDialect().analyzeExpression(context, accumDescr, accumDescr.getResultCode(), available);
            HashSet<String> requiredDeclarations = new HashSet<String>(initCodeAnalysis.getBoundIdentifiers().getDeclarations().keySet());
            requiredDeclarations.addAll(actionCodeAnalysis.getBoundIdentifiers().getDeclarations().keySet());
            requiredDeclarations.addAll(resultCodeAnalysis.getBoundIdentifiers().getDeclarations().keySet());
            HashMap requiredGlobals = new HashMap(initCodeAnalysis.getBoundIdentifiers().getGlobals());
            requiredGlobals.putAll(actionCodeAnalysis.getBoundIdentifiers().getGlobals());
            requiredGlobals.putAll(resultCodeAnalysis.getBoundIdentifiers().getGlobals());
            if (accumDescr.getReverseCode() != null) {
                AnalysisResult reverseCodeAnalysis = context.getDialect().analyzeBlock(context, accumDescr, accumDescr.getActionCode(), available);
                requiredDeclarations.addAll(reverseCodeAnalysis.getBoundIdentifiers().getDeclarations().keySet());
                requiredGlobals.putAll(reverseCodeAnalysis.getBoundIdentifiers().getGlobals());
            }
            Declaration[] declarations = new Declaration[requiredDeclarations.size()];
            int i = 0;
            Iterator it = requiredDeclarations.iterator();
            while (it.hasNext()) {
                declarations[i] = (Declaration)decls.get(it.next());
                ++i;
            }
            Declaration[] sourceDeclArr = source.getOuterDeclarations().values().toArray(new Declaration[0]);
            Map<String, Object> map = this.createVariableContext(className, null, context, declarations, null, requiredGlobals, null);
            map.put("className", accumDescr.getClassName());
            map.put("innerDeclarations", sourceDeclArr);
            map.put("isMultiPattern", accumDescr.isMultiPattern() ? Boolean.TRUE : Boolean.FALSE);
            String initCode = this.fixInitCode(initCodeAnalysis, accumDescr.getInitCode());
            String actionCode = accumDescr.getActionCode();
            String resultCode = accumDescr.getResultCode();
            String[] attributesTypes = new String[initCodeAnalysis.getLocalVariablesMap().size()];
            String[] attributes = new String[initCodeAnalysis.getLocalVariablesMap().size()];
            int index = 0;
            for (Map.Entry<String, JavaLocalDeclarationDescr> entry : initCodeAnalysis.getLocalVariablesMap().entrySet()) {
                attributes[index] = entry.getKey();
                attributesTypes[index] = entry.getValue().getType();
                ++index;
            }
            map.put("attributes", attributes);
            map.put("attributesTypes", attributesTypes);
            map.put("initCode", initCode);
            map.put("actionCode", actionCode);
            map.put("resultCode", resultCode);
            if (accumDescr.getReverseCode() == null) {
                map.put("reverseCode", "");
                map.put("supportsReverse", "false");
            } else {
                map.put("reverseCode", accumDescr.getReverseCode());
                map.put("supportsReverse", "true");
            }
            map.put("hashCode", new Integer(actionCode.hashCode()));
            accumulate = new Accumulate(source, declarations, sourceDeclArr);
            JavaAccumulateBuilder.generatTemplates("accumulateInnerClass", "accumulateInvoker", context, className, map, accumulate, accumDescr);
        }
        return accumulate;
    }

    protected String fixInitCode(JavaAnalysisResult analysis, String originalCode) {
        TreeSet<JavaLocalDeclarationDescr> locals = new TreeSet<JavaLocalDeclarationDescr>(new Comparator<JavaLocalDeclarationDescr>(){

            @Override
            public int compare(JavaLocalDeclarationDescr o1, JavaLocalDeclarationDescr o2) {
                return o1.getStart() - o2.getStart();
            }
        });
        Iterator<JavaLocalDeclarationDescr> it = analysis.getLocalVariablesMap().values().iterator();
        while (it.hasNext()) {
            locals.add(it.next());
        }
        StringBuilder initCode = new StringBuilder();
        int lastAdded = 0;
        for (JavaLocalDeclarationDescr d : locals) {
            initCode.append(originalCode.substring(lastAdded, d.getStart()));
            lastAdded = d.getEnd();
            for (JavaLocalDeclarationDescr.IdentifierDescr id : d.getIdentifiers()) {
                initCode.append(originalCode.substring(id.getStart(), id.getEnd()));
                initCode.append(";");
                for (lastAdded = id.getEnd(); lastAdded < originalCode.length() && (Character.isWhitespace(originalCode.charAt(lastAdded)) || originalCode.charAt(lastAdded) == ';'); ++lastAdded) {
                }
            }
        }
        initCode.append(originalCode.substring(lastAdded));
        return initCode.toString();
    }
}

