/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.agent.BaseKnowledgeAgentTest;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.RuleAttributeAsserter;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.definition.KnowledgePackage;
import org.drools.io.ResourceFactory;
import org.drools.rule.Rule;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Assert;
import org.junit.Test;

public class KnowledgeAgentBinaryDiffTests
extends BaseKnowledgeAgentTest {
    @Test
    public void testDifferentDateExpires() throws Exception {
        String attribute1 = "date-expires \"4-jan-2010\"";
        String attribute2 = "date-expires \"5-jan-2010\"";
        RuleAttributeAsserter asserter = new RuleAttributeAsserter(){

            public void assertRuleAttribute(String attribute, Rule rule) {
                if (attribute.equals("date-expires \"4-jan-2010\"")) {
                    Assert.assertEquals((long)2010L, (long)rule.getDateExpires().get(1));
                    Assert.assertEquals((long)0L, (long)rule.getDateExpires().get(2));
                    Assert.assertEquals((long)4L, (long)rule.getDateExpires().get(5));
                } else if (attribute.equals("date-expires \"5-jan-2010\"")) {
                    Assert.assertEquals((long)2010L, (long)rule.getDateExpires().get(1));
                    Assert.assertEquals((long)0L, (long)rule.getDateExpires().get(2));
                    Assert.assertEquals((long)5L, (long)rule.getDateExpires().get(5));
                } else {
                    throw new IllegalArgumentException("Unexpected attribute " + attribute);
                }
            }
        };
        this.differentRuleAttributeTest("date-expires \"4-jan-2010\"", "date-expires \"5-jan-2010\"", asserter);
    }

    @Test
    public void testDifferentDateEffective() throws Exception {
        String attribute1 = "date-effective \"4-jan-2010\"";
        String attribute2 = "date-effective \"5-jan-2010\"";
        RuleAttributeAsserter asserter = new RuleAttributeAsserter(){

            public void assertRuleAttribute(String attribute, Rule rule) {
                if (attribute.equals("date-effective \"4-jan-2010\"")) {
                    Assert.assertEquals((long)2010L, (long)rule.getDateEffective().get(1));
                    Assert.assertEquals((long)0L, (long)rule.getDateEffective().get(2));
                    Assert.assertEquals((long)4L, (long)rule.getDateEffective().get(5));
                } else if (attribute.equals("date-effective \"5-jan-2010\"")) {
                    Assert.assertEquals((long)2010L, (long)rule.getDateEffective().get(1));
                    Assert.assertEquals((long)0L, (long)rule.getDateEffective().get(2));
                    Assert.assertEquals((long)5L, (long)rule.getDateEffective().get(5));
                } else {
                    throw new IllegalArgumentException("Unexpected attribute " + attribute);
                }
            }
        };
        this.differentRuleAttributeTest("date-effective \"4-jan-2010\"", "date-effective \"5-jan-2010\"", asserter);
    }

    @Test
    public void testDifferentDialect() throws Exception {
        String attribute1 = "dialect \"java\"";
        String attribute2 = "dialect \"mvel\"";
        RuleAttributeAsserter asserter = new RuleAttributeAsserter(){

            public void assertRuleAttribute(String attribute, Rule rule) {
                if (attribute.equals("dialect \"java\"")) {
                    Assert.assertEquals((Object)"java", (Object)rule.getDialect());
                } else if (attribute.equals("dialect \"mvel\"")) {
                    Assert.assertEquals((Object)"mvel", (Object)rule.getDialect());
                } else {
                    throw new IllegalArgumentException("Unexpected attribute " + attribute);
                }
            }
        };
        this.differentRuleAttributeTest("dialect \"java\"", "dialect \"mvel\"", asserter);
    }

    @Test
    public void testDifferentRuleFlowGroup() throws Exception {
        String attribute1 = "ruleflow-group \"g1\"";
        String attribute2 = "ruleflow-group \"g2\"";
        RuleAttributeAsserter asserter = new RuleAttributeAsserter(){

            public void assertRuleAttribute(String attribute, Rule rule) {
                if (attribute.equals("ruleflow-group \"g1\"")) {
                    Assert.assertEquals((Object)"g1", (Object)rule.getRuleFlowGroup());
                } else if (attribute.equals("ruleflow-group \"g2\"")) {
                    Assert.assertEquals((Object)"g2", (Object)rule.getRuleFlowGroup());
                } else {
                    throw new IllegalArgumentException("Unexpected attribute " + attribute);
                }
            }
        };
        this.differentRuleAttributeTest("ruleflow-group \"g1\"", "ruleflow-group \"g2\"", asserter);
    }

    @Test
    public void testDifferentAutoFocus() throws Exception {
        String attribute1 = "auto-focus false";
        String attribute2 = "auto-focus true";
        RuleAttributeAsserter asserter = new RuleAttributeAsserter(){

            public void assertRuleAttribute(String attribute, Rule rule) {
                if (attribute.equals("auto-focus false")) {
                    Assert.assertEquals((Object)false, (Object)rule.getAutoFocus());
                } else if (attribute.equals("auto-focus true")) {
                    Assert.assertEquals((Object)true, (Object)rule.getAutoFocus());
                } else {
                    throw new IllegalArgumentException("Unexpected attribute " + attribute);
                }
            }
        };
        this.differentRuleAttributeTest("auto-focus false", "auto-focus true", asserter);
    }

    @Test
    public void testDifferentAgendaGroup() throws Exception {
        String attribute1 = "agenda-group \"g1\"";
        String attribute2 = "agenda-group \"g2\"";
        RuleAttributeAsserter asserter = new RuleAttributeAsserter(){

            public void assertRuleAttribute(String attribute, Rule rule) {
                if (attribute.equals("agenda-group \"g1\"")) {
                    Assert.assertEquals((Object)"g1", (Object)rule.getAgendaGroup());
                } else if (attribute.equals("agenda-group \"g2\"")) {
                    Assert.assertEquals((Object)"g2", (Object)rule.getAgendaGroup());
                } else {
                    throw new IllegalArgumentException("Unexpected attribute " + attribute);
                }
            }
        };
        this.differentRuleAttributeTest("agenda-group \"g1\"", "agenda-group \"g2\"", asserter);
    }

    @Test
    public void testDifferentLockOnActive() throws Exception {
        String attribute1 = "lock-on-active false";
        String attribute2 = "lock-on-active true";
        RuleAttributeAsserter asserter = new RuleAttributeAsserter(){

            public void assertRuleAttribute(String attribute, Rule rule) {
                if (attribute.equals("lock-on-active false")) {
                    Assert.assertEquals((Object)false, (Object)rule.isLockOnActive());
                } else if (attribute.equals("lock-on-active true")) {
                    Assert.assertEquals((Object)true, (Object)rule.isLockOnActive());
                } else {
                    throw new IllegalArgumentException("Unexpected attribute " + attribute);
                }
            }
        };
        this.differentRuleAttributeTest("lock-on-active false", "lock-on-active true", asserter);
    }

    @Test
    public void testDifferentNoLoop() throws Exception {
        String attribute1 = "no-loop false";
        String attribute2 = "no-loop true";
        RuleAttributeAsserter asserter = new RuleAttributeAsserter(){

            public void assertRuleAttribute(String attribute, Rule rule) {
                if (attribute.equals("no-loop false")) {
                    Assert.assertEquals((Object)false, (Object)rule.isNoLoop());
                } else if (attribute.equals("no-loop true")) {
                    Assert.assertEquals((Object)true, (Object)rule.isNoLoop());
                } else {
                    throw new IllegalArgumentException("Unexpected attribute " + attribute);
                }
            }
        };
        this.differentRuleAttributeTest("no-loop false", "no-loop true", asserter);
    }

    @Test
    public void testDifferentActivationGroup() throws Exception {
        String attribute1 = "activation-group \"1\"";
        String attribute2 = "activation-group \"2\"";
        RuleAttributeAsserter asserter = new RuleAttributeAsserter(){

            public void assertRuleAttribute(String attribute, Rule rule) {
                if (attribute.equals("activation-group \"1\"")) {
                    Assert.assertEquals((Object)"1", (Object)rule.getActivationGroup());
                } else if (attribute.equals("activation-group \"2\"")) {
                    Assert.assertEquals((Object)"2", (Object)rule.getActivationGroup());
                } else {
                    throw new IllegalArgumentException("Unexpected attribute " + attribute);
                }
            }
        };
        this.differentRuleAttributeTest("activation-group \"1\"", "activation-group \"2\"", asserter);
    }

    @Test
    public void testDifferentSalience() throws Exception {
        String attribute1 = "salience 1";
        String attribute2 = "salience 2";
        RuleAttributeAsserter asserter = new RuleAttributeAsserter(){

            public void assertRuleAttribute(String attribute, Rule rule) {
                if (attribute.equals("salience 1")) {
                    Assert.assertEquals((Object)"1", (Object)rule.getSalience().toString());
                } else if (attribute.equals("salience 2")) {
                    Assert.assertEquals((Object)"2", (Object)rule.getSalience().toString());
                } else {
                    throw new IllegalArgumentException("Unexpected attribute " + attribute);
                }
            }
        };
        this.differentRuleAttributeTest("salience 1", "salience 2", asserter);
    }

    @Test
    public void testDifferentLHS() throws Exception {
        File f1 = this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        list.clear();
        File f2 = this.fileManager.write("rule1.drl", this.createVersionedRule("rule1", "2"));
        this.scan(kagent);
        ksession = kbase.newStatefulKnowledgeSession();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"Some String");
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1-V2"));
        kagent.dispose();
    }

    @Test
    public void testDifferentConsequences() throws Exception {
        File f1 = this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        list.clear();
        this.fileManager.write("rule1.drl", this.createVersionedRule("rule1", "2"));
        this.scan(kagent);
        ksession = kbase.newStatefulKnowledgeSession();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"Some String");
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1-V2"));
        kagent.dispose();
    }

    @Test
    public void testEvalCondition() throws Exception {
        String rule1 = "";
        rule1 = rule1 + "package org.drools\n";
        rule1 = rule1 + "global Integer salesChannelId;\n";
        rule1 = rule1 + "global Boolean includeFinishing;\n";
        rule1 = rule1 + "global java.util.List list;\n";
        rule1 = rule1 + "rule \"Rule A\"\n";
        rule1 = rule1 + "  dialect \"java\"\n";
        rule1 = rule1 + "  ruleflow-group \"finishing-price\"\n";
        rule1 = rule1 + "  when\n";
        rule1 = rule1 + "      $s : String()\n";
        rule1 = rule1 + "      eval(salesChannelId @operator@ 4 && includeFinishing)\n";
        rule1 = rule1 + "  then\n";
        rule1 = rule1 + "      list.add(\"@message@\");\n";
        rule1 = rule1 + "  end\n";
        this.fileManager.write("rule1.drl", rule1.replaceAll("@message@", "Rule A fired!").replaceAll("@operator@", "!="));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("salesChannelId", (Object)1);
        ksession.setGlobal("includeFinishing", (Object)true);
        ksession.insert((Object)"Some String");
        ksession.fireAllRules();
        ksession.dispose();
        list.clear();
        this.fileManager.write("rule1.drl", rule1.replaceAll("@message@", "Rule A V2 fired!").replaceAll("@operator@", "=="));
        this.scan(kagent);
        ksession = kbase.newStatefulKnowledgeSession();
        ksession.setGlobal("list", list);
        ksession.setGlobal("salesChannelId", (Object)4);
        ksession.setGlobal("includeFinishing", (Object)true);
        ksession.insert((Object)"Some String");
        ksession.fireAllRules();
        ksession.dispose();
        kagent.dispose();
    }

    @Test
    public void testEvalConditionOnBinaryPackages() throws Exception {
        String rule1 = "";
        rule1 = rule1 + "package org.drools\n";
        rule1 = rule1 + "global Integer salesChannelId;\n";
        rule1 = rule1 + "global Boolean includeFinishing;\n";
        rule1 = rule1 + "global java.util.List list;\n";
        rule1 = rule1 + "rule \"Rule A\"\n";
        rule1 = rule1 + "  dialect \"java\"\n";
        rule1 = rule1 + "  ruleflow-group \"finishing-price\"\n";
        rule1 = rule1 + "  when\n";
        rule1 = rule1 + "      $s : String()\n";
        rule1 = rule1 + "      eval(salesChannelId @operator@ 4 && includeFinishing)\n";
        rule1 = rule1 + "  then\n";
        rule1 = rule1 + "      list.add(\"@message@\");\n";
        rule1 = rule1 + "  end\n";
        File ruleFile = this.fileManager.write("rule1.pkg", "");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.replaceAll("@message@", "Rule A fired!").replaceAll("@operator@", "!=").getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgePackage pkg = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        KnowledgeAgentBinaryDiffTests.writePackage(pkg, ruleFile);
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.pkg' type='PKG' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.setGlobal("salesChannelId", (Object)1);
        ksession.setGlobal("includeFinishing", (Object)true);
        ksession.insert((Object)"Some String");
        ksession.fireAllRules();
        ksession.dispose();
        list.clear();
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.replaceAll("@message@", "Rule A V2 fired!").replaceAll("@operator@", "==").getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        pkg = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        KnowledgeAgentBinaryDiffTests.writePackage(pkg, ruleFile);
        this.scan(kagent);
        ksession = kbase.newStatefulKnowledgeSession();
        ksession.setGlobal("list", list);
        ksession.setGlobal("salesChannelId", (Object)4);
        ksession.setGlobal("includeFinishing", (Object)true);
        ksession.insert((Object)"Some String");
        ksession.fireAllRules();
        ksession.dispose();
        kagent.dispose();
    }

    private void differentRuleAttributeTest(String attribute1, String attribute2, RuleAttributeAsserter asserter) throws Exception {
        File f1 = this.fileManager.write("rule1.drl", this.createAttributeRule("rule1", attribute1));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        Rule rule = (Rule)kagent.getKnowledgeBase().getRule("org.drools.test", "rule1");
        Assert.assertNotNull((Object)rule);
        asserter.assertRuleAttribute(attribute1, rule);
        File f2 = this.fileManager.write("rule1.drl", this.createAttributeRule("rule1", attribute2));
        this.scan(kagent);
        rule = (Rule)kagent.getKnowledgeBase().getRule("org.drools.test", "rule1");
        Assert.assertNotNull((Object)rule);
        asserter.assertRuleAttribute(attribute2, rule);
        kagent.dispose();
    }
}

