/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.agent.BaseKnowledgeAgentTest;
import org.drools.agent.KnowledgeAgent;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Assert;
import org.junit.Test;

public class KnowledgeAgentDSLTest
extends BaseKnowledgeAgentTest {
    @Test
    public void testDSLAndIncrementalChangeSet() throws Exception {
        this.fileManager.write("myExpander.dsl", this.createCommonDSL(null));
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule("Rule1"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rules.dslr' type='DSLR' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/myExpander.dsl' type='DSL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        ArrayList list = new ArrayList();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Person());
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Rule1"));
        list.clear();
        File expander = this.fileManager.write("myExpander.dsl", this.createCommonDSL("name == \"John\""));
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule("Rule1"));
        this.scan(kagent);
        ksession.insert((Object)new Person());
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        Person p = new Person();
        p.setName("John");
        ksession.insert((Object)p);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Rule1"));
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule(new String[]{"Rule1", "Rule2"}));
        this.scan(kagent);
        list.clear();
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Rule2"));
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule("Rule3"));
        this.scan(kagent);
        ksession.dispose();
        ksession = kbase.newStatefulKnowledgeSession();
        list.clear();
        ksession.setGlobal("list", list);
        ksession.insert((Object)p);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Rule3"));
        this.fileManager.deleteFile(expander);
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule("Rule1"));
        try {
            this.scan(kagent);
            Assert.fail((String)"Knowledge should fail to compile");
        }
        catch (Exception e) {
            // empty catch block
        }
        ksession.dispose();
        kagent.dispose();
    }

    @Test
    public void testDSLAndNewInstance() throws Exception {
        this.fileManager.write("myExpander.dsl", this.createCommonDSL(null));
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule("Rule1"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rules.dslr' type='DSLR' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/myExpander.dsl' type='DSL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        ArrayList list = new ArrayList();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, true);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Person());
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Rule1"));
        list.clear();
        ksession.dispose();
        File expander = this.fileManager.write("myExpander.dsl", this.createCommonDSL("name == \"John\""));
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule("Rule1"));
        this.scan(kagent);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Person());
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        Person p = new Person();
        p.setName("John");
        ksession.insert((Object)p);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Rule1"));
        ksession.dispose();
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule(new String[]{"Rule1", "Rule2"}));
        this.scan(kagent);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list.clear();
        ksession.setGlobal("list", list);
        ksession.insert((Object)p);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Rule1"));
        Assert.assertTrue((boolean)list.contains("Rule2"));
        ksession.dispose();
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule("Rule3"));
        this.scan(kagent);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list.clear();
        ksession.setGlobal("list", list);
        ksession.insert((Object)p);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("Rule3"));
        ksession.dispose();
        this.fileManager.deleteFile(expander);
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule("Rule1"));
        try {
            this.scan(kagent);
            Assert.fail((String)"Knowledge should fail to compile");
        }
        catch (Exception e) {
            // empty catch block
        }
        kagent.dispose();
    }
}

