/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.api;

import java.util.Collection;
import java.util.Collections;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.definition.KnowledgeDescr;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.type.FactType;
import org.drools.io.ResourceFactory;
import org.drools.lang.api.CEDescrBuilder;
import org.drools.lang.api.DeclareDescrBuilder;
import org.drools.lang.api.DescrFactory;
import org.drools.lang.api.FunctionDescrBuilder;
import org.drools.lang.api.PackageDescrBuilder;
import org.drools.lang.api.RuleDescrBuilder;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.ImportDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Assert;
import org.junit.Test;

public class DescrBuilderTest {
    @Test
    public void testPackage() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)DescrFactory.newPackage().name("org.drools").attribute("dialect").value("mvel").end()).getDescr();
        Assert.assertEquals((Object)"org.drools", (Object)pkg.getName());
        Assert.assertEquals((Object)"mvel", (Object)pkg.getAttribute("dialect").getValue());
        Assert.assertNull((Object)pkg.getAttribute("salience"));
        KnowledgePackage kpkg = this.compilePkgDescr(pkg);
        Assert.assertEquals((Object)"org.drools", (Object)kpkg.getName());
    }

    @Test
    public void testPackageAttributes() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((PackageDescrBuilder)((PackageDescrBuilder)DescrFactory.newPackage().name("org.drools").attribute("dialect").value("mvel").end()).attribute("salience", "10")).attribute("lock-on-active", "true", AttributeDescr.Type.BOOLEAN)).getDescr();
        Assert.assertEquals((Object)"org.drools", (Object)pkg.getName());
        Assert.assertEquals((long)3L, (long)pkg.getAttributes().size());
        Assert.assertEquals((Object)"mvel", (Object)pkg.getAttribute("dialect").getValue());
        Assert.assertEquals((Object)"10", (Object)pkg.getAttribute("salience").getValue());
        Assert.assertEquals((Object)"true", (Object)pkg.getAttribute("lock-on-active").getValue());
        Assert.assertEquals((Object)AttributeDescr.Type.BOOLEAN, (Object)pkg.getAttribute("lock-on-active").getType());
        Assert.assertNull((Object)pkg.getAttribute("no-loop"));
        KnowledgePackage kpkg = this.compilePkgDescr(pkg);
        Assert.assertEquals((Object)"org.drools", (Object)kpkg.getName());
    }

    @Test
    public void testPackageImports() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((PackageDescrBuilder)DescrFactory.newPackage().name("org.drools").newImport().target("java.util.List").end()).newImport().target("org.drools.examples.*").end()).getDescr();
        Assert.assertEquals((long)2L, (long)pkg.getImports().size());
        Assert.assertEquals((Object)"java.util.List", (Object)((ImportDescr)pkg.getImports().get(0)).getTarget());
        Assert.assertEquals((Object)"org.drools.examples.*", (Object)((ImportDescr)pkg.getImports().get(1)).getTarget());
    }

    @Test
    public void testGlobals() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((PackageDescrBuilder)DescrFactory.newPackage().name("org.drools").newGlobal().type("java.util.List").identifier("list").end()).newGlobal().type("Person").identifier("bob").end()).getDescr();
        Assert.assertEquals((long)2L, (long)pkg.getGlobals().size());
        Assert.assertEquals((Object)"java.util.List", (Object)((GlobalDescr)pkg.getGlobals().get(0)).getType());
        Assert.assertEquals((Object)"list", (Object)((GlobalDescr)pkg.getGlobals().get(0)).getIdentifier());
        Assert.assertEquals((Object)"Person", (Object)((GlobalDescr)pkg.getGlobals().get(1)).getType());
        Assert.assertEquals((Object)"bob", (Object)((GlobalDescr)pkg.getGlobals().get(1)).getIdentifier());
        KnowledgePackage kpkg = this.compilePkgDescr(pkg);
        Assert.assertEquals((Object)"org.drools", (Object)kpkg.getName());
    }

    @Test
    public void testFunctions() {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((RuleDescrBuilder)((CEDescrBuilder)((PackageDescrBuilder)((FunctionDescrBuilder)((FunctionDescrBuilder)((PackageDescrBuilder)DescrFactory.newPackage().name("org.drools").newFunctionImport().target("java.lang.Math.max").end()).newFunction().returnType("long").name("myMax").parameter("long", "v1")).parameter("long", "v2")).body("return max(v1, v2);").end()).newRule().name("test").lhs().eval().constraint("myMax(5, 10) == 10").end()).end()).rhs("// do something").end()).getDescr();
        Assert.assertEquals((long)1L, (long)pkg.getFunctionImports().size());
        Assert.assertEquals((long)1L, (long)pkg.getFunctions().size());
        Assert.assertEquals((long)1L, (long)pkg.getRules().size());
        KnowledgePackage kpkg = this.compilePkgDescr(pkg);
        Assert.assertEquals((Object)"org.drools", (Object)kpkg.getName());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(Collections.singletonList(kpkg));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testDeclare() throws InstantiationException, IllegalAccessException {
        PackageDescr pkg = (PackageDescr)((PackageDescrBuilder)((DeclareDescrBuilder)((DeclareDescrBuilder)((DeclareDescrBuilder)((DeclareDescrBuilder)DescrFactory.newPackage().name("org.beans").newDeclare().type("StockTick").newAnnotation("role").value("event").end()).newAnnotation("author").value("bob").end()).newField("symbol").type("String").end()).newField("price").type("double").end()).end()).getDescr();
        Assert.assertEquals((long)1L, (long)pkg.getTypeDeclarations().size());
        KnowledgePackage kpkg = this.compilePkgDescr(pkg);
        Assert.assertEquals((Object)"org.beans", (Object)kpkg.getName());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(Collections.singletonList(kpkg));
        FactType stType = kbase.getFactType("org.beans", "StockTick");
        Assert.assertNotNull((Object)stType);
        Object st = stType.newInstance();
        stType.set(st, "symbol", (Object)"RHT");
        stType.set(st, "price", (Object)10);
        Assert.assertEquals((Object)"RHT", (Object)stType.get(st, "symbol"));
    }

    private KnowledgePackage compilePkgDescr(PackageDescr pkg) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newDescrResource((KnowledgeDescr)pkg), ResourceType.DESCR);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        Collection kpkgs = kbuilder.getKnowledgePackages();
        Assert.assertEquals((long)1L, (long)kpkgs.size());
        return (KnowledgePackage)kpkgs.iterator().next();
    }
}

