/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.drools.Cheese;
import org.drools.Cheesery;
import org.drools.FactHandle;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Order;
import org.drools.OrderItem;
import org.drools.OuterClass;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.RuntimeDroolsException;
import org.drools.StatefulSession;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.event.rule.AfterActivationFiredEvent;
import org.drools.event.rule.AgendaEventListener;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.Package;
import org.drools.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.Activation;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class AccumulateTest {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    private RuleBase loadRuleBase(Reader reader) throws IOException, DroolsParserException, Exception {
        return this.loadRuleBase(reader, new PackageBuilderConfiguration());
    }

    private RuleBase loadRuleBase(Reader reader, PackageBuilderConfiguration conf) throws IOException, DroolsParserException, Exception {
        DrlParser parser = new DrlParser();
        PackageDescr packageDescr = parser.parse(reader);
        if (parser.hasErrors()) {
            Assert.fail((String)("Error messages in parser, need to sort this our (or else collect error messages)\n" + parser.getErrors()));
        }
        JavaDialectConfiguration jconf = (JavaDialectConfiguration)conf.getDialectConfiguration("java");
        jconf.setCompiler(0);
        PackageBuilder builder = new PackageBuilder(conf);
        builder.addPackage(packageDescr);
        if (builder.hasErrors()) {
            Assert.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        return ruleBase;
    }

    public KnowledgeBase loadKnowledgeBase(String resource, KnowledgeBuilderConfiguration kbconf) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)kbconf);
        kbuilder.add(ResourceFactory.newClassPathResource((String)resource, this.getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    public KnowledgeBase loadKnowledgeBaseFromString(String content) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(content)), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    @Test
    public void testAccumulateModify() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_AccumulateModify.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)24L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)31L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testAccumulate() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_Accumulate.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Person("Bob", "stilton", 20));
        wm.insert((Object)new Person("Mark", "provolone"));
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Cheese("brie", 5));
        wm.insert((Object)new Cheese("provolone", 150));
        wm.fireAllRules();
        Assert.assertEquals((Object)new Integer(165), results.get(0));
        Assert.assertEquals((Object)new Integer(10), results.get(1));
        Assert.assertEquals((Object)new Integer(150), results.get(2));
        Assert.assertEquals((Object)new Integer(10), results.get(3));
        Assert.assertEquals((Object)new Integer(210), results.get(4));
    }

    @Test
    public void testMVELAccumulate() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_AccumulateMVEL.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Person("Bob", "stilton", 20));
        wm.insert((Object)new Person("Mark", "provolone"));
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Cheese("brie", 5));
        wm.insert((Object)new Cheese("provolone", 150));
        wm.fireAllRules();
        Assert.assertEquals((Object)new Integer(165), results.get(0));
        Assert.assertEquals((Object)new Integer(10), results.get(1));
        Assert.assertEquals((Object)new Integer(150), results.get(2));
        Assert.assertEquals((Object)new Integer(10), results.get(3));
        Assert.assertEquals((Object)new Integer(210), results.get(4));
    }

    @Test
    public void testAccumulateModifyMVEL() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_AccumulateModifyMVEL.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)24L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)31L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testAccumulateReverseModify() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_AccumulateReverseModify.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)24L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        cheese[3].setPrice(20);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[3], (Object)cheese[3]);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)36L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testAccumulateReverseModify2() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_AccumulateReverseModify2.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)24L, (long)((Number)results.get(results.size() - 1)).intValue());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        cheese[3].setPrice(20);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[3], (Object)cheese[3]);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)36L, (long)((Number)results.get(results.size() - 1)).intValue());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testAccumulateReverseModifyMVEL() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_AccumulateReverseModifyMVEL.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)24L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)31L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testAccumulateReverseModifyMVEL2() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_AccumulateReverseModifyMVEL2.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)24L, (long)((Number)results.get(results.size() - 1)).intValue());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)31L, (long)((Number)results.get(results.size() - 1)).intValue());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testAccumulateWithFromChaining() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_AccumulateWithFromChaining.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 8), new Cheese("stilton", 10), new Cheese("stilton", 9), new Cheese("brie", 4), new Cheese("brie", 1), new Cheese("provolone", 8)};
        Cheesery cheesery = new Cheesery();
        for (int i = 0; i < cheese.length; ++i) {
            cheesery.addCheese(cheese[i]);
        }
        FactHandle cheeseryHandle = wm.insert((Object)cheesery);
        Person bob = new Person("Bob", "stilton");
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((List)results.get(results.size() - 1)).size());
        boolean index = true;
        cheese[1].setType("brie");
        wm.update((org.drools.runtime.rule.FactHandle)cheeseryHandle, (Object)cheesery);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((List)results.get(results.size() - 1)).size());
        cheesery.getCheeses().remove(cheese[3]);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseryHandle, (Object)cheesery);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testMVELAccumulate2WM() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_AccumulateMVEL.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm1 = ruleBase.newStatefulSession();
        ArrayList results1 = new ArrayList();
        wm1.setGlobal("results", results1);
        StatefulSession wm2 = ruleBase.newStatefulSession();
        ArrayList results2 = new ArrayList();
        wm2.setGlobal("results", results2);
        wm1.insert((Object)new Person("Bob", "stilton", 20));
        wm1.insert((Object)new Person("Mark", "provolone"));
        wm2.insert((Object)new Person("Bob", "stilton", 20));
        wm2.insert((Object)new Person("Mark", "provolone"));
        wm1.insert((Object)new Cheese("stilton", 10));
        wm1.insert((Object)new Cheese("brie", 5));
        wm2.insert((Object)new Cheese("stilton", 10));
        wm1.insert((Object)new Cheese("provolone", 150));
        wm2.insert((Object)new Cheese("brie", 5));
        wm2.insert((Object)new Cheese("provolone", 150));
        wm1.fireAllRules();
        wm2.fireAllRules();
        Assert.assertEquals((Object)new Integer(165), results1.get(0));
        Assert.assertEquals((Object)new Integer(10), results1.get(1));
        Assert.assertEquals((Object)new Integer(150), results1.get(2));
        Assert.assertEquals((Object)new Integer(10), results1.get(3));
        Assert.assertEquals((Object)new Integer(210), results1.get(4));
        Assert.assertEquals((Object)new Integer(165), results2.get(0));
        Assert.assertEquals((Object)new Integer(10), results2.get(1));
        Assert.assertEquals((Object)new Integer(150), results2.get(2));
        Assert.assertEquals((Object)new Integer(10), results2.get(3));
        Assert.assertEquals((Object)new Integer(210), results2.get(4));
    }

    @Test
    public void testAccumulateInnerClass() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_AccumulateInnerClass.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new OuterClass.InnerClass(10));
        wm.insert((Object)new OuterClass.InnerClass(5));
        wm.fireAllRules();
        Assert.assertEquals((Object)new Integer(15), results.get(0));
    }

    @Test
    public void testAccumulateReturningNull() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_AccumulateReturningNull.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        try {
            wm.insert((Object)new Cheese("stilton", 10));
            Assert.fail((String)"Should have raised an exception because accumulate is returning null");
        }
        catch (RuntimeDroolsException rde) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Should have raised a DroolsRuntimeException instead of " + e));
        }
    }

    @Test
    public void testAccumulateReturningNullMVEL() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_AccumulateReturningNullMVEL.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        try {
            wm.insert((Object)new Cheese("stilton", 10));
            Assert.fail((String)"Should have raised an exception because accumulate is returning null");
        }
        catch (RuntimeDroolsException rde) {
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Should have raised a DroolsRuntimeException instead of " + e));
        }
    }

    @Test
    public void testAccumulateSumJava() throws Exception {
        this.execTestAccumulateSum("test_AccumulateSum.drl");
    }

    @Test
    public void testAccumulateSumMVEL() throws Exception {
        this.execTestAccumulateSum("test_AccumulateSumMVEL.drl");
    }

    @Test
    public void testAccumulateMultiPatternWithFunctionJava() throws Exception {
        this.execTestAccumulateSum("test_AccumulateMultiPatternFunctionJava.drl");
    }

    @Test
    public void testAccumulateMultiPatternWithFunctionMVEL() throws Exception {
        this.execTestAccumulateSum("test_AccumulateMultiPatternFunctionMVEL.drl");
    }

    @Test
    public void testAccumulateCountJava() throws Exception {
        this.execTestAccumulateCount("test_AccumulateCount.drl");
    }

    @Test
    public void testAccumulateCountMVEL() throws Exception {
        this.execTestAccumulateCount("test_AccumulateCountMVEL.drl");
    }

    @Test
    public void testAccumulateAverageJava() throws Exception {
        this.execTestAccumulateAverage("test_AccumulateAverage.drl");
    }

    @Test
    public void testAccumulateAverageMVEL() throws Exception {
        this.execTestAccumulateAverage("test_AccumulateAverageMVEL.drl");
    }

    @Test
    public void testAccumulateMinJava() throws Exception {
        this.execTestAccumulateMin("test_AccumulateMin.drl");
    }

    @Test
    public void testAccumulateMinMVEL() throws Exception {
        this.execTestAccumulateMin("test_AccumulateMinMVEL.drl");
    }

    @Test
    public void testAccumulateMaxJava() throws Exception {
        this.execTestAccumulateMax("test_AccumulateMax.drl");
    }

    @Test
    public void testAccumulateMaxMVEL() throws Exception {
        this.execTestAccumulateMax("test_AccumulateMaxMVEL.drl");
    }

    @Test
    public void testAccumulateMultiPatternJava() throws Exception {
        this.execTestAccumulateReverseModifyMultiPattern("test_AccumulateMultiPattern.drl");
    }

    @Test
    public void testAccumulateMultiPatternMVEL() throws Exception {
        this.execTestAccumulateReverseModifyMultiPattern("test_AccumulateMultiPatternMVEL.drl");
    }

    @Test
    public void testAccumulateCollectListJava() throws Exception {
        this.execTestAccumulateCollectList("test_AccumulateCollectList.drl");
    }

    @Test
    public void testAccumulateCollectListMVEL() throws Exception {
        this.execTestAccumulateCollectList("test_AccumulateCollectListMVEL.drl");
    }

    @Test
    public void testAccumulateCollectSetJava() throws Exception {
        this.execTestAccumulateCollectSet("test_AccumulateCollectSet.drl");
    }

    @Test
    public void testAccumulateCollectSetMVEL() throws Exception {
        this.execTestAccumulateCollectSet("test_AccumulateCollectSetMVEL.drl");
    }

    @Test
    public void testAccumulateMultipleFunctionsJava() throws Exception {
        this.execTestAccumulateMultipleFunctions("test_AccumulateMultipleFunctions.drl");
    }

    @Test
    public void testAccumulateMultipleFunctionsMVEL() throws Exception {
        this.execTestAccumulateMultipleFunctions("test_AccumulateMultipleFunctionsMVEL.drl");
    }

    public void execTestAccumulateSum(String fileName) throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(fileName));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession session = ruleBase.newStatefulSession();
        DataSet data = new DataSet();
        data.results = new ArrayList();
        session.setGlobal("results", data.results);
        data.cheese = new Cheese[]{new Cheese("stilton", 8, 0), new Cheese("stilton", 10, 1), new Cheese("stilton", 9, 2), new Cheese("brie", 11, 3), new Cheese("brie", 4, 4), new Cheese("provolone", 8, 5)};
        data.bob = new Person("Bob", "stilton");
        data.cheeseHandles = new FactHandle[data.cheese.length];
        for (int i = 0; i < data.cheese.length; ++i) {
            data.cheeseHandles[i] = session.insert((Object)data.cheese[i]);
        }
        data.bobHandle = session.insert((Object)data.bob);
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)data.results.size());
        Assert.assertEquals((long)27L, (long)((Number)data.results.get(data.results.size() - 1)).intValue());
        session = SerializationHelper.getSerialisedStatefulSession(session, ruleBase);
        this.updateReferences(session, data);
        boolean index = true;
        data.cheese[1].setPrice(3);
        session.update((org.drools.runtime.rule.FactHandle)data.cheeseHandles[1], (Object)data.cheese[1]);
        session.fireAllRules();
        Assert.assertEquals((long)2L, (long)data.results.size());
        Assert.assertEquals((long)20L, (long)((Number)data.results.get(data.results.size() - 1)).intValue());
        data.bob.setLikes("brie");
        session.update((org.drools.runtime.rule.FactHandle)data.bobHandle, (Object)data.bob);
        session.fireAllRules();
        Assert.assertEquals((long)3L, (long)data.results.size());
        Assert.assertEquals((long)15L, (long)((Number)data.results.get(data.results.size() - 1)).intValue());
        session.retract((org.drools.runtime.rule.FactHandle)data.cheeseHandles[3]);
        session.fireAllRules();
        Assert.assertEquals((long)3L, (long)data.results.size());
    }

    private void updateReferences(StatefulSession session, DataSet data) {
        data.results = (List)session.getGlobal("results");
        Iterator it = session.iterateObjects();
        while (it.hasNext()) {
            Person p;
            Object next = it.next();
            if (next instanceof Cheese) {
                Cheese c;
                data.cheese[c.getOldPrice()] = c = (Cheese)next;
                data.cheeseHandles[c.getOldPrice()] = session.getFactHandle((Object)c);
                Assert.assertNotNull((Object)data.cheeseHandles[c.getOldPrice()]);
                continue;
            }
            if (!(next instanceof Person)) continue;
            data.bob = p = (Person)next;
            data.bobHandle = session.getFactHandle((Object)data.bob);
        }
    }

    public void execTestAccumulateCount(String fileName) throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(fileName));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 8), new Cheese("stilton", 10), new Cheese("stilton", 9), new Cheese("brie", 4), new Cheese("brie", 1), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((Number)results.get(results.size() - 1)).intValue());
        boolean index = true;
        cheese[1].setPrice(3);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((Number)results.get(results.size() - 1)).intValue());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertEquals((long)2L, (long)((Number)results.get(results.size() - 1)).intValue());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((long)3L, (long)results.size());
    }

    public void execTestAccumulateAverage(String fileName) throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(fileName));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 11), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)10L, (long)((Number)results.get(results.size() - 1)).intValue());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)16L, (long)((Number)results.get(results.size() - 1)).intValue());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[4]);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
    }

    public void execTestAccumulateMin(String fileName) throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(fileName));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 8), new Cheese("stilton", 10), new Cheese("stilton", 9), new Cheese("brie", 4), new Cheese("brie", 1), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(3);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((Number)results.get(results.size() - 1)).intValue());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)1L, (long)((Number)results.get(results.size() - 1)).intValue());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[4]);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
    }

    public void execTestAccumulateMax(String fileName) throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(fileName));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 4), new Cheese("stilton", 2), new Cheese("stilton", 3), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)9L, (long)((Number)results.get(results.size() - 1)).intValue());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)17L, (long)((Number)results.get(results.size() - 1)).intValue());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[4]);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
    }

    public void execTestAccumulateCollectList(String fileName) throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(fileName));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 4), new Cheese("stilton", 2), new Cheese("stilton", 3), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)6L, (long)((List)results.get(results.size() - 1)).size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)6L, (long)((List)results.get(results.size() - 1)).size());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[4]);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
    }

    public void execTestAccumulateCollectSet(String fileName) throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(fileName));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 4), new Cheese("stilton", 2), new Cheese("stilton", 3), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((Set)results.get(results.size() - 1)).size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((Set)results.get(results.size() - 1)).size());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertEquals((long)3L, (long)((Set)results.get(results.size() - 1)).size());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[4]);
        wm.fireAllRules();
        Assert.assertEquals((long)3L, (long)results.size());
    }

    public void execTestAccumulateReverseModifyMultiPattern(String fileName) throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream(fileName));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        Person mark = new Person("Mark", "provolone");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        FactHandle markHandle = wm.insert((Object)mark);
        wm.fireAllRules();
        Assert.assertEquals((long)0L, (long)results.size());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)32L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        bob.setLikes("brie");
        wm.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)39L, (long)((Cheesery)results.get(results.size() - 1)).getTotalAmount());
        wm.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testAccumulateWithPreviouslyBoundVariables() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_AccumulatePreviousBinds.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Cheese("brie", 5));
        wm.insert((Object)new Cheese("provolone", 150));
        wm.insert((Object)new Cheese("brie", 20));
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)new Integer(45), results.get(0));
    }

    @Test
    public void testAccumulateMVELWithModify() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_AccumulateMVELwithModify.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Order order = new Order(1, "Bob");
        OrderItem item1 = new OrderItem(order, 1, "maquilage", 1, 10);
        OrderItem item2 = new OrderItem(order, 2, "perfume", 1, 5);
        order.addItem(item1);
        order.addItem(item2);
        wm.insert((Object)order);
        wm.insert((Object)item1);
        wm.insert((Object)item2);
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)15L, (long)((Number)results.get(0)).intValue());
        Assert.assertEquals((double)15.0, (double)order.getTotal(), (double)0.0);
    }

    @Test
    public void testAccumulateGlobals() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_AccumulateGlobals.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.setGlobal("globalValue", (Object)new Integer(50));
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Cheese("brie", 5));
        wm.insert((Object)new Cheese("provolone", 150));
        wm.insert((Object)new Cheese("brie", 20));
        wm.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)new Integer(100), results.get(0));
    }

    @Test
    public void testAccumulateNonExistingFunction() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"test_NonExistingAccumulateFunction.drl", this.getClass()), ResourceType.DRL);
        Assert.assertTrue((String)"It must report a proper error when trying to use a non-registered funcion", (boolean)kbuilder.hasErrors());
        Assert.assertTrue((boolean)kbuilder.getErrors().toString().contains("Unknown accumulate function: 'nonExistingFunction' on rule 'Accumulate non existing function - Java'."));
        Assert.assertTrue((boolean)kbuilder.getErrors().toString().contains("Unknown accumulate function: 'nonExistingFunction' on rule 'Accumulate non existing function - MVEL'."));
    }

    @Test
    public void testAccumulateZeroParams() {
        String rule = "rule fromIt\nwhen\n    Number( $c: intValue ) from accumulate( Integer(), count( ) )\nthen\n    System.out.println( \"got \" + $c );\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(rule)), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Iterator errors = kbuilder.getErrors().iterator();
            while (errors.hasNext()) {
                System.out.println("kbuilder error: " + ((KnowledgeBuilderError)errors.next()).getMessage());
            }
        }
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
    }

    public void execTestAccumulateMultipleFunctions(String fileName) throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase(fileName, null);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 3), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 17), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = (FactHandle)ksession.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = (FactHandle)ksession.insert((Object)bob);
        ksession.fireAllRules();
        ArgumentCaptor cap = ArgumentCaptor.forClass(AfterActivationFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterActivationFired((AfterActivationFiredEvent)cap.capture());
        Activation activation = ((AfterActivationFiredEvent)cap.getValue()).getActivation();
        Assert.assertThat((Object)((Number)activation.getDeclarationValue("$sum")).intValue(), (Matcher)CoreMatchers.is((Object)18));
        Assert.assertThat((Object)((Number)activation.getDeclarationValue("$min")).intValue(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((Number)activation.getDeclarationValue("$avg")).intValue(), (Matcher)CoreMatchers.is((Object)6));
        Mockito.reset((Object[])new AgendaEventListener[]{ael});
        boolean index = true;
        cheese[1].setPrice(9);
        ksession.update((org.drools.runtime.rule.FactHandle)cheeseHandles[1], (Object)cheese[1]);
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterActivationFired((AfterActivationFiredEvent)cap.capture());
        activation = ((AfterActivationFiredEvent)cap.getValue()).getActivation();
        Assert.assertThat((Object)((Number)activation.getDeclarationValue("$sum")).intValue(), (Matcher)CoreMatchers.is((Object)24));
        Assert.assertThat((Object)((Number)activation.getDeclarationValue("$min")).intValue(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertThat((Object)((Number)activation.getDeclarationValue("$avg")).intValue(), (Matcher)CoreMatchers.is((Object)8));
        Mockito.reset((Object[])new AgendaEventListener[]{ael});
        bob.setLikes("brie");
        ksession.update((org.drools.runtime.rule.FactHandle)bobHandle, (Object)bob);
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterActivationFired((AfterActivationFiredEvent)cap.capture());
        activation = ((AfterActivationFiredEvent)cap.getValue()).getActivation();
        Assert.assertThat((Object)((Number)activation.getDeclarationValue("$sum")).intValue(), (Matcher)CoreMatchers.is((Object)32));
        Assert.assertThat((Object)((Number)activation.getDeclarationValue("$min")).intValue(), (Matcher)CoreMatchers.is((Object)15));
        Assert.assertThat((Object)((Number)activation.getDeclarationValue("$avg")).intValue(), (Matcher)CoreMatchers.is((Object)16));
        Mockito.reset((Object[])new AgendaEventListener[]{ael});
        ksession.retract((org.drools.runtime.rule.FactHandle)cheeseHandles[3]);
        ksession.fireAllRules();
        ((AgendaEventListener)Mockito.verify((Object)ael)).afterActivationFired((AfterActivationFiredEvent)cap.capture());
        activation = ((AfterActivationFiredEvent)cap.getValue()).getActivation();
        Assert.assertThat((Object)((Number)activation.getDeclarationValue("$sum")).intValue(), (Matcher)CoreMatchers.is((Object)17));
        Assert.assertThat((Object)((Number)activation.getDeclarationValue("$min")).intValue(), (Matcher)CoreMatchers.is((Object)17));
        Assert.assertThat((Object)((Number)activation.getDeclarationValue("$avg")).intValue(), (Matcher)CoreMatchers.is((Object)17));
    }

    @Test
    public void testAccumulateMinMax() throws Exception {
        String drl = "package org.drools.test \nimport org.drools.Cheese \nglobal java.util.List results \n rule minMax \nwhen \n    accumulate( Cheese( $p: price ), $min: min($p), $max: max($p) ) \nthen \n    results.add($min); results.add($max); \nend \n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(drl);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("Emmentaler", 4), new Cheese("Appenzeller", 6), new Cheese("Greyerzer", 2), new Cheese("Raclette", 3), new Cheese("Olm\u00fctzer Quargel", 15), new Cheese("Brie", 17), new Cheese("Dolcelatte", 8)};
        for (int i = 0; i < cheese.length; ++i) {
            ksession.insert((Object)cheese[i]);
        }
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)((Number)results.get(0)).intValue(), (long)2L);
        Assert.assertEquals((long)((Number)results.get(1)).intValue(), (long)17L);
    }

    @Test
    public void testAccumulateCE() throws Exception {
        String drl = "package org.drools\nglobal java.util.List results\nrule \"ocount\"\nwhen\n    accumulate( Cheese(), $c: count(1) )\nthen\n    results.add( $c + \" facts\" );\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(drl);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList results = new ArrayList();
        ksession.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("Emmentaler", 4), new Cheese("Appenzeller", 6), new Cheese("Greyerzer", 2), new Cheese("Raclette", 3), new Cheese("Olm\u00fctzer Quargel", 15), new Cheese("Brie", 17), new Cheese("Dolcelatte", 8)};
        for (int i = 0; i < cheese.length; ++i) {
            ksession.insert((Object)cheese[i]);
        }
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"7 facts", results.get(0));
    }

    @Test
    @Ignore
    public void testAccumulateAndRetract() {
        String drl = "package org.drools;\n\nimport java.util.ArrayList;\n\nglobal ArrayList list;\n\ndeclare Holder\n    list : ArrayList\nend\n\nrule \"Init\"\nwhen\n    $l : ArrayList()\nthen\n    insert( new Holder($l) );\nend\n\nrule \"axx\"\nwhen\n    $h : Holder( $l : list )\n    $n : Long() from accumulate (\n                    $b : String( ) from $l\n                    count($b))\nthen\n    System.out.println($n);\n    list.add($n);\nend\n\nrule \"clean\"\nsalience -10\nwhen\n    $h : Holder()\nthen\n    retract($h);\nend";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kb = KnowledgeBaseFactory.newKnowledgeBase();
        kb.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ks = kb.newStatefulKnowledgeSession();
        ArrayList resList = new ArrayList();
        ks.setGlobal("list", resList);
        ArrayList<String> list = new ArrayList<String>();
        list.add("x");
        list.add("y");
        list.add("z");
        ks.insert(list);
        ks.fireAllRules();
        Assert.assertEquals((Object)3L, resList.get(0));
    }

    public static class DataSet {
        public Cheese[] cheese;
        public FactHandle[] cheeseHandles;
        public Person bob;
        public FactHandle bobHandle;
        public List<?> results;
    }
}

