/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Message;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.definition.KnowledgePackage;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatelessKnowledgeSession;
import org.junit.Assert;
import org.junit.Test;

public class SerializedPackageMergeTest {
    private static final DateFormat DF = new SimpleDateFormat("dd-MMM-yyyy");
    private static final String[] DRLs = new String[]{"HelloWorld.drl", "test_Serialization1.drl"};

    @Test
    public void testRuleExecutionWithoutSerialization() {
        try {
            this.testRuleExecution(this.getSession(false));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Should not have raised any exception. Message: " + e.getMessage()));
        }
    }

    @Test
    public void testRuleExecutionWithSerialization() throws Exception {
        try {
            this.testRuleExecution(this.getSession(true));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Should not have raised any exception. Message: " + e.getMessage()));
        }
    }

    private void testRuleExecution(StatelessKnowledgeSession session) throws Exception {
        ArrayList list = new ArrayList();
        session.setGlobal("list", list);
        session.execute((Object)this.getObject());
        Assert.assertEquals((long)2L, (long)list.size());
    }

    private Message getObject() throws ParseException {
        Message message = new Message();
        message.setMessage("hola");
        message.setNumber(50);
        message.getList().add("hello");
        message.setBirthday(DF.parse("10-Jul-1976"));
        return message;
    }

    private StatelessKnowledgeSession getSession(boolean serialize) throws Exception {
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        for (String drl : DRLs) {
            KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newInputStreamResource((InputStream)this.getClass().getResourceAsStream(drl)), ResourceType.DRL);
            Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
            ArrayList<KnowledgePackage> kpkgs = kbuilder.getKnowledgePackages();
            ArrayList<KnowledgePackage> newCollection = null;
            if (serialize) {
                newCollection = new ArrayList<KnowledgePackage>();
                for (KnowledgePackage kpkg : kpkgs) {
                    kpkg = SerializationHelper.serializeObject(kpkg);
                    newCollection.add(kpkg);
                }
            } else {
                newCollection = kpkgs;
            }
            kbase.addKnowledgePackages(newCollection);
        }
        return kbase.newStatelessKnowledgeSession();
    }
}

