/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.janino.Java;
import org.drools.ChangeSet;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.agent.BaseKnowledgeAgentTest;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.impl.KnowledgeAgentImpl;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.builder.impl.KnowledgeBuilderImpl;
import org.drools.command.Command;
import org.drools.command.runtime.rule.InsertObjectCommand;
import org.drools.definition.KnowledgeDefinition;
import org.drools.definition.KnowledgePackage;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.io.impl.ByteArrayResource;
import org.drools.io.impl.ChangeSetImpl;
import org.drools.io.impl.UrlResource;
import org.drools.rule.Rule;
import org.drools.rule.TypeDeclaration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.StatelessKnowledgeSession;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeAgentTest
extends BaseKnowledgeAgentTest {
    @Test
    public void testModifyFileUrl() throws Exception {
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        this.fileManager.write("rule2.drl", this.createDefaultRule("rule2"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule2.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule3"));
        this.scan(kagent);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule3"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        kagent.dispose();
    }

    @Test
    public void testChangeSetInChangeSet() throws Exception {
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        this.fileManager.write("rule2.drl", this.createDefaultRule("rule2"));
        String xml1 = "";
        xml1 = xml1 + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml1 = xml1 + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml1 = xml1 + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml1 = xml1 + "    <add> ";
        xml1 = xml1 + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml1 = xml1 + "        <resource source='http://localhost:" + this.getPort() + "/rule2.drl' type='DRL' />";
        xml1 = xml1 + "    </add> ";
        xml1 = xml1 + "</change-set>";
        File fxml = this.fileManager.write("changeset2.xml", xml1);
        String xml2 = "";
        xml2 = xml2 + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml2 = xml2 + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml2 = xml2 + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml2 = xml2 + "    <add> ";
        xml2 = xml2 + "        <resource source='http://localhost:" + this.getPort() + "/changeset2.xml' type='CHANGE_SET' />";
        xml2 = xml2 + "    </add> ";
        xml2 = xml2 + "</change-set>";
        File fxm2 = this.fileManager.write("changeset.xml", xml1);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxm2.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule3"));
        this.scan(kagent);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule3"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        kagent.dispose();
    }

    @Test
    public void testModifyFileUrlWithStateless() throws Exception {
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        this.fileManager.write("rule2.drl", this.createDefaultRule("rule2"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule2.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatelessKnowledgeSession ksession = kagent.newStatelessKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.execute((Object)"hello");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule3"));
        this.scan(kagent);
        ksession.execute((Object)"hello");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule3"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        kagent.dispose();
    }

    @Test
    public void testModifyPackageUrl() throws Exception {
        String rule1 = this.createDefaultRule("rule1");
        String rule2 = this.createDefaultRule("rule2");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule2.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgePackage pkg = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        KnowledgeAgentTest.writePackage(pkg, this.fileManager.newFile("pkg1.pkg"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/pkg1.pkg' type='PKG' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        rule1 = this.createDefaultRule("rule3");
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule2.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        pkg = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        KnowledgeAgentTest.writePackage(pkg, this.fileManager.newFile("pkg1.pkg"));
        this.scan(kagent);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule3"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        kagent.dispose();
    }

    @Test
    public void testDeletePackageUrl() throws Exception {
        String rule1 = this.createDefaultRule("rule1", "org.drools.test1");
        String rule2 = this.createDefaultRule("rule2", "org.drools.test2");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule2.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        HashMap<String, KnowledgePackage> map = new HashMap<String, KnowledgePackage>();
        for (KnowledgePackage pkg : kbuilder.getKnowledgePackages()) {
            map.put(pkg.getName(), pkg);
        }
        KnowledgeAgentTest.writePackage((KnowledgePackage)map.get("org.drools.test1"), this.fileManager.newFile("pkg1.pkg"));
        KnowledgeAgentTest.writePackage((KnowledgePackage)map.get("org.drools.test2"), this.fileManager.newFile("pkg2.pkg"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/pkg1.pkg' type='PKG' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/pkg2.pkg' type='PKG' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        this.applyChangeSet(kagent, ResourceFactory.newByteArrayResource((byte[])xml.getBytes()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <remove> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/pkg2.pkg' type='PKG' />";
        xml = xml + "    </remove> ";
        xml = xml + "</change-set>";
        this.applyChangeSet(kagent, xml);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        kagent.dispose();
    }

    @Test
    public void testOldSchoolPackageUrl() throws Exception {
        String rule1 = this.createDefaultRule("rule1");
        String rule2 = this.createDefaultRule("rule2");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule2.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBuilderImpl kbi = (KnowledgeBuilderImpl)kbuilder;
        KnowledgeAgentTest.writePackage(kbi.getPackageBuilder().getPackage(), this.fileManager.newFile("pkgold.pkg"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/pkgold.pkg' type='PKG' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        kagent.dispose();
    }

    @Test
    public void testModifyFile() throws IOException, InterruptedException {
        File f1 = this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        File f2 = this.fileManager.write("rule2.drl", this.createDefaultRule("rule2"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='" + f1.toURI().toURL() + "' type='DRL' />";
        xml = xml + "        <resource source='" + f2.toURI().toURL() + "' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.write("rule1.drl", this.createDefaultRule("rule3"));
        this.scan(kagent);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule3"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        kagent.monitorResourceChangeEvents(false);
    }

    @Test
    public void testModifyDirectory() throws IOException, InterruptedException {
        File f1 = this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        File f2 = this.fileManager.write("rule2.drl", this.createDefaultRule("rule2"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='" + f1.getParentFile().toURI().toURL() + "' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset", "changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.write("rule3.drl", this.createDefaultRule("rule3"));
        this.fileManager.deleteFile(f1);
        this.scan(kagent);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule2"));
        Assert.assertTrue((boolean)list.contains("rule3"));
        kagent.dispose();
    }

    @Test
    public void testModifyFileInDirectory() throws Exception {
        File testDirectory = this.fileManager.newFile("test");
        testDirectory.mkdir();
        File f1 = this.fileManager.write("test", "rule1.drl", this.createDefaultRule("rule1"));
        File f2 = this.fileManager.write("test", "rule2.drl", this.createDefaultRule("rule2"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='file:" + this.fileManager.getRootDirectory().getAbsolutePath() + "/test' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset", "changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatefulKnowledgeSession ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        this.fileManager.write("test", "rule1.drl", this.createDefaultRule("rule3"));
        this.scan(kagent);
        ksession = kagent.getKnowledgeBase().newStatefulKnowledgeSession();
        list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule3"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        kagent.dispose();
    }

    @Test
    public void testStatelessWithCommands() throws Exception {
        File f1 = this.fileManager.write("rule1.drl", this.createDefaultRule("rule1"));
        File f2 = this.fileManager.write("rule2.drl", this.createDefaultRule("rule2"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='" + f1.getParentFile().toURI().toURL() + "' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset", "changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        StatelessKnowledgeSession ksession = kagent.newStatelessKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.execute((Command)new InsertObjectCommand((Object)"hello"));
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
    }

    @Test
    public void testResourceMapping() throws Exception {
        String rule1 = this.createDefaultRule("rule1");
        String rule2 = this.createDefaultRule("rule2");
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule2.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgePackage pkg = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        KnowledgeAgentTest.writePackage(pkg, this.fileManager.newFile("pkg1.pkg"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/pkg1.pkg' type='PKG' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, true);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        Rule r1 = (Rule)kagent.getKnowledgeBase().getRule("org.drools.test", "rule1");
        Assert.assertEquals((Object)((UrlResource)r1.getResource()).getURL().toString(), (Object)("http://localhost:" + this.getPort() + "/pkg1.pkg"));
        Rule r2 = (Rule)kagent.getKnowledgeBase().getRule("org.drools.test", "rule2");
        Assert.assertEquals((Object)((UrlResource)r2.getResource()).getURL().toString(), (Object)("http://localhost:" + this.getPort() + "/pkg1.pkg"));
        Map defMap = ((KnowledgeAgentImpl)kagent).getRegisteredResources();
        Assert.assertTrue((boolean)defMap.containsKey(r1.getResource()));
        Assert.assertTrue((boolean)defMap.containsKey(r2.getResource()));
        Set defs = (Set)defMap.get(r1.getResource());
        Assert.assertTrue((boolean)defs.contains(r1));
        Assert.assertTrue((boolean)defs.contains(r2));
        Assert.assertEquals((long)2L, (long)defs.size());
        String rule3 = this.createDefaultRule("rule3", "org.drools.test3");
        kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule3.getBytes()), ResourceType.DRL);
        pkg = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        KnowledgeAgentTest.writePackage(pkg, this.fileManager.newFile("pkg1.pkg"));
        this.scan(kagent);
        Assert.assertNotSame((Object)kbase, (Object)kagent.getKnowledgeBase());
        kbase = kagent.getKnowledgeBase();
        Assert.assertNull((Object)kbase.getKnowledgePackage("org.drools.test"));
        Assert.assertEquals((long)1L, (long)kbase.getKnowledgePackage("org.drools.test3").getRules().size());
        Rule r3 = (Rule)kbase.getRule("org.drools.test3", "rule3");
        Assert.assertEquals((Object)((UrlResource)r3.getResource()).getURL().toString(), (Object)("http://localhost:" + this.getPort() + "/pkg1.pkg"));
        defMap = ((KnowledgeAgentImpl)kagent).getRegisteredResources();
        Assert.assertTrue((boolean)defMap.containsKey(r3.getResource()));
        defs = (Set)defMap.get(r3.getResource());
        Assert.assertTrue((boolean)defs.contains(r3));
        Assert.assertFalse((boolean)defs.contains(r1));
        Assert.assertFalse((boolean)defs.contains(r2));
        Assert.assertEquals((long)1L, (long)defs.size());
        String rule4 = this.createDefaultRule("rule4", "org.drools.test4");
        ChangeSetImpl cs = new ChangeSetImpl();
        ByteArrayResource res = new ByteArrayResource(rule4.getBytes());
        res.setResourceType(ResourceType.DRL);
        cs.setResourcesAdded(Arrays.asList(res));
        kagent.applyChangeSet((ChangeSet)cs);
        Assert.assertNotSame((Object)kbase, (Object)kagent.getKnowledgeBase());
        kbase = kagent.getKnowledgeBase();
        Assert.assertEquals((long)1L, (long)kbase.getKnowledgePackage("org.drools.test3").getRules().size());
        Assert.assertEquals((long)1L, (long)kbase.getKnowledgePackage("org.drools.test4").getRules().size());
        Rule r4 = (Rule)kbase.getRule("org.drools.test4", "rule4");
        Assert.assertSame((Object)r4.getResource(), (Object)res);
        defMap = ((KnowledgeAgentImpl)kagent).getRegisteredResources();
        Assert.assertEquals((long)2L, (long)defMap.size());
        Assert.assertTrue((boolean)defMap.containsKey(r4.getResource()));
        defs = (Set)defMap.get(r4.getResource());
        Assert.assertTrue((boolean)defs.contains(r4));
        Assert.assertFalse((boolean)defs.contains(r3));
        Assert.assertFalse((boolean)defs.contains(r2));
        Assert.assertEquals((long)1L, (long)defs.size());
        defs = (Set)defMap.get(r3.getResource());
        Assert.assertTrue((boolean)defs.contains(r3));
        Assert.assertFalse((boolean)defs.contains(r4));
        Assert.assertFalse((boolean)defs.contains(r2));
        Assert.assertEquals((long)1L, (long)defs.size());
        kagent.dispose();
    }

    @Test
    public void testMultipleResourcesAndPackages() {
        String drl = "package org.test.myPack;\n\nimport java.util.List;\n\ndeclare org.anotherPack.MyType\n    field : String\nend\n\nrule \"init\"\nwhen \nthen \n  System.out.println(\"X\");\nend";
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        ByteArrayResource bres = (ByteArrayResource)ResourceFactory.newByteArrayResource((byte[])drl.getBytes());
        bres.setResourceType(ResourceType.DRL);
        ChangeSetImpl cs = new ChangeSetImpl();
        cs.setResourcesAdded(Arrays.asList(bres));
        kagent.applyChangeSet((ChangeSet)cs);
        KnowledgePackage pack = kagent.getKnowledgeBase().getKnowledgePackage("org.test.myPack");
        Assert.assertNotNull((Object)pack);
        Assert.assertEquals((long)1L, (long)pack.getRules().size());
        KnowledgePackage pack2 = kagent.getKnowledgeBase().getKnowledgePackage("org.anotherPack");
        Assert.assertNotNull((Object)pack2);
        Assert.assertEquals((long)0L, (long)pack2.getRules().size());
        String drl2 = "package org.test.myPack;\nfunction void foo() { \n} \n\n\ndeclare org.anotherPack.MyType2\n    field : String\nend\nrule \"rool\" \nwhen\nthen\nend\n";
        ByteArrayResource bres2 = (ByteArrayResource)ResourceFactory.newByteArrayResource((byte[])drl2.getBytes());
        bres2.setResourceType(ResourceType.DRL);
        ChangeSetImpl cs2 = new ChangeSetImpl();
        cs2.setResourcesAdded(Arrays.asList(bres2));
        kagent.applyChangeSet((ChangeSet)cs2);
        pack = kagent.getKnowledgeBase().getKnowledgePackage("org.test.myPack");
        Assert.assertNotNull((Object)pack);
        Assert.assertEquals((long)2L, (long)pack.getRules().size());
        pack2 = kagent.getKnowledgeBase().getKnowledgePackage("org.anotherPack");
        Assert.assertNotNull((Object)pack2);
        Assert.assertEquals((long)0L, (long)pack2.getRules().size());
        Collection def1 = (Collection)((KnowledgeAgentImpl)kagent).getRegisteredResources().get(bres);
        Assert.assertEquals((long)2L, (long)def1.size());
        this.checkAllDefinitionsBelongToResource(def1, bres);
        Collection def2 = (Collection)((KnowledgeAgentImpl)kagent).getRegisteredResources().get(bres2);
        Assert.assertEquals((long)2L, (long)def2.size());
        this.checkAllDefinitionsBelongToResource(def2, bres2);
    }

    private void checkAllDefinitionsBelongToResource(Collection<KnowledgeDefinition> def, ByteArrayResource res) {
        for (KnowledgeDefinition kd : def) {
            if (kd instanceof Java.TypeDeclaration) {
                Assert.assertEquals((Object)res, (Object)((TypeDeclaration)kd).getResource());
                continue;
            }
            if (!(kd instanceof Rule)) continue;
            Assert.assertEquals((Object)res, (Object)((Rule)kd).getResource());
        }
    }

    @Test
    public void testMissingChangeset() throws Exception {
        KnowledgeAgent kAgent = this.createKAgent(KnowledgeBaseFactory.newKnowledgeBase());
        String urlString = "file://tmp/MissingChangeSet.xml";
        try {
            URL url = new URL(urlString);
            Resource urlResource = ResourceFactory.newUrlResource((URL)url);
            Assert.assertNotNull((Object)urlResource);
            kAgent.applyChangeSet(urlResource);
            Assert.assertEquals((long)0L, (long)kAgent.getKnowledgeBase().getKnowledgePackages().size());
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

