/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.util.ArrayList;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.builder.conf.DeclarativeAgendaOption;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.event.rule.ActivationCancelledEvent;
import org.drools.event.rule.ActivationCreatedEvent;
import org.drools.event.rule.AfterActivationFiredEvent;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.AgendaGroupPoppedEvent;
import org.drools.event.rule.AgendaGroupPushedEvent;
import org.drools.event.rule.BeforeActivationFiredEvent;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.Activation;
import org.drools.runtime.rule.FactHandle;
import org.junit.Assert;
import org.junit.Test;

public class DeclarativeAgendaTest {
    @Test
    public void testBasicBlockOnAnnotation() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Activation.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule1 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule rule2 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule rule3 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go2' ) \n";
        str = str + "     $i : Activation( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockActivation( $i ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)DeclarativeAgendaOption.ENABLED);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kconf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1:go2"));
        Assert.assertTrue((boolean)list.contains("rule2:go2"));
        Assert.assertTrue((boolean)list.contains("rule3:go2"));
        list.clear();
        ksession.retract(go2);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1:go1"));
        Assert.assertTrue((boolean)list.contains("rule2:go1"));
        Assert.assertTrue((boolean)list.contains("rule3:go1"));
        ksession.dispose();
    }

    @Test
    public void testApplyBlockerFirst() {
        StatefulKnowledgeSession ksession = this.getStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go2 = ksession.insert((Object)"go2");
        FactHandle go1 = ksession.insert((Object)"go1");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1:go2"));
        list.clear();
        ksession.retract(go2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1:go1"));
    }

    @Test
    public void testApplyBlockerFirstWithFireAllRulesInbetween() {
        StatefulKnowledgeSession ksession = this.getStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        FactHandle go1 = ksession.insert((Object)"go1");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1:go2"));
        list.clear();
        ksession.retract(go2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1:go1"));
    }

    @Test
    public void testApplyBlockerSecond() {
        StatefulKnowledgeSession ksession = this.getStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go1 = ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1:go2"));
        list.clear();
        ksession.retract(go2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1:go1"));
    }

    @Test
    public void testApplyBlockerSecondWithUpdate() {
        StatefulKnowledgeSession ksession = this.getStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go1 = ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1:go2"));
        list.clear();
        ksession.update(go2, (Object)"go2");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1:go2"));
        list.clear();
        ksession.retract(go2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1:go1"));
    }

    @Test
    public void testApplyBlockerSecondAfterUpdate() {
        StatefulKnowledgeSession ksession = this.getStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go1 = ksession.insert((Object)"go1");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1:go1"));
        list.clear();
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1:go2"));
        list.clear();
        ksession.update(go1, (Object)"go1");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1:go2"));
        list.clear();
        ksession.retract(go2);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule1:go1"));
    }

    public StatefulKnowledgeSession getStatefulKnowledgeSession() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Activation.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule1 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go2' ) \n";
        str = str + "     $i : Activation( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockActivation( $i ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)DeclarativeAgendaOption.ENABLED);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kconf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        return ksession;
    }

    @Test
    public void testMultipleBlockers() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Activation.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule0 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go0' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules1 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "     $i : Activation( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockActivation( $i ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules2 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go2' ) \n";
        str = str + "     $i : Activation( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockActivation( $i ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules3 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go3' ) \n";
        str = str + "     $i : Activation( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockActivation( $i ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)DeclarativeAgendaOption.ENABLED);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kconf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go0 = ksession.insert((Object)"go0");
        FactHandle go1 = ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        FactHandle go3 = ksession.insert((Object)"go3");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule0:go1"));
        Assert.assertTrue((boolean)list.contains("rule0:go2"));
        Assert.assertTrue((boolean)list.contains("rule0:go3"));
        list.clear();
        ksession.retract(go3);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        ksession.retract(go2);
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        ksession.retract(go1);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule0:go0"));
        ksession.dispose();
    }

    @Test
    public void testMultipleBlockersWithUnblockAll() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Activation.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule0 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go0' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules1 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "     $i : Activation( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockActivation( $i ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules2 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go2' ) \n";
        str = str + "     $i : Activation( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockActivation( $i ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules3 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go3' ) \n";
        str = str + "     $i : Activation( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.blockActivation( $i ); \n";
        str = str + "end \n";
        str = str + "rule unblockAll @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go4' ) \n";
        str = str + "     $i : Activation( department == 'sales', active == true ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $i.rule.name + ':' + $s  ); \n";
        str = str + "    kcontext.unblockAllActivations( $i ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)DeclarativeAgendaOption.ENABLED);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kconf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle go0 = ksession.insert((Object)"go0");
        FactHandle go1 = ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        FactHandle go3 = ksession.insert((Object)"go3");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        System.out.println(list);
        Assert.assertTrue((boolean)list.contains("blockerAllSalesRules1:rule0:go1"));
        Assert.assertTrue((boolean)list.contains("blockerAllSalesRules2:rule0:go2"));
        Assert.assertTrue((boolean)list.contains("blockerAllSalesRules3:rule0:go3"));
        list.clear();
        FactHandle go4 = ksession.insert((Object)"go4");
        ksession.fireAllRules();
        Assert.assertEquals((long)5L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("unblockAll:rule0:go4"));
        Assert.assertTrue((boolean)list.contains("rule0:go0"));
        Assert.assertTrue((boolean)list.contains("blockerAllSalesRules1:rule0:go1"));
        Assert.assertTrue((boolean)list.contains("blockerAllSalesRules2:rule0:go2"));
        Assert.assertTrue((boolean)list.contains("blockerAllSalesRules3:rule0:go3"));
    }

    @Test
    public void testIterativeUpdate() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Activation.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule0 \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'rule0' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name ); \n";
        str = str + "end \n";
        str = str + "rule rule1 \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'rule1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name ); \n";
        str = str + "end \n";
        str = str + "rule rule2 \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'rule2' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules1 @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $l : List( ) \n";
        str = str + "     $i : Activation( rule.name == $l[0] ) \n";
        str = str + "then \n";
        str = str + "    list.add( 'block:' + $i.rule.name  ); \n";
        str = str + "    kcontext.blockActivation( $i ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)DeclarativeAgendaOption.ENABLED);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kconf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        FactHandle rule0 = ksession.insert((Object)"rule0");
        FactHandle rule1 = ksession.insert((Object)"rule1");
        FactHandle rule2 = ksession.insert((Object)"rule2");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule0"));
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        ArrayList<String> l = new ArrayList<String>();
        ksession.update(rule0, (Object)"rule0");
        ksession.update(rule1, (Object)"rule1");
        ksession.update(rule2, (Object)"rule2");
        l.add("rule0");
        FactHandle lh = ksession.insert(l);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("block:rule0"));
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        ksession.update(rule0, (Object)"rule0");
        ksession.update(rule1, (Object)"rule1");
        ksession.update(rule2, (Object)"rule2");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("block:rule0"));
        list.clear();
        l.set(0, "rule1");
        ksession.update(lh, l);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule0"));
        Assert.assertTrue((boolean)list.contains("block:rule1"));
        Assert.assertTrue((boolean)list.contains("rule2"));
        list.clear();
        ksession.update(rule0, (Object)"rule0");
        ksession.update(rule1, (Object)"rule1");
        ksession.update(rule2, (Object)"rule2");
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("block:rule1"));
        list.clear();
        l.set(0, "rule2");
        ksession.update(lh, l);
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("rule0"));
        Assert.assertTrue((boolean)list.contains("rule1"));
        Assert.assertTrue((boolean)list.contains("block:rule2"));
    }

    @Test
    public void testCancelActivation() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Activation.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule1 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule blockerAllSalesRules @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go2' ) \n";
        str = str + "     $i : Activation( department == 'sales' ) \n";
        str = str + "then \n";
        str = str + "    kcontext.cancelActivation( $i ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)DeclarativeAgendaOption.ENABLED);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kconf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        final ArrayList cancelled = new ArrayList();
        ksession.addEventListener(new AgendaEventListener(){

            public void beforeActivationFired(BeforeActivationFiredEvent event) {
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event) {
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
            }

            public void afterActivationFired(AfterActivationFiredEvent event) {
            }

            public void activationCreated(ActivationCreatedEvent event) {
            }

            public void activationCancelled(ActivationCancelledEvent event) {
                cancelled.add(event);
            }
        });
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        Assert.assertEquals((long)0L, (long)list.size());
        Assert.assertEquals((long)1L, (long)cancelled.size());
        Assert.assertEquals((Object)"rule1", (Object)((ActivationCancelledEvent)cancelled.get(0)).getActivation().getRule().getName());
        ksession.dispose();
    }

    @Test
    public void testActiveInActiveChanges() {
        String str = "";
        str = str + "package org.domain.test \n";
        str = str + "import " + Activation.class.getName() + "\n";
        str = str + "global java.util.List list \n";
        str = str + "dialect 'mvel' \n";
        str = str + "rule rule1 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule rule2 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule rule3 @department(sales) \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go1' ) \n";
        str = str + "then \n";
        str = str + "    list.add( kcontext.rule.name + ':' + $s ); \n";
        str = str + "end \n";
        str = str + "rule countActivateInActive @activationListener('direct') \n";
        str = str + "when \n";
        str = str + "     $s : String( this == 'go2' ) \n";
        str = str + "     $active : Number( this == 1 ) from accumulate( $a : Activation( department == 'sales', active == true ), count( $a ) )\n";
        str = str + "     $inActive : Number( this == 2 ) from  accumulate( $a : Activation( department == 'sales', active == false ), count( $a ) )\n";
        str = str + "then \n";
        str = str + "    list.add( $active + ':' + $inActive  ); \n";
        str = str + "    kcontext.halt( ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)DeclarativeAgendaOption.ENABLED);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kconf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)"go1");
        FactHandle go2 = ksession.insert((Object)"go2");
        ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertTrue((boolean)list.contains("1:2"));
        Assert.assertTrue((boolean)list.contains("rule2:go1"));
        Assert.assertTrue((boolean)list.contains("rule3:go1"));
        ksession.dispose();
    }
}

