/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.Cheese;
import org.drools.DroolsTestCase;
import org.drools.FactHandle;
import org.drools.Primitives;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.StockTick;
import org.drools.WorkingMemory;
import org.drools.base.ClassObjectType;
import org.drools.base.DefaultKnowledgeHelper;
import org.drools.common.ActivationGroupNode;
import org.drools.common.ActivationNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.LogicalDependency;
import org.drools.commons.jci.compilers.EclipseJavaCompiler;
import org.drools.commons.jci.compilers.JaninoJavaCompiler;
import org.drools.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.ParserError;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListNode;
import org.drools.integrationtests.SerializationHelper;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.BehaviorDescr;
import org.drools.lang.descr.BindingDescr;
import org.drools.lang.descr.ConditionalElementDescr;
import org.drools.lang.descr.EvalDescr;
import org.drools.lang.descr.ExistsDescr;
import org.drools.lang.descr.ExprConstraintDescr;
import org.drools.lang.descr.FieldConstraintDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.lang.descr.LiteralRestrictionDescr;
import org.drools.lang.descr.NotDescr;
import org.drools.lang.descr.OrDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.RestrictionDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.lang.descr.TypeFieldDescr;
import org.drools.reteoo.LeftTupleImpl;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Behavior;
import org.drools.rule.Declaration;
import org.drools.rule.EvalCondition;
import org.drools.rule.GroupElement;
import org.drools.rule.JavaDialectRuntimeData;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.Rule;
import org.drools.rule.SlidingTimeWindow;
import org.drools.rule.TypeDeclaration;
import org.drools.rule.VariableConstraint;
import org.drools.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.spi.Activation;
import org.drools.spi.AgendaGroup;
import org.drools.spi.CompiledInvoker;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.PropagationContext;
import org.drools.util.ClassLoaderUtil;
import org.drools.util.CompositeClassLoader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class PackageBuilderTest
extends DroolsTestCase {
    @After
    public void tearDown() {
        System.getProperties().remove("drools.warning.filters");
        System.getProperties().remove("drools.kbuilder.severity.duplicateFunction");
        System.getProperties().remove("drools.kbuilder.severity.duplicateRule");
    }

    @Test
    public void testErrors() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        BindingDescr fieldBindingDescr = new BindingDescr("x", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        fieldBindingDescr = new BindingDescr("y", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        pattern.addConstraint((BaseDescr)new ExprConstraintDescr("price == x"));
        ruleDescr.setConsequence((Object)"update(m);");
        builder.addPackage(packageDescr);
        Assert.assertTrue((builder.getErrors().getErrors().length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testErrorsInParser() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("bad_rule.drl")));
        Assert.assertTrue((boolean)builder.hasErrors());
    }

    @Test
    public void testReload() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        ruleDescr.setConsequence((Object)"map.put(\"value\", new Integer(1) );");
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        Rule rule = pkg.getRule("rule-1");
        this.assertLength(0, builder.getErrors().getErrors());
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        ruleBase.getGlobals().put("map", Map.class);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        HashMap map = new HashMap();
        workingMemory.setGlobal("map", map);
        MockTuple tuple = new MockTuple(new HashMap());
        tuple.setLeftTupleSink((LeftTupleSink)new RuleTerminalNode(1, null, rule, rule.getLhs(), 0, new BuildContext((InternalRuleBase)ruleBase, null)));
        MockActivation activation = new MockActivation(rule, 0, rule.getLhs(), tuple);
        DefaultKnowledgeHelper knowledgeHelper = new DefaultKnowledgeHelper((WorkingMemory)workingMemory);
        knowledgeHelper.setActivation((Activation)activation);
        rule.getConsequence().evaluate((KnowledgeHelper)knowledgeHelper, (WorkingMemory)workingMemory);
        Assert.assertEquals((Object)new Integer(1), map.get("value"));
        ruleDescr.setConsequence((Object)"map.put(\"value\", new Integer(2) );");
        pkg.removeRule(rule);
        Assert.assertEquals((long)0L, (long)((JavaDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData("java")).list().length);
        builder.addPackage(packageDescr);
        pkg = builder.getPackage();
        rule = pkg.getRule("rule-1");
        knowledgeHelper = new DefaultKnowledgeHelper((WorkingMemory)workingMemory);
        knowledgeHelper.setActivation((Activation)activation);
        rule.getConsequence().evaluate((KnowledgeHelper)knowledgeHelper, (WorkingMemory)workingMemory);
        Assert.assertEquals((Object)new Integer(2), map.get("value"));
    }

    @Test
    public void testSerializable() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        ruleDescr.setConsequence((Object)"map.put(\"value\", new Integer(1) );");
        PackageDescr back = SerializationHelper.serializeObject(packageDescr);
        Assert.assertNotNull((Object)back);
        Assert.assertEquals((Object)"p1", (Object)back.getName());
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        Rule rule = pkg.getRule("rule-1");
        this.assertLength(0, builder.getErrors().getErrors());
        Package newPkg = SerializationHelper.serializeObject(pkg);
        Rule newRule = newPkg.getRule("rule-1");
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        newPkg.getDialectRuntimeRegistry().onAdd(ruleBase.getRootClassLoader());
        newPkg.getDialectRuntimeRegistry().onBeforeExecute();
        ruleBase.getGlobals().put("map", Map.class);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        HashMap map = new HashMap();
        workingMemory.setGlobal("map", map);
        MockTuple tuple = new MockTuple(new HashMap());
        tuple.setLeftTupleSink((LeftTupleSink)new RuleTerminalNode(1, null, newRule, newRule.getLhs(), 0, new BuildContext((InternalRuleBase)ruleBase, null)));
        MockActivation activation = new MockActivation(newRule, 0, newRule.getLhs(), tuple);
        DefaultKnowledgeHelper knowledgeHelper = new DefaultKnowledgeHelper((WorkingMemory)workingMemory);
        knowledgeHelper.setActivation((Activation)activation);
        newRule.getConsequence().evaluate((KnowledgeHelper)knowledgeHelper, (WorkingMemory)workingMemory);
        Assert.assertEquals((Object)new Integer(1), map.get("value"));
    }

    @Test
    @Ignore
    public void testNoPackageName() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        try {
            builder.addPackage(new PackageDescr(null));
            Assert.fail((String)"should have errored here.");
        }
        catch (RuntimeException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            builder.addPackage(new PackageDescr(""));
            Assert.fail((String)"should have errored here.");
        }
        catch (RuntimeException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        builder.addPackageFromDrl((Reader)new StringReader("package foo"));
        builder.addPackageFromDrl((Reader)new StringReader("rule x then end"));
    }

    @Test
    public void testErrorReset() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader("package foo \n rule ORB"));
        Assert.assertTrue((boolean)builder.hasErrors());
        builder.resetErrors();
        Assert.assertFalse((boolean)builder.hasErrors());
        builder.addPackageFromDrl((Reader)new StringReader("package foo \n rule ORB"));
        Assert.assertTrue((boolean)builder.hasErrors());
    }

    @Test
    public void testLiteral() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        pattern.addConstraint((BaseDescr)new ExprConstraintDescr("type == 'stilton'"));
        ruleDescr.setConsequence((Object)"update(stilton);");
        builder.addPackage(packageDescr);
        this.assertLength(0, builder.getErrors().getErrors());
    }

    @Test
    public void testReturnValue() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        BindingDescr fieldBindingDescr = new BindingDescr("x", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        fieldBindingDescr = new BindingDescr("y", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        pattern.addConstraint((BaseDescr)new ExprConstraintDescr("price == (( (Integer) map.get( new Integer( x )) ).intValue() * y)"));
        ruleDescr.setConsequence((Object)"update(stilton);");
        builder.addPackage(packageDescr);
        Assert.assertEquals((String)"Should not have any errors", (long)0L, (long)builder.getErrors().getErrors().length);
    }

    @Test
    public void testReturnValueMethodCompare() {
        PackageBuilder builder1 = new PackageBuilder();
        PackageDescr packageDescr1 = new PackageDescr("package1");
        this.createReturnValueRule(packageDescr1, " x + y ");
        builder1.addPackage(packageDescr1);
        if (builder1.hasErrors()) {
            Assert.fail((String)builder1.getErrors().toString());
        }
        Pattern pattern1 = (Pattern)builder1.getPackage().getRules()[0].getLhs().getChildren().get(0);
        VariableConstraint returnValue1 = (VariableConstraint)pattern1.getConstraints().get(0);
        PackageBuilder builder2 = new PackageBuilder();
        PackageDescr packageDescr2 = new PackageDescr("package2");
        this.createReturnValueRule(packageDescr2, " x + y ");
        builder2.addPackage(packageDescr2);
        Pattern pattern2 = (Pattern)builder2.getPackage().getRules()[0].getLhs().getChildren().get(0);
        VariableConstraint returnValue2 = (VariableConstraint)pattern2.getConstraints().get(0);
        PackageBuilder builder3 = new PackageBuilder();
        PackageDescr packageDescr3 = new PackageDescr("package3");
        this.createReturnValueRule(packageDescr3, " x - y ");
        builder3.addPackage(packageDescr3);
        Pattern pattern3 = (Pattern)builder3.getPackage().getRules()[0].getLhs().getChildren().get(0);
        VariableConstraint returnValue3 = (VariableConstraint)pattern3.getConstraints().get(0);
        Assert.assertEquals((Object)returnValue1, (Object)returnValue2);
        Assert.assertFalse((boolean)returnValue1.equals((Object)returnValue3));
        Assert.assertFalse((boolean)returnValue2.equals((Object)returnValue3));
    }

    @Test
    public void testPredicate() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        BindingDescr fieldBindingDescr = new BindingDescr("x", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        BindingDescr fieldBindingDescr2 = new BindingDescr("y", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr2);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        ExprConstraintDescr predicate = new ExprConstraintDescr("eval(( ( Integer )map.get( new Integer(x) )).intValue() == y)");
        pattern.addConstraint((BaseDescr)predicate);
        ruleDescr.setConsequence((Object)"update(stilton);");
        builder.addPackage(packageDescr);
        this.assertLength(0, builder.getErrors().getErrors());
    }

    @Test
    public void testPredicateMethodCompare() {
        PackageBuilder builder1 = new PackageBuilder();
        PackageDescr packageDescr1 = new PackageDescr("package1");
        this.createPredicateRule(packageDescr1, "eval(x==y)");
        builder1.addPackage(packageDescr1);
        if (builder1.hasErrors()) {
            Assert.fail((String)builder1.getErrors().toString());
        }
        Pattern pattern1 = (Pattern)builder1.getPackage().getRules()[0].getLhs().getChildren().get(0);
        PredicateConstraint predicate1 = (PredicateConstraint)pattern1.getConstraints().get(0);
        PackageBuilder builder2 = new PackageBuilder();
        PackageDescr packageDescr2 = new PackageDescr("package2");
        this.createPredicateRule(packageDescr2, "eval(x==y)");
        builder2.addPackage(packageDescr2);
        if (builder2.hasErrors()) {
            Assert.fail((String)builder2.getErrors().toString());
        }
        Pattern pattern2 = (Pattern)builder2.getPackage().getRules()[0].getLhs().getChildren().get(0);
        PredicateConstraint predicate2 = (PredicateConstraint)pattern2.getConstraints().get(0);
        PackageBuilder builder3 = new PackageBuilder();
        if (builder3.hasErrors()) {
            Assert.fail((String)builder3.getErrors().toString());
        }
        PackageDescr packageDescr3 = new PackageDescr("package3");
        this.createPredicateRule(packageDescr3, "eval(x!=y)");
        builder3.addPackage(packageDescr3);
        Pattern pattern3 = (Pattern)builder3.getPackage().getRules()[0].getLhs().getChildren().get(0);
        PredicateConstraint predicate3 = (PredicateConstraint)pattern3.getConstraints().get(0);
        Assert.assertEquals((Object)predicate1, (Object)predicate2);
        Assert.assertFalse((boolean)predicate1.equals((Object)predicate3));
        Assert.assertFalse((boolean)predicate2.equals((Object)predicate3));
    }

    @Test
    public void testEval() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        BindingDescr fieldBindingDescr = new BindingDescr("x", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        fieldBindingDescr = new BindingDescr("y", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        EvalDescr evalDescr = new EvalDescr((Object)"( ( Integer )map.get( new Integer(x) ) ).intValue() == y");
        lhs.addDescr((BaseDescr)evalDescr);
        ruleDescr.setConsequence((Object)"update(stilton);");
        builder.addPackage(packageDescr);
        this.assertLength(0, builder.getErrors().getErrors());
        Package pkg = builder.getPackage();
        Rule rule = pkg.getRule("rule-1");
        EvalCondition eval = (EvalCondition)rule.getLhs().getChildren().get(1);
        CompiledInvoker invoker = (CompiledInvoker)eval.getEvalExpression();
        List list = invoker.getMethodBytecode();
    }

    @Test
    public void testEvalMethodCompare() {
        PackageBuilder builder1 = new PackageBuilder();
        PackageDescr packageDescr1 = new PackageDescr("package1");
        this.createEvalRule(packageDescr1, "1==1");
        builder1.addPackage(packageDescr1);
        EvalCondition eval1 = (EvalCondition)builder1.getPackage().getRules()[0].getLhs().getChildren().get(0);
        PackageBuilder builder2 = new PackageBuilder();
        PackageDescr packageDescr2 = new PackageDescr("package2");
        this.createEvalRule(packageDescr2, "1==1");
        builder2.addPackage(packageDescr2);
        EvalCondition eval2 = (EvalCondition)builder2.getPackage().getRules()[0].getLhs().getChildren().get(0);
        PackageBuilder builder3 = new PackageBuilder();
        PackageDescr packageDescr3 = new PackageDescr("package3");
        this.createEvalRule(packageDescr3, "1==3");
        builder3.addPackage(packageDescr3);
        EvalCondition eval3 = (EvalCondition)builder3.getPackage().getRules()[0].getLhs().getChildren().get(0);
        Assert.assertEquals((Object)eval1, (Object)eval2);
        Assert.assertFalse((boolean)eval1.equals((Object)eval3));
        Assert.assertFalse((boolean)eval2.equals((Object)eval3));
    }

    @Test
    public void testOr() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        Rule rule = this.createRule((ConditionalElementDescr)new OrDescr(), builder, "update(stilton);");
        this.assertLength(0, builder.getErrors().getErrors());
        GroupElement lhs = rule.getLhs();
        this.assertLength(1, lhs.getChildren());
        GroupElement or = (GroupElement)lhs.getChildren().get(0);
        this.assertLength(1, or.getChildren());
        Pattern pattern = (Pattern)or.getChildren().get(0);
        LiteralConstraint literalConstarint = (LiteralConstraint)pattern.getConstraints().get(0);
    }

    @Test
    public void testAnd() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        Rule rule = this.createRule((ConditionalElementDescr)new AndDescr(), builder, "update(stilton);");
        this.assertLength(0, builder.getErrors().getErrors());
        GroupElement lhs = rule.getLhs();
        this.assertLength(1, lhs.getChildren());
        GroupElement and = (GroupElement)lhs.getChildren().get(0);
        this.assertLength(1, and.getChildren());
        Pattern pattern = (Pattern)and.getChildren().get(0);
        LiteralConstraint literalConstraint = (LiteralConstraint)pattern.getConstraints().get(0);
    }

    @Test
    public void testNot() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        Rule rule = this.createRule((ConditionalElementDescr)new NotDescr(), builder, "update(stilton);");
        Assert.assertTrue((boolean)builder.hasErrors());
        builder = new PackageBuilder();
        rule = this.createRule((ConditionalElementDescr)new NotDescr(), builder, "");
        Assert.assertEquals((long)0L, (long)builder.getErrors().getErrors().length);
        GroupElement lhs = rule.getLhs();
        this.assertLength(1, lhs.getChildren());
        GroupElement not = (GroupElement)lhs.getChildren().get(0);
        this.assertLength(1, not.getChildren());
        Pattern pattern = (Pattern)not.getChildren().get(0);
        LiteralConstraint literalConstarint = (LiteralConstraint)pattern.getConstraints().get(0);
    }

    @Test
    public void testExists() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        Rule rule = this.createRule((ConditionalElementDescr)new ExistsDescr(), builder, "update(stilton);");
        Assert.assertTrue((boolean)builder.hasErrors());
        builder = new PackageBuilder();
        rule = this.createRule((ConditionalElementDescr)new ExistsDescr(), builder, "");
        Assert.assertEquals((long)0L, (long)builder.getErrors().getErrors().length);
        GroupElement lhs = rule.getLhs();
        this.assertLength(1, lhs.getChildren());
        GroupElement exists = (GroupElement)lhs.getChildren().get(0);
        this.assertLength(1, exists.getChildren());
        Pattern pattern = (Pattern)exists.getChildren().get(0);
        LiteralConstraint literalConstarint = (LiteralConstraint)pattern.getConstraints().get(0);
    }

    @Test
    public void testNumbers() throws Exception {
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("booleanPrimitive == true "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("booleanPrimitive == false "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("charPrimitive == 'a' "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("charPrimitive == \"a\" "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("bytePrimitive == 1 "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("bytePrimitive == 0 "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("bytePrimitive == -1 "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("shortPrimitive == 1 "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("shortPrimitive == 0 "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("shortPrimitive == -1 "));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("intPrimitive == 1"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("intPrimitive == 0"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("intPrimitive == -1"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("longPrimitive == 1"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("longPrimitive == 0"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("longPrimitive == -1"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("floatPrimitive == 1.1"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("floatPrimitive == 0"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("floatPrimitive == -1.1"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("doublePrimitive == 1.1"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("doublePrimitive == 0"));
        this.createLiteralRule((BaseDescr)new ExprConstraintDescr("doublePrimitive == -1.1"));
    }

    @Test
    public void testNull() {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr patternDescr = new PatternDescr(Cheese.class.getName(), "stilton");
        FieldConstraintDescr literalDescr = new FieldConstraintDescr("type");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", null));
        patternDescr.addConstraint((BaseDescr)literalDescr);
        ruleDescr.setConsequence((Object)"");
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        Rule rule = pkg.getRule("rule-1");
        this.assertLength(0, builder.getErrors().getErrors());
    }

    @Test
    public void testWarnings() {
        System.setProperty("drools.kbuilder.severity.duplicateRule", "WARNING");
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr1 = this.createBasicPackageWithOneRule(11, 1);
        PackageDescr packageDescr2 = this.createBasicPackageWithOneRule(22, 2);
        builder.addPackage(packageDescr1);
        builder.addPackage(packageDescr2);
        Assert.assertFalse((boolean)builder.hasErrors());
        Assert.assertTrue((boolean)builder.hasWarnings());
    }

    @Test
    public void testWarningsReportAsErrors() {
        System.setProperty("drools.kbuilder.severity.duplicateRule", "ERROR");
        PackageBuilderConfiguration cfg = new PackageBuilderConfiguration();
        PackageBuilder builder = new PackageBuilder(cfg);
        PackageDescr packageDescr1 = this.createBasicPackageWithOneRule(11, 1);
        PackageDescr packageDescr2 = this.createBasicPackageWithOneRule(22, 2);
        builder.addPackage(packageDescr1);
        builder.addPackage(packageDescr2);
        Assert.assertTrue((boolean)builder.hasErrors());
        Assert.assertFalse((boolean)builder.hasWarnings());
    }

    @Test
    public void testResetWarnings() {
        System.setProperty("drools.kbuilder.severity.duplicateRule", "WARNING");
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr1 = this.createBasicPackageWithOneRule(11, 1);
        PackageDescr packageDescr2 = this.createBasicPackageWithOneRule(22, 2);
        builder.addPackage(packageDescr1);
        builder.addPackage(packageDescr2);
        Assert.assertTrue((boolean)builder.hasWarnings());
        builder.resetWarnings();
        Assert.assertFalse((boolean)builder.hasWarnings());
        builder.addPackage(packageDescr1);
        Assert.assertTrue((boolean)builder.hasWarnings());
    }

    @Test
    public void testResetProblems() throws DroolsParserException, IOException {
        System.setProperty("drools.kbuilder.severity.duplicateRule", "WARNING");
        System.setProperty("drools.kbuilder.severity.duplicateFunction", "ERROR");
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr1 = this.createBasicPackageWithOneRule(11, 1);
        PackageDescr packageDescr2 = this.createBasicPackageWithOneRule(22, 2);
        builder.addPackage(packageDescr1);
        builder.addPackage(packageDescr2);
        builder.addPackageFromDrl((Reader)new StringReader("package foo \n rule ORB"));
        builder.addPackageFromDrl((Reader)new StringReader("package org.drools\nfunction boolean testIt() {\n  return true;\n}\n"));
        builder.addPackageFromDrl((Reader)new StringReader("package org.drools\nfunction boolean testIt() {\n  return false;\n}\n"));
        Assert.assertTrue((boolean)builder.hasWarnings());
        Assert.assertTrue((boolean)builder.hasErrors());
        builder.resetProblems();
        Assert.assertFalse((boolean)builder.hasWarnings());
        Assert.assertFalse((boolean)builder.hasErrors());
    }

    @Test
    public void testResetWarningsButNotErrors() throws DroolsParserException, IOException {
        System.setProperty("drools.kbuilder.severity.duplicateRule", "WARNING");
        System.setProperty("drools.kbuilder.severity.duplicateFunction", "ERROR");
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr1 = this.createBasicPackageWithOneRule(11, 1);
        PackageDescr packageDescr2 = this.createBasicPackageWithOneRule(22, 2);
        builder.addPackage(packageDescr1);
        builder.addPackage(packageDescr2);
        builder.addPackageFromDrl((Reader)new StringReader("package foo \n rule ORB"));
        builder.addPackageFromDrl((Reader)new StringReader("package org.drools\nfunction boolean testIt() {\n  return true;\n}\n"));
        builder.addPackageFromDrl((Reader)new StringReader("package org.drools\nfunction boolean testIt() {\n  return false;\n}\n"));
        Assert.assertTrue((boolean)builder.hasWarnings());
        Assert.assertTrue((boolean)builder.hasErrors());
        builder.resetWarnings();
        Assert.assertFalse((boolean)builder.hasWarnings());
        Assert.assertTrue((boolean)builder.hasErrors());
    }

    @Test
    public void testWarnOnFunctionReplacement() throws DroolsParserException, IOException {
        System.setProperty("drools.kbuilder.severity.duplicateFunction", "WARNING");
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new StringReader("package org.drools\nfunction boolean testIt() {\n  return true;\n}\n"));
        builder.addPackageFromDrl((Reader)new StringReader("package org.drools\nfunction boolean testIt() {\n  return false;\n}\n"));
        Assert.assertTrue((boolean)builder.hasWarnings());
    }

    @Test
    public void testDuplicateRuleNames() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = this.createBasicPackageWithOneRule(1, 1);
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        ruleDescr.setLocation(42, 43);
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr patternDescr = new PatternDescr(Cheese.class.getName(), "stilton");
        FieldConstraintDescr literalDescr = new FieldConstraintDescr("type");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("!=", null));
        patternDescr.addConstraint((BaseDescr)literalDescr);
        ruleDescr.setConsequence((Object)"");
        ruleDescr = new RuleDescr("rule-2");
        ruleDescr.setLocation(42, 43);
        packageDescr.addRule(ruleDescr);
        lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        patternDescr = new PatternDescr(Cheese.class.getName(), "stilton");
        literalDescr = new FieldConstraintDescr("type");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("!=", null));
        patternDescr.addConstraint((BaseDescr)literalDescr);
        ruleDescr.setConsequence((Object)"");
        builder.addPackage(packageDescr);
        this.assertLength(1, builder.getErrors().getErrors());
        ParserError err = (ParserError)builder.getErrors().getErrors()[0];
        Assert.assertEquals((long)42L, (long)err.getRow());
        Assert.assertEquals((long)43L, (long)err.getCol());
    }

    private PackageDescr createBasicPackageWithOneRule(int line, int col) {
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        ruleDescr.setLocation(line, col);
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr patternDescr = new PatternDescr(Cheese.class.getName(), "stilton");
        FieldConstraintDescr literalDescr = new FieldConstraintDescr("type");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", null));
        patternDescr.addConstraint((BaseDescr)literalDescr);
        ruleDescr.setConsequence((Object)"");
        return packageDescr;
    }

    @Test
    @Ignore
    public void testDuplicateDeclaration() {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern1 = new PatternDescr(Cheese.class.getName());
        lhs.addDescr((BaseDescr)pattern1);
        BindingDescr fieldBindingDescr = new BindingDescr("$type", "type");
        FieldConstraintDescr literalDescr = new FieldConstraintDescr("type");
        literalDescr.addRestriction((RestrictionDescr)new LiteralRestrictionDescr("==", "stilton"));
        pattern1.addConstraint((BaseDescr)fieldBindingDescr);
        pattern1.addConstraint((BaseDescr)literalDescr);
        PatternDescr pattern2 = new PatternDescr(Cheese.class.getName());
        lhs.addDescr((BaseDescr)pattern2);
        pattern2.addConstraint((BaseDescr)fieldBindingDescr);
        ruleDescr.setConsequence((Object)"update(stilton);");
        builder.addPackage(packageDescr);
        this.assertLength(2, builder.getErrors().getErrors());
    }

    @Test
    public void testCompilerConfiguration() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr pkgDescr = new PackageDescr("org.test");
        builder.addPackage(pkgDescr);
        DialectCompiletimeRegistry reg = builder.getPackageRegistry(pkgDescr.getName()).getDialectCompiletimeRegistry();
        Field dialectField = builder.getClass().getDeclaredField("defaultDialect");
        dialectField.setAccessible(true);
        String dialectName = (String)dialectField.get(builder);
        reg = builder.getPackageRegistry(pkgDescr.getName()).getDialectCompiletimeRegistry();
        Dialect dialect = reg.getDialect(dialectName);
        Field compilerField = dialect.getClass().getDeclaredField("compiler");
        compilerField.setAccessible(true);
        JavaCompiler compiler = (JavaCompiler)compilerField.get(dialect);
        Assert.assertSame(EclipseJavaCompiler.class, compiler.getClass());
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        JavaDialectConfiguration javaConf = (JavaDialectConfiguration)conf.getDialectConfiguration("java");
        javaConf.setCompiler(1);
        builder = new PackageBuilder(conf);
        builder.addPackage(pkgDescr);
        dialectName = (String)dialectField.get(builder);
        reg = builder.getPackageRegistry(pkgDescr.getName()).getDialectCompiletimeRegistry();
        dialect = reg.getDialect(dialectName);
        compiler = (JavaCompiler)compilerField.get(dialect);
        Assert.assertSame(JaninoJavaCompiler.class, compiler.getClass());
        conf = new PackageBuilderConfiguration();
        javaConf = (JavaDialectConfiguration)conf.getDialectConfiguration("java");
        javaConf.setCompiler(0);
        builder = new PackageBuilder(conf);
        builder.addPackage(pkgDescr);
        dialectName = (String)dialectField.get(builder);
        reg = builder.getPackageRegistry(pkgDescr.getName()).getDialectCompiletimeRegistry();
        dialect = reg.getDialect(dialectName);
        compiler = (JavaCompiler)compilerField.get(dialect);
        Assert.assertSame(EclipseJavaCompiler.class, compiler.getClass());
    }

    @Test
    public void testTypeDeclaration() throws Exception {
        PackageDescr pkgDescr = new PackageDescr("org.drools");
        TypeDeclarationDescr typeDescr = new TypeDeclarationDescr("StockTick");
        typeDescr.addAnnotation("role", "event");
        typeDescr.addAnnotation("class", "org.drools.StockTick");
        pkgDescr.addTypeDeclaration(typeDescr);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(pkgDescr);
        if (builder.hasErrors()) {
            Assert.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        Assert.assertEquals((long)1L, (long)pkg.getTypeDeclarations().size());
        TypeDeclaration type = pkg.getTypeDeclaration("StockTick");
        Assert.assertEquals((Object)"StockTick", (Object)type.getTypeName());
        Assert.assertEquals((Object)TypeDeclaration.Role.EVENT, (Object)type.getRole());
        Assert.assertEquals(StockTick.class, (Object)type.getTypeClass());
    }

    @Test
    public void testTypeDeclarationNewBean() throws Exception {
        PackageDescr pkgDescr = new PackageDescr("org.test");
        TypeDeclarationDescr typeDescr = new TypeDeclarationDescr("NewBean");
        TypeFieldDescr f1 = new TypeFieldDescr("name", new PatternDescr("String"));
        TypeFieldDescr f2 = new TypeFieldDescr("age", new PatternDescr("int"));
        typeDescr.addField(f1);
        typeDescr.addField(f2);
        pkgDescr.addTypeDeclaration(typeDescr);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(pkgDescr);
        Package pkg = builder.getPackage();
        Assert.assertEquals((long)1L, (long)pkg.getTypeDeclarations().size());
        TypeDeclaration type = pkg.getTypeDeclaration("NewBean");
        Assert.assertEquals((Object)"NewBean", (Object)type.getTypeName());
        Assert.assertEquals((Object)TypeDeclaration.Role.FACT, (Object)type.getRole());
        Assert.assertEquals((Object)"org.test.NewBean", (Object)type.getTypeClass().getName());
        Assert.assertFalse((boolean)builder.hasErrors());
        Package bp = builder.getPackage();
        CompositeClassLoader rootClassloader = ClassLoaderUtil.getClassLoader((ClassLoader[])new ClassLoader[]{Thread.currentThread().getContextClassLoader()}, ((Object)((Object)this)).getClass(), (boolean)false);
        JavaDialectRuntimeData dialectData = (JavaDialectRuntimeData)bp.getDialectRuntimeRegistry().getDialectData("java");
        dialectData.onAdd(bp.getDialectRuntimeRegistry(), rootClassloader);
        Class newBean = rootClassloader.loadClass("org.test.NewBean");
        Assert.assertNotNull((Object)newBean);
    }

    @Test
    public void testPackageMerge() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        try {
            builder.addPackage(new PackageDescr("org.drools"));
            builder.addPackageFromDrl((Reader)new StringReader("package org.drools\nfunction boolean testIt() {\n  return true;\n}\n"));
        }
        catch (RuntimeException e) {
            Assert.fail((String)("Should not raise any exception: " + e.getMessage()));
        }
    }

    private void createReturnValueRule(PackageDescr packageDescr, String expression) {
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        BindingDescr fieldBindingDescr = new BindingDescr("x", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        fieldBindingDescr = new BindingDescr("y", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        pattern.addConstraint((BaseDescr)new ExprConstraintDescr("price == (" + expression + ")"));
        ruleDescr.setConsequence((Object)"update(stilton);");
    }

    private void createPredicateRule(PackageDescr packageDescr, String expression) {
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Cheese.class.getName(), "stilton");
        lhs.addDescr((BaseDescr)pattern);
        BindingDescr fieldBindingDescr = new BindingDescr("x", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr);
        BindingDescr fieldBindingDescr2 = new BindingDescr("y", "price");
        pattern.addConstraint((BaseDescr)fieldBindingDescr2);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        pattern.addConstraint((BaseDescr)new ExprConstraintDescr(expression));
        ruleDescr.setConsequence((Object)"update(stilton);");
    }

    private void createEvalRule(PackageDescr packageDescr, String expression) {
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        packageDescr.addGlobal(new GlobalDescr("map", "java.util.Map"));
        EvalDescr evalDescr = new EvalDescr((Object)expression);
        lhs.addDescr((BaseDescr)evalDescr);
        ruleDescr.setConsequence((Object)"");
    }

    private void createLiteralRule(BaseDescr descr) {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr pattern = new PatternDescr(Primitives.class.getName());
        lhs.addDescr((BaseDescr)pattern);
        pattern.addConstraint(descr);
        ruleDescr.setConsequence((Object)"");
        builder.addPackage(packageDescr);
        this.assertLength(0, builder.getErrors().getErrors());
    }

    private Rule createRule(ConditionalElementDescr ceDescr, PackageBuilder builder, String consequence) throws Exception {
        PackageDescr packageDescr = new PackageDescr("p1");
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        lhs.addDescr((BaseDescr)ceDescr);
        PatternDescr patternDescr = new PatternDescr(Cheese.class.getName(), "stilton");
        patternDescr.addConstraint((BaseDescr)new ExprConstraintDescr("type == \"stilton\" "));
        ceDescr.addDescr((BaseDescr)patternDescr);
        ruleDescr.setConsequence((Object)consequence);
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        Rule rule = pkg.getRule("rule-1");
        Assert.assertEquals((Object)"rule-1", (Object)rule.getName());
        return rule;
    }

    @Test
    public void testJaninoWithStaticImports() throws Exception {
        PackageBuilderConfiguration cfg = new PackageBuilderConfiguration();
        JavaDialectConfiguration javaConf = (JavaDialectConfiguration)cfg.getDialectConfiguration("java");
        javaConf.setCompiler(1);
        PackageBuilder bldr = new PackageBuilder(cfg);
        bldr.addPackageFromDrl((Reader)new StringReader("package testBuilderPackageConfig \n import java.util.List"));
        bldr.addPackageFromDrl((Reader)new StringReader("package testBuilderPackageConfig \n function void doSomething() {\n System.err.println(List.class.toString()); }"));
        Assert.assertFalse((boolean)bldr.hasErrors());
    }

    @Test
    public void testSinglePackage() throws Exception {
        PackageBuilderConfiguration cfg = new PackageBuilderConfiguration();
        cfg.setAllowMultipleNamespaces(false);
        PackageBuilder bldr = new PackageBuilder(cfg);
        bldr.addPackageFromDrl((Reader)new StringReader("package whee\n import org.drools.Cheese"));
        Assert.assertFalse((boolean)bldr.hasErrors());
        bldr.addPackageFromDrl((Reader)new StringReader("package whee\n import org.drools.Person"));
        Assert.assertFalse((boolean)bldr.hasErrors());
        bldr.addPackageFromDrl((Reader)new StringReader("package whee2\n import org.drools.Person"));
        Assert.assertFalse((boolean)bldr.hasErrors());
        Assert.assertEquals((long)1L, (long)bldr.getPackages().length);
        cfg = new PackageBuilderConfiguration();
        Assert.assertEquals((Object)true, (Object)cfg.isAllowMultipleNamespaces());
        bldr = new PackageBuilder(cfg);
        bldr.addPackageFromDrl((Reader)new StringReader("package whee\n import org.drools.Cheese"));
        Assert.assertFalse((boolean)bldr.hasErrors());
        bldr.addPackageFromDrl((Reader)new StringReader("import org.drools.Person"));
        Assert.assertFalse((boolean)bldr.hasErrors());
        bldr.addPackageFromDrl((Reader)new StringReader("package whee2\n import org.drools.Person"));
        Assert.assertFalse((boolean)bldr.hasErrors());
        Assert.assertEquals((long)3L, (long)bldr.getPackages().length);
    }

    @Test
    public void testTimeWindowBehavior() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        PackageDescr packageDescr = new PackageDescr("p1");
        TypeDeclarationDescr typeDeclDescr = new TypeDeclarationDescr(StockTick.class.getName());
        typeDeclDescr.addAnnotation("role", "event");
        packageDescr.addTypeDeclaration(typeDeclDescr);
        RuleDescr ruleDescr = new RuleDescr("rule-1");
        packageDescr.addRule(ruleDescr);
        AndDescr lhs = new AndDescr();
        ruleDescr.setLhs(lhs);
        PatternDescr patternDescr = new PatternDescr(StockTick.class.getName(), "$tick");
        BehaviorDescr windowDescr = new BehaviorDescr("window");
        windowDescr.setSubType("time");
        windowDescr.setParameters(Collections.singletonList("60000"));
        patternDescr.addBehavior(windowDescr);
        lhs.addDescr((BaseDescr)patternDescr);
        ruleDescr.setConsequence((Object)"System.out.println( $tick );");
        builder.addPackage(packageDescr);
        this.assertLength(0, builder.getErrors().getErrors());
        Package pkg = builder.getPackage();
        Rule rule = pkg.getRule("rule-1");
        Assert.assertNotNull((Object)rule);
        Pattern pattern = (Pattern)rule.getLhs().getChildren().get(0);
        Assert.assertEquals((Object)StockTick.class.getName(), (Object)((ClassObjectType)pattern.getObjectType()).getClassType().getName());
        Behavior window = (Behavior)pattern.getBehaviors().get(0);
        Assert.assertEquals((Object)Behavior.BehaviorType.TIME_WINDOW, (Object)window.getType());
        Assert.assertEquals((long)60000L, (long)((SlidingTimeWindow)window).getSize());
    }

    class MockTuple
    extends LeftTupleImpl {
        private Map declarations;

        public MockTuple(Map declarations) {
            this.declarations = declarations;
        }

        public InternalFactHandle get(int patern) {
            return null;
        }

        public InternalFactHandle get(Declaration declaration) {
            return (InternalFactHandle)this.declarations.get(declaration);
        }

        public InternalFactHandle[] getFactHandles() {
            return (InternalFactHandle[])this.declarations.values().toArray(new FactHandle[0]);
        }

        public boolean dependsOn(FactHandle handle) {
            return false;
        }

        public void setActivation(Activation activation) {
        }

        public long getRecency() {
            return 0L;
        }

        public int size() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MockActivation
    implements Activation {
        private Rule rule;
        private int salience;
        private final GroupElement subrule;
        private LeftTupleImpl tuple;

        public MockActivation(Rule rule, int salience, GroupElement subrule, LeftTupleImpl tuple) {
            this.rule = rule;
            this.salience = salience;
            this.tuple = tuple;
            this.subrule = subrule;
        }

        public Rule getRule() {
            return this.rule;
        }

        public int getSalience() {
            return this.salience;
        }

        public LeftTupleImpl getTuple() {
            return this.tuple;
        }

        public PropagationContext getPropagationContext() {
            return null;
        }

        public long getActivationNumber() {
            return 0L;
        }

        public void remove() {
        }

        public void addLogicalDependency(LogicalDependency node) {
        }

        public LinkedList getLogicalDependencies() {
            return null;
        }

        public boolean isActivated() {
            return false;
        }

        public void setActivated(boolean activated) {
        }

        public ActivationGroupNode getActivationGroupNode() {
            return null;
        }

        public void setActivationGroupNode(ActivationGroupNode activationGroupNode) {
        }

        public GroupElement getSubRule() {
            return this.subrule;
        }

        public AgendaGroup getAgendaGroup() {
            return null;
        }

        public ActivationNode getActivationNode() {
            return null;
        }

        public void setActivationNode(ActivationNode ruleFlowGroupNode) {
        }

        public void setLogicalDependencies(LinkedList justified) {
        }

        public List<FactHandle> getFactHandles() {
            return null;
        }

        public List<Object> getObjects() {
            return null;
        }

        public Object getDeclarationValue(String variableName) {
            return null;
        }

        public List<String> getDeclarationIDs() {
            return null;
        }

        public InternalFactHandle getFactHandle() {
            return null;
        }

        public boolean isAdded() {
            return false;
        }

        public boolean isActive() {
            return this.isActivated();
        }

        public void addBlocked(LogicalDependency node) {
        }

        public LinkedList getBlocked() {
            return null;
        }

        public void setBlocked(LinkedList justified) {
        }

        public void addBlocked(LinkedListNode node) {
        }

        public LinkedList getBlockers() {
            return null;
        }
    }
}

