/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.conf.EventProcessingOption;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.conf.MBeansOption;
import org.drools.definition.rule.Rule;
import org.drools.definition.type.Position;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.io.impl.ByteArrayResource;
import org.junit.Assert;
import org.junit.Test;

public class AnnotationsTest {
    @Test
    public void annotationTest() {
        String drl = "package org.drools.test;\n import org.drools.definition.type.Position; \n import org.drools.integrationtests.AnnotationsTest.Annot; \ndeclare AnnotatedBean \n @Deprecated \n @Annot( intProp=7          ,typeProp=String.class          ,strProp=\"hello world\"          ,enumProp=AnnPropEnum.THREE          ,dblArrProp={1.0,2.0}          ,typeArrProp={String.class, org.drools.integrationtests.AnnotationsTest.class}          ,strArrProp={\"x1\",\"x2\"}          ,enumArrProp={AnnPropEnum.ONE, AnnPropEnum.THREE}          ) \n  \n  @role(event) \n   age : int \n name : String      @key    @Position(0)    @Deprecated \n end \n   \n\n declare SecondBean \n  @NonexistingAnnotation  \n field : String @Annot \nend \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        junit.framework.Assert.assertEquals((int)0, (int)kbuilder.getErrors().size());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        Class clazz = kbase.getFactType("org.drools.test", "AnnotatedBean").getFactClass();
        junit.framework.Assert.assertNotNull((Object)clazz);
        try {
            Field fld = clazz.getDeclaredField("name");
            junit.framework.Assert.assertEquals((int)2, (int)fld.getAnnotations().length);
            junit.framework.Assert.assertNotNull((Object)fld.getAnnotation(Deprecated.class));
            junit.framework.Assert.assertNotNull((Object)fld.getAnnotation(Position.class));
            Position pos = fld.getAnnotation(Position.class);
            junit.framework.Assert.assertEquals((int)0, (int)pos.value());
        }
        catch (NoSuchFieldException nsfe) {
            Assert.fail((String)("field name has not been generated correctly : " + nsfe.getMessage()));
        }
        Annotation[] anns = clazz.getAnnotations();
        junit.framework.Assert.assertEquals((int)2, (int)anns.length);
        junit.framework.Assert.assertNotNull((Object)clazz.getAnnotation(Deprecated.class));
        junit.framework.Assert.assertNotNull((Object)clazz.getAnnotation(Annot.class));
        Annot ann = clazz.getAnnotation(Annot.class);
        junit.framework.Assert.assertEquals((int)7, (int)ann.intProp());
        junit.framework.Assert.assertEquals(String.class, (Object)ann.typeProp());
        junit.framework.Assert.assertEquals((String)"hello world", (String)ann.strProp());
        junit.framework.Assert.assertEquals((Object)((Object)AnnPropEnum.THREE), (Object)((Object)ann.enumProp()));
        Assert.assertArrayEquals((double[])new double[]{1.0, 2.0}, (double[])ann.dblArrProp(), (double)1.0E-16);
        Assert.assertArrayEquals((Object[])new Class[]{String.class, AnnotationsTest.class}, (Object[])ann.typeArrProp());
        Assert.assertArrayEquals((Object[])new String[]{"x1", "x2"}, (Object[])ann.strArrProp());
        Assert.assertArrayEquals((Object[])new AnnPropEnum[]{AnnPropEnum.ONE, AnnPropEnum.THREE}, (Object[])ann.enumArrProp());
        Class clazz2 = kbase.getFactType("org.drools.test", "SecondBean").getFactClass();
        junit.framework.Assert.assertNotNull((Object)clazz2);
        Annotation[] anns2 = clazz2.getAnnotations();
        junit.framework.Assert.assertEquals((int)0, (int)anns2.length);
        Annot ann2 = null;
        try {
            Field fld2 = clazz2.getDeclaredField("field");
            junit.framework.Assert.assertEquals((int)1, (int)fld2.getAnnotations().length);
            junit.framework.Assert.assertNotNull((Object)fld2.getAnnotation(Annot.class));
            ann2 = fld2.getAnnotation(Annot.class);
        }
        catch (NoSuchFieldException nsfe) {
            Assert.fail((String)("field name has not been generated correctly : " + nsfe.getMessage()));
        }
        junit.framework.Assert.assertNotNull(ann2);
        junit.framework.Assert.assertEquals((int)0, (int)ann2.intProp());
        junit.framework.Assert.assertEquals((String)"foo", (String)ann2.strProp());
        junit.framework.Assert.assertEquals((Object)((Object)AnnPropEnum.ONE), (Object)((Object)ann2.enumProp()));
        Assert.assertArrayEquals((double[])new double[]{0.4, 0.5}, (double[])ann2.dblArrProp(), (double)1.0E-16);
        Assert.assertArrayEquals((Object[])new String[]{"a", "b", "c"}, (Object[])ann2.strArrProp());
        Assert.assertArrayEquals((Object[])new AnnPropEnum[]{AnnPropEnum.TWO, AnnPropEnum.THREE}, (Object[])ann2.enumArrProp());
    }

    @Test
    public void annotationErrorTest() {
        String drl = "package org.drools.test;\n declare MissingAnnotationBean \n @IgnoreMissingAnnotation1 \n name : String      @IgnoreMissingAnnotation2( noProp = 999 ) \n end \n ";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(drl.getBytes()), ResourceType.DRL);
        junit.framework.Assert.assertEquals((int)0, (int)kbuilder.getErrors().size());
        String drl2 = "package org.drools.test;\n import org.drools.integrationtests.AnnotationsTest.Annot; \ndeclare MissingAnnotationBean \n @Annot( wrongProp1 = 1 ) \n name : String      @Annot( wrongProp2 = 2, wrongProp3 = 3 ) \n end \n ";
        KnowledgeBuilder kbuilder2 = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder2.add((Resource)new ByteArrayResource(drl2.getBytes()), ResourceType.DRL);
        junit.framework.Assert.assertEquals((int)2, (int)kbuilder2.getErrors().size());
    }

    @Test
    public void testRuleAnnotation() {
        String drl = "package org.drools\nrule X\n    @author(\"John Doe\")\n    @output(Hello World!)\n    @value( 10 + 10 )\n    @alt( \"Hello \"+\"World!\" )\nwhen\n    Person()\nthen\nend";
        KnowledgeBaseConfiguration conf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        conf.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        conf.setOption((KnowledgeBaseOption)MBeansOption.ENABLED);
        KnowledgeBase kbase = this.loadKnowledgeBase("kb1", drl, conf);
        Rule rule = kbase.getRule("org.drools", "X");
        Assert.assertEquals((Object)"John Doe", rule.getMetaData().get("author"));
        Assert.assertEquals((Object)"Hello World!", rule.getMetaData().get("output"));
        Assert.assertEquals((long)20L, (long)((Number)rule.getMetaData().get("value")).intValue());
        Assert.assertEquals((Object)"Hello World!", rule.getMetaData().get("alt"));
    }

    @Test
    public void testRuleAnnotation2() {
        String drl = "package org.drools\nrule X\n    @alt(\" \\\"<- these are supposed to be the only quotes ->\\\" \")\nwhen\n    Person()\nthen\nend";
        KnowledgeBaseConfiguration conf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        conf.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        conf.setOption((KnowledgeBaseOption)MBeansOption.ENABLED);
        KnowledgeBase kbase = this.loadKnowledgeBase("kb1", drl, conf);
        Rule rule = kbase.getRule("org.drools", "X");
        Assert.assertEquals((Object)" \"<- these are supposed to be the only quotes ->\" ", rule.getMetaData().get("alt"));
    }

    private KnowledgeBase loadKnowledgeBase(String id, String drl, KnowledgeBaseConfiguration conf) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((String)id, (KnowledgeBaseConfiguration)conf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface Annot {
        public int intProp() default 0;

        public Class typeProp();

        public String strProp() default "foo";

        public AnnPropEnum enumProp() default AnnPropEnum.ONE;

        public double[] dblArrProp() default {0.4, 0.5};

        public Class[] typeArrProp();

        public String[] strArrProp() default {"a", "b", "c"};

        public AnnPropEnum[] enumArrProp() default {AnnPropEnum.TWO, AnnPropEnum.THREE};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AnnPropEnum {
        ONE("one"),
        TWO("two"),
        THREE("three");

        private String value;

        private AnnPropEnum(String s) {
            this.value = s;
        }

        public String getValue() {
            return this.value;
        }
    }
}

