/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Mailbox;
import org.drools.Message;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionConstraintsTest {
    @Test
    public void testExpressionConstraints1() {
        String drl = "package org.drools\nimport org.drools.Mailbox.FolderType;\nrule R1\n        dialect \"mvel\"\n    when\n        $m : Mailbox( \n                $folderType : getDefaultFolderType(),\n                FolderType.INBOX == $folderType,\n                $folderType == FolderType.INBOX,\n                $mailForFolder2 : getMailTypeForFolderType(getDefaultFolderType()),\n                FolderType.SENT != getDefaultFolderType(), \n                getDefaultFolderType() != FolderType.SENT, \n                getMailTypeForFolderType($folderType) == MailType.WORK,\n                1 > 0\n        )\n    then\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(drl);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Mailbox mbox = new Mailbox("me@test.com");
        Message message = new Message();
        message.setMessage("Welcome");
        message.setStatus(0);
        mbox.getFolder(Mailbox.FolderType.INBOX).add(message);
        ksession.insert((Object)mbox);
        ksession.insert((Object)message);
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rules);
    }

    @Test
    public void testExpressionConstraints2() {
        String drl = "package org.drools\nimport org.drools.Mailbox.FolderType;\nrule R1\n    dialect \"mvel\"\n    when\n        $m : Mailbox( \n                $me : owneremail,\n                recentContacts[Mailbox.TEST_EMAIL] != null,\n                recentContacts[\"me@test.com\"] != null,\n                $d1 : recentContacts[Mailbox.TEST_EMAIL],\n                $d2 : recentContacts[\"me@test.com\"],\n                recentContacts.get(owneremail) != null,\n                recentContacts.get($me) != null,\n                recentContacts[$me] != null,\n                $d3: recentContacts.get(owneremail),\n                // Waiting for MVEL fixes for the following 2 scenarios                // recentContacts[owneremail] != null,\n                // recentContacts[getOwneremail()] != null,\n                0 < 1\n        )\n    then\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(drl);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Mailbox mbox = new Mailbox("me@test.com");
        Message message = new Message();
        message.setMessage("Welcome");
        message.setStatus(0);
        mbox.getFolder(Mailbox.FolderType.INBOX).add(message);
        ksession.insert((Object)mbox);
        ksession.insert((Object)message);
        int rules = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rules);
    }

    private KnowledgeBase loadKnowledgeBaseFromString(String ... drlContentStrings) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (String drlContentString : drlContentStrings) {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drlContentString.getBytes()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }
}

