/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.drools.base.evaluators.EvaluatorRegistry;
import org.drools.compiler.DroolsParserException;
import org.drools.lang.DRLLexer;
import org.drools.lang.DRLParser;
import org.drools.lang.dsl.DefaultExpander;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ErrorsParserTest {
    private DRLParser parser;

    @Before
    public void setUp() throws Exception {
        this.parser = null;
        new EvaluatorRegistry();
    }

    @After
    public void tearDown() throws Exception {
        this.parser = null;
    }

    @Test
    public void testNotBindindShouldBarf() throws Exception {
        DRLParser parser = this.parseResource("not_with_binding_error.drl");
        parser.compilationUnit();
        Assert.assertTrue((boolean)parser.hasErrors());
    }

    @Test
    public void testExpanderErrorsAfterExpansion() throws Exception {
        String name = "expander_post_errors.dslr";
        DefaultExpander expander = new DefaultExpander();
        String expanded = expander.expand(this.getReader("expander_post_errors.dslr"));
        DRLParser parser = this.parse("expander_post_errors.dslr", expanded);
        parser.compilationUnit();
        Assert.assertTrue((boolean)parser.hasErrors());
        Assert.assertEquals((long)1L, (long)parser.getErrors().size());
        DroolsParserException err = (DroolsParserException)((Object)parser.getErrors().get(0));
        Assert.assertEquals((long)6L, (long)err.getLineNumber());
    }

    @Test
    public void testInvalidSyntax_Catches() throws Exception {
        this.parseResource("invalid_syntax.drl").compilationUnit();
        Assert.assertTrue((boolean)this.parser.hasErrors());
    }

    @Test
    public void testMultipleErrors() throws Exception {
        this.parseResource("multiple_errors.drl").compilationUnit();
        Assert.assertTrue((boolean)this.parser.hasErrors());
        Assert.assertEquals((long)2L, (long)this.parser.getErrors().size());
    }

    @Test
    public void testPackageGarbage() throws Exception {
        this.parseResource("package_garbage.drl").compilationUnit();
        Assert.assertTrue((boolean)this.parser.hasErrors());
    }

    @Test
    public void testEvalWithSemicolon() throws Exception {
        this.parseResource("eval_with_semicolon.drl").compilationUnit();
        Assert.assertTrue((boolean)this.parser.hasErrors());
        Assert.assertEquals((long)1L, (long)this.parser.getErrorMessages().size());
        Assert.assertEquals((Object)"ERR 102", (Object)((DroolsParserException)((Object)this.parser.getErrors().get(0))).getErrorCode());
    }

    @Test
    public void testLexicalError() throws Exception {
        this.parseResource("lex_error.drl").compilationUnit();
        Assert.assertTrue((boolean)this.parser.hasErrors());
    }

    @Test
    public void testTempleteError() throws Exception {
        this.parseResource("template_test_error.drl").compilationUnit();
        Assert.assertTrue((boolean)this.parser.hasErrors());
    }

    @Test
    public void testErrorMessageForMisplacedParenthesis() throws Exception {
        DRLParser parser = this.parseResource("misplaced_parenthesis.drl");
        parser.compilationUnit();
        Assert.assertTrue((String)"Parser should have raised errors", (boolean)parser.hasErrors());
        Assert.assertEquals((long)1L, (long)parser.getErrors().size());
        Assert.assertEquals((Object)"ERR 102", (Object)((DroolsParserException)((Object)parser.getErrors().get(0))).getErrorCode());
    }

    @Test
    public void testNPEOnParser() throws Exception {
        DRLParser parser = this.parseResource("npe_on_parser.drl");
        parser.compilationUnit();
        Assert.assertTrue((String)"Parser should have raised errors", (boolean)parser.hasErrors());
        Assert.assertEquals((long)1L, (long)parser.getErrors().size());
        Assert.assertTrue((boolean)((DroolsParserException)((Object)parser.getErrors().get(0))).getErrorCode().equals("ERR 102"));
    }

    @Test
    public void testCommaMisuse() throws Exception {
        DRLParser parser = this.parseResource("comma_misuse.drl");
        try {
            parser.compilationUnit();
            Assert.assertTrue((String)"Parser should have raised errors", (boolean)parser.hasErrors());
        }
        catch (NullPointerException npe) {
            Assert.fail((String)"Should not raise NPE");
        }
    }

    private DRLParser parse(String text) throws Exception {
        this.parser = this.newParser(this.newTokenStream((Lexer)this.newLexer(this.newCharStream(text))));
        return this.parser;
    }

    private DRLParser parse(String source, String text) throws Exception {
        this.parser = this.newParser(this.newTokenStream((Lexer)this.newLexer(this.newCharStream(text))));
        return this.parser;
    }

    private Reader getReader(String name) throws Exception {
        InputStream in = this.getClass().getResourceAsStream(name);
        return new InputStreamReader(in);
    }

    private DRLParser parseResource(String name) throws Exception {
        Reader reader = this.getReader(name);
        StringBuilder text = new StringBuilder();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return this.parse(name, text.toString());
    }

    private CharStream newCharStream(String text) {
        return new ANTLRStringStream(text);
    }

    private DRLLexer newLexer(CharStream charStream) {
        return new DRLLexer(charStream);
    }

    private TokenStream newTokenStream(Lexer lexer) {
        return new CommonTokenStream((TokenSource)lexer);
    }

    private DRLParser newParser(TokenStream tokenStream) {
        DRLParser p = new DRLParser(tokenStream);
        return p;
    }
}

