/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.util.ArrayList;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.definition.KnowledgePackage;
import org.drools.definitions.impl.KnowledgePackageImp;
import org.drools.io.ResourceFactory;
import org.drools.rule.EvalCondition;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.Pattern;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.Rule;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.spi.EvalExpression;
import org.drools.spi.PredicateExpression;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class JavaDialectBinaryEqualityTest {
    @Test
    public void test1() {
        KnowledgePackage pkg1 = this.getKnowledgePackage1();
        KnowledgePackage pkg2 = this.getKnowledgePackage1();
        KnowledgePackage pkg3 = this.getKnowledgePackage2();
        Rule rule1 = ((KnowledgePackageImp)pkg1).pkg.getRule("rule1");
        Rule rule2 = ((KnowledgePackageImp)pkg2).pkg.getRule("rule1");
        Rule rule3 = ((KnowledgePackageImp)pkg3).pkg.getRule("rule1");
        Pattern p1 = (Pattern)rule1.getLhs().getChildren().get(0);
        LiteralConstraint rvc1 = (LiteralConstraint)p1.getConstraints().get(0);
        Pattern p2 = (Pattern)rule2.getLhs().getChildren().get(0);
        LiteralConstraint rvc2 = (LiteralConstraint)p2.getConstraints().get(0);
        Assert.assertNotSame((Object)rvc1, (Object)rvc2);
        Assert.assertEquals((Object)rvc1, (Object)rvc2);
        Pattern p3 = (Pattern)rule3.getLhs().getChildren().get(0);
        LiteralConstraint rvc3 = (LiteralConstraint)p3.getConstraints().get(0);
        Assert.assertNotSame((Object)rvc1, (Object)rvc3);
        Assert.assertThat((Object)rvc1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)rvc3)));
        PredicateConstraint pc1 = (PredicateConstraint)p1.getConstraints().get(1);
        PredicateExpression pe1 = pc1.getPredicateExpression();
        PredicateConstraint pc2 = (PredicateConstraint)p2.getConstraints().get(1);
        PredicateExpression pe2 = pc2.getPredicateExpression();
        Assert.assertNotSame((Object)pe1, (Object)pe2);
        Assert.assertEquals((Object)pe1, (Object)pe2);
        PredicateConstraint pc3 = (PredicateConstraint)p3.getConstraints().get(1);
        PredicateExpression pe3 = pc3.getPredicateExpression();
        Assert.assertNotSame((Object)pe1, (Object)pe3);
        Assert.assertThat((Object)pe1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)pe3)));
        EvalCondition ec1 = (EvalCondition)rule1.getLhs().getChildren().get(1);
        EvalExpression ee1 = ec1.getEvalExpression();
        EvalCondition ec2 = (EvalCondition)rule2.getLhs().getChildren().get(1);
        EvalExpression ee2 = ec2.getEvalExpression();
        Assert.assertNotSame((Object)ee1, (Object)ee2);
        Assert.assertEquals((Object)ee1, (Object)ee2);
        EvalCondition ec3 = (EvalCondition)rule3.getLhs().getChildren().get(1);
        EvalExpression ee3 = ec3.getEvalExpression();
        Assert.assertNotSame((Object)ee1, (Object)ee3);
        Assert.assertThat((Object)ee1, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)ee3)));
        Assert.assertNotSame((Object)rule1.getConsequence(), (Object)rule2.getConsequence());
        Assert.assertEquals((Object)rule1.getConsequence(), (Object)rule2.getConsequence());
        Assert.assertNotSame((Object)rule1.getConsequence(), (Object)rule3.getConsequence());
        Assert.assertThat((Object)rule1.getConsequence(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)rule3.getConsequence())));
        Assert.assertNotSame((Object)rule1.getLhs(), (Object)rule2.getLhs());
        Assert.assertEquals((Object)rule1.getLhs(), (Object)rule2.getLhs());
        Assert.assertNotSame((Object)rule1.getLhs(), (Object)rule3.getLhs());
        Assert.assertThat((Object)rule1.getLhs(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)rule3.getLhs())));
    }

    public KnowledgePackage getKnowledgePackage1() {
        String str = "";
        str = str + "package org.drools\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1 dialect\"java\" \n";
        str = str + "when\n";
        str = str + "   $p : Person( age : age == ( 17 + 17 ), eval( age == 34 ))\n";
        str = str + "   eval( $p.getAge() == 34 )\n";
        str = str + "then\n";
        str = str + "   list.add( $p );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        ArrayList list = new ArrayList();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Person("darth", 34));
        ksession.fireAllRules();
        Assert.assertEquals((Object)new Person("darth", 34), list.get(0));
        return kbase.getKnowledgePackage("org.drools");
    }

    public KnowledgePackage getKnowledgePackage2() {
        String str = "";
        str = str + "package org.drools\n";
        str = str + "global java.util.List list\n";
        str = str + "rule rule1 dialect\"java\" \n";
        str = str + "when\n";
        str = str + "   $p : Person( age : age == ( 18 + 18 ), eval( age == 36 ))\n";
        str = str + "   eval( $p.getAge() == 36 )\n";
        str = str + "then\n";
        str = str + "   System.out.println( $p );\n";
        str = str + "   list.add( $p );\n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        ArrayList list = new ArrayList();
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Person("darth", 36));
        ksession.fireAllRules();
        Assert.assertEquals((Object)new Person("darth", 36), list.get(0));
        return kbase.getKnowledgePackage("org.drools");
    }
}

