/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder.dialect.java;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.base.ClassObjectType;
import org.drools.base.mvel.MVELPredicateExpression;
import org.drools.base.mvel.MVELReturnValueExpression;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.InternalRuleBase;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.io.ResourceFactory;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.ReturnValueRestriction;
import org.drools.rule.VariableConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.CompiledInvoker;
import org.drools.spi.FieldValue;
import org.drools.spi.PredicateExpression;
import org.drools.spi.ReturnValueExpression;
import org.junit.Assert;
import org.junit.Test;

public class JavaDialectTest {
    @Test
    public void testEvalDetectionInAlphaNode() {
        String drl = "";
        drl = drl + "package org.test\n";
        drl = drl + "import org.drools.Person\n";
        drl = drl + "global java.util.List list\n";
        drl = drl + "rule test1\n";
        drl = drl + "when\n";
        drl = drl + "   $p1 : Person( eval( name \n != null ), name == ( new String(\"xxx\") ) )\n";
        drl = drl + "then\n";
        drl = drl + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        List nodes = ((InternalRuleBase)((KnowledgeBaseImpl)kbase).ruleBase).getRete().getObjectTypeNodes();
        ObjectTypeNode node = null;
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != Person.class) continue;
            node = n;
            break;
        }
        AlphaNode alphanode = (AlphaNode)node.getSinkPropagator().getSinks()[0];
        PredicateConstraint c = (PredicateConstraint)alphanode.getConstraint();
        Assert.assertTrue((boolean)(c.getPredicateExpression() instanceof PredicateExpression));
        Assert.assertTrue((boolean)(c.getPredicateExpression() instanceof CompiledInvoker));
        Assert.assertTrue((!(c.getPredicateExpression() instanceof MVELPredicateExpression) ? 1 : 0) != 0);
        alphanode = (AlphaNode)alphanode.getSinkPropagator().getSinks()[0];
        FieldValue fieldVal = ((LiteralConstraint)alphanode.getConstraint()).getField();
        Assert.assertEquals((Object)"xxx", (Object)fieldVal.getValue());
    }

    @Test
    public void testEvalDetectionInBetaNode() {
        String drl = "";
        drl = drl + "package org.test\n";
        drl = drl + "import org.drools.Person\n";
        drl = drl + "global java.util.List list\n";
        drl = drl + "rule test1\n";
        drl = drl + "when\n";
        drl = drl + "   $s  : String()\n";
        drl = drl + "   $p1 : Person( eval( name \n != $s ), name == ( new String($s+\"xxx\") ) )\n";
        drl = drl + "then\n";
        drl = drl + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newReaderResource((Reader)new StringReader(drl)), ResourceType.DRL);
        KnowledgeBuilderErrors errors = kbuilder.getErrors();
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        List nodes = ((InternalRuleBase)((KnowledgeBaseImpl)kbase).ruleBase).getRete().getObjectTypeNodes();
        ObjectTypeNode node = null;
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != Person.class) continue;
            node = n;
            break;
        }
        BetaNode betaanode = (BetaNode)node.getSinkPropagator().getSinks()[0];
        BetaNodeFieldConstraint[] constraint = betaanode.getConstraints();
        PredicateConstraint c = (PredicateConstraint)constraint[0];
        Assert.assertTrue((boolean)(c.getPredicateExpression() instanceof PredicateExpression));
        Assert.assertTrue((boolean)(c.getPredicateExpression() instanceof CompiledInvoker));
        Assert.assertTrue((!(c.getPredicateExpression() instanceof MVELPredicateExpression) ? 1 : 0) != 0);
        ReturnValueRestriction r = (ReturnValueRestriction)((VariableConstraint)constraint[1]).getRestriction();
        Assert.assertTrue((boolean)(r.getExpression() instanceof ReturnValueExpression));
        Assert.assertTrue((boolean)(r.getExpression() instanceof CompiledInvoker));
        Assert.assertTrue((!(r.getExpression() instanceof MVELReturnValueExpression) ? 1 : 0) != 0);
    }
}

