/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.util.ArrayList;
import java.util.List;
import org.drools.Cheese;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Assert;
import org.junit.Test;

public class FunctionsTest {
    private KnowledgeBase loadKnowledgeBaseFromString(String ... drlContentStrings) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (String drlContentString : drlContentStrings) {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drlContentString.getBytes()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    private KnowledgeBase loadKnowledgeBase(String ... classPathResources) {
        return this.loadKnowledgeBase((KnowledgeBuilderConfiguration)null, classPathResources);
    }

    private KnowledgeBase loadKnowledgeBase(KnowledgeBuilderConfiguration kbconf, String ... classPathResources) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)kbconf);
        for (String classPathResource : classPathResources) {
            kbuilder.add(ResourceFactory.newClassPathResource((String)classPathResource, this.getClass()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    @Test
    public void testFunction() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_FunctionInConsequence.drl");
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession.fireAllRules();
        Assert.assertEquals((Object)new Integer(5), ((List)ksession.getGlobal("list")).get(0));
    }

    @Test
    public void testFunctionException() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_FunctionException.drl");
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        Cheese brie = new Cheese("brie", 12);
        ksession.insert((Object)brie);
        try {
            ksession.fireAllRules();
            Assert.fail((String)"Should throw an Exception from the Function");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"this should throw an exception", (Object)e.getCause().getMessage());
        }
    }

    @Test
    public void testFunctionWithPrimitives() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_FunctionWithPrimitives.drl");
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        ksession.insert((Object)stilton);
        ksession.fireAllRules();
        Assert.assertEquals((Object)new Integer(10), list.get(0));
    }

    @Test
    public void testFunctionCallingFunctionWithEclipse() throws Exception {
        KnowledgeBuilderConfiguration kbconf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        kbconf.setProperty("drools.dialect.java.compiler", "ECLIPSE");
        KnowledgeBase kbase = this.loadKnowledgeBase(kbconf, "test_functionCallingFunction.drl");
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)12L, (long)((Integer)list.get(0)).intValue());
    }

    @Test
    public void testFunctionCallingFunctionWithJanino() throws Exception {
        KnowledgeBuilderConfiguration kbconf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        kbconf.setProperty("drools.dialect.java.compiler", "JANINO");
        KnowledgeBase kbase = this.loadKnowledgeBase(kbconf, "test_functionCallingFunction.drl");
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("results", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)12L, (long)((Integer)list.get(0)).intValue());
    }

    @Test
    public void testJBRULES3117() {
        String str = "package org.drools\nfunction boolean isOutOfRange( Object value, int lower ) { return true; }\nfunction boolean isNotContainedInt( Object value, int[] values ) { return true; }\nrule R1\nwhen\nthen\n    boolean x = isOutOfRange( Integer.MAX_VALUE, 1 );\n    boolean y = isNotContainedInt( Integer.MAX_VALUE, new int[] { 1, 2, 3 } );\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        int rulesFired = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)rulesFired);
    }
}

