/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.drools.Address;
import org.drools.Cheese;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.TestEnum;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.extractors.MVELClassFieldReader;
import org.drools.base.mvel.MVELDebugHandler;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.InternalRuleBase;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.core.util.DateUtils;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.integrationtests.SerializationHelper;
import org.drools.integrationtests.TestObject;
import org.drools.io.ResourceFactory;
import org.drools.lang.descr.PackageDescr;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.MapBackedClassLoader;
import org.drools.rule.Package;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.FieldValue;
import org.drools.type.DateFormats;
import org.drools.type.DateFormatsImpl;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public class MVELTest {
    @Test
    public void testHelloWorld() throws Exception {
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("test_mvel.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        ArrayList list2 = new ArrayList();
        workingMemory.setGlobal("list2", list2);
        Cheese c = new Cheese("stilton", 10);
        workingMemory.insert((Object)c);
        workingMemory.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)BigInteger.valueOf(30L), list.get(0));
        Assert.assertEquals((Object)22, list.get(1));
        Assert.assertEquals((Object)"hello world", list2.get(0));
        Date dt = DateUtils.parseDate((String)"10-Jul-1974", (DateFormats)new DateFormatsImpl());
        Assert.assertEquals((Object)dt, (Object)c.getUsedBy());
    }

    @Test
    public void testIncrementOperator() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    dialect \"mvel\" \n";
        str = str + "when \n";
        str = str + "    $I : Integer() \n";
        str = str + "then \n";
        str = str + "    i = $I.intValue(); \n";
        str = str + "    i += 5; \n";
        str = str + "    list.add( i ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)5);
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)10, list.get(0));
    }

    @Test
    public void testEvalWithBigDecimal() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "import java.math.BigDecimal; \n";
        str = str + "global java.util.List list \n";
        str = str + "rule rule1 \n";
        str = str + "    dialect \"mvel\" \n";
        str = str + "when \n";
        str = str + "    $bd : BigDecimal() \n";
        str = str + "    eval( $bd.compareTo( BigDecimal.ZERO ) > 0 ) \n";
        str = str + "then \n";
        str = str + "    list.add( $bd ); \n";
        str = str + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.err.println(kbuilder.getErrors());
        }
        Assert.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new BigDecimal(1.5));
        ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)new BigDecimal(1.5), list.get(0));
    }

    @Test
    public void testLocalVariableMVELConsequence() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_LocalVariableMVELConsequence.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.insert((Object)new Person("bob", "stilton"));
        workingMemory.insert((Object)new Person("mark", "brie"));
        try {
            workingMemory.fireAllRules();
            Assert.assertEquals((String)"should have fired twice", (long)2L, (long)list.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Should not raise any exception");
        }
    }

    @Test
    public void testMVELUsingGlobalsInDebugMode() throws Exception {
        MVELDebugHandler.setDebugMode((boolean)true);
        try {
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_MVELGlobalDebug.drl")));
            Package pkg = builder.getPackage();
            RuleBase ruleBase = this.getRuleBase();
            ruleBase.addPackage(pkg);
            ruleBase = SerializationHelper.serializeObject(ruleBase);
            StatefulSession session = ruleBase.newStatefulSession();
            session.dispose();
            MVELDebugHandler.setDebugMode((boolean)false);
        }
        catch (Exception e) {
            MVELDebugHandler.setDebugMode((boolean)false);
            e.printStackTrace();
            Assert.fail((String)"Should not raise exceptions");
        }
    }

    @Test
    public void testDuplicateLocalVariableMVELConsequence() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(this.getClass().getResourceAsStream("test_DuplicateLocalVariableMVELConsequence.drl")));
        Assert.assertTrue((boolean)builder.hasErrors());
    }

    @Test
    public void testArrays() throws Exception {
        String text = "package test_mvel;\n";
        text = text + "import org.drools.integrationtests.TestObject;\n";
        text = text + "import function org.drools.integrationtests.TestObject.array;\n";
        text = text + "no-loop true\n";
        text = text + "dialect \"mvel\"\n";
        text = text + "rule \"1\"\n";
        text = text + "salience 1\n";
        text = text + "when\n";
        text = text + "    $fact: TestObject()\n";
        text = text + "    eval($fact.checkHighestPriority(\"mvel\", 2))\n";
        text = text + "    eval($fact.stayHasDaysOfWeek(\"mvel\", false, new String[][]{{\"2008-04-01\", \"2008-04-10\"}}))\n";
        text = text + "then\n";
        text = text + "    $fact.applyValueAddPromo(1,2,3,4,\"mvel\");\n";
        text = text + "end";
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        ruleBase.addPackage(this.compileRule(text.replaceAll("mvel", "java")));
        ruleBase.addPackage(this.compileRule(text));
        ArrayList list = new ArrayList();
        ruleBase.newStatelessSession().execute((Object)new TestObject(list));
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"TestObject.checkHighestPriority: java|2", list.get(0));
        Assert.assertEquals((Object)"TestObject.stayHasDaysOfWeek: java|false|[2008-04-01, 2008-04-10]", list.get(1));
        Assert.assertEquals((Object)"TestObject.checkHighestPriority: mvel|2", list.get(2));
        Assert.assertEquals((Object)"TestObject.stayHasDaysOfWeek: mvel|false|[2008-04-01, 2008-04-10]", list.get(3));
        Assert.assertEquals((Object)"TestObject.applyValueAddPromo: 1|2|3|4|mvel", list.get(4));
        Assert.assertEquals((Object)"TestObject.applyValueAddPromo: 1|2|3|4|java", list.get(5));
    }

    @Test
    public void testPackageImports() throws Exception {
        String str = "";
        str = str + "package org.drools \n";
        str = str + "dialect \"mvel\"\n";
        str = str + "import org.acme.healthcare.* \n";
        str = str + "import org.acme.insurance.* \n";
        str = str + "import org.acme.sensors.SensorReading \n";
        str = str + "rule rule1 \n";
        str = str + "  when \n";
        str = str + "    eval(true)\n";
        str = str + "  then \n";
        str = str + "    insert(new Claim());         // from org.acme.healthcare.* \n";
        str = str + "    insert(new Policy());        // from org.acme.insurance.* \n";
        str = str + "    insert(new SensorReading()); // from org.acme.sensor.SensorReading \n";
        str = str + "end\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            throw new RuntimeException(kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        int result = ksession.fireAllRules();
        Assert.assertEquals((long)1L, (long)result);
        Collection insertedObjects = ksession.getObjects();
        Assert.assertEquals((long)3L, (long)insertedObjects.size());
    }

    @Test
    @Ignore
    public void testSizeCheckInObject() {
        String str = "package org.test \nimport " + Triangle.class.getCanonicalName() + "\n" + "global java.util.List list \n" + "rule \"show\" \n" + "when  \n" + "    $m : Triangle( deliveries.size == 0) \n" + "then \n" + "    list.add('r1'); \n" + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors().toString());
            Assert.fail((String)kbuilder.getErrors().toString());
        }
    }

    @Test
    public void testNestedEnum() {
        String str = "package org.test \nimport " + Triangle.class.getCanonicalName() + "\n" + "global java.util.List list \n" + "rule \"show\" \n" + "when  \n" + "    $t: Triangle(t == Triangle.Type.ACUTE) \n" + "then \n" + "    list.add($t.getT()); \n" + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Triangle t = new Triangle(Triangle.Type.ACUTE);
        ksession.insert((Object)t);
        ksession.fireAllRules();
        Assert.assertEquals((Object)((Object)Triangle.Type.ACUTE), list.get(0));
    }

    @Test
    public void testNestedEnumWithMap() {
        String str = "package org.test \nimport " + DMap.class.getCanonicalName() + " \n" + "import " + Triangle.class.getCanonicalName() + "\n" + "global java.util.List list \n" + "rule \"show\" \n" + "when  \n" + "    $m : DMap( this[Triangle.Type.ACUTE] == 'xxx') \n" + "then \n" + "    list.add('r1'); \n" + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        DMap m = new DMap();
        m.put(Triangle.Type.ACUTE, "xxx");
        ksession.insert((Object)m);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"r1", list.get(0));
    }

    @Test
    public void testNewConstructor() {
        AlphaNode alphanode;
        AlphaNodeFieldConstraint constraint;
        String str = "package org.test \nimport " + Person.class.getCanonicalName() + "\n" + "import " + Address.class.getCanonicalName() + "\n" + "global java.util.List list \n" + "rule \"show\" \n" + "when  \n" + "    $m : Person( address == new Address('s1')) \n" + "then \n" + "    list.add('r1'); \n" + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p = new Person("yoda");
        p.setAddress(new Address("s1"));
        ksession.insert((Object)p);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"r1", list.get(0));
        List nodes = ((InternalRuleBase)((KnowledgeBaseImpl)kbase).ruleBase).getRete().getObjectTypeNodes();
        ObjectTypeNode node = null;
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != Person.class) continue;
            node = n;
            break;
        }
        if ((constraint = (alphanode = (AlphaNode)node.getSinkPropagator().getSinks()[0]).getConstraint()) instanceof LiteralConstraint) {
            Assert.assertTrue((boolean)(((LiteralConstraint)constraint).getFieldExtractor() instanceof ClassFieldReader));
            FieldValue r = ((LiteralConstraint)constraint).getField();
            Assert.assertEquals((Object)p.getAddress(), (Object)r.getValue());
        }
    }

    @Test
    public void testArrayAccessorWithGenerics() {
        AlphaNode alphanode;
        AlphaNodeFieldConstraint constraint;
        String str = "package org.test \nimport " + Person.class.getCanonicalName() + "\n" + "import " + Address.class.getCanonicalName() + "\n" + "global java.util.List list \n" + "rule \"show\" \n" + "when  \n" + "    $m : Person( addresses[0] == new Address('s1'), addresses[0].street == new Address('s1').street ) \n" + "then \n" + "    list.add('r1'); \n" + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p = new Person("yoda");
        p.addAddress(new Address("s1"));
        ksession.insert((Object)p);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"r1", list.get(0));
        List nodes = ((InternalRuleBase)((KnowledgeBaseImpl)kbase).ruleBase).getRete().getObjectTypeNodes();
        ObjectTypeNode node = null;
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != Person.class) continue;
            node = n;
            break;
        }
        if ((constraint = (alphanode = (AlphaNode)node.getSinkPropagator().getSinks()[0]).getConstraint()) instanceof LiteralConstraint) {
            Assert.assertTrue((boolean)(((LiteralConstraint)constraint).getFieldExtractor() instanceof MVELClassFieldReader));
            Assert.assertEquals((Object)new Address("s1"), (Object)((LiteralConstraint)constraint).getField().getValue());
        }
        if ((constraint = (alphanode = (AlphaNode)alphanode.getSinkPropagator().getSinks()[0]).getConstraint()) instanceof LiteralConstraint) {
            Assert.assertTrue((boolean)(((LiteralConstraint)constraint).getFieldExtractor() instanceof MVELClassFieldReader));
            Assert.assertEquals((Object)new Address("s1").getStreet(), (Object)((LiteralConstraint)constraint).getField().getValue());
        }
    }

    @Test
    public void testArrayAccessorWithStaticFieldAccess() {
        AlphaNode alphanode;
        AlphaNodeFieldConstraint constraint;
        String str = "package org.test \nimport " + Person.class.getCanonicalName() + "\n" + "import " + Address.class.getCanonicalName() + "\n" + "import " + Triangle.class.getCanonicalName() + "\n" + "global java.util.List list \n" + "rule \"show\" \n" + "when  \n" + "    $m : Person( addresses[Triangle.ZERO] == new Address('s1'), addresses[Triangle.ZERO].street == new Address('s1').street ) \n" + "then \n" + "    list.add('r1'); \n" + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p = new Person("yoda");
        p.addAddress(new Address("s1"));
        ksession.insert((Object)p);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"r1", list.get(0));
        List nodes = ((InternalRuleBase)((KnowledgeBaseImpl)kbase).ruleBase).getRete().getObjectTypeNodes();
        ObjectTypeNode node = null;
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != Person.class) continue;
            node = n;
            break;
        }
        if ((constraint = (alphanode = (AlphaNode)node.getSinkPropagator().getSinks()[0]).getConstraint()) instanceof LiteralConstraint) {
            Assert.assertTrue((boolean)(((LiteralConstraint)alphanode.getConstraint()).getFieldExtractor() instanceof MVELClassFieldReader));
            Assert.assertEquals((Object)new Address("s1"), (Object)((LiteralConstraint)alphanode.getConstraint()).getField().getValue());
        }
        if ((constraint = (alphanode = (AlphaNode)alphanode.getSinkPropagator().getSinks()[0]).getConstraint()) instanceof LiteralConstraint) {
            Assert.assertTrue((boolean)(((LiteralConstraint)alphanode.getConstraint()).getFieldExtractor() instanceof MVELClassFieldReader));
            Assert.assertEquals((Object)new Address("s1").getStreet(), (Object)((LiteralConstraint)alphanode.getConstraint()).getField().getValue());
        }
    }

    @Test
    public void testMapAccessorWithStaticFieldAccess() {
        AlphaNode alphanode;
        AlphaNodeFieldConstraint constraint;
        String str = "package org.test \nimport " + Person.class.getCanonicalName() + "\n" + "import " + Address.class.getCanonicalName() + "\n" + "import " + TestEnum.class.getCanonicalName() + "\n" + "global java.util.List list \n" + "rule \"show\" \n" + "when  \n" + "    $m : Person( namedAddresses[TestEnum.ONE] == new Address('s1'), namedAddresses[TestEnum.ONE].street == new Address('s1').street ) \n" + "then \n" + "    list.add('r1'); \n" + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Person p = new Person("yoda");
        p.getNamedAddresses().put((Object)TestEnum.ONE, new Address("s1"));
        ksession.insert((Object)p);
        ksession.fireAllRules();
        Assert.assertEquals((Object)"r1", list.get(0));
        List nodes = ((InternalRuleBase)((KnowledgeBaseImpl)kbase).ruleBase).getRete().getObjectTypeNodes();
        ObjectTypeNode node = null;
        for (ObjectTypeNode n : nodes) {
            if (((ClassObjectType)n.getObjectType()).getClassType() != Person.class) continue;
            node = n;
            break;
        }
        if ((constraint = (alphanode = (AlphaNode)node.getSinkPropagator().getSinks()[0]).getConstraint()) instanceof LiteralConstraint) {
            Assert.assertTrue((boolean)(((LiteralConstraint)alphanode.getConstraint()).getFieldExtractor() instanceof MVELClassFieldReader));
            Assert.assertEquals((Object)new Address("s1"), (Object)((LiteralConstraint)alphanode.getConstraint()).getField().getValue());
        }
        if ((constraint = (alphanode = (AlphaNode)alphanode.getSinkPropagator().getSinks()[0]).getConstraint()) instanceof LiteralConstraint) {
            Assert.assertTrue((boolean)(((LiteralConstraint)alphanode.getConstraint()).getFieldExtractor() instanceof MVELClassFieldReader));
            Assert.assertEquals((Object)new Address("s1").getStreet(), (Object)((LiteralConstraint)alphanode.getConstraint()).getField().getValue());
        }
    }

    @Test
    public void testArrayAccessorWithoutGenerics() {
        String str = "package org.test \nimport " + Person.class.getCanonicalName() + "\n" + "import " + Address.class.getCanonicalName() + "\n" + "global java.util.List list \n" + "rule \"show\" \n" + "when  \n" + "    $m : Person( addressesNoGenerics[0].street == new Address('s1').street) \n" + "then \n" + "    list.add('r1'); \n" + "end \n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        Assert.assertTrue((boolean)kbuilder.hasErrors());
    }

    @Test
    @Ignore(value="Added 30-APR-2011 -Rikkola-")
    public void testNestedEnumFromJar() {
        String str = "package org.test \nimport org.drools.examples.eventing.EventRequest \nglobal java.util.List list \nrule 'zaa'\n  when \n  request: EventRequest( status == EventRequest.Status.ACTIVE )\n   then \n request.setStatus(EventRequest.Status.ACTIVE); \n  end";
        JarInputStream jis = null;
        try {
            jis = new JarInputStream(this.getClass().getResourceAsStream("/eventing-example.jar"));
        }
        catch (IOException e) {
            Assert.fail((String)"Failed to load the jar");
        }
        MapBackedClassLoader loader = MVELTest.createClassLoader(jis);
        KnowledgeBuilderConfiguration knowledgeBuilderConfiguration = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader[])new ClassLoader[]{loader});
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)knowledgeBuilderConfiguration);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBaseConfiguration knowledgeBaseConfiguration = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader[])new ClassLoader[]{loader});
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)knowledgeBaseConfiguration);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Triangle t = new Triangle(Triangle.Type.ACUTE);
        ksession.insert((Object)t);
        ksession.fireAllRules();
        Assert.assertEquals((Object)((Object)Triangle.Type.ACUTE), list.get(0));
    }

    public static MapBackedClassLoader createClassLoader(JarInputStream jis) {
        ClassLoader parentClassLoader;
        final ClassLoader p = parentClassLoader = Thread.currentThread().getContextClassLoader();
        MapBackedClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<MapBackedClassLoader>(){

            @Override
            public MapBackedClassLoader run() {
                return new MapBackedClassLoader(p);
            }
        });
        try {
            JarEntry entry = null;
            byte[] buf = new byte[1024];
            int len = 0;
            while ((entry = jis.getNextJarEntry()) != null) {
                if (entry.isDirectory() || entry.getName().endsWith(".java")) continue;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                while ((len = jis.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                }
                loader.addResource(entry.getName(), out.toByteArray());
            }
        }
        catch (IOException e) {
            Assert.fail((String)"failed to read the jar");
        }
        return loader;
    }

    private Package compileRule(String drl) throws Exception {
        PackageBuilder builder = new PackageBuilder(new PackageBuilderConfiguration());
        builder.addPackageFromDrl((Reader)new StringReader(drl));
        Package pkg = builder.getPackage();
        if (!pkg.isValid()) {
            throw new DroolsParserException(pkg.getErrorSummary());
        }
        return pkg;
    }

    public Object compiledExecute(String ex) {
        Serializable compiled = MVEL.compileExpression((String)ex);
        return MVEL.executeExpression((Object)compiled, (Object)new Object(), new HashMap());
    }

    private RuleBase loadRuleBase(Reader reader) throws IOException, DroolsParserException, Exception {
        DrlParser parser = new DrlParser();
        PackageDescr packageDescr = parser.parse(reader);
        if (parser.hasErrors()) {
            Assert.fail((String)("Error messages in parser, need to sort this our (or else collect error messages)\n" + parser.getErrors()));
        }
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(packageDescr);
        if (builder.hasErrors()) {
            Assert.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        return ruleBase;
    }

    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    @Test
    public void test1() {
        ParserContext pc = new ParserContext();
        pc.addInput("x", String.class);
        pc.setStrongTyping(true);
        Serializable o = MVEL.compileExpression((String)"x.startsWith('d')", (ParserContext)pc);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("x", "d");
        MVEL.executeExpression((Object)o, vars);
        System.out.println(o);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Triangle {
        public static final int ZERO = 0;
        private List<Map<String, Object>> deliveries;
        private Type t;

        public Triangle(Type t) {
            this.t = t;
        }

        public Type getT() {
            return this.t;
        }

        public void setT(Type t) {
            this.t = t;
        }

        public List<Map<String, Object>> getDeliveries() {
            return this.deliveries;
        }

        public void setDeliveries(List<Map<String, Object>> deliveries) {
            this.deliveries = deliveries;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            ACUTE,
            OBTUSE;

        }
    }

    public static class DMap
    extends HashMap {
    }
}

