/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.drools.ClockType;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.SessionConfiguration;
import org.drools.StockTick;
import org.drools.base.ClassObjectType;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.InternalFactHandle;
import org.drools.compiler.DroolsParserException;
import org.drools.conf.EventProcessingOption;
import org.drools.conf.KnowledgeBaseOption;
import org.drools.event.rule.ActivationCreatedEvent;
import org.drools.event.rule.AfterActivationFiredEvent;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.ObjectInsertedEvent;
import org.drools.event.rule.WorkingMemoryEventListener;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.EntryPoint;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.conf.ClockTypeOption;
import org.drools.runtime.conf.KnowledgeSessionOption;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.drools.spi.ObjectType;
import org.drools.time.impl.PseudoClockScheduler;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.IsCollectionContaining;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;

public class StreamsTest {
    private KnowledgeBase loadKnowledgeBase(String fileName) throws IOException, DroolsParserException, Exception {
        return this.loadKnowledgeBase(fileName, KnowledgeBaseFactory.newKnowledgeBaseConfiguration());
    }

    private KnowledgeBase loadKnowledgeBase(String fileName, KnowledgeBaseConfiguration kconf) throws IOException, DroolsParserException, Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)fileName, this.getClass()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            System.out.println(kbuilder.getErrors());
            return null;
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kconf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return SerializationHelper.serializeObject(kbase);
    }

    private KnowledgeBase loadKnowledgeBaseFromString(String ... drlContentStrings) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (String drlContentString : drlContentStrings) {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drlContentString.getBytes()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    @Test
    public void testEventAssertion() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_EntryPoint.drl");
        SessionConfiguration conf = new SessionConfiguration();
        conf.setClockType(ClockType.PSEUDO_CLOCK);
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession((KnowledgeSessionConfiguration)conf, null);
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        StockTick tick1 = new StockTick(1L, "DROO", 50.0, System.currentTimeMillis());
        StockTick tick2 = new StockTick(2L, "ACME", 10.0, System.currentTimeMillis());
        StockTick tick3 = new StockTick(3L, "ACME", 10.0, System.currentTimeMillis());
        StockTick tick4 = new StockTick(4L, "DROO", 50.0, System.currentTimeMillis());
        InternalFactHandle handle1 = (InternalFactHandle)session.insert((Object)tick1);
        InternalFactHandle handle2 = (InternalFactHandle)session.insert((Object)tick2);
        InternalFactHandle handle3 = (InternalFactHandle)session.insert((Object)tick3);
        InternalFactHandle handle4 = (InternalFactHandle)session.insert((Object)tick4);
        Assert.assertNotNull((Object)handle1);
        Assert.assertNotNull((Object)handle2);
        Assert.assertNotNull((Object)handle3);
        Assert.assertNotNull((Object)handle4);
        Assert.assertTrue((boolean)handle1.isEvent());
        Assert.assertTrue((boolean)handle2.isEvent());
        Assert.assertTrue((boolean)handle3.isEvent());
        Assert.assertTrue((boolean)handle4.isEvent());
        session.fireAllRules();
        Assert.assertEquals((long)0L, (long)results.size());
        StockTick tick5 = new StockTick(5L, "DROO", 50.0, System.currentTimeMillis());
        StockTick tick6 = new StockTick(6L, "ACME", 10.0, System.currentTimeMillis());
        StockTick tick7 = new StockTick(7L, "ACME", 15.0, System.currentTimeMillis());
        StockTick tick8 = new StockTick(8L, "DROO", 50.0, System.currentTimeMillis());
        WorkingMemoryEntryPoint entry = session.getWorkingMemoryEntryPoint("StockStream");
        InternalFactHandle handle5 = (InternalFactHandle)entry.insert((Object)tick5);
        InternalFactHandle handle6 = (InternalFactHandle)entry.insert((Object)tick6);
        InternalFactHandle handle7 = (InternalFactHandle)entry.insert((Object)tick7);
        InternalFactHandle handle8 = (InternalFactHandle)entry.insert((Object)tick8);
        Assert.assertNotNull((Object)handle5);
        Assert.assertNotNull((Object)handle6);
        Assert.assertNotNull((Object)handle7);
        Assert.assertNotNull((Object)handle8);
        Assert.assertTrue((boolean)handle5.isEvent());
        Assert.assertTrue((boolean)handle6.isEvent());
        Assert.assertTrue((boolean)handle7.isEvent());
        Assert.assertTrue((boolean)handle8.isEvent());
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertSame((Object)tick7, results.get(0));
    }

    @Test
    public void testEntryPointReference() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_EntryPointReference.drl");
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        StockTick tick5 = new StockTick(5L, "DROO", 50.0, System.currentTimeMillis());
        StockTick tick6 = new StockTick(6L, "ACME", 10.0, System.currentTimeMillis());
        StockTick tick7 = new StockTick(7L, "ACME", 30.0, System.currentTimeMillis());
        StockTick tick8 = new StockTick(8L, "DROO", 50.0, System.currentTimeMillis());
        WorkingMemoryEntryPoint entry = session.getWorkingMemoryEntryPoint("stream1");
        InternalFactHandle handle5 = (InternalFactHandle)entry.insert((Object)tick5);
        InternalFactHandle handle6 = (InternalFactHandle)entry.insert((Object)tick6);
        InternalFactHandle handle7 = (InternalFactHandle)entry.insert((Object)tick7);
        InternalFactHandle handle8 = (InternalFactHandle)entry.insert((Object)tick8);
        Assert.assertNotNull((Object)handle5);
        Assert.assertNotNull((Object)handle6);
        Assert.assertNotNull((Object)handle7);
        Assert.assertNotNull((Object)handle8);
        Assert.assertTrue((boolean)handle5.isEvent());
        Assert.assertTrue((boolean)handle6.isEvent());
        Assert.assertTrue((boolean)handle7.isEvent());
        Assert.assertTrue((boolean)handle8.isEvent());
        session.fireAllRules();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertSame((Object)tick7, results.get(0));
    }

    @Test
    public void testModifyRetracOnEntryPointFacts() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_modifyRetractEntryPoint.drl");
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        ArrayList results = new ArrayList();
        session.setGlobal("results", results);
        StockTick tick5 = new StockTick(5L, "DROO", 50.0, System.currentTimeMillis());
        StockTick tick6 = new StockTick(6L, "ACME", 10.0, System.currentTimeMillis());
        StockTick tick7 = new StockTick(7L, "ACME", 30.0, System.currentTimeMillis());
        StockTick tick8 = new StockTick(8L, "DROO", 50.0, System.currentTimeMillis());
        WorkingMemoryEntryPoint entry = session.getWorkingMemoryEntryPoint("stream1");
        InternalFactHandle handle5 = (InternalFactHandle)entry.insert((Object)tick5);
        InternalFactHandle handle6 = (InternalFactHandle)entry.insert((Object)tick6);
        InternalFactHandle handle7 = (InternalFactHandle)entry.insert((Object)tick7);
        InternalFactHandle handle8 = (InternalFactHandle)entry.insert((Object)tick8);
        Assert.assertNotNull((Object)handle5);
        Assert.assertNotNull((Object)handle6);
        Assert.assertNotNull((Object)handle7);
        Assert.assertNotNull((Object)handle8);
        Assert.assertTrue((boolean)handle5.isEvent());
        Assert.assertTrue((boolean)handle6.isEvent());
        Assert.assertTrue((boolean)handle7.isEvent());
        Assert.assertTrue((boolean)handle8.isEvent());
        session.fireAllRules();
        System.out.println(results);
        Assert.assertEquals((long)2L, (long)results.size());
        Assert.assertEquals((long)30L, (long)((Number)results.get(0)).intValue());
        Assert.assertEquals((long)110L, (long)((Number)results.get(1)).intValue());
        Assert.assertEquals((long)3L, (long)entry.getObjects().size());
        Assert.assertEquals((long)0L, (long)session.getObjects().size());
    }

    @Test
    public void testModifyOnEntryPointFacts() throws Exception {
        String str = "package org.drools\ndeclare StockTick\n        @role ( event )\nend\nrule R1 salience 100\n    when\n        $s1 : StockTick( company == 'RHT', price == 10 ) from entry-point ep1\n    then\n        StockTick s = $s1;\n        modify( s ) { setPrice( 50 ) };\nend\nrule R2 salience 90\n    when\n        $s1 : StockTick( company == 'RHT', price == 10 ) from entry-point ep2\n    then\n        StockTick s = $s1;\n        modify( s ) { setPrice( 50 ) };\nend\nrule R3 salience 80\n    when\n        $s1 : StockTick( company == 'RHT', price == 10 ) from entry-point ep3\n    then\n        StockTick s = $s1;\n        modify( s ) { setPrice( 50 ) };\nend\n";
        KnowledgeBase kbase = this.loadKnowledgeBaseFromString(str);
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        WorkingMemoryEntryPoint ep1 = ksession.getWorkingMemoryEntryPoint("ep1");
        WorkingMemoryEntryPoint ep2 = ksession.getWorkingMemoryEntryPoint("ep2");
        WorkingMemoryEntryPoint ep3 = ksession.getWorkingMemoryEntryPoint("ep3");
        ep1.insert((Object)new StockTick(1L, "RHT", 10.0, 1000L));
        ep2.insert((Object)new StockTick(1L, "RHT", 10.0, 1000L));
        ep3.insert((Object)new StockTick(1L, "RHT", 10.0, 1000L));
        int rulesFired = ksession.fireAllRules();
        Assert.assertEquals((long)3L, (long)rulesFired);
        ArgumentCaptor captor = ArgumentCaptor.forClass(AfterActivationFiredEvent.class);
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)3))).afterActivationFired((AfterActivationFiredEvent)captor.capture());
        List aafe = captor.getAllValues();
        Assert.assertThat((Object)((AfterActivationFiredEvent)aafe.get(0)).getActivation().getRule().getName(), (Matcher)CoreMatchers.is((Object)"R1"));
        Assert.assertThat((Object)((AfterActivationFiredEvent)aafe.get(1)).getActivation().getRule().getName(), (Matcher)CoreMatchers.is((Object)"R2"));
        Assert.assertThat((Object)((AfterActivationFiredEvent)aafe.get(2)).getActivation().getRule().getName(), (Matcher)CoreMatchers.is((Object)"R3"));
    }

    @Test
    public void testGetEntryPointList() throws Exception {
        KnowledgeBase kbase = this.loadKnowledgeBase("test_EntryPointReference.drl");
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        WorkingMemoryEntryPoint def = session.getWorkingMemoryEntryPoint(EntryPoint.DEFAULT.getEntryPointId());
        WorkingMemoryEntryPoint s1 = session.getWorkingMemoryEntryPoint("stream1");
        WorkingMemoryEntryPoint s2 = session.getWorkingMemoryEntryPoint("stream2");
        WorkingMemoryEntryPoint s3 = session.getWorkingMemoryEntryPoint("stream3");
        Collection eps = session.getWorkingMemoryEntryPoints();
        Assert.assertEquals((long)4L, (long)eps.size());
        Assert.assertTrue((boolean)eps.contains(def));
        Assert.assertTrue((boolean)eps.contains(s1));
        Assert.assertTrue((boolean)eps.contains(s2));
        Assert.assertTrue((boolean)eps.contains(s3));
    }

    @Test
    public void testEventDoesNotExpireIfNotInPattern() throws Exception {
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = this.loadKnowledgeBase("test_EventExpiration.drl", kconf);
        KnowledgeSessionConfiguration ksessionConfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksessionConfig.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(ksessionConfig, null);
        WorkingMemoryEventListener wml = (WorkingMemoryEventListener)Mockito.mock(WorkingMemoryEventListener.class);
        ksession.addEventListener(wml);
        PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
        StockTick st1 = new StockTick(1L, "RHT", 100.0, 1000L);
        StockTick st2 = new StockTick(2L, "RHT", 100.0, 1000L);
        ksession.insert((Object)st1);
        ksession.insert((Object)st2);
        ((WorkingMemoryEventListener)Mockito.verify((Object)wml, (VerificationMode)Mockito.times((int)2))).objectInserted((ObjectInsertedEvent)Matchers.any(ObjectInsertedEvent.class));
        Assert.assertThat((Object)ksession.getObjects().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)ksession.getObjects(), (Matcher)IsCollectionContaining.hasItems((Object[])new Object[]{st1, st2}));
        ksession.fireAllRules();
        clock.advanceTime(3L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertThat((Object)ksession.getObjects().size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testEventExpirationSetToZero() throws Exception {
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = this.loadKnowledgeBase("test_EventExpirationSetToZero.drl", kconf);
        KnowledgeSessionConfiguration ksessionConfig = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        ksessionConfig.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)"pseudo"));
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession(ksessionConfig, null);
        WorkingMemoryEventListener wml = (WorkingMemoryEventListener)Mockito.mock(WorkingMemoryEventListener.class);
        ksession.addEventListener(wml);
        AgendaEventListener ael = (AgendaEventListener)Mockito.mock(AgendaEventListener.class);
        ksession.addEventListener(ael);
        PseudoClockScheduler clock = (PseudoClockScheduler)ksession.getSessionClock();
        StockTick st1 = new StockTick(1L, "RHT", 100.0, 1000L);
        StockTick st2 = new StockTick(2L, "RHT", 100.0, 1000L);
        ksession.insert((Object)st1);
        ksession.insert((Object)st2);
        ((WorkingMemoryEventListener)Mockito.verify((Object)wml, (VerificationMode)Mockito.times((int)2))).objectInserted((ObjectInsertedEvent)Matchers.any(ObjectInsertedEvent.class));
        ((AgendaEventListener)Mockito.verify((Object)ael, (VerificationMode)Mockito.times((int)2))).activationCreated((ActivationCreatedEvent)Matchers.any(ActivationCreatedEvent.class));
        Assert.assertThat((Object)ksession.getObjects().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        Assert.assertThat((Object)ksession.getObjects(), (Matcher)IsCollectionContaining.hasItems((Object[])new Object[]{st1, st2}));
        int fired = ksession.fireAllRules();
        Assert.assertThat((Object)fired, (Matcher)CoreMatchers.equalTo((Object)2));
        clock.advanceTime(3L, TimeUnit.SECONDS);
        ksession.fireAllRules();
        Assert.assertThat((Object)ksession.getObjects().size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }

    @Test
    public void testEventExpirationValue() throws Exception {
        String drl1 = "package org.drools.pkg1\nimport org.drools.StockTick\ndeclare StockTick\n    @role(event)\nend\nrule X\nwhen\n    StockTick()\nthen\nend\n";
        String drl2 = "package org.drools.pkg2\nimport org.drools.StockTick\ndeclare StockTick\n    @role(event)\nend\nrule X\nwhen\n    StockTick()\nthen\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl1.getBytes()), ResourceType.DRL);
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drl2.getBytes()), ResourceType.DRL);
        Assert.assertFalse((String)kbuilder.getErrors().toString(), (boolean)kbuilder.hasErrors());
        KnowledgeBaseConfiguration kconf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration();
        kconf.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kconf);
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        List otns = ((ReteooRuleBase)((KnowledgeBaseImpl)kbase).getRuleBase()).getRete().getObjectTypeNodes();
        ClassObjectType stot = new ClassObjectType(StockTick.class);
        for (ObjectTypeNode otn : otns) {
            if (!otn.getObjectType().isAssignableFrom((ObjectType)stot)) continue;
            Assert.assertEquals((long)-1L, (long)otn.getExpirationOffset());
        }
    }
}

