/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests.eventgenerator.example;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.integrationtests.eventgenerator.PseudoSessionClock;
import org.drools.integrationtests.eventgenerator.SimpleEventGenerator;
import org.drools.integrationtests.eventgenerator.SimpleEventListener;
import org.drools.integrationtests.eventgenerator.example.ProductionEvent;
import org.drools.integrationtests.eventgenerator.example.Resource;
import org.drools.integrationtests.eventgenerator.example.SlidingWindow;
import org.drools.rule.Package;

public class ExampleScenario {
    public static final String FILE_NAME_RULES = "../example_scenario.drl";
    private static int NUMBER_RESOURCES = 3;
    public static final int AVG_OCCUR_PRODUCTION_EVENT = 7000;
    public static final int MIN_OCCUR_PRODUCTION_EVENT = 4000;
    public static final int AVG_OCCUR_HEARTBEAT_EVENT = 90000;
    public static final int MIN_OCCUR_HEARTBEAT_EVENT = 45000;
    public static final int AVG_OCCUR_ALERT_EVENT = 1800000;
    public static final int MIN_OCCUR_ALERT_EVENT = 0;
    private static WorkingMemory wm;

    public static void setup() {
        InputStreamReader source = new InputStreamReader(ExampleScenario.class.getResourceAsStream(FILE_NAME_RULES));
        PackageBuilder builder = new PackageBuilder();
        try {
            builder.addPackageFromDrl((Reader)source);
        }
        catch (DroolsParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Package pkg = builder.getPackage();
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        try {
            ruleBase.addPackage(pkg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        wm = ruleBase.newStatefulSession();
    }

    public static final void main(String[] args) {
        ExampleScenario.setup();
        System.out.println("Waiting for messages...");
        System.out.println("Press [return] to quit\n");
        ArrayList<Resource> resources = new ArrayList<Resource>();
        SimpleEventGenerator myGenerator = new SimpleEventGenerator(wm, new SimpleEventListener(wm), PseudoSessionClock.timeInMinutes(15L));
        for (int i = 0; i < NUMBER_RESOURCES; ++i) {
            Resource res = new Resource("mach" + i);
            resources.add(res);
            wm.insert((Object)res.getOpStatus());
            SlidingWindow sw = new SlidingWindow(0L, res.getId(), PseudoSessionClock.timeInMinutes(10L), PseudoSessionClock.timeInMinutes(2L));
            wm.insert((Object)sw);
            myGenerator.addEventSource("Conveyor" + i, new ProductionEvent(res.getId()), 4000L, 7000L, 0L, 0);
        }
        myGenerator.generate();
        BufferedReader waiter = new BufferedReader(new InputStreamReader(System.in));
        try {
            waiter.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

