/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import junit.framework.Assert;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.integrationtests.SerializationHelper;
import org.drools.io.ResourceFactory;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.Package;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;

public class CommonTestMethodBase
extends Assert {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    protected RuleBase getSinglethreadRuleBase() throws Exception {
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        config.setMultithreadEvaluation(false);
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KnowledgeBase kbase) {
        return kbase.newStatefulKnowledgeSession();
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KnowledgeBase kbase, KnowledgeSessionConfiguration ksconf) {
        return kbase.newStatefulKnowledgeSession(ksconf, null);
    }

    protected KnowledgeBase loadKnowledgeBaseFromString(String ... drlContentStrings) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (String drlContentString : drlContentStrings) {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])drlContentString.getBytes()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            CommonTestMethodBase.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    protected KnowledgeBase loadKnowledgeBase(String ... classPathResources) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (String classPathResource : classPathResources) {
            kbuilder.add(ResourceFactory.newClassPathResource((String)classPathResource, ((Object)((Object)this)).getClass()), ResourceType.DRL);
        }
        if (kbuilder.hasErrors()) {
            CommonTestMethodBase.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    protected Package loadPackage(String classPathResource) throws DroolsParserException, IOException {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(classPathResource)));
        if (builder.hasErrors()) {
            CommonTestMethodBase.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        return pkg;
    }

    protected RuleBase loadRuleBase(Reader reader) throws IOException, DroolsParserException, Exception {
        DrlParser parser = new DrlParser();
        PackageDescr packageDescr = parser.parse(reader);
        if (parser.hasErrors()) {
            CommonTestMethodBase.fail((String)("Error messages in parser, need to sort this our (or else collect error messages):\n" + parser.getErrors()));
        }
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(packageDescr);
        if (builder.hasErrors()) {
            CommonTestMethodBase.fail((String)builder.getErrors().toString());
        }
        Package pkg = builder.getPackage();
        pkg = SerializationHelper.serializeObject(pkg);
        RuleBase ruleBase = this.getSinglethreadRuleBase();
        ruleBase.addPackage(pkg);
        ruleBase = SerializationHelper.serializeObject(ruleBase);
        return ruleBase;
    }
}

