/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.agent.BaseKnowledgeAgentTest;
import org.drools.agent.KnowledgeAgent;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Test;

public class KnowledgeAgentCustomClassLoaderTest
extends BaseKnowledgeAgentTest {
    @Test
    public void testCustomKnowledgeBuilderConfigurationWithIncrementalProcessing() throws Exception {
        this.testCustomKnowledgeBuilderConfiguration(false);
    }

    @Test
    public void testCustomKnowledgeBuilderConfigurationWithoutIncrementalProcessing() throws Exception {
        this.testCustomKnowledgeBuilderConfiguration(true);
    }

    @Test
    public void testUseKBaseClassLoaderForCompilingPropertyWithIncrementalProcessing() throws Exception {
        this.testUseKBaseClassLoaderForCompilingProperty(false);
    }

    @Test
    public void testUseKBaseClassLoaderForCompilingPropertyWithoutIncrementalProcessing() throws Exception {
        this.testUseKBaseClassLoaderForCompilingProperty(true);
    }

    private void testCustomKnowledgeBuilderConfiguration(boolean newInstance) throws Exception {
        this.testKagentWithCustomClassLoader(newInstance, false);
    }

    private void testUseKBaseClassLoaderForCompilingProperty(boolean newInstance) throws Exception {
        this.testKagentWithCustomClassLoader(newInstance, true);
    }

    private void testKagentWithCustomClassLoader(boolean newInstance, boolean useKBaseClassLoaderForCompiling) throws Exception {
        String rule = this.createCustomRule(true, "org.drools.test", new String[]{"org.drools.agent.test.KnowledgeAgentInstance"}, new String[]{"rule1"}, null, "   KnowledgeAgentInstance($id: instanceId)\n", "  list.add(\"Instance number \"+$id);\n");
        this.fileManager.write("rule1.drl", rule);
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rule1.drl' type='DRL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        URL jarURL = ((Object)((Object)this)).getClass().getResource("/KAModelTest.jar");
        URLClassLoader ucl = new URLClassLoader(new URL[]{jarURL}, ((Object)((Object)this)).getClass().getClassLoader());
        KnowledgeBaseConfiguration kbaseConfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader[])new ClassLoader[]{ucl});
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kbaseConfig);
        KnowledgeAgent kagent = this.createKAgent(kbase, newInstance, false);
        try {
            this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
            KnowledgeAgentCustomClassLoaderTest.fail((String)"Knowledge should fail to compile");
        }
        catch (Exception e) {
            KnowledgeAgentCustomClassLoaderTest.assertTrue((boolean)e.getMessage().contains("Unable to compile Knowledge"));
        }
        KnowledgeAgentCustomClassLoaderTest.assertTrue((boolean)kagent.getKnowledgeBase().getKnowledgePackages().isEmpty());
        kagent.dispose();
        if (useKBaseClassLoaderForCompiling) {
            kagent = this.createKAgent(kbase, newInstance, true);
        } else {
            KnowledgeBuilderConfiguration kbuilderConfig = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader[])new ClassLoader[]{ucl});
            kagent = this.createKAgent(kbase, newInstance, false, kbuilderConfig);
        }
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        KnowledgeAgentCustomClassLoaderTest.assertEquals((int)1, (int)kagent.getKnowledgeBase().getKnowledgePackages().size());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kagent.getKnowledgeBase());
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        Class<?> modelClass = ucl.loadClass("org.drools.agent.test.KnowledgeAgentInstance");
        Object modelInstance = modelClass.newInstance();
        modelClass.getMethod("setInstanceId", Integer.TYPE).invoke(modelInstance, 2);
        ksession.insert(modelInstance);
        ksession.fireAllRules();
        KnowledgeAgentCustomClassLoaderTest.assertEquals((int)1, (int)list.size());
        KnowledgeAgentCustomClassLoaderTest.assertTrue((boolean)list.contains("Instance number 2"));
        ksession.dispose();
        kagent.dispose();
    }
}

