/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.SystemEventListener;
import org.drools.agent.BaseKnowledgeAgentTest;
import org.drools.agent.KnowledgeAgent;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Test;

public class KnowledgeAgentDisposeTest
extends BaseKnowledgeAgentTest {
    private int resourceChangeNotificationCount = 0;

    @Test
    public void testMonitorResourceChangeEvents() throws Exception {
        this.fileManager.write("myExpander.dsl", this.createCommonDSL(null));
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule("Rule1"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rules.dslr' type='DSLR' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/myExpander.dsl' type='DSL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        this.resourceChangeNotificationCount = 0;
        this.fileManager.write("myExpander.dsl", this.createCommonDSL("name == \"John\""));
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule("Rule1"));
        this.scan(kagent);
        KnowledgeAgentDisposeTest.assertEquals((int)1, (int)this.resourceChangeNotificationCount);
        this.resourceChangeNotificationCount = 0;
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule(new String[]{"Rule1", "Rule2"}));
        this.scan(kagent);
        KnowledgeAgentDisposeTest.assertEquals((int)1, (int)this.resourceChangeNotificationCount);
        this.resourceChangeNotificationCount = 0;
        kagent.monitorResourceChangeEvents(false);
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule("Rule1"));
        try {
            this.scan(kagent);
            KnowledgeAgentDisposeTest.fail((String)"The agent didn't process any change set. This should be failed.");
        }
        catch (RuntimeException e) {
            KnowledgeAgentDisposeTest.assertEquals((String)e.getMessage(), (String)"Event for KnowledgeBase update, due to scan, was never received");
        }
        KnowledgeAgentDisposeTest.assertEquals((int)0, (int)this.resourceChangeNotificationCount);
        kagent.monitorResourceChangeEvents(true);
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule("Rule1"));
        this.scan(kagent);
        KnowledgeAgentDisposeTest.assertEquals((int)1, (int)this.resourceChangeNotificationCount);
        kagent.monitorResourceChangeEvents(false);
    }

    @Test
    public void testDispose() throws Exception {
        this.fileManager.write("myExpander.dsl", this.createCommonDSL(null));
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule("Rule1"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rules.dslr' type='DSLR' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/myExpander.dsl' type='DSL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        this.resourceChangeNotificationCount = 0;
        this.fileManager.write("myExpander.dsl", this.createCommonDSL("name == \"John\""));
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule("Rule1"));
        this.scan(kagent);
        KnowledgeAgentDisposeTest.assertEquals((int)1, (int)this.resourceChangeNotificationCount);
        this.resourceChangeNotificationCount = 0;
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.setGlobal("list", new ArrayList());
        ksession.fireAllRules();
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule(new String[]{"Rule1", "Rule2"}));
        this.scan(kagent);
        KnowledgeAgentDisposeTest.assertEquals((int)1, (int)this.resourceChangeNotificationCount);
        this.resourceChangeNotificationCount = 0;
        ksession.fireAllRules();
        try {
            kagent.dispose();
            KnowledgeAgentDisposeTest.fail((String)"The agent should failed");
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        ksession.dispose();
        kagent.dispose();
        this.fileManager.write("rules.dslr", this.createCommonDSLRRule("Rule1"));
        try {
            this.scan(kagent);
            KnowledgeAgentDisposeTest.fail((String)"The agent didn't process any change set. This should be failed.");
        }
        catch (RuntimeException e) {
            KnowledgeAgentDisposeTest.assertEquals((String)e.getMessage(), (String)"Event for KnowledgeBase update, due to scan, was never received");
        }
        KnowledgeAgentDisposeTest.assertEquals((int)0, (int)this.resourceChangeNotificationCount);
    }

    public KnowledgeAgent createKAgent(KnowledgeBase kbase, boolean newInstance) {
        KnowledgeAgent kagent = super.createKAgent(kbase, newInstance);
        kagent.setSystemEventListener(new SystemEventListener(){

            public void info(String message) {
            }

            public void info(String message, Object object) {
            }

            public void warning(String message) {
            }

            public void warning(String message, Object object) {
            }

            public void exception(String message, Throwable e) {
            }

            public void exception(Throwable e) {
            }

            public void debug(String message) {
                if ("KnowledgeAgent received ChangeSet changed notification".equals(message)) {
                    KnowledgeAgentDisposeTest.this.resourceChangeNotificationCount++;
                }
            }

            public void debug(String message, Object object) {
            }
        });
        return kagent;
    }
}

