/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.Person;
import org.drools.agent.BaseKnowledgeAgentTest;
import org.drools.agent.KnowledgeAgent;
import org.drools.event.knowledgeagent.AfterChangeSetAppliedEvent;
import org.drools.event.knowledgeagent.AfterChangeSetProcessedEvent;
import org.drools.event.knowledgeagent.AfterResourceProcessedEvent;
import org.drools.event.knowledgeagent.BeforeChangeSetAppliedEvent;
import org.drools.event.knowledgeagent.BeforeChangeSetProcessedEvent;
import org.drools.event.knowledgeagent.BeforeResourceProcessedEvent;
import org.drools.event.knowledgeagent.KnowledgeAgentEventListener;
import org.drools.event.knowledgeagent.KnowledgeBaseUpdatedEvent;
import org.drools.event.knowledgeagent.ResourceCompilationFailedEvent;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.Test;

public class KnowledgeAgentEventListenerTest
extends BaseKnowledgeAgentTest {
    private final Object lock = new Object();
    private volatile boolean changeSetApplied;
    private boolean compilationErrors;
    private boolean kbaseUpdated;
    private int beforeChangeSetProcessed;
    private int afterChangeSetProcessed;
    private int beforeChangeSetApplied;
    private int afterChangeSetApplied;
    private int beforeResourceProcessed;
    private int afterResourceProcessed;

    @Test
    public void testEventListenerWithIncrementalChangeSet() throws Exception {
        this.fileManager.write("myExpander.dsl", this.createCommonDSL(null));
        this.fileManager.write("rules.drl", this.createCommonDSLRRule("Rule1"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rules.drl' type='DSLR' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/myExpander.dsl' type='DSL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        ArrayList list = new ArrayList();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.beforeResourceProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.afterResourceProcessed);
        KnowledgeAgentEventListenerTest.assertFalse((boolean)this.compilationErrors);
        KnowledgeAgentEventListenerTest.assertTrue((boolean)this.kbaseUpdated);
        this.resetEventCounters();
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Person("John", 34));
        ksession.fireAllRules();
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)list.size());
        KnowledgeAgentEventListenerTest.assertTrue((boolean)list.contains("Rule1"));
        list.clear();
        File f2 = this.fileManager.write("myExpander.dsl", this.createCommonDSL("name == \"John\""));
        this.fileManager.write("rules.drl", this.createCommonDSLRRule("Rule1"));
        this.scan(kagent);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.beforeResourceProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.afterResourceProcessed);
        KnowledgeAgentEventListenerTest.assertFalse((boolean)this.compilationErrors);
        KnowledgeAgentEventListenerTest.assertTrue((boolean)this.kbaseUpdated);
        this.resetEventCounters();
        ksession.fireAllRules();
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)list.size());
        KnowledgeAgentEventListenerTest.assertTrue((boolean)list.contains("Rule1"));
        list.clear();
        this.fileManager.write("rules.drl", this.createCommonDSLRRule(new String[]{"Rule1", "Rule2"}));
        this.scan(kagent);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeResourceProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterResourceProcessed);
        KnowledgeAgentEventListenerTest.assertFalse((boolean)this.compilationErrors);
        KnowledgeAgentEventListenerTest.assertTrue((boolean)this.kbaseUpdated);
        this.resetEventCounters();
        ksession.fireAllRules();
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)list.size());
        KnowledgeAgentEventListenerTest.assertTrue((boolean)list.contains("Rule2"));
        list.clear();
        this.fileManager.write("rules.drl", this.createCommonDSLRRule("Rule3"));
        this.scan(kagent);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeResourceProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterResourceProcessed);
        KnowledgeAgentEventListenerTest.assertFalse((boolean)this.compilationErrors);
        KnowledgeAgentEventListenerTest.assertTrue((boolean)this.kbaseUpdated);
        this.resetEventCounters();
        ksession.fireAllRules();
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)list.size());
        KnowledgeAgentEventListenerTest.assertTrue((boolean)list.contains("Rule3"));
        list.clear();
        this.fileManager.deleteFile(f2);
        this.scan(kagent);
        this.fileManager.write("rules.drl", this.createCommonDSLRRule("Rule1"));
        try {
            this.scan(kagent);
            KnowledgeAgentEventListenerTest.fail((String)"An exception was expected");
        }
        catch (Exception e) {
            // empty catch block
        }
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.beforeChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.afterChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.beforeChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.afterChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.beforeResourceProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.afterResourceProcessed);
        KnowledgeAgentEventListenerTest.assertTrue((boolean)this.compilationErrors);
        KnowledgeAgentEventListenerTest.assertTrue((boolean)this.kbaseUpdated);
        this.resetEventCounters();
        ksession.dispose();
        kagent.dispose();
    }

    @Test
    public void testEventListenerWithoutIncrementalChangeSet() throws Exception {
        this.fileManager.write("myExpander.dsl", this.createCommonDSL(null));
        this.fileManager.write("rules.drl", this.createCommonDSLRRule("Rule1"));
        String xml = "";
        xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'";
        xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'";
        xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        xml = xml + "    <add> ";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/rules.drl' type='DSLR' />";
        xml = xml + "        <resource source='http://localhost:" + this.getPort() + "/myExpander.dsl' type='DSL' />";
        xml = xml + "    </add> ";
        xml = xml + "</change-set>";
        File fxml = this.fileManager.write("changeset.xml", xml);
        ArrayList list = new ArrayList();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        KnowledgeAgent kagent = this.createKAgent(kbase, false);
        this.applyChangeSet(kagent, ResourceFactory.newUrlResource((URL)fxml.toURI().toURL()));
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.beforeResourceProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.afterResourceProcessed);
        KnowledgeAgentEventListenerTest.assertFalse((boolean)this.compilationErrors);
        KnowledgeAgentEventListenerTest.assertTrue((boolean)this.kbaseUpdated);
        this.resetEventCounters();
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kagent.getKnowledgeBase());
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Person("John", 34));
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)list.size());
        KnowledgeAgentEventListenerTest.assertTrue((boolean)list.contains("Rule1"));
        list.clear();
        File f2 = this.fileManager.write("myExpander.dsl", this.createCommonDSL("name == \"John\""));
        this.fileManager.write("rules.drl", this.createCommonDSLRRule("Rule1"));
        this.scan(kagent);
        ksession = this.createKnowledgeSession(kagent.getKnowledgeBase());
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Person("John", 34));
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)list.size());
        KnowledgeAgentEventListenerTest.assertTrue((boolean)list.contains("Rule1"));
        list.clear();
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.beforeResourceProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.afterResourceProcessed);
        KnowledgeAgentEventListenerTest.assertFalse((boolean)this.compilationErrors);
        KnowledgeAgentEventListenerTest.assertTrue((boolean)this.kbaseUpdated);
        this.resetEventCounters();
        ksession = this.createKnowledgeSession(kagent.getKnowledgeBase());
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Person("John", 34));
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)list.size());
        KnowledgeAgentEventListenerTest.assertTrue((boolean)list.contains("Rule1"));
        list.clear();
        this.fileManager.write("rules.drl", this.createCommonDSLRRule(new String[]{"Rule1", "Rule2"}));
        this.scan(kagent);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeResourceProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterResourceProcessed);
        KnowledgeAgentEventListenerTest.assertFalse((boolean)this.compilationErrors);
        KnowledgeAgentEventListenerTest.assertTrue((boolean)this.kbaseUpdated);
        this.resetEventCounters();
        ksession = this.createKnowledgeSession(kagent.getKnowledgeBase());
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Person("John", 34));
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)list.size());
        KnowledgeAgentEventListenerTest.assertTrue((boolean)list.contains("Rule1"));
        KnowledgeAgentEventListenerTest.assertTrue((boolean)list.contains("Rule2"));
        list.clear();
        this.fileManager.write("rules.drl", this.createCommonDSLRRule("Rule3"));
        this.scan(kagent);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.beforeResourceProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)this.afterResourceProcessed);
        KnowledgeAgentEventListenerTest.assertFalse((boolean)this.compilationErrors);
        KnowledgeAgentEventListenerTest.assertTrue((boolean)this.kbaseUpdated);
        this.resetEventCounters();
        ksession = this.createKnowledgeSession(kagent.getKnowledgeBase());
        ksession.setGlobal("list", list);
        ksession.insert((Object)new Person("John", 34));
        ksession.fireAllRules();
        ksession.dispose();
        KnowledgeAgentEventListenerTest.assertEquals((int)1, (int)list.size());
        KnowledgeAgentEventListenerTest.assertTrue((boolean)list.contains("Rule3"));
        list.clear();
        this.fileManager.deleteFile(f2);
        this.scan(kagent);
        this.fileManager.write("rules.drl", this.createCommonDSLRRule("Rule1"));
        try {
            this.scan(kagent);
            KnowledgeAgentEventListenerTest.fail((String)"An exception was expected");
        }
        catch (Exception e) {
            // empty catch block
        }
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.beforeChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.afterChangeSetApplied);
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.beforeChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.afterChangeSetProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.beforeResourceProcessed);
        KnowledgeAgentEventListenerTest.assertEquals((int)2, (int)this.afterResourceProcessed);
        KnowledgeAgentEventListenerTest.assertTrue((boolean)this.compilationErrors);
        KnowledgeAgentEventListenerTest.assertTrue((boolean)this.kbaseUpdated);
        this.resetEventCounters();
        ksession.dispose();
        kagent.dispose();
    }

    public KnowledgeAgent createKAgent(KnowledgeBase kbase, boolean newInstance) {
        KnowledgeAgent kagent = super.createKAgent(kbase, newInstance);
        kagent.addEventListener(new KnowledgeAgentEventListener(){

            public void beforeChangeSetApplied(BeforeChangeSetAppliedEvent event) {
                KnowledgeAgentEventListenerTest.this.beforeChangeSetApplied++;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterChangeSetApplied(AfterChangeSetAppliedEvent event) {
                KnowledgeAgentEventListenerTest.this.afterChangeSetApplied++;
                Object object = KnowledgeAgentEventListenerTest.this.lock;
                synchronized (object) {
                    KnowledgeAgentEventListenerTest.this.changeSetApplied = true;
                    KnowledgeAgentEventListenerTest.this.lock.notifyAll();
                }
            }

            public void beforeChangeSetProcessed(BeforeChangeSetProcessedEvent event) {
                KnowledgeAgentEventListenerTest.this.beforeChangeSetProcessed++;
            }

            public void afterChangeSetProcessed(AfterChangeSetProcessedEvent event) {
                KnowledgeAgentEventListenerTest.this.afterChangeSetProcessed++;
            }

            public void beforeResourceProcessed(BeforeResourceProcessedEvent event) {
                KnowledgeAgentEventListenerTest.this.beforeResourceProcessed++;
            }

            public void afterResourceProcessed(AfterResourceProcessedEvent event) {
                KnowledgeAgentEventListenerTest.this.afterResourceProcessed++;
            }

            public void knowledgeBaseUpdated(KnowledgeBaseUpdatedEvent event) {
                KnowledgeAgentEventListenerTest.this.kbaseUpdated = true;
            }

            public void resourceCompilationFailed(ResourceCompilationFailedEvent event) {
                KnowledgeAgentEventListenerTest.this.compilationErrors = true;
                System.out.println(event.getKnowledgeBuilder().getErrors().toString());
            }
        });
        KnowledgeAgentEventListenerTest.assertEquals((String)"test agent", (String)kagent.getName());
        return kagent;
    }

    private void resetEventCounters() {
        this.beforeChangeSetApplied = 0;
        this.beforeChangeSetProcessed = 0;
        this.beforeResourceProcessed = 0;
        this.afterChangeSetApplied = 0;
        this.afterChangeSetProcessed = 0;
        this.afterResourceProcessed = 0;
        this.compilationErrors = false;
        this.changeSetApplied = false;
        this.kbaseUpdated = false;
    }
}

