/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.CommonTestMethodBase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderErrors;
import org.drools.builder.ResourceType;
import org.drools.command.BatchExecutionCommand;
import org.drools.command.Command;
import org.drools.command.CommandFactory;
import org.drools.command.builder.KnowledgeBuilderAddCommand;
import org.drools.command.builder.KnowledgeBuilderGetErrorsCommand;
import org.drools.command.builder.KnowledgeBuilderGetKnowledgePackagesCommand;
import org.drools.command.builder.KnowledgeBuilderHasErrorsCommand;
import org.drools.command.builder.NewKnowledgeBuilderCommand;
import org.drools.integrationtests.DroolsTest;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.runtime.ExecutionResults;
import org.drools.runtime.StatefulKnowledgeSession;
import org.junit.After;
import org.junit.Test;

public class KBuilderBatchExecutionTest
extends CommonTestMethodBase {
    private static final String source = "org/drools/lang/misplaced_parenthesis.drl";
    private StatefulKnowledgeSession ksession = null;
    private static int counter = 0;

    @After
    public void disposeKSession() throws Exception {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testKBuilderAdd() throws Exception {
        Resource res = ResourceFactory.newClassPathResource((String)source);
        KBuilderBatchExecutionTest.assertNotNull((Object)res);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        this.ksession = this.createKnowledgeSession(kbase);
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add(new NewKnowledgeBuilderCommand("kbuilder"));
        commands.add(new KnowledgeBuilderAddCommand(res, ResourceType.DRL, null));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        KBuilderBatchExecutionTest.assertNotNull((Object)result);
        Object kbuilder = result.getValue("kbuilder");
        KBuilderBatchExecutionTest.assertNotNull((Object)kbuilder);
        KBuilderBatchExecutionTest.assertTrue((boolean)(kbuilder instanceof KnowledgeBuilder));
        KBuilderBatchExecutionTest.assertTrue((boolean)((KnowledgeBuilder)kbuilder).hasErrors());
    }

    @Test
    public void testHasErrors() throws Exception {
        Resource res = ResourceFactory.newClassPathResource((String)source);
        KBuilderBatchExecutionTest.assertNotNull((Object)res);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        this.ksession = this.createKnowledgeSession(kbase);
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add(new NewKnowledgeBuilderCommand());
        commands.add(new KnowledgeBuilderAddCommand(res, ResourceType.DRL, null));
        commands.add(new KnowledgeBuilderHasErrorsCommand("hasErrors"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        KBuilderBatchExecutionTest.assertNotNull((Object)result);
        Object hasErrors = result.getValue("hasErrors");
        KBuilderBatchExecutionTest.assertNotNull((Object)hasErrors);
        KBuilderBatchExecutionTest.assertEquals((Object)Boolean.TRUE, (Object)hasErrors);
    }

    @Test
    public void testBatchGetErrors() throws Exception {
        Resource res = ResourceFactory.newClassPathResource((String)source);
        KBuilderBatchExecutionTest.assertNotNull((Object)res);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        this.ksession = this.createKnowledgeSession(kbase);
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add(new NewKnowledgeBuilderCommand());
        commands.add(new KnowledgeBuilderAddCommand(res, ResourceType.DRL, null));
        commands.add(new KnowledgeBuilderGetErrorsCommand("errors"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        KBuilderBatchExecutionTest.assertNotNull((Object)result);
        Object errors = result.getValue("errors");
        KBuilderBatchExecutionTest.assertNotNull((Object)errors);
        KBuilderBatchExecutionTest.assertTrue((boolean)(errors instanceof KnowledgeBuilderErrors));
        KnowledgeBuilderErrors kbErrors = (KnowledgeBuilderErrors)errors;
        KBuilderBatchExecutionTest.assertEquals((int)2, (int)kbErrors.size());
        KnowledgeBuilderError kbError = (KnowledgeBuilderError)kbErrors.iterator().next();
        KBuilderBatchExecutionTest.assertTrue((boolean)kbError.getMessage().startsWith("[ERR 102]"));
    }

    @Test
    public void testGetKnowledgePackages() {
        int NUM_FACTS = 5;
        String ruleString = "package org.drools.integrationtests;\nimport " + KBuilderBatchExecutionTest.class.getCanonicalName() + ";\n" + "import org.drools.integrationtests.DroolsTest.Foo;\n" + "import org.drools.integrationtests.DroolsTest.Bar;\n" + "rule test\n" + "when\n" + "      Foo($p : id, id < " + Integer.toString(NUM_FACTS) + ")\n" + "      Bar(id == $p)\n" + "then\n" + "   " + KBuilderBatchExecutionTest.class.getSimpleName() + ".incCounter();\n" + "end\n";
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        this.ksession = this.createKnowledgeSession(kbase);
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add(new NewKnowledgeBuilderCommand());
        commands.add(new KnowledgeBuilderAddCommand(ResourceFactory.newByteArrayResource((byte[])ruleString.getBytes()), ResourceType.DRL, null));
        commands.add(new KnowledgeBuilderGetKnowledgePackagesCommand("pkgs"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        KBuilderBatchExecutionTest.assertNotNull((Object)result);
        Object pkgsObject = result.getValue("pkgs");
        KBuilderBatchExecutionTest.assertTrue((pkgsObject != null && pkgsObject instanceof Collection ? 1 : 0) != 0);
        kbase.addKnowledgePackages((Collection)pkgsObject);
        this.ksession.dispose();
        this.ksession = this.createKnowledgeSession(kbase);
        for (int i = 0; i < NUM_FACTS; ++i) {
            this.ksession.insert((Object)new DroolsTest.Foo(i));
            this.ksession.insert((Object)new DroolsTest.Bar(i));
        }
        this.ksession.fireAllRules();
        KBuilderBatchExecutionTest.assertEquals((int)NUM_FACTS, (int)counter);
    }

    public static void incCounter() {
        ++counter;
    }
}

