/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command;

import java.util.ArrayList;
import java.util.List;
import org.drools.Cheese;
import org.drools.CommonTestMethodBase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.command.BatchExecutionCommand;
import org.drools.command.Command;
import org.drools.command.CommandFactory;
import org.drools.io.ResourceFactory;
import org.drools.runtime.ExecutionResults;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.QueryResults;
import org.junit.After;
import org.junit.Test;

public class MoreBatchExecutionTest
extends CommonTestMethodBase {
    private StatefulKnowledgeSession ksession = null;

    @After
    public void disposeKSession() throws Exception {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testFireAllRules() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/integrationtests/test_ImportFunctions.drl"), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            MoreBatchExecutionTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        this.ksession = this.createKnowledgeSession(kbase);
        Cheese cheese = new Cheese("stilton", 15);
        this.ksession.insert((Object)cheese);
        List list = new ArrayList();
        this.ksession.setGlobal("list", list);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newFireAllRules((String)"fired"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        MoreBatchExecutionTest.assertNotNull((String)"Batch execution result is null!", (Object)result);
        Object firedObject = result.getValue("fired");
        MoreBatchExecutionTest.assertTrue((String)"Retrieved object is null or incorrect!", (firedObject != null && firedObject instanceof Integer ? 1 : 0) != 0);
        MoreBatchExecutionTest.assertEquals((Object)4, (Object)firedObject);
        list = (List)this.ksession.getGlobal("list");
        MoreBatchExecutionTest.assertEquals((int)4, (int)list.size());
        MoreBatchExecutionTest.assertEquals((Object)"rule1", list.get(0));
        MoreBatchExecutionTest.assertEquals((Object)"rule2", list.get(1));
        MoreBatchExecutionTest.assertEquals((Object)"rule3", list.get(2));
        MoreBatchExecutionTest.assertEquals((Object)"rule4", list.get(3));
    }

    @Test
    public void testQuery() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"org/drools/integrationtests/simple_query_test.drl"), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            MoreBatchExecutionTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.insert((Object)new Cheese("stinky", 5));
        this.ksession.insert((Object)new Cheese("smelly", 7));
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newQuery((String)"numStinkyCheeses", (String)"simple query"));
        BatchExecutionCommand cmds = CommandFactory.newBatchExecution(commands);
        ExecutionResults result = (ExecutionResults)this.ksession.execute((Command)cmds);
        MoreBatchExecutionTest.assertNotNull((String)"Batch execution result is null!", (Object)result);
        Object queryResultsObject = result.getValue("numStinkyCheeses");
        MoreBatchExecutionTest.assertTrue((String)"Retrieved object is null or incorrect!", (queryResultsObject != null && queryResultsObject instanceof QueryResults ? 1 : 0) != 0);
        MoreBatchExecutionTest.assertEquals((int)1, (int)((QueryResults)queryResultsObject).size());
    }
}

