/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.util.ArrayList;
import java.util.List;
import org.drools.CommonTestMethodBase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.ActivationIterator;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.Activation;
import org.junit.Test;

public class ActivationIteratorTest
extends CommonTestMethodBase {
    @Test
    public void testSingleLian() {
        String str = "package org.drools.test \n\nrule rule1 when\n    $s : String( this != 'xx' )\nthen\nend\nrule rule6 when\n     java.util.Map()\nthen\nend\n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            ActivationIteratorTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        for (int i = 0; i < 5; ++i) {
            ksession.insert((Object)new String("" + i));
        }
        ActivationIterator it = ActivationIterator.iterator((StatefulKnowledgeSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        Activation act = (Activation)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s") + ":" + act.isActive());
            act = (Activation)it.next();
        }
        this.assertContains(new String[]{"rule1:0:true", "rule1:1:true", "rule1:2:true", "rule1:3:true", "rule1:4:true"}, list);
        ksession.fireAllRules();
        it = ActivationIterator.iterator((StatefulKnowledgeSession)ksession);
        list = new ArrayList();
        act = (Activation)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s") + ":" + act.isActive());
            act = (Activation)it.next();
        }
        this.assertContains(new String[]{"rule1:0:false", "rule1:1:false", "rule1:2:false", "rule1:3:false", "rule1:4:false"}, list);
    }

    @Test
    public void testLianPlusEvaln() {
        String str = "package org.drools.test \n\nrule rule1 when\n    $s : String( this != 'xx' )\n    eval( 1 == 1 ) \nthen\nend\nrule rule6 when\n     java.util.Map()\nthen\nend\n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            ActivationIteratorTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        for (int i = 0; i < 5; ++i) {
            ksession.insert((Object)new String("" + i));
        }
        ActivationIterator it = ActivationIterator.iterator((StatefulKnowledgeSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        Activation act = (Activation)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s") + ":" + act.isActive());
            act = (Activation)it.next();
        }
        this.assertContains(new String[]{"rule1:0:true", "rule1:1:true", "rule1:2:true", "rule1:3:true", "rule1:4:true"}, list);
        ksession.fireAllRules();
        it = ActivationIterator.iterator((StatefulKnowledgeSession)ksession);
        list = new ArrayList();
        act = (Activation)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s") + ":" + act.isActive());
            act = (Activation)it.next();
        }
        this.assertContains(new String[]{"rule1:0:false", "rule1:1:false", "rule1:2:false", "rule1:3:false", "rule1:4:false"}, list);
    }

    @Test
    public void testLianPlusEvalnWithSharing() {
        String str = "package org.drools.test \n\nrule rule0 when\n    $s : String( this != 'xx' )\nthen\nend\nrule rule1 when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) <= 2 ) \nthen\nend\nrule rule2 when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) <= 2 ) \nthen\nend\nrule rule3 when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) > 2 ) \nthen\nend\nrule rule4 when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) > 2 ) \n    eval( Integer.parseInt( $s ) > 3 ) \nthen\nend\nrule rule5 when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) > 2 ) \n    eval( Integer.parseInt( $s ) > 3 ) \nthen\nend\nrule rule6 when\n     java.util.Map()\nthen\nend\n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            ActivationIteratorTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        for (int i = 0; i < 5; ++i) {
            ksession.insert((Object)new String("" + i));
        }
        ActivationIterator it = ActivationIterator.iterator((StatefulKnowledgeSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        Activation act = (Activation)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s") + ":" + act.isActive());
            act = (Activation)it.next();
        }
        this.assertContains(new String[]{"rule0:0:true", "rule0:1:true", "rule0:2:true", "rule0:3:true", "rule0:4:true", "rule1:0:true", "rule1:1:true", "rule1:2:true", "rule2:0:true", "rule2:1:true", "rule2:2:true", "rule3:3:true", "rule3:4:true", "rule3:4:true"}, list);
        ksession.fireAllRules();
        it = ActivationIterator.iterator((StatefulKnowledgeSession)ksession);
        list = new ArrayList();
        act = (Activation)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s") + ":" + act.isActive());
            act = (Activation)it.next();
        }
        this.assertContains(new String[]{"rule0:0:false", "rule0:1:false", "rule0:2:false", "rule0:3:false", "rule0:4:false", "rule1:0:false", "rule1:1:false", "rule1:2:false", "rule2:0:false", "rule2:1:false", "rule2:2:false", "rule3:3:false", "rule3:4:false", "rule3:4:false"}, list);
    }

    @Test
    public void testLianPlusEvalnWithSharingWithMixedDormantAndActive() {
        String str = "package org.drools.test \n\nrule rule0 salience ( Integer.parseInt('1'+$s) ) when\n    $s : String( this != 'xx' )\nthen\nend\nrule rule1 salience ( Integer.parseInt('1'+$s)) when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) <= 2 ) \nthen\nend\nrule rule2 salience ( Integer.parseInt('1'+$s)) when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) <= 2 ) \nthen\n    kcontext.getKnowledgeRuntime().halt();\nend\nrule rule3 salience ( Integer.parseInt('1'+$s)) when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) > 2 ) \nthen\nend\nrule rule4 salience ( Integer.parseInt('1'+$s) ) when\n    $s : String( this != 'xx' )\n    eval( Integer.parseInt( $s ) > 2 ) \n    eval( Integer.parseInt( $s ) > 3 ) \nthen\nend\n\nrule rule6 when\n     java.util.Map()\nthen\nend\n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            ActivationIteratorTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        for (int i = 0; i < 5; ++i) {
            ksession.insert((Object)new String("" + i));
        }
        ksession.fireAllRules();
        ActivationIterator it = ActivationIterator.iterator((StatefulKnowledgeSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        Activation act = (Activation)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s") + ":" + act.isActive());
            act = (Activation)it.next();
        }
        this.assertContains(new String[]{"rule0:0:true", "rule0:1:true", "rule0:2:true", "rule0:3:false", "rule0:4:false", "rule1:0:true", "rule1:1:true", "rule1:2:true", "rule2:0:true", "rule2:1:true", "rule2:2:false", "rule3:3:false", "rule3:4:false", "rule3:4:false"}, list);
    }

    @Test
    public void testSingleJoinNode() {
        String str = "package org.drools.test \n\nrule rule1 when\n    $s1 : String( )\n    $s2 : String( )\nthen\nend\n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            ActivationIteratorTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        for (int i = 0; i < 2; ++i) {
            ksession.insert((Object)new String("" + i));
        }
        ActivationIterator it = ActivationIterator.iterator((StatefulKnowledgeSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        Activation act = (Activation)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.isActive());
            act = (Activation)it.next();
        }
        this.assertContains(new String[]{"rule1:0:1:true", "rule1:1:0:true", "rule1:1:1:true", "rule1:0:0:true"}, list);
        ksession.fireAllRules();
        it = ActivationIterator.iterator((StatefulKnowledgeSession)ksession);
        list = new ArrayList();
        act = (Activation)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.isActive());
            act = (Activation)it.next();
        }
        this.assertContains(new String[]{"rule1:0:1:false", "rule1:1:0:false", "rule1:1:1:false", "rule1:0:0:false"}, list);
    }

    @Test
    public void testSingleJoinNodePlusEvaln() {
        String str = "package org.drools.test \n\nrule rule1 when\n    $s1 : String( )\n    $s2 : String( )\n    eval( 1 == 1 ) \nthen\nend\n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            ActivationIteratorTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        for (int i = 0; i < 2; ++i) {
            ksession.insert((Object)new String("" + i));
        }
        ActivationIterator it = ActivationIterator.iterator((StatefulKnowledgeSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        Activation act = (Activation)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.isActive());
            act = (Activation)it.next();
        }
        this.assertContains(new String[]{"rule1:0:1:true", "rule1:1:0:true", "rule1:1:1:true", "rule1:0:0:true"}, list);
        ksession.fireAllRules();
        it = ActivationIterator.iterator((StatefulKnowledgeSession)ksession);
        list = new ArrayList();
        act = (Activation)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.isActive());
            act = (Activation)it.next();
        }
        this.assertContains(new String[]{"rule1:0:1:false", "rule1:1:0:false", "rule1:1:1:false", "rule1:0:0:false"}, list);
    }

    @Test
    public void testSingleJoinNodePlusEvalnWithSharing() {
        String str = "package org.drools.test \n\nrule rule1 when\n    $s1 : String( )\n    $s2 : String( )\n    eval( 1 == 1 ) \nthen\nend\nrule rule2 when\n    $s1 : String( )\nthen\nend\nrule rule3 when\n    $s1 : String( )\n    $s2 : String( )\n    $s3 : String( )\n    eval( 1 == 1 ) \nthen\nend\n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            ActivationIteratorTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        for (int i = 0; i < 2; ++i) {
            ksession.insert((Object)new String("" + i));
        }
        ActivationIterator it = ActivationIterator.iterator((StatefulKnowledgeSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        Activation act = (Activation)it.next();
        while (act != null) {
            if (act.getRule().getName().equals("rule3")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.getDeclarationValue("$s3") + ":" + act.isActive());
            } else if (act.getRule().getName().equals("rule1")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.isActive());
            } else if (act.getRule().getName().equals("rule2")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.isActive());
            }
            act = (Activation)it.next();
        }
        this.assertContains(new String[]{"rule1:0:0:true", "rule1:0:1:true", "rule1:1:0:true", "rule1:1:1:true", "rule2:1:true", "rule2:0:true", "rule3:0:0:0:true", "rule3:0:0:1:true", "rule3:1:0:0:true", "rule3:1:0:1:true", "rule3:0:1:0:true", "rule3:0:1:1:true", "rule3:1:1:0:true", "rule3:1:1:1:true"}, list);
        ksession.fireAllRules();
        it = ActivationIterator.iterator((StatefulKnowledgeSession)ksession);
        list = new ArrayList();
        act = (Activation)it.next();
        while (act != null) {
            if (act.getRule().getName().equals("rule3")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.getDeclarationValue("$s3") + ":" + act.isActive());
            } else if (act.getRule().getName().equals("rule1")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.isActive());
            } else if (act.getRule().getName().equals("rule2")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.isActive());
            }
            act = (Activation)it.next();
        }
        this.assertContains(new String[]{"rule1:0:0:false", "rule1:0:1:false", "rule1:1:0:false", "rule1:1:1:false", "rule2:1:false", "rule2:0:false", "rule3:0:0:0:false", "rule3:0:0:1:false", "rule3:1:0:0:false", "rule3:1:0:1:false", "rule3:0:1:0:false", "rule3:0:1:1:false", "rule3:1:1:0:false", "rule3:1:1:1:false"}, list);
    }

    @Test
    public void testSingleJoinNodePlusEvalnWithSharingWithMixedDormantAndActive() {
        String str = "package org.drools.test \n\nrule rule1  salience ( Integer.parseInt( '1'+$s1+'0'+$s2 ) ) when\n    $s1 : String( )\n    $s2 : String( )\n    eval( 1 == 1 ) \nthen\nend\nrule rule2 salience 1020 when\n    $s1 : String( )\nthen\n    kcontext.getKnowledgeRuntime().halt();\nend\nrule rule3  salience ( Integer.parseInt( '1'+$s1+'1'+$s2  ) ) when\n    $s1 : String( )\n    $s2 : String( )\n    $s3 : String( )\n    eval( 1 == 1 ) \nthen\nend\n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            ActivationIteratorTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        for (int i = 0; i < 2; ++i) {
            ksession.insert((Object)new String("" + i));
        }
        ksession.fireAllRules();
        ActivationIterator it = ActivationIterator.iterator((StatefulKnowledgeSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        Activation act = (Activation)it.next();
        while (act != null) {
            if (act.getRule().getName().equals("rule3")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.getDeclarationValue("$s3") + ":" + act.isActive());
            } else if (act.getRule().getName().equals("rule1")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.getDeclarationValue("$s2") + ":" + act.isActive());
            } else if (act.getRule().getName().equals("rule2")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.isActive());
            }
            act = (Activation)it.next();
        }
        this.assertContains(new String[]{"rule1:0:0:true", "rule1:0:1:true", "rule1:1:0:false", "rule1:1:1:false", "rule2:1:false", "rule2:0:true", "rule3:0:0:0:true", "rule3:0:0:1:true", "rule3:1:0:0:false", "rule3:1:0:1:false", "rule3:0:1:0:true", "rule3:0:1:1:true", "rule3:1:1:0:false", "rule3:1:1:1:false"}, list);
    }

    @Test
    public void testNotSharingWithMixedDormantAndActive() {
        String str = "package org.drools.test \n\nrule rule1 salience 10 when\n    not String( this == '1' )\nthen\nend\nrule rule2  salience ( Integer.parseInt( $s1+'1' ) ) when\n    not String( this == '1' )\n    $s1 : String( )\n    eval( 1 == 1 ) \nthen\nend\nrule rule3 salience ( Integer.parseInt( $s1+'2' ) ) when\n    $s1 : String( )\n    not String( this == '1' )\n    eval( 1 == 1 ) \n    eval( 1 == 1 ) \nthen\n    kcontext.getKnowledgeRuntime().halt();\nend\n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            ActivationIteratorTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)"0");
        ksession.insert((Object)"2");
        ksession.fireAllRules();
        ActivationIterator it = ActivationIterator.iterator((StatefulKnowledgeSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        Activation act = (Activation)it.next();
        while (act != null) {
            if (act.getRule().getName().equals("rule3")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.isActive());
            } else if (act.getRule().getName().equals("rule1")) {
                list.add(act.getRule().getName() + ":" + act.isActive());
            } else if (act.getRule().getName().equals("rule2")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.isActive());
            }
            act = (Activation)it.next();
        }
        this.assertContains(new String[]{"rule1:true", "rule2:0:true", "rule2:2:true", "rule3:0:true", "rule3:2:false"}, list);
    }

    @Test
    public void testExistsSharingWithMixedDormantAndActive() {
        String str = "package org.drools.test \n\nrule rule1 salience 100 when\n    exists String( this == '1' )\nthen\nend\nrule rule2  salience ( Integer.parseInt( $s1+'1' ) ) when\n    exists String( this == '1' )\n    $s1 : String( )\n    eval( 1 == 1 ) \nthen\nend\nrule rule3 salience ( Integer.parseInt( $s1+'1' ) ) when\n    $s1 : String( )\n    exists String( this == '1' )\n    eval( 1 == 1 ) \n    eval( 1 == 1 ) \nthen\n    kcontext.getKnowledgeRuntime().halt();\nend\n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            ActivationIteratorTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)"0");
        ksession.insert((Object)"1");
        ksession.insert((Object)"2");
        ksession.fireAllRules();
        ActivationIterator it = ActivationIterator.iterator((StatefulKnowledgeSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        Activation act = (Activation)it.next();
        while (act != null) {
            if (act.getRule().getName().equals("rule3")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.isActive());
            } else if (act.getRule().getName().equals("rule1")) {
                list.add(act.getRule().getName() + ":" + act.isActive());
            } else if (act.getRule().getName().equals("rule2")) {
                list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.isActive());
            }
            act = (Activation)it.next();
        }
        this.assertContains(new String[]{"rule1:false", "rule2:0:true", "rule2:1:true", "rule2:2:true", "rule3:2:false"}, list);
    }

    @Test
    public void testFromnSharingWithMixedDormantAndActive() {
        String str = "package org.drools.test \nglobal java.util.List list \n\nrule rule1 salience ( Integer.parseInt( $s1+'1' ) )  when\n    $s1 : String( this == '1' )  from list\nthen\nend\nrule rule2  salience ( Integer.parseInt( $s1+'1' ) ) when\n    $s1 : String( )  from list \n    eval( 1 == 1 ) \nthen\nend\nrule rule3 salience ( Integer.parseInt( $s1+'1' ) ) when\n    $s1 : String( ) from list  \n    eval( 1 == 1 ) \n    eval( 1 == 1 ) \nthen\n    kcontext.getKnowledgeRuntime().halt();\nend\n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            ActivationIteratorTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("1");
        list.add("2");
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ActivationIterator it = ActivationIterator.iterator((StatefulKnowledgeSession)ksession);
        list = new ArrayList();
        Activation act = (Activation)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.isActive());
            act = (Activation)it.next();
        }
        this.assertContains(new String[]{"rule1:1:true", "rule2:0:true", "rule2:1:true", "rule2:2:true", "rule3:0:true", "rule3:1:true", "rule3:2:false"}, list);
    }

    @Test
    public void testAccnSharingWithMixedDormantAndActive() {
        String str = "package org.drools.test \n\nrule rule1 when\n    $s1 : Double() from accumulate( $i : Integer(), sum ( $i ) )    then\nend\nrule rule2  when\n    $s1 : Double() from accumulate( $i : Integer(), sum ( $i ) )        eval( 1 == 1 ) \nthen\nend\nrule rule3  salience 10 when\n    eval( 1 == 1 ) \n    $s1 : Double() from accumulate( $i : Integer(), sum ( $i ) )        eval( 1 == 1 ) \nthen\n    kcontext.getKnowledgeRuntime().halt();\nend\n\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            ActivationIteratorTest.fail((String)kbuilder.getErrors().toString());
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.insert((Object)new Integer(1));
        ksession.insert((Object)new Integer(2));
        ksession.insert((Object)new Integer(3));
        ksession.fireAllRules();
        ActivationIterator it = ActivationIterator.iterator((StatefulKnowledgeSession)ksession);
        ArrayList<String> list = new ArrayList<String>();
        list = new ArrayList();
        Activation act = (Activation)it.next();
        while (act != null) {
            list.add(act.getRule().getName() + ":" + act.getDeclarationValue("$s1") + ":" + act.isActive());
            act = (Activation)it.next();
        }
        this.assertContains(new String[]{"rule1:6.0:true", "rule2:6.0:true", "rule3:6.0:false"}, list);
    }

    public void assertContains(Object[] objects, List list) {
        for (Object object : objects) {
            if (list.contains(object)) continue;
            ActivationIteratorTest.fail((String)("does not contain:" + object));
        }
    }
}

