/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.CImpl;
import org.drools.compiler.DImpl;
import org.drools.compiler.IA;
import org.drools.compiler.IB;
import org.drools.compiler.PackageBuilder;
import org.drools.io.ResourceFactory;
import org.drools.rule.TypeDeclaration;
import org.junit.Assert;
import org.junit.Test;

public class TypeDeclarationMergingTest {
    @Test
    public void testMask() {
        TypeDeclaration tdeclr = new TypeDeclaration(CImpl.class.getName());
        Assert.assertEquals((long)0L, (long)tdeclr.getSetMask());
        tdeclr.setRole(TypeDeclaration.Role.EVENT);
        Assert.assertEquals((long)1L, (long)(tdeclr.getSetMask() & 1));
        Assert.assertFalse((2 == (tdeclr.getSetMask() & 2) ? 1 : 0) != 0);
        Assert.assertFalse((4 == (tdeclr.getSetMask() & 4) ? 1 : 0) != 0);
        tdeclr.setTypesafe(false);
        Assert.assertEquals((long)1L, (long)(tdeclr.getSetMask() & 1));
        Assert.assertEquals((long)2L, (long)(tdeclr.getSetMask() & 2));
        Assert.assertFalse((4 == (tdeclr.getSetMask() & 4) ? 1 : 0) != 0);
        tdeclr = new TypeDeclaration(CImpl.class.getName());
        tdeclr.setTypesafe(true);
        Assert.assertFalse((1 == (tdeclr.getSetMask() & 1) ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)(tdeclr.getSetMask() & 2));
        Assert.assertFalse((4 == (tdeclr.getSetMask() & 4) ? 1 : 0) != 0);
        tdeclr.setFormat(TypeDeclaration.Format.POJO);
        Assert.assertFalse((1 == (tdeclr.getSetMask() & 1) ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)(tdeclr.getSetMask() & 2));
        Assert.assertEquals((long)4L, (long)(tdeclr.getSetMask() & 4));
    }

    @Test
    public void testOverrideFromParentClass() {
        String str = "package org.test \nglobal java.util.List list \ndeclare " + CImpl.class.getCanonicalName() + "\n" + "    @typesafe(true)\n" + "    @role(event)\n" + "end\n" + "declare " + DImpl.class.getCanonicalName() + "\n" + "    @typesafe(false)\n" + "end\n";
        PackageBuilder builder = this.getPackageBuilder(str);
        TypeDeclaration tdecl = builder.getTypeDeclaration(DImpl.class);
        Assert.assertEquals((Object)false, (Object)tdecl.isTypesafe());
        Assert.assertEquals((Object)TypeDeclaration.Role.EVENT, (Object)tdecl.getRole());
    }

    @Test
    public void testInheritNoneExitenceFromParentClass() {
        String str = "package org.test \nglobal java.util.List list \ndeclare " + CImpl.class.getCanonicalName() + "\n" + "    @typesafe(true)\n" + "    @role(event)\n" + "end\n";
        PackageBuilder builder = this.getPackageBuilder(str);
        TypeDeclaration tdecl = builder.getTypeDeclaration(DImpl.class);
        Assert.assertEquals((Object)true, (Object)tdecl.isTypesafe());
        Assert.assertEquals((Object)TypeDeclaration.Role.EVENT, (Object)tdecl.getRole());
    }

    @Test
    public void testInheritExitenceFromParentClass() {
        String str = "package org.test \nglobal java.util.List list \ndeclare " + CImpl.class.getCanonicalName() + "\n" + "    @typesafe(true)\n" + "    @role(event)\n" + "end\n" + "declare " + DImpl.class.getCanonicalName() + "\n" + "end\n";
        PackageBuilder builder = this.getPackageBuilder(str);
        TypeDeclaration tdecl = builder.getTypeDeclaration(DImpl.class);
        Assert.assertEquals((Object)true, (Object)tdecl.isTypesafe());
        Assert.assertEquals((Object)TypeDeclaration.Role.EVENT, (Object)tdecl.getRole());
    }

    @Test
    public void testOverrideFromParentInterface() {
        String str = "package org.test \nglobal java.util.List list \ndeclare " + IB.class.getCanonicalName() + "\n" + "    @typesafe(true)\n" + "    @role(event)\n" + "end\n" + "declare " + DImpl.class.getCanonicalName() + "\n" + "    @typesafe(false)\n" + "end\n";
        PackageBuilder builder = this.getPackageBuilder(str);
        TypeDeclaration tdecl = builder.getTypeDeclaration(DImpl.class);
        Assert.assertEquals((Object)false, (Object)tdecl.isTypesafe());
        Assert.assertEquals((Object)TypeDeclaration.Role.EVENT, (Object)tdecl.getRole());
    }

    @Test
    public void testOverrideFromDeeperParentInterface() {
        String str = "package org.test \nglobal java.util.List list \ndeclare " + IA.class.getCanonicalName() + "\n" + "    @typesafe(true)\n" + "    @role(event)\n" + "end\n" + "declare " + DImpl.class.getCanonicalName() + "\n" + "    @typesafe(false)\n" + "end\n";
        PackageBuilder builder = this.getPackageBuilder(str);
        TypeDeclaration tdecl = builder.getTypeDeclaration(DImpl.class);
        Assert.assertEquals((Object)false, (Object)tdecl.isTypesafe());
        Assert.assertEquals((Object)TypeDeclaration.Role.EVENT, (Object)tdecl.getRole());
    }

    @Test
    public void testOverrideFromDeeperHierarchyParentInterface() {
        String str = "package org.test \nglobal java.util.List list \ndeclare " + IA.class.getCanonicalName() + "\n" + "    @typesafe(true)\n" + "    @role(event)\n" + "end\n" + "declare " + IB.class.getCanonicalName() + "\n" + "    @role(fact)\n" + "end\n" + "declare " + DImpl.class.getCanonicalName() + "\n" + "end\n";
        PackageBuilder builder = this.getPackageBuilder(str);
        TypeDeclaration tdecl = builder.getTypeDeclaration(DImpl.class);
        Assert.assertEquals((Object)true, (Object)tdecl.isTypesafe());
        Assert.assertEquals((Object)TypeDeclaration.Role.FACT, (Object)tdecl.getRole());
    }

    @Test
    public void testInheritNoneExitenceFromParentInterface() {
        String str = "package org.test \nglobal java.util.List list \ndeclare " + IB.class.getCanonicalName() + "\n" + "    @typesafe(true)\n" + "    @role(event)\n" + "end\n";
        PackageBuilder builder = this.getPackageBuilder(str);
        TypeDeclaration tdecl = builder.getTypeDeclaration(DImpl.class);
        Assert.assertEquals((Object)true, (Object)tdecl.isTypesafe());
        Assert.assertEquals((Object)TypeDeclaration.Role.EVENT, (Object)tdecl.getRole());
    }

    @Test
    public void testInheritExitenceFromParentInterface() {
        String str = "package org.test \nglobal java.util.List list \ndeclare " + IB.class.getCanonicalName() + "\n" + "    @typesafe(true)\n" + "    @role(event)\n" + "end\n" + "declare " + DImpl.class.getCanonicalName() + "\n" + "end\n";
        PackageBuilder builder = this.getPackageBuilder(str);
        TypeDeclaration tdecl = builder.getTypeDeclaration(DImpl.class);
        Assert.assertEquals((Object)true, (Object)tdecl.isTypesafe());
        Assert.assertEquals((Object)TypeDeclaration.Role.EVENT, (Object)tdecl.getRole());
    }

    @Test
    public void testOverrideFromMixedHierarchyParentInterface() {
        String str = "package org.test \nglobal java.util.List list \ndeclare " + IA.class.getCanonicalName() + "\n" + "    @typesafe(true)\n" + "    @role(event)\n" + "end\n" + "declare " + CImpl.class.getCanonicalName() + "\n" + "    @role(fact)\n" + "end\n" + "declare " + DImpl.class.getCanonicalName() + "\n" + "end\n";
        PackageBuilder builder = this.getPackageBuilder(str);
        TypeDeclaration tdecl = builder.getTypeDeclaration(DImpl.class);
        Assert.assertEquals((Object)true, (Object)tdecl.isTypesafe());
        Assert.assertEquals((Object)TypeDeclaration.Role.FACT, (Object)tdecl.getRole());
    }

    private PackageBuilder getPackageBuilder(String str) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])str.getBytes()), ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            Assert.fail((String)kbuilder.getErrors().toString());
        }
        PackageBuilder builder = ((KnowledgeBuilderImpl)kbuilder).pkgBuilder;
        return builder;
    }
}

