/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.changeset;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.drools.ChangeSet;
import org.drools.CommonTestMethodBase;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.DecisionTableConfiguration;
import org.drools.builder.DecisionTableInputType;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.io.ResourceFactory;
import org.drools.io.impl.UrlResource;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.xml.XmlChangeSetReader;
import org.junit.Test;
import org.xml.sax.SAXException;

public class ChangeSetTest
extends CommonTestMethodBase {
    @Test
    public void testXmlParser() throws SAXException, IOException {
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        XmlChangeSetReader xmlReader = new XmlChangeSetReader(conf.getSemanticModules());
        xmlReader.setClassLoader(ChangeSetTest.class.getClassLoader(), ChangeSetTest.class);
        String str = "";
        str = str + "<change-set ";
        str = str + "xmlns='http://drools.org/drools-5.0/change-set' ";
        str = str + "xmlns:xs='http://www.w3.org/2001/XMLSchema-instance' ";
        str = str + "xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        str = str + "    <add> ";
        str = str + "        <resource source='http://www.domain.com/test.drl' type='DRL' />";
        str = str + "        <resource source='http://www.domain.com/test.xls' type='DTABLE' >";
        str = str + "            <decisiontable-conf worksheet-name='sheet10' input-type='XLS' />";
        str = str + "        </resource>";
        str = str + "    </add> ";
        str = str + "</change-set>";
        StringReader reader = new StringReader(str);
        ChangeSet changeSet = xmlReader.read((Reader)reader);
        ChangeSetTest.assertEquals((int)2, (int)changeSet.getResourcesAdded().size());
        UrlResource resource = (UrlResource)((List)changeSet.getResourcesAdded()).get(0);
        ChangeSetTest.assertNull((Object)resource.getConfiguration());
        ChangeSetTest.assertEquals((String)"http://www.domain.com/test.drl", (String)resource.getURL().toString());
        ChangeSetTest.assertEquals((Object)ResourceType.DRL, (Object)resource.getResourceType());
        resource = (UrlResource)((List)changeSet.getResourcesAdded()).get(1);
        ChangeSetTest.assertEquals((String)"http://www.domain.com/test.xls", (String)resource.getURL().toString());
        ChangeSetTest.assertEquals((Object)ResourceType.DTABLE, (Object)resource.getResourceType());
        DecisionTableConfiguration dtConf = (DecisionTableConfiguration)resource.getConfiguration();
        ChangeSetTest.assertEquals((Object)DecisionTableInputType.XLS, (Object)dtConf.getInputType());
    }

    @Test
    public void testIntegregation() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"changeset1Test.xml", ((Object)((Object)this)).getClass()), ResourceType.CHANGE_SET);
        ChangeSetTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        ChangeSetTest.assertEquals((int)2, (int)list.size());
        ChangeSetTest.assertTrue((boolean)list.containsAll(Arrays.asList("rule1", "rule2")));
    }

    @Test
    public void testBasicAuthentication() throws SAXException, IOException {
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        XmlChangeSetReader xmlReader = new XmlChangeSetReader(conf.getSemanticModules());
        xmlReader.setClassLoader(ChangeSetTest.class.getClassLoader(), ChangeSetTest.class);
        String str = "";
        str = str + "<change-set ";
        str = str + "xmlns='http://drools.org/drools-5.0/change-set' ";
        str = str + "xmlns:xs='http://www.w3.org/2001/XMLSchema-instance' ";
        str = str + "xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >";
        str = str + "    <add> ";
        str = str + "        <resource source='http://localhost:8081/jboss-brms/org.drools.guvnor.Guvnor/package/defaultPackage/LATEST' type='PKG' basicAuthentication='enabled' username='admin' password='pwd'/>";
        str = str + "    </add> ";
        str = str + "</change-set>";
        StringReader reader = new StringReader(str);
        ChangeSet changeSet = xmlReader.read((Reader)reader);
        ChangeSetTest.assertEquals((int)1, (int)changeSet.getResourcesAdded().size());
        UrlResource resource = (UrlResource)((List)changeSet.getResourcesAdded()).get(0);
        ChangeSetTest.assertNull((Object)resource.getConfiguration());
        ChangeSetTest.assertEquals((String)"http://localhost:8081/jboss-brms/org.drools.guvnor.Guvnor/package/defaultPackage/LATEST", (String)resource.getURL().toString());
        ChangeSetTest.assertEquals((String)"enabled", (String)resource.getBasicAuthentication());
        ChangeSetTest.assertEquals((String)"admin", (String)resource.getUsername());
        ChangeSetTest.assertEquals((String)"pwd", (String)resource.getPassword());
        ChangeSetTest.assertEquals((Object)ResourceType.PKG, (Object)resource.getResourceType());
    }
}

